/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.ArrayList;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.xmlschema.AttrGroupNotFoundException;
import oracle.bpm.xmlschema.AttrGroupTypeDescription;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;

class AttributeGroup
extends SchemaElement {
    AttributeGroup() {
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        if (this.type != null) {
            return this.type;
        }
        String ref = this.getRef();
        if (ref != null) {
            try {
                current = this.getContext().lookupAttributeGroup(ref).buildType(null);
            }
            catch (AttrGroupNotFoundException e) {
                this.reportError(e);
                current = new AttrGroupTypeDescription(new ArrayList());
            }
        } else {
            ArrayList<TypeDescription> group = new ArrayList<TypeDescription>();
            for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
                TypeDescription attribute = element.buildType(current);
                if (attribute == null || !attribute.isAttribute()) continue;
                group.add(attribute);
            }
            current = new AttrGroupTypeDescription(group);
        }
        this.type = current;
        return current;
    }

    @Override
    protected void declare() throws TypeException {
        String name = this.getName();
        if (name != null) {
            this.getTarget().declareAttributeGroup(name, this);
        }
    }

    String getName() {
        return this.getAttribute("name");
    }

    String getRef() {
        return this.getAttribute("ref");
    }
}

