/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import oracle.bpm.resources.Msg;
import oracle.bpm.xml.msg.XmlMsg;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlObjectErrorHandler
implements ErrorHandler {
    private StringBuilder messages = new StringBuilder();

    public boolean hasMessages() {
        return this.messages.length() > 0;
    }

    public String getMessagesString() {
        return this.messages.toString();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.addMessage(XmlMsg.WARNING(XmlObjectErrorHandler.getException(exception)));
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.addMessage(XmlMsg.ERROR(XmlObjectErrorHandler.getException(exception)));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.addMessage(XmlMsg.FATAL_ERROR(XmlObjectErrorHandler.getException(exception)));
    }

    private static String getException(SAXParseException saxParseException) {
        String uriString = saxParseException.getSystemId();
        String lineNumber = Integer.toString(saxParseException.getLineNumber());
        String uri = uriString == null ? "none" : uriString;
        String exceptionMessage = saxParseException.getMessage();
        return XmlMsg.XML_VALIDATION_EXCEPTION_DETAIL(lineNumber, uri, exceptionMessage).getString();
    }

    private void addMessage(Msg msg) {
        this.messages.append(msg.getString()).append('\n');
    }
}

