/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.ArrayList;
import oracle.bpm.xmlruntime.SortedChildrenList;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmlruntime.XMLValue;

public class ElementList
extends ArrayList<Object> {
    private SortedChildrenList children;
    private String element;
    @Deprecated
    private boolean elementIsQualified;
    private String elementNamespace;
    private int elemPosition;
    private String elemType;
    static final long serialVersionUID = 4143673026387084763L;
    static final long serialCheck = -7511034563522368249L;

    ElementList(SortedChildrenList children, String tagName, String elemType, int elemPosition, String elemNamespace, boolean elementIsQualified) {
        this.elemPosition = elemPosition;
        this.children = children;
        this.element = tagName;
        this.elemType = elemType;
        this.elementNamespace = elemNamespace;
        this.elementIsQualified = elementIsQualified;
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            XMLObject element = children.get(i);
            boolean isArrayElement = ElementList.isArrayElement(element, tagName);
            if (!isArrayElement) continue;
            super.add(XMLValue.convertFrom(element, elemType));
        }
    }

    @Override
    public boolean add(Object element) {
        super.add(element);
        XMLObject xmlObject = (XMLObject)XMLValue.convertTo(element, this.elemType, this.element, this.elementNamespace, this.elementIsQualified);
        this.children.add(xmlObject, this.elemPosition);
        return true;
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0 || index > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Cannot insert element '" + this.element + "' at index " + index + " because there are only " + this.size() + " elements.");
        }
        super.add(index, element);
        int childrenIndex = this.mapIndex(index);
        if (childrenIndex == -1 && index > 0 && (childrenIndex = this.mapIndex(index - 1)) != -1) {
            ++childrenIndex;
        }
        if (childrenIndex == -1) {
            childrenIndex = 0;
        }
        this.children.add(childrenIndex, (XMLObject)XMLValue.convertTo(element, this.elemType, this.element, this.elementNamespace, this.elementIsQualified));
    }

    @Override
    public Object set(int index, Object element) {
        Object oldValue = super.set(index, element);
        XMLObject xmlObject = (XMLObject)XMLValue.convertTo(element, this.elemType, this.element, this.elementNamespace, this.elementIsQualified);
        int childrenIndex = this.mapIndex(index);
        this.children.set(childrenIndex, xmlObject);
        return oldValue;
    }

    @Override
    public void clear() {
        String name = this.element;
        SortedChildrenList childrenList = this.children;
        ElementList.clear(childrenList, name);
    }

    @Override
    public Object remove(int index) {
        int childrenIndex = this.mapIndex(index);
        this.children.remove(childrenIndex);
        return super.remove(index);
    }

    static void clear(SortedChildrenList childrenList, String elementName) {
        for (int i = childrenList.size() - 1; i >= 0; --i) {
            XMLObject element = childrenList.get(i);
            if (!ElementList.isArrayElement(element, elementName)) continue;
            childrenList.remove(i);
        }
    }

    private static boolean isArrayElement(XMLObject element, String tagName) {
        return element != null && tagName.equals(element.getTagName());
    }

    private int mapIndex(int index) {
        int length = this.children.size();
        String name = this.element;
        int childrenIndex = -1;
        int j = 0;
        for (int i = 0; i < length; ++i) {
            XMLObject element = this.children.get(i);
            if (!ElementList.isArrayElement(element, name)) continue;
            if (j == index) {
                childrenIndex = i;
                break;
            }
            ++j;
        }
        return childrenIndex;
    }
}

