/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.DefaultFactory;
import oracle.bpm.xmlparser.Element;
import oracle.bpm.xmlparser.ElementFactory;
import oracle.bpm.xmlparser.MessageListener;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlparser.UnexpectedContentException;
import oracle.bpm.xmlruntime.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    private StringBuilder buffer;
    private boolean buildingContext;
    private int closedPrefix = 0;
    private Stack<NamespaceContext> contexts;
    private int current;
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private ElementFactory factory;
    private StringList infos;
    private MessageListener listener;
    private URL location;
    private Locator locator;
    private Element root;
    private SAXParser saxParser;
    private Element[] stack;
    private List<SAXException> warnings = new ArrayList<SAXException>();

    public Parser() {
        this.infos = StringList.create();
        this.contexts = new Stack();
        this.factory = new DefaultFactory();
    }

    public static void main(String[] args) throws Exception {
        Parser xmlparser;
        DefaultElement tree;
        if (args.length != 1) {
            System.err.println("Usage: fuegoxml <xmlFile>");
            System.exit(1);
        }
        if ((tree = (DefaultElement)(xmlparser = new Parser()).parse(new File(args[0]).toURI().toURL())) != null) {
            IndentedPrintWriter pw = new IndentedPrintWriter(System.out);
            tree.dump(pw, "UTF-8");
            pw.flush();
        }
        for (SAXException error : xmlparser.getErrors()) {
            System.err.println("error: " + error);
        }
        for (SAXException warning : xmlparser.getErrors()) {
            System.err.println("warning: " + warning);
        }
    }

    public NamespaceContext getRootNamespaceContext() {
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setElementFactory(ElementFactory factory) {
        this.factory = factory;
    }

    public ElementFactory getElementFactory() {
        return this.factory;
    }

    public SAXException[] getErrors() {
        return Parser.makeArray(this.errors);
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public URL getSourceLocation() {
        return this.location;
    }

    public SAXException[] getWarnings() {
        return Parser.makeArray(this.warnings);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer == null) {
            if (Parser.isWhitesSpace(ch, start, length)) {
                return;
            }
            this.buffer = new StringBuilder(length);
        }
        this.buffer.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.dispatchPendingTextData();
        try {
            --this.current;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        ++this.closedPrefix;
        NamespaceContext current = null;
        if (!this.contexts.isEmpty()) {
            current = this.contexts.peek();
        }
        if (current != null && this.closedPrefix == current.getDeclaredPrefixCount()) {
            NamespaceContext ctx = this.popContext();
            this.closedPrefix = 0;
            if (this.factory != null) {
                this.factory.setContext(ctx.getParent());
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errors.add(e);
        if (this.listener != null) {
            this.listener.error(e.getLineNumber(), e.getColumnNumber(), e.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.errors.add(e);
        if (this.listener != null) {
            this.listener.error(e.getLineNumber(), e.getColumnNumber(), e.getMessage());
        }
    }

    public void info(String message) {
        this.infos.add(message);
        if (this.listener != null) {
            this.listener.info(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Element parse(URL location) throws ParserException {
        Element element;
        InputStream in = location.openStream();
        try {
            PushbackInputStream pb = new PushbackInputStream(in, 32);
            InputSource source = new InputSource(pb);
            byte[] buffer = new byte[3];
            int count = pb.read(buffer);
            if (count >= 3 && buffer[0] == -17 && buffer[1] == -69 && buffer[2] == -65) {
                source.setEncoding("UTF-8");
            } else {
                pb.unread(buffer, 0, count);
            }
            element = this.parse(location, source);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ParserException(e);
            }
        }
        in.close();
        return element;
    }

    public synchronized <E extends Element> E parse(File location, Class<E> expectedType) throws ParserException {
        try {
            return this.parse(location.toURI().toURL(), expectedType);
        }
        catch (MalformedURLException e) {
            throw new ParserException(e);
        }
    }

    public synchronized <E extends Element> E parse(URL location, Class<E> expectedType) throws ParserException {
        Element result = this.parse(location);
        if (!expectedType.isInstance(result)) {
            throw new UnexpectedContentException(result, "Expected '" + expectedType + "' but was: '" + result.getClass() + '\'');
        }
        return (E)((Element)expectedType.cast(result));
    }

    @Deprecated
    public synchronized Element parse(URL location, Reader input) throws ParserException {
        InputSource source = new InputSource(input);
        return this.parse(location, source);
    }

    public synchronized Element parse(URL location, InputStream input) throws ParserException {
        InputSource source = new InputSource(input);
        return this.parse(location, source);
    }

    public synchronized Element parse(URL location, String input) throws ParserException {
        InputSource source = new InputSource(new StringReader(input));
        return this.parse(location, source);
    }

    public synchronized <E extends Element> E parse(URL location, Reader input, Class<E> expectedType) throws ParserException {
        Element result = this.parse(location, input);
        if (!expectedType.isInstance(result)) {
            throw new UnexpectedContentException(result, "Expected '" + expectedType + "' but was: '" + result.getClass() + '\'');
        }
        return (E)((Element)expectedType.cast(result));
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource source = null;
        try {
            String file;
            if (systemId != null && (file = new URL(systemId).getFile()) != null) {
                int index = file.lastIndexOf(47);
                file = file.substring(index + 1);
                if (this.location != null) {
                    source = Parser.openDocument(this.location, file);
                }
                if (source == null) {
                    source = new InputSource(new FileInputStream(new File(FuegoDirectories.extDir(), file)));
                }
            }
            if (source == null) {
                source = super.resolveEntity(publicId, systemId);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        return source;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.resetMessages();
        this.reset();
    }

    @Override
    public void startElement(String namespace, String name, String qualifiedName, Attributes attrs) throws SAXException {
        this.dispatchPendingTextData();
        try {
            Element element;
            this.buildingContext = false;
            if (this.root == null && this.contexts.isEmpty()) {
                NamespaceContext ctx = this.createContext(this.getRootNamespaceContext());
                this.pushContext(ctx);
                if (this.factory != null) {
                    this.factory.setContext(ctx);
                }
            }
            if (name == null && qualifiedName != null) {
                int q = qualifiedName.indexOf(58);
                name = qualifiedName.substring(q + 1);
            }
            HashMap<QName, String> attributes = null;
            if (attrs != null) {
                attributes = new HashMap<QName, String>();
                int length = attrs.getLength();
                for (int i = 0; i < length; ++i) {
                    String uri = attrs.getURI(i);
                    if ("http://www.w3.org/2000/xmlns/".equals(uri)) continue;
                    String localName = attrs.getLocalName(i);
                    String prefix = XmlUtils.prefix(attrs.getQName(i));
                    String attrValue = attrs.getValue(i);
                    QName qname = new QName(uri, localName, prefix);
                    attributes.put(qname, attrValue);
                }
            }
            if ((element = this.factory.create(namespace, name, attributes)) == null) {
                throw new SAXException("couldn't create element for " + name);
            }
            Element parent = this.peek();
            if (parent != null) {
                parent.addChild(element);
            } else {
                this.root = element;
            }
            this.push(element);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        NamespaceContext current = !this.contexts.isEmpty() ? this.contexts.peek() : this.getRootNamespaceContext();
        if (!this.buildingContext) {
            current = this.createContext(current);
            this.pushContext(current);
            this.closedPrefix = 0;
            if (this.factory != null) {
                this.factory.setContext(current);
            }
        }
        if (current != null) {
            current.addNamespace(prefix, uri);
        }
        this.buildingContext = true;
    }

    public void warning(String message) {
        try {
            this.warning(new SAXParseException(message, null, null, -1, -1));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.warnings.add(e);
        if (this.listener != null) {
            this.listener.warning(e.getLineNumber(), e.getColumnNumber(), e.getMessage());
        }
    }

    protected NamespaceContext createContext(NamespaceContext parent) {
        return new NamespaceContext(parent);
    }

    protected NamespaceContext popContext() {
        return this.contexts.pop();
    }

    protected void pushContext(NamespaceContext ctx) {
        this.contexts.push(ctx);
    }

    protected void reset() {
        this.stack = new Element[1024];
        this.current = 0;
        this.root = null;
        this.buildingContext = false;
        if (this.factory != null) {
            this.factory.setParser(this);
        }
        this.buffer = null;
        this.contexts.clear();
    }

    protected void resetMessages() {
        this.errors.clear();
        this.warnings.clear();
        this.infos.clear();
    }

    protected Element pop() {
        return this.stack[--this.current];
    }

    protected void push(Element element) {
        if (this.current >= this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length + 128);
        }
        this.stack[this.current++] = element;
    }

    private static boolean isWhitesSpace(char[] ch, int start, int length) {
        block3: for (int i = 0; i < length; ++i) {
            switch (ch[start + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static SAXException[] makeArray(List<? extends SAXException> exceptions) {
        SAXException[] result = new SAXException[exceptions.size()];
        return exceptions.toArray(result);
    }

    private static InputSource openDocument(URL base, String file) throws IOException {
        base = new URL(base, file);
        InputStream in = base.openStream();
        return new InputSource(in);
    }

    private void dispatchPendingTextData() throws SAXException {
        if (this.buffer != null) {
            String data = this.buffer.toString();
            this.buffer = null;
            Element element = this.factory.createText(data);
            if (element == null) {
                throw new SAXException("couldn't create element for character data ");
            }
            Element parent = this.peek();
            if (parent != null) {
                parent.addChild(element);
            }
        }
    }

    private Element parse(URL location, InputSource source) throws ParserException {
        try {
            this.location = location;
            if (this.saxParser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                this.saxParser = factory.newSAXParser();
            }
            this.saxParser.parse(source, (DefaultHandler)this);
            return this.root;
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ParserException(e);
        }
        catch (SAXException e) {
            throw new ParserException(e);
        }
    }

    private Element peek() {
        int pos = this.current;
        return pos > 0 ? this.stack[pos - 1] : null;
    }
}

