/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlparser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xmlparser.Element;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.Parser;
import oracle.bpm.xmlparser.Text;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultElement
implements Element {
    private Map<QName, String> attributes;
    private int column = -1;
    private NamespaceContext context;
    private DefaultElement first;
    private int line = -1;
    private String name;
    private String namespace;
    private DefaultElement next;
    private DefaultElement parent;
    private Parser parser;
    private int type;

    public static <E extends DefaultElement> E findByAttributeValue(@Nullable E[] elements, String name, String value) {
        if (elements != null) {
            for (E element : elements) {
                String attrValue = ((DefaultElement)element).getAttribute(name);
                if (attrValue == null || !attrValue.equals(value)) continue;
                return element;
            }
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        QName qname = new QName(name);
        this.setAttribute(qname, value);
    }

    public void setAttribute(QName qname, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<QName, String>();
        }
        this.attributes.put(qname, value);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public String getAttribute(String name) {
        return this.getAttribute(new QName(name));
    }

    public String getAttribute(QName name) {
        String value = null;
        if (this.attributes != null) {
            value = this.attributes.get(name);
        }
        return value;
    }

    public <E extends Enum> E getAttribute(String name, Class<E> enumType) {
        Enum result = null;
        String value = this.getAttribute(name);
        if (value != null) {
            Enum[] constants;
            for (Enum constant : constants = (Enum[])enumType.getEnumConstants()) {
                if (!value.equals(constant.toString())) continue;
                result = constant;
                break;
            }
        }
        return (E)result;
    }

    public Short getShortAttribute(String name) {
        String value = this.getAttribute(name);
        return value != null ? Short.valueOf(value) : null;
    }

    public Integer getIntAttribute(String name) {
        String value = this.getAttribute(name);
        return value != null ? Integer.valueOf(value) : null;
    }

    public Double getDoubleAttribute(String name) {
        String value = this.getAttribute(name);
        return value != null ? Double.valueOf(value) : null;
    }

    public Long getLongAttribute(String name) {
        String value = this.getAttribute(name);
        return value != null ? Long.valueOf(value) : null;
    }

    public Boolean getBooleanAttribute(String name) {
        String value = this.getAttribute(name);
        return "true".equals(value) || "yes".equals(value);
    }

    public Time getTimeAttribute(String name) {
        String value = this.getAttribute(name);
        return value != null ? Time.valueOf(value) : null;
    }

    public BigDecimal getDecimalAttribute(String name) {
        String value = this.getAttribute(name);
        return value != null ? new BigDecimal(value) : null;
    }

    public String getAttribute(String namespace, String name) {
        QName qname = new QName(namespace, name);
        return this.attributes.get(qname);
    }

    public void setAttributes(Map<QName, String> attributes) {
        this.attributes = attributes;
    }

    public Map<QName, String> getAttributes() {
        return this.attributes;
    }

    public void setColumn(int col) {
        this.column = col;
    }

    public int getColumn() {
        return this.column;
    }

    public void setElementType(int type) {
        this.type = type;
    }

    public int getElementType() {
        return this.type;
    }

    public void setFirstElement(DefaultElement element) {
        if (element != null) {
            element.setParent(this);
        }
        this.first = element;
    }

    public DefaultElement getFirstElement() {
        return this.first;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setNSContext(NamespaceContext ctx) {
        this.context = ctx;
    }

    public NamespaceContext getNSContext() {
        DefaultElement parent = this.getParent();
        if (this.context == null) {
            this.context = parent != null ? parent.getNSContext() : new NamespaceContext();
        }
        return this.context;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNextElement(DefaultElement element) {
        this.next = element;
    }

    public DefaultElement getNextElement() {
        return this.next;
    }

    public void setParent(DefaultElement parent) {
        this.parent = parent;
    }

    public DefaultElement getParent() {
        return this.parent;
    }

    public int getPosition() {
        int position = -1;
        if (this.parent != null) {
            DefaultElement current = this.parent.getFirstElement();
            position = 0;
            while (current != null && current != this) {
                current = current.getParent();
                ++position;
            }
        }
        return position;
    }

    public void setTagName(String name) {
        this.name = name;
    }

    public String getTagName() {
        return this.name;
    }

    public void setXMLParser(Parser xmlparser) {
        this.parser = xmlparser;
    }

    public Parser getXMLParser() {
        return this.parser;
    }

    @Override
    public void addChild(Element element) {
        DefaultElement elem = (DefaultElement)element;
        if (this.first == null) {
            this.first = elem;
        } else {
            DefaultElement current = this.first;
            while (current.getNextElement() != null) {
                current = current.getNextElement();
            }
            current.setNextElement(elem);
        }
        elem.setParent(this);
    }

    public void removeChild(Element element) {
        if (this.first != null) {
            if (this.first.equals(element)) {
                this.first = this.first.getNextElement();
            } else {
                DefaultElement previous = this.first;
                for (DefaultElement current = this.first.getNextElement(); current != null; current = current.getNextElement()) {
                    if (current.equals(element)) {
                        previous.setNextElement(current.getNextElement());
                        return;
                    }
                    previous = current;
                }
            }
        }
        if (element instanceof DefaultElement) {
            ((DefaultElement)element).setNextElement(null);
        }
    }

    public void setElement(String tagName, Element element) {
        DefaultElement current;
        DefaultElement defaultElement = (DefaultElement)element;
        defaultElement.setTagName(tagName);
        DefaultElement prev = null;
        for (current = this.first; current != null && !tagName.equals(current.getTagName()); current = current.getNextElement()) {
            prev = current;
        }
        if (current == null) {
            this.addChild(element);
        } else {
            if (prev != null) {
                prev.setNextElement(defaultElement);
            } else {
                this.setFirstElement(defaultElement);
            }
            defaultElement.setNextElement(current.getNextElement());
            defaultElement.setParent(this);
            current.setNextElement(null);
            current.setParent(null);
        }
    }

    public void setAllElements(String tagName, Element[] elements) {
        for (DefaultElement child : this.findChildrenByName(tagName)) {
            this.removeChild(child);
        }
        for (Element element : elements) {
            DefaultElement defaultElement = (DefaultElement)element;
            defaultElement.setTagName(tagName);
            this.addChild(element);
        }
    }

    public void setAllElementValues(String tagName, String[] values) {
        for (String value : values) {
            DefaultElement child = new DefaultElement();
            child.setTagName(tagName);
            this.addChild(child);
            child.addChild(new Text(value));
        }
    }

    public String[] getAllElementValues(String tagName) {
        DefaultElement[] children = this.findChildrenByName(tagName);
        String[] result = new String[children.length];
        int i = 0;
        for (DefaultElement child : children) {
            DefaultElement content = child.getFirstElement();
            if (content instanceof Text) {
                Text text = (Text)content;
                result[i] = text.getContent();
            }
            ++i;
        }
        return result;
    }

    public void setElementValue(String tagName, Object value) {
        DefaultElement child = this.findChildByName(tagName);
        if (child != null) {
            Text text = (Text)child.getFirstElement();
            if (text == null) {
                text = new Text(String.valueOf(value));
                child.addChild(text);
            } else {
                text.setContent(String.valueOf(value));
            }
        } else {
            child = new DefaultElement();
            child.setTagName(tagName);
            this.addChild(child);
            child.addChild(new Text(String.valueOf(value)));
        }
    }

    public String getElementValue(String tagName) {
        String result = null;
        DefaultElement child = this.findChildByName(tagName);
        if (child instanceof Text) {
            Text text = (Text)child;
            result = text.getContent();
        }
        return result;
    }

    public Short getShortElementValue(String name) {
        String value = this.getElementValue(name);
        return value != null ? Short.valueOf(value) : null;
    }

    public Integer getIntElementValue(String name) {
        String value = this.getElementValue(name);
        return value != null ? Integer.valueOf(value) : null;
    }

    public Long getLongElementValue(String name) {
        String value = this.getElementValue(name);
        return value != null ? Long.valueOf(value) : null;
    }

    public Boolean getBooleanElementValue(String name) {
        String value = this.getElementValue(name);
        return "true".equals(value) || "yes".equals(value);
    }

    public Time getTimeElementValue(String name) {
        String value = this.getElementValue(name);
        return value != null ? Time.valueOf(value) : null;
    }

    public BigDecimal getDecimalElementValue(String name) {
        String value = this.getElementValue(name);
        return value != null ? new BigDecimal(value) : null;
    }

    public String contextPath() {
        StringBuilder path = new StringBuilder();
        DefaultElement current = this;
        while (current != null) {
            String tag = current.getTagName();
            int position = current.getPosition();
            if (position != -1) {
                path.insert(0, tag + '[' + position + ']');
            } else {
                path.insert(0, tag);
            }
            if ((current = current.getParent()) == null) continue;
            path.insert(0, '/');
        }
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File target) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            IndentedPrintWriter indentedWriter = new IndentedPrintWriter(writer);
            this.dump(indentedWriter, "UTF-8");
            indentedWriter.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void store(OutputStream target) throws IOException {
        IndentedPrintWriter indentedWriter = new IndentedPrintWriter(new OutputStreamWriter(target, Literals.DEFAULT_ENCODING));
        this.dump(indentedWriter, Literals.DEFAULT_ENCODING);
        indentedWriter.flush();
        indentedWriter.close();
    }

    public void store(Writer target) throws IOException {
        this.internalStore(target, false, Literals.DEFAULT_ENCODING);
    }

    public void storeAsFuego(Writer target, String encoding) throws IOException {
        this.internalStore(target, true, encoding != null ? encoding : Literals.DEFAULT_ENCODING);
    }

    public void dump(PrintStream out) {
        this.dump(new IndentedPrintWriter(out, true), Literals.DEFAULT_ENCODING);
    }

    public void dump(IndentedPrintWriter out, String enconding) {
        this.dump(out, true, null, enconding);
    }

    public void dump(IndentedPrintWriter out, String enconding, DumpParameters parameters) {
        this.dump(out, true, null, enconding, parameters);
    }

    public <E extends DefaultElement> E findAncestorByClass(Class<E> cl) {
        DefaultElement current;
        for (current = this; current != null && !cl.isAssignableFrom(current.getClass()); current = current.getParent()) {
        }
        return (E)((DefaultElement)cl.cast(current));
    }

    public DefaultElement findChildByAttributeValue(String attribute, String value) {
        String attributeValue;
        DefaultElement element;
        for (element = this.getFirstElement(); element != null && !Any.equals(attributeValue = element.getAttribute(attribute), value); element = element.getNextElement()) {
        }
        return element;
    }

    public <E extends DefaultElement> E getElementByClass(Class<E> cl) {
        return this.findChildByClass(cl);
    }

    public <E extends DefaultElement> E findChildByClass(Class<E> cl) {
        DefaultElement[] elements = this.findChildrenByClass(cl);
        return (E)(elements.length > 0 ? (DefaultElement)cl.cast(elements[0]) : null);
    }

    public DefaultElement getElement(String name) {
        return this.findChildByName(name);
    }

    public <E extends DefaultElement> E getElement(String name, Class<E> type) {
        DefaultElement child = this.findChildByName(name);
        return (E)(child != null ? (DefaultElement)type.cast(child) : null);
    }

    public DefaultElement findChildByName(String name) {
        for (DefaultElement element = this.getFirstElement(); element != null; element = element.getNextElement()) {
            if (!name.equals(element.getTagName())) continue;
            return element;
        }
        return null;
    }

    public DefaultElement[] findChildrenByName(String name) {
        ArrayList<DefaultElement> result = new ArrayList<DefaultElement>();
        for (DefaultElement element = this.getFirstElement(); element != null; element = element.getNextElement()) {
            if (!name.equals(element.getTagName())) continue;
            result.add(element);
        }
        return result.toArray(new DefaultElement[result.size()]);
    }

    public <E extends DefaultElement> E[] getAllElementsByClass(Class<E> cl) {
        return this.findChildrenByClass(cl);
    }

    public <E extends DefaultElement> E[] findChildrenByClass(Class<E> cl) {
        ArrayList<E> children = new ArrayList<E>();
        for (DefaultElement current = this.getFirstElement(); current != null; current = current.getNextElement()) {
            if (!cl.isAssignableFrom(current.getClass())) continue;
            children.add(cl.cast(current));
        }
        return children.toArray((DefaultElement[])Array.newInstance(cl, children.size()));
    }

    public <E extends DefaultElement> List<E> findRecursiveChildrenByClass(Class<E> cl) {
        ArrayList<E> children = new ArrayList<E>();
        for (DefaultElement current = this.getFirstElement(); current != null; current = current.getNextElement()) {
            if (cl.isAssignableFrom(current.getClass())) {
                children.add(cl.cast(current));
            }
            children.addAll(current.findRecursiveChildrenByClass(cl));
        }
        return children;
    }

    public void generateXml(XmlWriter xml) throws IOException {
        xml.startElement(this.getTagName());
        this.generateXmlAttributes(xml);
        this.generateXmlNamespaces(xml);
        this.generateXmlElements(xml);
        xml.endElement();
    }

    public void info(String msg) {
        this.getXMLParser().info(msg);
    }

    public void reportError(String msg) {
        try {
            this.getXMLParser().error(new SAXParseException(msg, null, null, this.getLine(), this.getColumn()));
        }
        catch (SAXException sax) {
            sax.printStackTrace();
        }
    }

    public void reportError(Exception e) {
        this.reportError(e.getMessage());
    }

    public void reportWarning(String msg) {
        try {
            this.getXMLParser().warning(new SAXParseException(msg, null, null, this.getLine(), this.getColumn()));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void reportInfo(String msg) {
        this.getXMLParser().info(msg);
    }

    public boolean isEmpty() {
        return !this.hasChildren() && !this.hasAttributes();
    }

    public String toString() {
        return String.valueOf(this.getTagName()) + this.getAttributes();
    }

    protected String getPrefix(String ns) {
        NamespaceContext context = this.getNSContext();
        return context != null ? context.findPrefixByUri(ns) : null;
    }

    protected boolean addNewLineBeforeTag() {
        return false;
    }

    protected void generateXmlAttributes(XmlWriter xml) throws IOException {
        Map<QName, String> attributes = this.getAttributes();
        if (attributes != null) {
            for (Map.Entry<QName, String> entry : attributes.entrySet()) {
                QName qname = entry.getKey();
                String name = qname.getLocalPart();
                xml.printAttribute(name, entry.getValue());
            }
        }
    }

    protected void generateXmlElements(XmlWriter xml) throws IOException {
        for (DefaultElement element = this.getFirstElement(); element != null; element = element.getNextElement()) {
            element.generateXml(xml);
        }
    }

    protected void generateXmlNamespaces(XmlWriter xml) throws IOException {
        NamespaceContext nsContext = this.getNSContext();
        DefaultElement parent = this.getParent();
        if (parent == null || parent.getNSContext() != nsContext) {
            Map<String, Collection<String>> prefixByUri = nsContext.getPrefixesByUri();
            Set<Map.Entry<String, Collection<String>>> entries = prefixByUri.entrySet();
            for (Map.Entry<String, Collection<String>> entry : entries) {
                if (entry.getKey().length() <= 0) continue;
                String uri = entry.getKey();
                Collection<String> prefixes = entry.getValue();
                for (String prefix : prefixes) {
                    StringBuilder name = new StringBuilder().append("xmlns");
                    if (prefix.length() != 0) {
                        name.append(':').append(prefix);
                    }
                    xml.printAttribute(name.toString(), uri);
                }
            }
        }
    }

    protected void dump(IndentedPrintWriter out, boolean root, NamespaceContext currentCtx, String encoding) {
        this.dump(out, root, false, currentCtx, encoding);
    }

    protected void dump(IndentedPrintWriter out, boolean root, NamespaceContext currentCtx, String encoding, DumpParameters parameters) {
        this.dump(out, root, false, currentCtx, encoding, parameters);
    }

    protected void dump(IndentedPrintWriter out, boolean root, boolean fuegoProcessingInstruction, NamespaceContext currentCtx, String encoding) {
        this.dump(out, root, fuegoProcessingInstruction, currentCtx, encoding, new DumpParameters());
    }

    protected void dump(IndentedPrintWriter out, boolean root, boolean fuegoProcessingInstruction, NamespaceContext currentCtx, String encoding, DumpParameters parameters) {
        if (parameters == null) {
            parameters = new DumpParameters();
        }
        if (root) {
            out.print(Id.getXmlProcessingInstructionLine(encoding));
            if (fuegoProcessingInstruction) {
                out.print(Id.getFuegoProcessingInstructionLine());
            }
            out.setIndentationString("    ");
        }
        NamespaceContext nsContext = this.getNSContext();
        String currentNs = this.getNamespace();
        String currentPrefix = nsContext.findPrefixByUri(currentNs);
        if (this.addNewLineBeforeTag()) {
            out.println();
        }
        out.print('<');
        if (currentPrefix != null && currentPrefix.length() != 0) {
            out.print(currentPrefix);
            out.print(':');
        }
        assert (this.name != null) : "tag name is null for class '" + this.getClass().getName() + '\'';
        out.print(this.name);
        if (this.attributes != null) {
            Charset charset = Charset.forName(encoding);
            CharsetEncoder encoder = charset.newEncoder();
            for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
                String prefix;
                String value = (String)entry.getValue();
                if (value == null) continue;
                out.print(' ');
                QName qname = (QName)entry.getKey();
                String uri = qname.getNamespaceURI();
                String name = qname.getLocalPart();
                if (!("".equals(uri) || (prefix = nsContext.findPrefixByUri(uri)) == null || "xmlns".equals(name) && "xmlns".equals(prefix))) {
                    out.print(prefix);
                    out.print(':');
                }
                out.print(name);
                out.print('=');
                out.print('\"');
                out.print(Str.toXMLString(value, encoder));
                out.print('\"');
            }
        }
        if (currentCtx != nsContext) {
            Set<Map.Entry<String, Object>> entries;
            if (root && parameters.isAddContextNamespaces()) {
                Map<String, String> prefixToUri = nsContext.getAllPrefixToUriMap();
                entries = prefixToUri.entrySet();
                for (Map.Entry<Object, Object> entry : entries) {
                    String prefix = (String)entry.getKey();
                    String uri = (String)entry.getValue();
                    DefaultElement.dumpNamespaceDeclaration(out, uri, prefix);
                }
            } else {
                Map<String, Collection<String>> prefixByUri = nsContext.getPrefixesByUri();
                entries = prefixByUri.entrySet();
                for (Map.Entry<Object, Object> entry : entries) {
                    if (((String)entry.getKey()).length() <= 0) continue;
                    String uri = (String)entry.getKey();
                    Collection prefixes = (Collection)entry.getValue();
                    for (String prefix : prefixes) {
                        DefaultElement.dumpNamespaceDeclaration(out, uri, prefix);
                    }
                }
            }
        }
        if (this.getFirstElement() == null) {
            out.print('/');
        } else {
            out.print('>');
            if (parameters.isPrintIndented()) {
                out.println();
                out.indent();
            }
            for (DefaultElement current = this.getFirstElement(); current != null; current = current.getNextElement()) {
                current.dump(out, false, nsContext, encoding, parameters);
            }
            if (parameters.isPrintIndented()) {
                out.dedent();
            }
            out.print("</");
            if (currentPrefix != null && currentPrefix.length() != 0) {
                out.print(currentPrefix);
                out.print(':');
            }
            out.print(this.name);
        }
        out.print('>');
        if (parameters.isPrintIndented()) {
            out.println();
        }
    }

    private static void dumpNamespaceDeclaration(IndentedPrintWriter out, String uri, String prefix) {
        if (uri != null && uri.length() == 0 || "xmlns".equals(prefix)) {
            return;
        }
        out.print(' ');
        out.print("xmlns");
        if (prefix != null && prefix.length() != 0) {
            out.print(':');
            out.print(prefix);
        }
        out.print("=\"");
        out.print(uri);
        out.print("\" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStore(Writer target, boolean fuegoProcessingInstruction, String encoding) {
        IndentedPrintWriter indentedWriter = null;
        try {
            indentedWriter = new IndentedPrintWriter(target);
            this.dump(indentedWriter, true, fuegoProcessingInstruction, null, encoding);
            indentedWriter.flush();
        }
        catch (Throwable throwable) {
            StreamUtils.close(indentedWriter);
            throw throwable;
        }
        StreamUtils.close(indentedWriter);
    }

    private boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    private boolean hasChildren() {
        return this.first != null;
    }

    public static class DumpParameters {
        private boolean addContextNamespaces;
        private boolean printIndented;

        public DumpParameters() {
            this(false, true);
        }

        public DumpParameters(boolean addContextNamespaces, boolean printIndented) {
            this.setAddContextNamespaces(addContextNamespaces);
            this.setPrintIndented(printIndented);
        }

        public boolean isPrintIndented() {
            return this.printIndented;
        }

        public void setPrintIndented(boolean printIndented) {
            this.printIndented = printIndented;
        }

        public boolean isAddContextNamespaces() {
            return this.addContextNamespaces;
        }

        public void setAddContextNamespaces(boolean addContextNamespaces) {
            this.addContextNamespaces = addContextNamespaces;
        }
    }
}

