/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlgen;

import java.io.IOException;
import java.util.Map;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.xmlgen.BaseGenerator;
import oracle.bpm.xmlgen.XmlConfiguration;

public class XmlFactoryGenerator
extends BaseGenerator {
    public XmlFactoryGenerator(XmlConfiguration config) {
        super(config);
    }

    static String tagConstant(String tagName) {
        return tagName.toUpperCase().replace('-', '_');
    }

    void generate(Map<String, String> tags) throws IOException {
        IndentedPrintWriter out = this.openClass("ElementFactory");
        out.println("package " + this.getJavaPackage() + ";");
        out.println();
        out.println("import oracle.bpm.xmlparser.DefaultFactory;");
        out.println("import oracle.bpm.xmlparser.DefaultElement;");
        out.println("import oracle.bpm.xmlparser.Element;");
        out.println("import javax.xml.namespace.QName;");
        out.println("import java.util.Map;");
        String requires = this.getConfig().getRequires();
        if (requires != null) {
            String[] requireList;
            for (String pkg : requireList = requires.split(",\\s+")) {
                out.println("import " + pkg + ".*;");
            }
        }
        out.println();
        out.println("public class " + this.getPrefix() + "ElementFactory");
        out.println("    extends DefaultFactory");
        out.println("{");
        out.indent();
        out.println("public Element create(String namespace, String name, Map<QName, String> attrs) {");
        out.indent();
        out.println("Element element;");
        out.println("int type = " + this.getPrefix() + "ElementType.findByName(name);");
        out.println();
        out.println("switch (type) {");
        for (String tagName : tags.keySet()) {
            String className = tags.get(tagName);
            if (className.equals(this.getPrefix() + "XMLObject")) continue;
            out.println("case " + this.getPrefix() + "ElementType." + XmlFactoryGenerator.tagConstant(tagName) + ":");
            out.println("    element = new " + className + "();");
            out.println("    break;");
        }
        out.println("default:");
        out.println("    element = new DefaultElement();");
        out.println("    break;");
        out.println("}");
        out.println();
        out.println("init(namespace, name, attrs, (DefaultElement) element);");
        out.println();
        out.println("return element;");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.close();
    }
}

