/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.xhb;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.bpm.log.Log;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xobject.UtilitiesLib;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.presentationComponents.ComponentIdFactory;
import oracle.bpm.xobject.xhb.A;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.IMG;
import oracle.bpm.xobject.xhb.KeyEvents;
import oracle.bpm.xobject.xhb.MouseEvents;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public final class Group
extends Element
implements KeyEvents,
MouseEvents {
    private String addDisabledSrc = null;
    private String addDownDisabledSrc = null;
    private String addDownSrc = null;
    private String addDownTooltip = null;
    private String addJavaScript = null;
    private String addSrc = null;
    private String addTootlip = null;
    private String addUpDisabledSrc = null;
    private String addUpSrc = null;
    private String addUpTooltip = null;
    private String bgColor = null;
    private String cachedHtmlCode = null;
    private int cellpadding = 0;
    private int cellspacing = 0;
    private String fgColor = null;
    private String groupName;
    private String headerAlignment;
    private String headerClickJavascript = null;
    private String headerCssClass = null;
    private boolean headerEnabled = true;
    private String[] headers;
    private String headerSortDownTypeImageSrc = null;
    private int headerSortedColumnIndex = -1;
    private String headerSortedStyle = null;
    private int headerSortedType = -1;
    private String headerSortUpTypeImageSrc = null;
    private String headerStyle = null;
    private int[] headersWidth;
    private int highPageIndex = -1;
    private ArrayList<GroupRow> htmlCodeRowList;
    private String id = String.valueOf(System.currentTimeMillis());
    private String indexAnchorStyle = null;
    private String indexCellStyle = null;
    private String indexCssClass = null;
    private boolean indexEnabled = true;
    private boolean indexTabNavigation = false;
    private String insertDownJavaScript = null;
    private String insertUpJavaScript = null;
    private boolean isDirty = true;
    private boolean isReadOnly = false;
    private boolean isToolbarDirty = true;
    private boolean isVisible = true;
    private boolean isVisibleCollapsed = false;
    private int lowPageIndex = 0;
    private String minusDisabledSrc = null;
    private String minusSrc = null;
    private String minusTooltip = null;
    private String nextPagingDisabledSrc = null;
    private String nextPagingJavaScript = null;
    private String nextPagingSrc = null;
    private String onFocusScript = null;
    private String pagingCellStyle = null;
    private String pagingCssClass = null;
    private String pagingFontStyle = null;
    private boolean pagingShowAll = false;
    private String prevPagingDisabledSrc = null;
    private String prevPagingJavaScript = null;
    private String prevPagingSrc = null;
    private String removeDisabledSrc = null;
    private String removeJavaScript = null;
    private String removeLastJavaScript = null;
    private String removeSrc = null;
    private String removeTooltip = null;
    private String rowEvenCssClass;
    private String rowEvenStyle;
    private String rowOddCssClass;
    private String rowOddStyle;
    private int tabIndex = 0;
    private String toolbarHtmlCode = null;
    private int totalRowQty = -1;
    public static final int SORT_NONE_ORDER = -1;
    public static final int SORT_ASCENDING_ORDER = 0;
    public static final int SORT_DESCENDING_ORDER = 1;
    private static final String TAG_NAME = "Table";
    static final long serialVersionUID = -5581646294000789069L;
    static final long serialCheck = 6409973181806292770L;

    public Group(String[] headers, int[] headersWidth) {
        this(null, headers, headersWidth);
    }

    public Group(String id, String[] headers, int[] headersWidth) {
        super(TAG_NAME, id);
        this.htmlCodeRowList = new ArrayList();
        this.headersWidth = headersWidth;
        this.headers = headers;
        this.groupName = this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int compQty = 10;
        String[] headerText = new String[compQty];
        int[] headerWidth = new int[compQty];
        TR modelTR = new TR();
        for (int i = 0; i < compQty; ++i) {
            headerText[i] = "Title #" + i;
            headerWidth[i] = 10;
            TD comTD = new TD(String.valueOf(i));
            comTD.setStyle("background-color: #F3F8FC;color: #FF0000");
            comTD.addChild(new Text(String.valueOf(i), "Text #" + i));
            modelTR.addChild(comTD);
        }
        Group testGroup = new Group("group1", headerText, new int[]{1, 2, 3});
        testGroup.setHeaderStyle("border-bottom: 2px solid  #000000;border-top: 2px solid  #000000;background-color: #7887BC");
        testGroup.setIndexCellStyle("background-color: #7887BC;font: bold small-caps 8pt sans-serif ");
        testGroup.setPagingCellStyle("background-color: #00FF00;font: bold small-caps 10pt sans-serif");
        try {
            testGroup.setPagingRange(0, 5);
            testGroup.setRowQtyWithoutPaging(35);
            testGroup.addRow(modelTR);
            testGroup.addRow(modelTR);
            testGroup.addRow(modelTR);
            testGroup.addRow(modelTR);
            testGroup.addRow(modelTR);
            testGroup.addRow(modelTR);
            testGroup.addRow(modelTR);
            testGroup.addRow(modelTR);
            TR modelTR2 = new TR();
            for (int i = 0; i < compQty; ++i) {
                headerText[i] = "Title #" + i;
                TD comTD = new TD(String.valueOf(i));
                comTD.setStyle("background-color: #FF0000;color: #0000FF");
                comTD.addChild(new Text(String.valueOf(i), "Text #" + i));
                modelTR2.addChild(comTD);
            }
            testGroup.insertRow(10, modelTR2);
            testGroup.insertRow(1, modelTR2);
            testGroup.insertRow(3, modelTR2);
            testGroup.removeRow();
            testGroup.addRow(modelTR2);
            testGroup.removeRow(100);
            testGroup.removeRow(0);
            testGroup.removeRow(-100);
            testGroup.removeRow(5);
            testGroup.removeRow(3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OutputStreamWriter fWriter = null;
        try {
            File htmlCodeFile = new File("c:/tmp/groupTest.html");
            fWriter = new FileWriter(htmlCodeFile);
            fWriter.write(testGroup.getHtmlText());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fWriter != null) {
                    fWriter.flush();
                    fWriter.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setAddJavaScript(String addJavaScript) {
        this.addJavaScript = addJavaScript;
        this.setToolbarDirty();
    }

    public String getAddJavaScript() {
        return this.addJavaScript;
    }

    public void setBgColor(String bgColor) {
        if (bgColor != null) {
            this.bgColor = bgColor;
        }
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setCellpadding(int cellpadding) {
        this.cellpadding = cellpadding;
    }

    public int getCellpadding() {
        return this.cellpadding;
    }

    public void setCellspacing(int cellspacing) {
        this.cellspacing = cellspacing;
    }

    public int getCellspacing() {
        return this.cellspacing;
    }

    public void setDownSortImageSrc(String downSrc) {
        this.headerSortDownTypeImageSrc = downSrc;
    }

    public String getDownSortImageSrc() {
        return this.headerSortDownTypeImageSrc;
    }

    public void setEvenRowCssClass(String cssClass) {
        this.rowEvenCssClass = cssClass;
    }

    public String getEvenRowCssClass() {
        return this.rowEvenCssClass;
    }

    public void setEvenRowStyle(String style) {
        this.rowEvenStyle = style;
    }

    public String getEvenRowStyle() {
        return this.rowEvenStyle;
    }

    public void setFgColor(String fgColor) {
        if (fgColor != null) {
            this.fgColor = fgColor;
        }
    }

    public String getFgColor() {
        return this.fgColor;
    }

    public void setGralToolBarImageSrc(String addSrc, String addDisabledSrc, String minusSrc, String minusDisabledSrc) {
        this.addSrc = addSrc;
        this.addDisabledSrc = addDisabledSrc;
        this.minusSrc = minusSrc;
        this.minusDisabledSrc = minusDisabledSrc;
        this.setToolbarDirty();
    }

    public void setGralToolBarTooltips(String addTooltip, String minusTooltip) {
        this.addTootlip = addTooltip;
        this.minusTooltip = minusTooltip;
        this.setToolbarDirty();
    }

    public void setHeaderAlignment(String headerAlignment) {
        this.headerAlignment = headerAlignment;
        this.setDirty();
    }

    public String getHeaderAlignment() {
        return this.headerAlignment;
    }

    public void setHeaderClickJavaScript(String headerClickJavaScript) {
        this.headerClickJavascript = headerClickJavaScript;
    }

    public String getHeaderClickJavaScript() {
        return this.headerClickJavascript;
    }

    public void setHeaderCssClass(String cssClass) {
        this.headerCssClass = cssClass;
        this.setDirty();
    }

    public String getHeaderCssClass() {
        return this.headerCssClass;
    }

    public void setHeaderEnabled(boolean enabled) {
        this.headerEnabled = enabled;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderSortedStyle(String style) {
        this.headerSortedStyle = style;
    }

    public String getHeaderSortedStyle() {
        return this.headerSortedStyle;
    }

    public void setHeaderStyle(String style) {
        this.headerStyle = style;
        this.setDirty();
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
        this.setDirty();
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeadersWidth(int[] headersWidth) {
        this.headersWidth = headersWidth;
        this.setDirty();
    }

    public int[] getHeadersWidth() {
        return this.headersWidth;
    }

    @Override
    public void setHtmlId(String id) {
        if (id != null) {
            super.setHtmlId(id);
            this.id = id;
        }
    }

    public void setIndexTabNavigation(boolean indextabenabled) {
        this.indexTabNavigation = indextabenabled;
    }

    public boolean getIndexTabNavigation() {
        return this.indexTabNavigation;
    }

    @Override
    public String getHtmlText() throws IOException {
        if (this.isDirty() || this.cachedHtmlCode == null) {
            StringBuffer groupHtmlCode = new StringBuffer();
            groupHtmlCode.append("<TABLE cellpadding=\"0\" cellspacing=\"0\" style=\"");
            groupHtmlCode.append(this.getVisibilityStyle());
            groupHtmlCode.append("\">\n");
            groupHtmlCode.append("\n<!-- Toolbar -->\n");
            groupHtmlCode.append("<TR ");
            groupHtmlCode.append(this.isReadOnly() || !this.isVisible() ? "style=\"display:none;\"" : "");
            groupHtmlCode.append(">\n");
            if (this.isToolbarDirty() || this.toolbarHtmlCode == null) {
                this.toolbarHtmlCode = this.getGroupToolbarTD().getHtmlText();
                this.unsetToolbarDirty();
            }
            groupHtmlCode.append(this.toolbarHtmlCode);
            groupHtmlCode.append("</TR>\n");
            groupHtmlCode.append("\n  <!-- Group Body -->\n");
            groupHtmlCode.append("<TR>\n");
            groupHtmlCode.append("<TD align=\"left\" valign=\"top\">\n");
            groupHtmlCode.append("  <TABLE");
            for (Element.Attribute o : this.getAllAttributes().values()) {
                groupHtmlCode.append(" ");
                groupHtmlCode.append(o.getHTML());
            }
            groupHtmlCode.append(" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            groupHtmlCode.append("  <TBODY>\n");
            groupHtmlCode.append("  <TR>\n");
            groupHtmlCode.append("  <TD>\n");
            groupHtmlCode.append("  <TABLE cellpadding=\"");
            groupHtmlCode.append(this.getCellpadding());
            groupHtmlCode.append("\" cellspacing=\"");
            groupHtmlCode.append(this.getCellspacing());
            groupHtmlCode.append("\" border=\"0\">\n");
            groupHtmlCode.append(this.getColGroup());
            if (this.isHeaderEnabled()) {
                groupHtmlCode.append("\n  <!-- Headers -->\n");
                groupHtmlCode.append(this.getGroupHeaderTR().getHtmlText());
            }
            for (GroupRow aHtmlCodeRowList : this.htmlCodeRowList) {
                groupHtmlCode.append("\n  <!-- Group TR -->\n");
                groupHtmlCode.append(aHtmlCodeRowList.getHtmlText());
            }
            if (this.hasPagingRange()) {
                groupHtmlCode.append("\n  <!-- Paging -->\n");
                groupHtmlCode.append(this.getGroupPagingTR().getHtmlText());
            }
            groupHtmlCode.append("  </TABLE>\n");
            groupHtmlCode.append("  </TD>\n");
            groupHtmlCode.append("  </TR>\n");
            groupHtmlCode.append("  </TBODY>\n");
            groupHtmlCode.append("  </TABLE>\n");
            groupHtmlCode.append("</TD>\n");
            groupHtmlCode.append("</TR>\n");
            groupHtmlCode.append("</TABLE>\n");
            this.cachedHtmlCode = groupHtmlCode.toString();
            this.unsetDirty();
        }
        return this.cachedHtmlCode;
    }

    public void setIndexAnchorStyle(String style) {
        this.indexAnchorStyle = style;
        this.setDirty();
    }

    public String getIndexAnchorStyle() {
        return this.indexAnchorStyle;
    }

    public void setIndexCellStyle(String style) {
        this.indexCellStyle = style;
        this.setDirty();
    }

    public String getIndexCellStyle() {
        return this.indexCellStyle;
    }

    public void setIndexCssClass(String cssClass) {
        this.indexCssClass = cssClass;
        this.setDirty();
    }

    public String getIndexCssClass() {
        return this.indexCssClass;
    }

    public void setIndexEnabled(boolean enabled) {
        this.indexEnabled = enabled;
    }

    public boolean isIndexEnabled() {
        return this.indexEnabled;
    }

    public void setInsertDownJavaScript(String insertDownJavaScript) {
        this.insertDownJavaScript = insertDownJavaScript;
        this.setToolbarDirty();
    }

    public String getInsertDownJavaScript() {
        return this.insertDownJavaScript;
    }

    public void setInsertUpJavaScript(String insertUpJavaScript) {
        this.insertUpJavaScript = insertUpJavaScript;
        this.setToolbarDirty();
    }

    public String getInsertUpJavaScript() {
        return this.insertUpJavaScript;
    }

    public void setNextPagingDisabledImageSrc(String nextPagingDisabledSrc) {
        this.nextPagingDisabledSrc = nextPagingDisabledSrc;
    }

    public String getNextPagingDisabledImageSrc() {
        return this.nextPagingDisabledSrc;
    }

    public void setNextPagingImageSrc(String nextPagingSrc) {
        this.nextPagingSrc = nextPagingSrc;
    }

    public String getNextPagingImageSrc() {
        return this.nextPagingSrc;
    }

    public void setNextPagingJavaScript(String nextPagingJavaScript) {
        this.nextPagingJavaScript = nextPagingJavaScript;
    }

    public String getNextPagingJavaScript() {
        return this.nextPagingJavaScript;
    }

    public void setOddRowCssClass(String cssClass) {
        this.rowOddCssClass = cssClass;
    }

    public String getOddRowCssClass() {
        return this.rowOddCssClass;
    }

    public void setOddRowStyle(String style) {
        this.rowOddStyle = style;
    }

    public String getOddRowStyle() {
        return this.rowOddStyle;
    }

    @Override
    public void setOnFocus(String script) {
        this.onFocusScript = script;
    }

    @Override
    public void setOnMouseMove(String script) {
        super.setOnMouseMove(script);
    }

    @Override
    public void setOnMouseOut(String script) {
        super.setOnMouseOut(script);
    }

    @Override
    public void setOnMouseOver(String script) {
        super.setOnMouseOver(script);
    }

    @Override
    public void setOnMouseUp(String script) {
        super.setOnMouseUp(script);
    }

    public void setPagingCellStyle(String pagingCellStyle) {
        this.pagingCellStyle = pagingCellStyle;
        if (this.hasPagingRange()) {
            this.setDirty();
        }
    }

    public String getPagingCellStyle() {
        return this.pagingCellStyle;
    }

    public void setPagingCssClass(String cssClass) {
        this.pagingCssClass = cssClass;
        if (this.hasPagingRange()) {
            this.setDirty();
        }
    }

    public String getPagingCssClass() {
        return this.pagingCssClass;
    }

    public void setPagingRange(int lowPageIndex, int highPageIndex) {
        this.lowPageIndex = lowPageIndex;
        this.highPageIndex = highPageIndex;
        this.htmlCodeRowList.clear();
        this.setDirty();
    }

    public int[] getPagingRange() {
        return new int[]{this.lowPageIndex, this.highPageIndex};
    }

    public int getPagingRangeQty() {
        return this.highPageIndex - this.lowPageIndex + 1;
    }

    public void setPagingShowAll(boolean showAll) {
        this.pagingShowAll = showAll;
    }

    public boolean isPagingShowAll() {
        return this.pagingShowAll;
    }

    public void setPagingTextStyle(String pagingTextStyle) {
        this.pagingFontStyle = pagingTextStyle;
        if (this.hasPagingRange()) {
            this.setDirty();
        }
    }

    public String getPagingTextStyle() {
        return this.pagingFontStyle;
    }

    public void setPrevPagingDisabledImageSrc(String prevPagingDisabledSrc) {
        this.prevPagingDisabledSrc = prevPagingDisabledSrc;
    }

    public String getPrevPagingDisabledImageSrc() {
        return this.prevPagingDisabledSrc;
    }

    public void setPrevPagingImageSrc(String prevPagingSrc) {
        this.prevPagingSrc = prevPagingSrc;
    }

    public String getPrevPagingImageSrc() {
        return this.prevPagingSrc;
    }

    public void setPrevPagingJavaScript(String prevPagingJavaScript) {
        this.prevPagingJavaScript = prevPagingJavaScript;
    }

    public String getPrevPagingJavaScript() {
        return this.prevPagingJavaScript;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.isReadOnly) {
            this.setDirty();
        }
        this.isReadOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setRemoveJavaScript(String removeJavaScript) {
        this.removeJavaScript = removeJavaScript;
        this.setToolbarDirty();
    }

    public String getRemoveJavaScript() {
        return this.removeJavaScript;
    }

    public void setRemoveLastJavaScript(String removeLastJavaScript) {
        this.removeLastJavaScript = removeLastJavaScript;
        this.setToolbarDirty();
    }

    public String getRemoveLastJavaScript() {
        return this.removeLastJavaScript;
    }

    public void setRow(int groupIndex, TR tr) throws IOException {
        int index = this.convertGroupRealIndexToArrayIndex(groupIndex);
        if (index >= 0 && index < this.htmlCodeRowList.size()) {
            this.htmlCodeRowList.set(index, this.getGroupTR(tr, groupIndex));
            this.setDirty();
        } else if (index == this.htmlCodeRowList.size()) {
            this.addRow(tr);
        } else if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XHB_GROUP_SET_OUT_OF_BOUNDS(String.valueOf(index), String.valueOf(this.htmlCodeRowList.size())));
        }
    }

    public void setRowQtyWithoutPaging(int totalRowQty) {
        if (this.totalRowQty != totalRowQty) {
            this.totalRowQty = totalRowQty;
            this.setDirty();
        }
    }

    public int getRowQtyWithoutPaging() {
        return this.totalRowQty;
    }

    public void setSelectToolBarImageSrc(String addUpSrc, String addUpDisabledSrc, String addDownSrc, String addDownDisabledSrc, String removeSrc, String removeDisabledSrc) {
        this.addUpSrc = addUpSrc;
        this.addUpDisabledSrc = addUpDisabledSrc;
        this.addDownSrc = addDownSrc;
        this.addDownDisabledSrc = addDownDisabledSrc;
        this.removeSrc = removeSrc;
        this.removeDisabledSrc = removeDisabledSrc;
        this.setToolbarDirty();
    }

    public void setSelectToolBarTooltips(String addUpTooltip, String addDownTooltip, String removeTooltip) {
        this.addUpTooltip = addUpTooltip;
        this.addDownTooltip = addDownTooltip;
        this.removeTooltip = removeTooltip;
        this.setToolbarDirty();
    }

    public void setSortedColumn(int columnIndex, int orderType) {
        if (this.headerSortedColumnIndex != columnIndex || this.headerSortedType != orderType) {
            this.headerSortedColumnIndex = columnIndex;
            this.headerSortedType = orderType;
            this.setDirty();
        }
    }

    @Override
    public void setStyle(String style) {
        this.addAttribute(STYLE_PROPERTY, style);
        this.setDirty();
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setToolbarDirty() {
        this.isToolbarDirty = true;
    }

    public boolean isToolbarDirty() {
        return this.isToolbarDirty;
    }

    public void setUpSortImageSrc(String upSrc) {
        this.headerSortUpTypeImageSrc = upSrc;
    }

    public String getUpSortImageSrc() {
        return this.headerSortUpTypeImageSrc;
    }

    public void setVisible(boolean isVisible, boolean isVisibleCollapsed) {
        if (this.isVisible != isVisible || this.isVisibleCollapsed != isVisibleCollapsed) {
            this.isVisible = isVisible;
            this.isVisibleCollapsed = isVisibleCollapsed;
            this.setDirty();
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isVisibleCollapsed() {
        return this.isVisibleCollapsed;
    }

    public void addRow(TR tr) throws IOException {
        boolean isGroupFull = false;
        int index = this.htmlCodeRowList.size();
        if (this.hasPagingRange()) {
            if (this.htmlCodeRowList.size() >= this.getPagingRangeQty()) {
                isGroupFull = true;
            } else {
                index += this.lowPageIndex;
            }
        }
        if (!isGroupFull) {
            this.htmlCodeRowList.add(this.getGroupTR(tr, index));
            this.setDirty();
        } else if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XHB_GROUP_ADD_FULL);
        }
    }

    public void clearRows() {
        this.htmlCodeRowList.clear();
        this.setDirty();
    }

    public boolean hasPagingRange() {
        return this.highPageIndex != -1;
    }

    public void insertRow(int groupIndex, TR tr) throws IOException {
        int index = this.convertGroupRealIndexToArrayIndex(groupIndex);
        if (index == this.htmlCodeRowList.size()) {
            this.addRow(tr);
        } else if (index >= 0 && index < this.htmlCodeRowList.size()) {
            this.htmlCodeRowList.add(index, this.getGroupTR(tr, index));
            if (this.hasPagingRange() && this.htmlCodeRowList.size() > this.getPagingRangeQty()) {
                this.removeRow();
            }
            this.refreshTrs();
            this.setDirty();
        } else if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XHB_GROUP_INSERT_OUT_OF_RANGE(String.valueOf(index), String.valueOf(this.htmlCodeRowList.size()), ArrayUtils.toString(this.getPagingRange())));
        }
    }

    @Override
    public void setOnClick(String script) {
        super.setOnClick(script);
    }

    @Override
    public void setOnDblClick(String script) {
        super.setOnDblClick(script);
    }

    @Override
    public void setOnKeyDown(String script) {
        super.setOnKeyDown(script);
    }

    @Override
    public void setOnKeyPress(String script) {
        super.setOnKeyPress(script);
    }

    @Override
    public void setOnKeyUp(String script) {
        super.setOnKeyUp(script);
    }

    @Override
    public void setOnMouseDown(String script) {
        super.setOnMouseDown(script);
    }

    public void removeRow() throws IOException {
        if (!this.htmlCodeRowList.isEmpty()) {
            this.htmlCodeRowList.remove(this.htmlCodeRowList.size() - 1);
            this.setDirty();
        }
    }

    public void removeRow(int groupIndex) throws IOException {
        int index = this.convertGroupRealIndexToArrayIndex(groupIndex);
        if (index >= 0 && index < this.htmlCodeRowList.size()) {
            this.htmlCodeRowList.remove(index);
            this.refreshTrs();
            this.setDirty();
        } else if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XHB_GROUP_REMOVE_OUT_OF_BOUNDS(String.valueOf(index), String.valueOf(this.htmlCodeRowList.size())));
        }
    }

    public void removeRows(int groupIndexStart, int groupIndexEnd) {
        int index = this.convertGroupRealIndexToArrayIndex(groupIndexStart);
        int rowQty = groupIndexEnd - groupIndexStart;
        if (index >= 0 && index < this.htmlCodeRowList.size()) {
            for (int i = 0; i <= rowQty; ++i) {
                if (index < 0 || index >= this.htmlCodeRowList.size()) continue;
                this.htmlCodeRowList.remove(index);
            }
            this.refreshTrs();
            this.setDirty();
        } else if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XHB_GROUP_REMOVE_OUT_OF_BOUNDS(String.valueOf(index), String.valueOf(this.htmlCodeRowList.size())));
        }
    }

    public void resetPagingRange() {
        this.lowPageIndex = 0;
        this.highPageIndex = -1;
        this.htmlCodeRowList.clear();
        this.setDirty();
    }

    public int size() {
        return this.htmlCodeRowList.size();
    }

    public void unsetToolbarDirty() {
        this.isToolbarDirty = false;
    }

    @Override
    public void writeHtmlText(Writer w) throws IOException {
        w.write(this.getHtmlText());
    }

    @Override
    protected boolean hasCloseTag() {
        return false;
    }

    private String getColGroup() {
        StringBuffer colGroupBuffer = new StringBuffer();
        colGroupBuffer.append("<COLGROUP>\n");
        if (this.isIndexEnabled()) {
            colGroupBuffer.append("<COL />\n");
        }
        for (int i = 0; i < this.headers.length; ++i) {
            colGroupBuffer.append("<COL");
            if (this.headersWidth != null) {
                colGroupBuffer.append(" width=\"");
                colGroupBuffer.append(this.headersWidth[i]);
                colGroupBuffer.append("px\"");
            }
            colGroupBuffer.append("/>\n");
        }
        colGroupBuffer.append("</COLGROUP>\n");
        return colGroupBuffer.toString();
    }

    private void setDirty() {
        this.isDirty = true;
    }

    private boolean isDirty() {
        return this.isDirty;
    }

    private TD getGroupHeaderTD(int headerIndex, String headerTxt, String cellId, boolean isPlainHeader) {
        IMG orderTypeImage = null;
        TD headerTD = new TD();
        headerTD.setStyle(this.getHeaderStyle());
        headerTD.setCssClass(this.getHeaderCssClass());
        headerTD.setAlign(this.headerAlignment);
        DIV headerDIV = new DIV();
        headerDIV.setHtmlId(cellId);
        Text headerText = new Text();
        if (isPlainHeader) {
            headerText.setPlainText(headerTxt);
        } else {
            headerText.setText(headerTxt);
            if (this.getHeaderClickJavaScript() != null) {
                headerDIV.setOnClick(this.getHeaderClickJavaScript());
                headerDIV.setOnMouseOver("this.style.cursor = 'pointer'");
                headerDIV.setOnMouseOut("this.style.cursor = 'auto'");
                headerDIV.setStyle("text-decoration: underline;");
                if (this.headerSortedColumnIndex != -1 && this.headerSortedColumnIndex == headerIndex) {
                    orderTypeImage = new IMG();
                    orderTypeImage.setBorder(0);
                    String src = this.headerSortedType == 0 ? this.getDownSortImageSrc() : this.getUpSortImageSrc();
                    orderTypeImage.setSrc(src);
                    headerTD.setStyle(this.getHeaderSortedStyle());
                }
            }
        }
        headerDIV.addChild(headerText);
        if (orderTypeImage != null) {
            headerDIV.addChild(orderTypeImage);
        }
        headerTD.addChild(headerDIV);
        return headerTD;
    }

    private TR getGroupHeaderTR() {
        TR headerTR = new TR();
        if (this.isIndexEnabled()) {
            headerTR.addChild(this.getGroupHeaderTD(-1, "&nbsp;", this.buildHeaderId(this.groupName, -1), true));
        }
        for (int i = 0; i < this.headers.length; ++i) {
            String header = this.headers[i];
            headerTR.addChild(this.getGroupHeaderTD(i, header, this.buildHeaderId(this.groupName, i), false));
        }
        return headerTR;
    }

    private String buildHeaderId(String groupName, int index) {
        return ComponentIdFactory.buildGroupHeaderId(groupName, index);
    }

    private TR getGroupPagingTR() {
        TR pagingTR = new TR("pagingTR");
        TD pagingTD = new TD("pagingTD");
        pagingTD.setColSpan(String.valueOf(this.headers.length + 1));
        pagingTD.setAlign("left");
        pagingTD.setVAlign("top");
        pagingTD.setStyle(this.getPagingCellStyle());
        pagingTD.setCssClass(this.getPagingCssClass());
        Table pagingTable = new Table("pagingTable");
        pagingTable.setCellPadding("1");
        pagingTable.setCellSpacing("5");
        pagingTable.setBorder("0");
        TR pagingTableTR = new TR("pagingTableTR");
        TD prevTD = new TD("prevTD");
        prevTD.setAlign("right");
        prevTD.setVAlign("middle");
        IMG prevIMG = new IMG("prevIMG");
        prevIMG.setHtmlId(this.groupName + "$prevIMG");
        prevIMG.setBorder(0);
        if (this.isPrevPagingDisabled()) {
            prevIMG.setSrc(this.getPrevPagingDisabledImageSrc());
            prevTD.addChild(prevIMG);
        } else {
            A prevAnchor = new A("prevAnchor");
            prevAnchor.setHtmlId(this.groupName + "$prevAnchor");
            prevAnchor.setOnClick(this.getPrevPagingJavaScript());
            prevAnchor.setHref("#");
            prevAnchor.setHtmlId(this.id.concat("_paging_prev"));
            prevAnchor.setOnFocus(this.onFocusScript);
            prevIMG.setSrc(this.getPrevPagingImageSrc());
            prevAnchor.addChild(prevIMG);
            prevTD.addChild(prevAnchor);
        }
        TD indexTD = new TD("indexTD");
        indexTD.setStyle(this.getPagingTextStyle());
        indexTD.setAlign("center");
        A indexAnchor = new A("indexAnchor");
        indexAnchor.setHtmlId(this.groupName + "$indexAnchor");
        indexAnchor.addChild(new Text("total", " / " + String.valueOf(this.totalRowQty)));
        String lowIndex = this.totalRowQty == 0 ? "0" : String.valueOf(this.lowPageIndex + 1);
        String highIndex = this.totalRowQty <= this.highPageIndex + 1 ? String.valueOf(this.totalRowQty) : String.valueOf(this.highPageIndex + 1);
        indexTD.addChild(new Text("pagingIndexes", lowIndex + " - " + highIndex));
        indexTD.addChild(indexAnchor);
        TD nextTD = new TD("nextTD");
        nextTD.setAlign("left");
        nextTD.setVAlign("middle");
        IMG nextIMG = new IMG("nextIMG");
        nextIMG.setHtmlId(this.groupName + "$nextIMG");
        nextIMG.setBorder(0);
        if (this.isNextPagingDisabled()) {
            nextIMG.setSrc(this.getNextPagingDisabledImageSrc());
            nextTD.addChild(nextIMG);
        } else {
            A nextAnchor = new A("nextAnchor");
            nextAnchor.setHtmlId(this.groupName + "$nextAnchor");
            nextAnchor.setOnClick(this.getNextPagingJavaScript());
            nextAnchor.setHref("#");
            nextAnchor.setHtmlId(this.id.concat("_paging_next"));
            nextAnchor.setOnFocus(this.onFocusScript);
            nextIMG.setSrc(this.getNextPagingImageSrc());
            nextAnchor.addChild(nextIMG);
            nextTD.addChild(nextAnchor);
        }
        pagingTR.addChild(pagingTD);
        pagingTD.addChild(pagingTable);
        pagingTable.addChild(pagingTableTR);
        pagingTableTR.addChild(prevTD);
        pagingTableTR.addChild(indexTD);
        pagingTableTR.addChild(nextTD);
        return pagingTR;
    }

    private GroupRow getGroupTR(TR modelTR, int index) throws IOException {
        return new GroupRow(modelTR, index, this.isReadOnly());
    }

    private TD getGroupToolbarTD() {
        TD toolbarTD = new TD(this.groupName + "$toolbarTd");
        Table toolbarTable = new Table("toolbarTable");
        toolbarTable.setCellPadding("0");
        toolbarTable.setCellSpacing("0");
        toolbarTable.setWidth("100%");
        toolbarTable.setHeight("100%");
        TR toolbarTableTR = new TR("toolbarTableTR");
        TD toolbarGralTD = new TD("toolbarGralTD");
        Table toolbarGralTable = new Table("toolbarGralTable");
        toolbarGralTable.setCellPadding("4");
        toolbarGralTable.setCellSpacing("0");
        TR toolbarGralTableTR = new TR("toolbarGralTableTR");
        DIV toolbarGralTableAddDIV = new DIV("toolbarGralTableAddDIV");
        toolbarGralTableAddDIV.setHtmlId(this.groupName + "$addDIV");
        A toolbarGralTableAddAnchor = new A("toolbarGralTableAddAnchor");
        toolbarGralTableAddAnchor.setHref("#");
        toolbarGralTableAddAnchor.setOnClick(this.getAddJavaScript());
        toolbarGralTableAddAnchor.setHtmlId(this.id.concat("_toolbar_add"));
        toolbarGralTableAddAnchor.setOnFocus(this.onFocusScript);
        toolbarGralTableAddAnchor.setTabIndex(this.getTabIndex());
        TD toolbarGralTableAddTD = new TD("toolbarGralTableAddTD");
        IMG addIMG = new IMG("addImage");
        addIMG.setSrc(this.addSrc);
        addIMG.setBorder(0);
        addIMG.setWidth(15);
        addIMG.setHeight(17);
        addIMG.setVspace(0);
        addIMG.setHspace(0);
        addIMG.setTitle(this.addTootlip);
        DIV toolbarGralTableAddDisabledDIV = new DIV("toolbarGralTableAddDisabledDIV");
        toolbarGralTableAddDisabledDIV.setHtmlId(this.groupName + "$addDisabledDIV");
        toolbarGralTableAddDisabledDIV.setStyle("display:none");
        IMG addDisabledIMG = new IMG("addDisabledIMG");
        addDisabledIMG.setSrc(this.addDisabledSrc);
        addDisabledIMG.setBorder(0);
        addDisabledIMG.setWidth(15);
        addDisabledIMG.setHeight(17);
        addDisabledIMG.setVspace(0);
        addDisabledIMG.setHspace(0);
        addDisabledIMG.setTitle(this.addTootlip);
        DIV toolbarGralTableMinusDIV = new DIV("toolbarGralTableMinusDIV");
        toolbarGralTableMinusDIV.setHtmlId(this.groupName + "$minusDIV");
        A toolbarGralTableMinusAnchor = new A("toolbarGralTableMinusAnchor");
        toolbarGralTableMinusAnchor.setHref("#");
        toolbarGralTableMinusAnchor.setOnClick(this.getRemoveLastJavaScript());
        toolbarGralTableMinusAnchor.setHtmlId(this.id.concat("_toolbar_minus"));
        toolbarGralTableMinusAnchor.setOnFocus(this.onFocusScript);
        toolbarGralTableMinusAnchor.setTabIndex(this.getTabIndex());
        TD toolbarGralTableMinusTD = new TD("toolbarGralTableMinusTD");
        IMG minusIMG = new IMG("minusImage");
        minusIMG.setSrc(this.minusSrc);
        minusIMG.setBorder(0);
        minusIMG.setWidth(15);
        minusIMG.setHeight(17);
        minusIMG.setVspace(0);
        minusIMG.setHspace(0);
        minusIMG.setTitle(this.minusTooltip);
        DIV toolbarGralTableMinusDisabledDIV = new DIV("toolbarGralTableMinusDisabledDIV");
        toolbarGralTableMinusDisabledDIV.setHtmlId(this.groupName + "$minusDisabledDIV");
        toolbarGralTableMinusDisabledDIV.setStyle("display:none");
        IMG minusDisabledIMG = new IMG("minusDisabledIMG");
        minusDisabledIMG.setSrc(this.minusDisabledSrc);
        minusDisabledIMG.setBorder(0);
        minusDisabledIMG.setWidth(15);
        minusDisabledIMG.setHeight(17);
        minusDisabledIMG.setVspace(0);
        minusDisabledIMG.setHspace(0);
        minusDisabledIMG.setTitle(this.minusTooltip);
        toolbarGralTD.setStyle(this.getHeaderStyle());
        toolbarGralTD.setCssClass(this.getHeaderCssClass());
        toolbarGralTableAddAnchor.addChild(addIMG);
        toolbarGralTableAddDIV.addChild(toolbarGralTableAddAnchor);
        toolbarGralTableAddDisabledDIV.addChild(addDisabledIMG);
        toolbarGralTableAddTD.addChild(toolbarGralTableAddDIV);
        toolbarGralTableAddTD.addChild(toolbarGralTableAddDisabledDIV);
        toolbarGralTableMinusAnchor.addChild(minusIMG);
        toolbarGralTableMinusDIV.addChild(toolbarGralTableMinusAnchor);
        toolbarGralTableMinusDisabledDIV.addChild(minusDisabledIMG);
        toolbarGralTableMinusTD.addChild(toolbarGralTableMinusDIV);
        toolbarGralTableMinusTD.addChild(toolbarGralTableMinusDisabledDIV);
        toolbarGralTableTR.addChild(toolbarGralTableAddTD);
        toolbarGralTableTR.addChild(toolbarGralTableMinusTD);
        toolbarGralTable.addChild(toolbarGralTableTR);
        toolbarGralTD.addChild(toolbarGralTable);
        toolbarTableTR.addChild(toolbarGralTD);
        if (this.isIndexEnabled()) {
            TD toolbarSelectTD = new TD("toolbarSelectTD");
            Table toolbarSelectTable = new Table("toolbarSelectTable");
            toolbarSelectTable.setCellPadding("4");
            toolbarSelectTable.setCellSpacing("0");
            TR toolbarSelectTableTR = new TR("toolbarSelectTableTR");
            DIV toolbarSelectTableAddUpDIV = new DIV("toolbarSelectTableAddUpDIV");
            toolbarSelectTableAddUpDIV.setHtmlId(this.groupName + "$addUpDIV");
            toolbarSelectTableAddUpDIV.setStyle("display:none");
            A toolbarSelectTableAddUpAnchor = new A("toolbarSelectTableAddUpAnchor");
            toolbarSelectTableAddUpAnchor.setHref("#");
            toolbarSelectTableAddUpAnchor.setOnClick(this.getInsertUpJavaScript());
            toolbarSelectTableAddUpAnchor.setHtmlId(this.id.concat("_toolbar_addUp"));
            toolbarSelectTableAddUpAnchor.setOnFocus(this.getOnFocusScritpt(this.id.concat("_toolbar_add")));
            toolbarSelectTableAddUpAnchor.setTabIndex(this.getTabIndex());
            TD toolbarSelectTableAddUpTD = new TD("toolbarSelectTableAddUpTD");
            IMG addUpIMG = new IMG("addUpIMG");
            addUpIMG.setSrc(this.addUpSrc);
            addUpIMG.setBorder(0);
            addUpIMG.setWidth(15);
            addUpIMG.setHeight(17);
            addUpIMG.setVspace(0);
            addUpIMG.setHspace(0);
            addUpIMG.setTitle(this.addUpTooltip);
            DIV toolbarSelectTableAddUpDisabledDIV = new DIV("toolbarSelectTableAddUpDisabledDIV");
            toolbarSelectTableAddUpDisabledDIV.setHtmlId(this.groupName + "$addUpDisabledDIV");
            IMG addUpDisabledIMG = new IMG("addDisabledIMG");
            addUpDisabledIMG.setSrc(this.addUpDisabledSrc);
            addUpDisabledIMG.setBorder(0);
            addUpDisabledIMG.setWidth(15);
            addUpDisabledIMG.setHeight(17);
            addUpDisabledIMG.setVspace(0);
            addUpDisabledIMG.setHspace(0);
            addUpDisabledIMG.setTitle(this.addUpTooltip);
            DIV toolbarSelectTableAddDownDIV = new DIV("toolbarSelectTableAddDownDIV");
            toolbarSelectTableAddDownDIV.setHtmlId(this.groupName + "$addDownDIV");
            toolbarSelectTableAddDownDIV.setStyle("display:none");
            A toolbarSelectTableAddDownAnchor = new A("toolbarSelectTableAddDownAnchor");
            toolbarSelectTableAddDownAnchor.setHref("#");
            toolbarSelectTableAddDownAnchor.setOnClick(this.getInsertDownJavaScript());
            toolbarSelectTableAddDownAnchor.setHtmlId(this.id.concat("_toolbar_addDown"));
            toolbarSelectTableAddDownAnchor.setOnFocus(this.getOnFocusScritpt(this.id.concat("_toolbar_add")));
            toolbarSelectTableAddDownAnchor.setTabIndex(this.getTabIndex());
            TD toolbarSelectTableAddDownTD = new TD("toolbarSelectTableAddDownTD");
            IMG addDownIMG = new IMG("addDownIMG");
            addDownIMG.setSrc(this.addDownSrc);
            addDownIMG.setBorder(0);
            addDownIMG.setWidth(15);
            addDownIMG.setHeight(17);
            addDownIMG.setVspace(0);
            addDownIMG.setHspace(0);
            addDownIMG.setTitle(this.addDownTooltip);
            DIV toolbarSelectTableAddDownDisabledDIV = new DIV("toolbarSelectTableAddDownDisabledDIV");
            toolbarSelectTableAddDownDisabledDIV.setHtmlId(this.groupName + "$addDownDisabledDIV");
            IMG addDownDisabledIMG = new IMG("addDownDisabledIMG");
            addDownDisabledIMG.setSrc(this.addDownDisabledSrc);
            addDownDisabledIMG.setBorder(0);
            addDownDisabledIMG.setWidth(15);
            addDownDisabledIMG.setHeight(17);
            addDownDisabledIMG.setVspace(0);
            addDownDisabledIMG.setHspace(0);
            addDownDisabledIMG.setTitle(this.addDownTooltip);
            DIV toolbarSelectTableRemoveDIV = new DIV("toolbarSelectTableRemoveDIV");
            toolbarSelectTableRemoveDIV.setHtmlId(this.groupName + "$removeDIV");
            toolbarSelectTableRemoveDIV.setStyle("display:none");
            A toolbarSelectTableRemoveAnchor = new A("toolbarSelectTableRemoveAnchor");
            toolbarSelectTableRemoveAnchor.setHref("#");
            toolbarSelectTableRemoveAnchor.setOnClick(this.getRemoveJavaScript());
            toolbarSelectTableRemoveAnchor.setHtmlId(this.id.concat("_toolbar_remove"));
            toolbarSelectTableRemoveAnchor.setOnFocus(this.getOnFocusScritpt(this.id.concat("_toolbar_add")));
            toolbarSelectTableRemoveAnchor.setTabIndex(this.getTabIndex());
            TD toolbarSelectTableRemoveTD = new TD("toolbarSelectTableRemoveTD");
            IMG removeIMG = new IMG("removeIMG");
            removeIMG.setSrc(this.removeSrc);
            removeIMG.setBorder(0);
            removeIMG.setWidth(15);
            removeIMG.setHeight(17);
            removeIMG.setVspace(0);
            removeIMG.setHspace(0);
            removeIMG.setTitle(this.removeTooltip);
            DIV toolbarSelectTableRemoveDisabledDIV = new DIV("toolbarSelectTableRemoveDisabledDIV");
            toolbarSelectTableRemoveDisabledDIV.setHtmlId(this.groupName + "$removeDisabledDIV");
            IMG removeDisabledIMG = new IMG("removeDisabledIMG");
            removeDisabledIMG.setSrc(this.removeDisabledSrc);
            removeDisabledIMG.setBorder(0);
            removeDisabledIMG.setWidth(15);
            removeDisabledIMG.setHeight(17);
            removeDisabledIMG.setVspace(0);
            removeDisabledIMG.setHspace(0);
            removeDisabledIMG.setTitle(this.removeTooltip);
            toolbarSelectTD.setStyle(this.getHeaderStyle());
            toolbarSelectTD.setCssClass(this.getHeaderCssClass());
            toolbarSelectTableAddUpAnchor.addChild(addUpIMG);
            toolbarSelectTableAddUpDIV.addChild(toolbarSelectTableAddUpAnchor);
            toolbarSelectTableAddUpDisabledDIV.addChild(addUpDisabledIMG);
            toolbarSelectTableAddUpTD.addChild(toolbarSelectTableAddUpDIV);
            toolbarSelectTableAddUpTD.addChild(toolbarSelectTableAddUpDisabledDIV);
            toolbarSelectTableAddDownAnchor.addChild(addDownIMG);
            toolbarSelectTableAddDownDIV.addChild(toolbarSelectTableAddDownAnchor);
            toolbarSelectTableAddDownDisabledDIV.addChild(addDownDisabledIMG);
            toolbarSelectTableAddDownTD.addChild(toolbarSelectTableAddDownDIV);
            toolbarSelectTableAddDownTD.addChild(toolbarSelectTableAddDownDisabledDIV);
            toolbarSelectTableRemoveAnchor.addChild(removeIMG);
            toolbarSelectTableRemoveDIV.addChild(toolbarSelectTableRemoveAnchor);
            toolbarSelectTableRemoveDisabledDIV.addChild(removeDisabledIMG);
            toolbarSelectTableRemoveTD.addChild(toolbarSelectTableRemoveDIV);
            toolbarSelectTableRemoveTD.addChild(toolbarSelectTableRemoveDisabledDIV);
            toolbarSelectTableTR.addChild(toolbarSelectTableAddUpTD);
            toolbarSelectTableTR.addChild(toolbarSelectTableAddDownTD);
            toolbarSelectTableTR.addChild(toolbarSelectTableRemoveTD);
            toolbarSelectTable.addChild(toolbarSelectTableTR);
            toolbarSelectTD.addChild(toolbarSelectTable);
            toolbarTableTR.addChild(toolbarSelectTD);
        }
        TD toolbarWhiteTD = new TD(this.groupName + "$toolbarWhiteTD");
        toolbarWhiteTD.setWidth("100%");
        toolbarTableTR.addChild(toolbarWhiteTD);
        toolbarTable.addChild(toolbarTableTR);
        toolbarTD.addChild(toolbarTable);
        return toolbarTD;
    }

    private boolean isNextPagingDisabled() {
        return this.hasPagingRange() && this.totalRowQty <= this.highPageIndex + 1;
    }

    private String getOnFocusScritpt(String id) {
        if (this.onFocusScript != null) {
            return "setLastFocusElement('" + id + "');";
        }
        return this.onFocusScript;
    }

    private boolean isPrevPagingDisabled() {
        return this.hasPagingRange() && this.lowPageIndex <= 0;
    }

    private String getVisibilityStyle() {
        if (!this.isVisible()) {
            if (this.isVisibleCollapsed()) {
                return "display:none;";
            }
            return "visibility:hidden;";
        }
        return "";
    }

    private int convertGroupRealIndexToArrayIndex(int realGroupIndex) {
        if (this.hasPagingRange()) {
            return realGroupIndex - this.lowPageIndex;
        }
        return realGroupIndex;
    }

    private void refreshTrs() {
        for (int i = 0; i < this.htmlCodeRowList.size(); ++i) {
            GroupRow groupRow = this.htmlCodeRowList.get(i);
            groupRow.setGroupIndex(i + this.lowPageIndex);
            String pattern = XOConstants.createGrpIndexRegExp() + "\"";
            String indexSeparator = "\\$";
            for (int j = 0; j < groupRow.htmlCellCodeList.size(); ++j) {
                String cellCode = (String)groupRow.htmlCellCodeList.get(j);
                String fixedCellCode = cellCode.replaceAll(pattern, "\\$" + i + "\"");
                groupRow.htmlCellCodeList.set(j, fixedCellCode);
            }
        }
    }

    private void unsetDirty() {
        this.isDirty = false;
    }

    private class GroupRow {
        private int groupIndex;
        private ArrayList<String> htmlCellCodeList;
        private String htmlTRCode = null;
        private boolean isReadOnly;
        private boolean isRowDirty;

        public GroupRow(TR trModel, int groupIndex, boolean isReadOnly) throws IOException {
            this.groupIndex = groupIndex;
            this.htmlCellCodeList = new ArrayList();
            this.isRowDirty = true;
            this.isReadOnly = isReadOnly;
            this.fillHtmlCellCodeList(trModel);
        }

        public void setGroupIndex(int newGroupIndex) {
            this.groupIndex = newGroupIndex;
            this.isRowDirty = true;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public boolean isRowDirty() {
            return this.isRowDirty;
        }

        private String getHtmlText() throws IOException {
            if (this.isRowDirty || this.htmlTRCode == null) {
                StringBuffer trHtmlCodeBuffer = new StringBuffer();
                String trId = ComponentIdFactory.buildComponentId(this.getRowId());
                TR newTR = new TR(trId);
                newTR.setHtmlId(trId);
                if (this.groupIndex % 2 == 0) {
                    newTR.setStyle(Group.this.getEvenRowStyle());
                    newTR.setCssClass(Group.this.getEvenRowCssClass());
                } else {
                    newTR.setStyle(Group.this.getOddRowStyle());
                    newTR.setCssClass(Group.this.getOddRowCssClass());
                }
                if (Group.this.isIndexEnabled()) {
                    Text indexText;
                    TD indexTD = new TD();
                    indexTD.setStyle(Group.this.getIndexCellStyle());
                    indexTD.setCssClass(Group.this.getIndexCssClass());
                    StringBuffer jsIndexOnClick = new StringBuffer();
                    jsIndexOnClick.append("highlightTR('");
                    jsIndexOnClick.append(trId);
                    jsIndexOnClick.append("','");
                    jsIndexOnClick.append(Group.this.groupName);
                    jsIndexOnClick.append("');return false;");
                    Element indexElement = indexText = new Text("indexAnchorText", String.valueOf(this.groupIndex + 1));
                    if (!this.isReadOnly()) {
                        if (Group.this.getIndexTabNavigation()) {
                            A indexAnchor = new A();
                            indexAnchor.setStyle(Group.this.getIndexAnchorStyle());
                            indexAnchor.setCssClass(Group.this.getIndexCssClass());
                            indexAnchor.setTabIndex(Group.this.getTabIndex());
                            indexAnchor.setHref("#");
                            indexAnchor.setOnClick(jsIndexOnClick.toString());
                            indexAnchor.addChild(indexText);
                            indexElement = indexAnchor;
                        } else {
                            DIV indexDiv = new DIV();
                            indexDiv.setStyle("text-decoration: underline");
                            indexDiv.setOnMouseOver("this.style.cursor='pointer'");
                            indexDiv.setOnMouseOut("this.style.cursor='default'");
                            indexDiv.setOnClick(jsIndexOnClick.toString());
                            indexDiv.addChild(indexText);
                            indexElement = indexDiv;
                        }
                    }
                    indexTD.addChild(indexElement);
                    newTR.addChild(indexTD);
                }
                String newTRHtmlCode = newTR.getHtmlText();
                String strHeader = newTRHtmlCode.substring(0, newTRHtmlCode.lastIndexOf("</"));
                String strFooter = newTRHtmlCode.substring(newTRHtmlCode.lastIndexOf("</"), newTRHtmlCode.length());
                trHtmlCodeBuffer.append(strHeader);
                for (String cellHtmlCode : this.htmlCellCodeList) {
                    trHtmlCodeBuffer.append(cellHtmlCode);
                }
                trHtmlCodeBuffer.append(strFooter);
                this.htmlTRCode = trHtmlCodeBuffer.toString();
                this.isRowDirty = false;
            }
            return this.htmlTRCode;
        }

        private void fillHtmlCellCodeList(TR trModel) throws IOException {
            Iterator<Element> modelTdIterator = trModel.getAllChilds();
            int cellIndex = 0;
            while (modelTdIterator.hasNext()) {
                TD td = (TD)modelTdIterator.next();
                String tdId = ComponentIdFactory.buildComponentId(UtilitiesLib.buildCellId(this.getRowId(), cellIndex++));
                td.setHtmlId(tdId);
                this.htmlCellCodeList.add(td.getHtmlText());
            }
        }

        private String getRowId() {
            return UtilitiesLib.buildRowId(Group.this.groupName, this.groupIndex);
        }
    }
}

