/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.xhb;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Element
implements Serializable {
    private Map<String, Attribute> attrMap_d;
    private LinkedHashMap<String, Element> childs;
    private String closeTag_d;
    private boolean dirty_d;
    private boolean hasNewLineAfterTag_d = true;
    private boolean hasNewLinesBetweenTags_d = true;
    private String id_d;
    private String openTag_d;
    private Element parent_d;
    private int tabCount_d;
    private String tagName_d;
    static final long serialVersionUID = -9113741501631416379L;
    public static String ON_KEY_DOWN = "onKeyDown";
    public static String ON_KEY_PRESS = "onKeyPress";
    public static String ON_KEY_UP = "onKeyUp";
    public static String ON_CLICK = "onclick";
    public static String ON_DOUBLE_CLICK = "onDblClick";
    public static String ON_MOUSE_DOWN = "onMouseDown";
    public static String ON_MOUSE_UP = "onMouseUp";
    public static String ON_MOUSE_OVER = "onMouseOver";
    public static String ON_MOUSE_MOVE = "onMouseMove";
    public static String ON_MOUSE_OUT = "onMouseOut";
    public static String ON_FOCUS = "onFocus";
    public static String ON_BLUR = "onBlur";
    public static String ON_SUBMIT = "onSubmit";
    public static String ON_RESET = "onReset";
    public static String ON_SELECT = "onSelect";
    public static String ON_CHANGE = "onChange";
    public static String ON_LOAD = "onLoad";
    public static String ON_UNLOAD = "onUnload";
    public static String STYLE_PROPERTY = "style";
    public static String ID_PROPERTY = "id";
    public static String CSS_CLASS_PROPERTY = "class";
    public static String TITLE_PROPERTY = "title";
    static final long serialCheck = 387698560702213353L;

    protected Element(String tagName) {
        this(tagName, null);
    }

    protected Element(String tagName, String id) {
        this(tagName, id, true);
    }

    protected Element(String tagName, String id, boolean hasNewLinesBetweenTags) {
        this.id_d = id;
        this.tagName_d = tagName;
        this.tabCount_d = 0;
        this.childs = new LinkedHashMap();
        this.attrMap_d = new HashMap<String, Attribute>();
        this.dirty_d = true;
        this.hasNewLinesBetweenTags_d = hasNewLinesBetweenTags;
    }

    public final Iterator<Element> getAllChilds() {
        return this.childs.values().iterator();
    }

    public final String getAttribute(String name) {
        Attribute att = this.getAttributeObject(name);
        return att != null ? att.getValue() : null;
    }

    public final Element getChild(Element e) {
        return this.getChild(e.getId());
    }

    public final Element getChild(String id) {
        return this.childs.get(id);
    }

    public final int getChildQty() {
        return this.childs.size();
    }

    public final void setId(String id) {
        this.id_d = id;
    }

    public final String getId() {
        return this.id_d != null ? this.id_d : "" + this.hashCode();
    }

    public final void setNoNewLinesBetweenTags() {
        this.hasNewLinesBetweenTags_d = false;
    }

    public final Element getParent() {
        return this.parent_d;
    }

    public String getTagName() {
        return this.tagName_d;
    }

    public void addChild(Element e) {
        if (this.hasCloseTag()) {
            e.setParent(this);
            e.setTabCount(this.getTabCount() + 1);
            if (!this.hasNewLinesBetweenTags()) {
                e.setNoNewLineAfterTag();
                e.setNoNewLinesBetweenTags();
            }
            this.childs.put(e.getId(), e);
        } else assert (false) : this.getTagName() + " elements don't support childs.";
    }

    public final boolean hasAttribute(String attrId) {
        return this.attrMap_d.containsKey(attrId);
    }

    public final boolean hasChilds() {
        return !this.childs.isEmpty();
    }

    public final boolean hasNewLinesBetweenTags() {
        return this.hasNewLinesBetweenTags_d;
    }

    public final void removeAllChilds() {
        this.childs = null;
        this.childs = new LinkedHashMap();
    }

    public final Attribute removeAttribute(String name) {
        this.dirty();
        return this.attrMap_d.remove(name);
    }

    public final Element removeChild(Element e) {
        return this.removeChild(e.getId());
    }

    public final Element removeChild(String id) {
        return (Element)this.childs.remove(id);
    }

    public void setCssClass(String cssClass) {
        this.addAttribute(CSS_CLASS_PROPERTY, cssClass);
    }

    public void setHtmlId(String id) {
        this.addAttribute(ID_PROPERTY, id);
    }

    public String getHtmlText() throws IOException {
        StringWriter sw = new StringWriter();
        this.writeHtmlText(sw);
        return sw.toString();
    }

    public void setStyle(String style) {
        this.addAttribute(STYLE_PROPERTY, style);
    }

    public void setTitle(String title) {
        this.addAttribute(TITLE_PROPERTY, title);
    }

    public void writeHtmlText(Writer w) throws IOException {
        w.write(this.buildOpenTag());
        if (!this.hasCloseTag()) {
            return;
        }
        for (Element element : this.childs.values()) {
            element.writeHtmlText(w);
        }
        if (this.hasCloseTag()) {
            w.write(this.buildCloseTag());
        }
        this.clean();
    }

    protected abstract boolean hasCloseTag();

    protected final Map<String, Attribute> getAllAttributes() {
        return this.attrMap_d;
    }

    protected final Attribute getAttributeObject(String name) {
        return this.attrMap_d.get(name);
    }

    protected final int getTabCount() {
        return this.tabCount_d;
    }

    protected final void addAttribute(String name, String value) {
        this.addAttribute(name, value, false);
    }

    protected final void addAttribute(String name, String value, boolean force) {
        if (force) {
            this.attrMap_d.put(name, new Attribute(name, value != null ? value : ""));
            this.dirty();
        } else if (value != null && value.length() > 0) {
            this.attrMap_d.put(name, new Attribute(name, value));
            this.dirty();
        } else if (this.attrMap_d.containsKey(name)) {
            this.attrMap_d.remove(name);
            this.dirty();
        }
    }

    protected final void addSingleAttribute(String name) {
        this.attrMap_d.put(name, new Attribute(name));
        this.dirty();
    }

    protected final void dirty() {
        this.dirty_d = true;
    }

    protected void setNoNewLineAfterTag() {
        this.hasNewLineAfterTag_d = false;
    }

    protected void setOnBlur(String script) {
        this.addAttribute(ON_BLUR, script);
    }

    protected void setOnChange(String script) {
        this.addAttribute(ON_CHANGE, script);
    }

    protected void setOnClick(String script) {
        this.addAttribute(ON_CLICK, script);
    }

    protected void setOnDblClick(String script) {
        this.addAttribute(ON_DOUBLE_CLICK, script);
    }

    protected void setOnFocus(String script) {
        this.addAttribute(ON_FOCUS, script);
    }

    protected void setOnKeyDown(String script) {
        this.addAttribute(ON_KEY_DOWN, script);
    }

    protected void setOnKeyPress(String script) {
        this.addAttribute(ON_KEY_PRESS, script);
    }

    protected void setOnKeyUp(String script) {
        this.addAttribute(ON_KEY_UP, script);
    }

    protected void setOnLoad(String script) {
        this.addAttribute(ON_LOAD, script);
    }

    protected void setOnMouseDown(String script) {
        this.addAttribute(ON_MOUSE_DOWN, script);
    }

    protected void setOnMouseMove(String script) {
        this.addAttribute(ON_MOUSE_MOVE, script);
    }

    protected void setOnMouseOut(String script) {
        this.addAttribute(ON_MOUSE_OUT, script);
    }

    protected void setOnMouseOver(String script) {
        this.addAttribute(ON_MOUSE_OVER, script);
    }

    protected void setOnMouseUp(String script) {
        this.addAttribute(ON_MOUSE_UP, script);
    }

    protected void setOnReset(String script) {
        this.addAttribute(ON_RESET, script);
    }

    protected void setOnSelect(String script) {
        this.addAttribute(ON_SELECT, script);
    }

    protected void setOnSubmit(String script) {
        this.addAttribute(ON_SUBMIT, script);
    }

    protected void setOnUnload(String script) {
        this.addAttribute(ON_UNLOAD, script);
    }

    protected boolean hasNewLineAfterTag() {
        return this.hasNewLineAfterTag_d;
    }

    private boolean isDirty() {
        return this.dirty_d;
    }

    private void setParent(Element parent) {
        this.parent_d = parent;
    }

    private void setTabCount(int tabCount) {
        this.tabCount_d = tabCount;
        for (Element element : this.childs.values()) {
            element.setTabCount(tabCount + 1);
        }
    }

    private String buildCloseTag() {
        if (this.isDirty()) {
            this.closeTag_d = this.closeTag();
        }
        return this.closeTag_d.intern();
    }

    private String buildOpenTag() {
        if (this.isDirty()) {
            this.openTag_d = this.openTag();
        }
        return this.openTag_d.intern();
    }

    private void clean() {
        this.dirty_d = false;
    }

    private String closeTag() {
        if (this.hasCloseTag()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("</");
            buffer.append(this.getTagName());
            buffer.append(">");
            if (this.hasNewLineAfterTag()) {
                buffer.append("\n");
            }
            return buffer.toString();
        }
        return "";
    }

    private String openTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(this.getTagName());
        for (Attribute attribute : this.attrMap_d.values()) {
            buffer.append(" ");
            buffer.append(attribute.getHTML());
        }
        if (!this.hasCloseTag()) {
            buffer.append("/");
        }
        buffer.append(">");
        if (this.hasNewLinesBetweenTags() && this.hasNewLineAfterTag()) {
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected static final class Attribute
    implements Serializable {
        private String name_d;
        private String value_d;
        static final long serialCheck = 6771676552127874013L;
        static final long serialVersionUID = -4885288725326209581L;

        public Attribute(String name) {
            this(name, null);
        }

        public Attribute(String name, String value) {
            this.setName(name);
            this.setValue(value);
        }

        public String getHTML() {
            if (this.value_d == null) {
                return this.name_d;
            }
            return this.name_d + "=\"" + this.value_d + "\"";
        }

        public void setName(String name) {
            this.name_d = name;
        }

        public String getName() {
            return this.name_d;
        }

        public void setValue(String value) {
            this.value_d = this.convertToSafeAttribute(value);
        }

        public String getValue() {
            return this.unconvertFromSafeAttribute(this.value_d);
        }

        private String convertToSafeAttribute(String text) {
            if (text != null) {
                text = text.replaceAll("\\\"", "&quot;");
            }
            return text;
        }

        private String unconvertFromSafeAttribute(String text) {
            if (text != null) {
                text = text.replaceAll("&quot;", "\"");
            }
            return text;
        }
    }
}

