/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.LinkProperties;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponentDelegate;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public abstract class XOPresentationComponentImpl
implements XOPresentationComponent {
    private String bgcolor = null;
    private String cssClass = null;
    private boolean editable = true;
    private final XOPresentationComponentDelegate elementDelegate;
    private String fgcolor = null;
    private XOGroupComponent group = null;
    private String href = null;
    private boolean isPresCompDirty = false;
    private XFormPresentationXMLObject presModelComp;
    private XScreen screen;
    private int tabindex = 0;
    private String text = null;
    private boolean visible = true;
    private boolean visibleCollapsed = true;

    protected XOPresentationComponentImpl(XScreen screen, XFormPresentationXMLObject presModelComp) {
        this.screen = screen;
        this.presModelComp = presModelComp;
        this.elementDelegate = new XOPresentationComponentDelegate(this);
        this.initEditableProperty();
        this.initColorProperties();
        this.initLinkProperty();
        this.initCssProperty();
        this.initTabIndexProperty();
    }

    public abstract void _setEditable(boolean var1);

    public abstract void _setVisible(boolean var1, boolean var2);

    @Override
    public final void setBackgroundColor(String color) {
        if (this.getPresentationXMLObject() instanceof ColorProperties) {
            this.bgcolor = color;
            this._setBackgroundColor(this.bgcolor);
            this.setPresCompDirty(true);
        } else {
            Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_SET_COLOR_NON_SUPPORTED(this.getId()));
        }
    }

    @Override
    public final String getBackgroundColor() {
        return this.bgcolor;
    }

    @Override
    public final boolean isDisplay() {
        return this.screen.isDisplay();
    }

    @Override
    public final boolean isEditor() {
        return this.screen.isEditor();
    }

    @Override
    public final void setForegroundColor(String color) {
        if (this.getPresentationXMLObject() instanceof ColorProperties) {
            this.fgcolor = color;
            this._setForegroundColor(this.fgcolor);
            this.setPresCompDirty(true);
        } else {
            Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_SET_FOREGROUNDCOLOR_NON_SUPPORTED(this.getId()));
        }
    }

    @Override
    public final String getForegroundColor() {
        return this.fgcolor;
    }

    @Override
    public final void setGroup(XOGroupComponent group) {
        this.group = group;
    }

    @Override
    public final XOGroupComponent getGroup() {
        return this.group;
    }

    @Override
    public final boolean isGroupColumnComponent() {
        return this.getGroup() != null;
    }

    @Override
    public final String getId() {
        return this.presModelComp != null ? this.presModelComp.getId() : null;
    }

    @Override
    public final void setLink(String href) {
        if (this.getPresentationXMLObject() instanceof LinkProperties) {
            this.href = href;
            this._setLink(this.href);
            this.setPresCompDirty(true);
        } else {
            Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_SET_LINK_NON_SUPPORTED(this.getId()));
        }
    }

    @Override
    public final String getLink() {
        if (this.getPresentationXMLObject() instanceof LinkProperties) {
            return this.href != null && this.href.trim().length() > 0 ? this.href : null;
        }
        Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_SET_COLOR_NON_SUPPORTED(this.getId()));
        return null;
    }

    @Override
    public final boolean isPreview() {
        return this.screen.isPreview();
    }

    @Override
    public final String getReference() {
        return this.presModelComp != null ? this.presModelComp.getReference() : null;
    }

    @Override
    public final boolean isShow() {
        return this.screen.isShow();
    }

    @Override
    public void setCssClassName(String cssClass) {
        if (this.getPresentationXMLObject() != null) {
            this.cssClass = cssClass;
            this._setCssClassName(this.cssClass);
            this.setPresCompDirty(true);
        } else {
            Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_SET_LINK_NON_SUPPORTED(this.getId()));
        }
    }

    @Override
    public String getCssClassName() {
        return this.cssClass;
    }

    @Override
    public boolean isCssEnabled() {
        return this.screen.isCssEnabled();
    }

    public final String getDivId() {
        return this.presModelComp != null ? this.presModelComp.getId() + "_div" : null;
    }

    @Override
    public final void setEditable(boolean editable) {
        boolean previousEditableState = this.isEditable();
        boolean bl = this.editable = editable && !this.isDisplay();
        if (previousEditableState != this.isEditable()) {
            this._setEditable(this.editable);
            this.setPresCompDirty(true);
        }
    }

    @Override
    public final boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isMixedCss() {
        return this.presModelComp.isMixedCss();
    }

    @Override
    public void setPresCompDirty(boolean presCompDirty) {
        this.isPresCompDirty = presCompDirty;
        this.getXScreen().fireChangeEvent(this.getId());
    }

    @Override
    public boolean isPresCompDirty() {
        return this.isPresCompDirty;
    }

    @Override
    public final XFormPresentationXMLObject getPresentationXMLObject() {
        return this.presModelComp;
    }

    public void setTabindex(int tabindex) {
        this.tabindex = tabindex;
    }

    public int getTabindex() {
        return this.tabindex;
    }

    @Override
    public final boolean isVisible() {
        if (this.isGroupColumnComponent() && !this.getGroup().isVisible()) {
            return false;
        }
        return this.visible;
    }

    @Override
    public final boolean isVisibleCollapsed() {
        if (this.isGroupColumnComponent() && this.getGroup().isVisibleCollapsed()) {
            return true;
        }
        return this.visibleCollapsed;
    }

    @Override
    public final XScreen getXScreen() {
        return this.screen;
    }

    public final boolean areEventsAllowed() {
        return this.isShow() || !this.isDisplay() && !this.isPreview() && this.isEditable();
    }

    @Override
    public final void refreshComponent() {
        this._setEditable(this.isEditable());
        this._setVisible(this.isVisible(), this.visibleCollapsed);
    }

    @Override
    public final void setVisible(boolean visible, boolean collapsed) {
        if (this.isVisible() != visible) {
            this.visible = visible;
            this.visibleCollapsed = collapsed;
            this._setVisible(this.visible, this.visibleCollapsed);
            this.setPresCompDirty(true);
        }
    }

    @Override
    public final void setText(String text) {
        String string = text = text != null ? this.getI18NText(text) : "";
        if (!text.equals(this.text)) {
            this.text = text;
            this._setText(this.text);
            this.setPresCompDirty(true);
        }
    }

    @Override
    public String getI18NText(String key) {
        XObjectInstance xo = this.getXScreen().getXO();
        String i18nText = xo != null ? xo.getI18NResource(key, this.getXScreen().getLocale()) : key;
        return i18nText;
    }

    @Override
    public final String getText() {
        return this.text;
    }

    @Override
    public void resetPresCompDirty() {
        this.isPresCompDirty = false;
    }

    public String toString() {
        return "Component name: " + (this.presModelComp != null ? this.presModelComp.getName() : "null") + ", Id: " + this.getId() + ", Class: " + this.getClass().getName();
    }

    protected abstract void _setBackgroundColor(String var1);

    protected abstract void _setCssClassName(String var1);

    protected abstract void _setForegroundColor(String var1);

    protected abstract void _setLink(String var1);

    protected abstract void _setText(String var1);

    private void initColorProperties() {
        if (this.presModelComp != null && this.presModelComp instanceof ColorProperties) {
            ColorProperties elementWithColorProperties = (ColorProperties)((Object)this.presModelComp);
            this.bgcolor = elementWithColorProperties.getBgcolor();
            this.fgcolor = elementWithColorProperties.getFgcolor();
        }
    }

    private void initCssProperty() {
        if (this.presModelComp != null) {
            this.cssClass = this.presModelComp.getCssClass();
        }
    }

    private void initEditableProperty() {
        boolean isEditable;
        boolean bl = isEditable = !this.isDisplay();
        if (this.presModelComp != null) {
            if (this.presModelComp instanceof XFormUserInputPresentationXMLObject) {
                isEditable = ((XFormUserInputPresentationXMLObject)this.presModelComp).isEditable();
            } else if (this.presModelComp instanceof XFormRepeatable) {
                isEditable = ((XFormRepeatable)this.presModelComp).isEditable();
            }
        }
        this.setEditable(isEditable);
    }

    private void initLinkProperty() {
        if (this.presModelComp != null && this.presModelComp instanceof LinkProperties) {
            this.href = ((LinkProperties)((Object)this.presModelComp)).getLink();
        }
    }

    private void initTabIndexProperty() {
        if (this.presModelComp != null) {
            this.tabindex = this.presModelComp.getTabindex();
        }
    }
}

