/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.runtime.AbstractXScreen;
import oracle.bpm.xobject.runtime.ConstraintReport;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.XOExecutionController;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.html.HTMLElementChangeListener;
import oracle.bpm.xobject.runtime.html.HTMLGroup;
import oracle.bpm.xobject.runtime.html.HTMLGroupElement;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.html.HTMLPage;
import oracle.bpm.xobject.runtime.presentationComponents.XOElementComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XScreenHTMLImpl
extends AbstractXScreen
implements Serializable {
    private String bgColor;
    private String controllerId;
    private transient HTMLElementChangeListener elementChangeListener = null;
    private List<HTMLMsg> errorMsgList = null;
    private String focusComponentId = null;
    private StringBuffer onLoadBodyScript_d = null;
    private HTMLPage page_d;
    private StringBuffer scriptToPerform = null;
    private Map<Integer, String> scriptToPerformMap;
    private List<HTMLMsg> warningMsgList = null;
    static final long serialCheck = -7023642587537815119L;
    static final long serialVersionUID = -7180290101671824821L;

    public XScreenHTMLImpl(XORuntimeManager rMgr) {
        this(rMgr, null);
    }

    private XScreenHTMLImpl(XORuntimeManager rMgr, String bgColor) {
        super(rMgr);
        this.bgColor = bgColor;
        XORuntimeManager runtimeManager = this.getRuntimeManager();
        runtimeManager.setXScreen(this);
        XOExecutionController executionController = runtimeManager.getExecutionController();
        this.controllerId = executionController != null ? executionController.getIdentifier() : String.valueOf(System.currentTimeMillis());
    }

    public final void cleanErrorStuff() {
        this.warningMsgList = null;
        this.errorMsgList = null;
        this.onLoadBodyScript_d = null;
        this.scriptToPerform = null;
        this.focusComponentId = null;
    }

    public final void clearElementChangeListener() {
        this.elementChangeListener = null;
    }

    @Override
    public void fireChangeEvent(String presId) {
        if (this.elementChangeListener != null) {
            this.elementChangeListener.elementChange(presId);
        }
    }

    public final String getDocumentHtmlText() {
        try {
            return this.getPage().getDocumentHtmlText();
        }
        catch (IOException e) {
            Log.logSevere(e);
            return null;
        }
    }

    public final HTMLElementChangeListener getElementChangeListener() {
        return this.elementChangeListener;
    }

    public final String getElementHTMLDiv(String presId) throws IOException {
        assert (presId != null);
        HTMLElement element = this.getPElementWithId(presId);
        assert (element != null);
        return element.getDivId();
    }

    public final String getElementHTMLText(String presId) throws IOException {
        assert (presId != null);
        HTMLElement element = this.getPElementWithId(presId);
        assert (element != null);
        return element.getPureElement().getHtmlText();
    }

    public final List<HTMLMsg> getErrorMsgList() {
        return this.errorMsgList;
    }

    public final String getFormHtmlText() {
        try {
            return this.getPage().getFormHtmlText();
        }
        catch (IOException e) {
            Log.logSevere(e);
            return null;
        }
    }

    public final String getHTMLMsgs() {
        StringBuffer msgBuffer = new StringBuffer();
        if (this.hasErrorsToShow() || this.hasWarningsToShow()) {
            msgBuffer.append("<TABLE style='border-collapse:collapse;width: 100%;border: 1px solid;' cellpadding='2'>");
            msgBuffer.append("<colgroup><col><col width='100%'></colgroup>");
            msgBuffer.append(this.buildHTMLMsgs(this.getErrorMsgList()));
            msgBuffer.append(this.buildHTMLMsgs(this.getWarningMsgList()));
            msgBuffer.append("</TABLE>");
        }
        return msgBuffer.toString();
    }

    public final String getOnLoadBodyScript() {
        if (this.focusComponentId != null) {
            this.addOnLoadBodyScript("setFocusOnElement('" + this.focusComponentId + "');");
        }
        return this.onLoadBodyScript_d != null ? this.onLoadBodyScript_d.toString() : "";
    }

    public final HTMLPage getPage() {
        if (this.page_d == null) {
            this.page_d = new HTMLPage(this.bgColor, this.controllerId, this);
        }
        return this.page_d;
    }

    public final HTMLElement getPElementWithId(String pressId) {
        return (HTMLElement)this.getPresComponentWithId(pressId);
    }

    public final HTMLElement getPElementWithRef(String dataId) {
        return (HTMLElement)((Object)this.getPresComponentWithRef(dataId));
    }

    public final String getScriptToPerform() {
        StringBuffer result = new StringBuffer();
        if (this.focusComponentId != null) {
            this.addScriptToPerform("setFocusOnElement('" + this.focusComponentId + "');");
        }
        if (this.scriptToPerform != null) {
            result.append(this.scriptToPerform.toString());
        }
        if (this.scriptToPerformMap != null) {
            for (String script : this.scriptToPerformMap.values()) {
                if (script == null) continue;
                result.append(script);
            }
        }
        return result.toString();
    }

    public final List<HTMLMsg> getWarningMsgList() {
        return this.warningMsgList;
    }

    @Override
    public boolean hasErrorsToShow() {
        return this.errorMsgList != null && this.errorMsgList.size() > 0;
    }

    @Override
    public boolean hasWarningsToShow() {
        return this.warningMsgList != null && this.warningMsgList.size() > 0;
    }

    @Override
    public void openURL(String url, boolean newWindow, boolean standardBrowser) {
        StringBuffer theScript = new StringBuffer();
        if (!url.toLowerCase().startsWith("mailto:")) {
            if (newWindow) {
                theScript.append("window.open('");
                theScript.append(url);
                theScript.append("', '_blank'");
                if (!standardBrowser) {
                    theScript.append(", 'resizable,scrollbars'");
                }
                theScript.append(");");
            } else {
                theScript.append("getMainOpenerWindow().location = '");
                theScript.append(url);
                theScript.append("';");
            }
        } else {
            theScript.append("window.location='");
            theScript.append(url);
            theScript.append("'");
        }
        this.addScriptToPerform(theScript.toString());
        this.addOnLoadBodyScript(theScript.toString());
    }

    @Override
    public void broadcastViewChangeEvent(String viewId) {
        StringBuffer theScript = new StringBuffer("broadcastViewChangeEvent('").append(Str.escapeForScripts(viewId)).append("');");
        this.addScriptToPerform(theScript.toString());
        this.addOnLoadBodyScript(theScript.toString());
    }

    @Override
    public void printPresentation() {
        String theScript = "printFuegoObject();";
        this.addOnLoadBodyScript(theScript);
        this.addScriptToPerform(theScript);
    }

    @Override
    public void processFocus(String componentId) {
        HTMLElement element = this.getPElementWithId(componentId);
        if (element != null) {
            this.setFocus(element.getHtmlAttString());
        }
    }

    @Override
    public void processFocus(String groupComponentId, String columnComponentId, int index) {
        HTMLGroup groupElement = (HTMLGroup)this.getPElementWithId(groupComponentId);
        if (groupElement != null) {
            String columnHTMLId = groupElement.getElementColumnHtmlId(columnComponentId, index);
            this.setFocus(columnHTMLId);
        }
    }

    public final void restoreTimerValues(String values) {
        if (this.onLoadBodyScript_d == null) {
            this.onLoadBodyScript_d = new StringBuffer("");
        }
        this.onLoadBodyScript_d.append("restoreTimerValues('").append(values).append("');");
    }

    public final void setElementChangeListener(HTMLElementChangeListener elementChangeListener) {
        this.elementChangeListener = elementChangeListener;
    }

    public final void setFocus(String componentId) {
        this.focusComponentId = componentId;
    }

    public final void setStyleSheet(String styleSheet) {
        if (this.getPage() != null) {
            this.getPage().setSyleSheet(styleSheet);
        }
    }

    @Override
    public void showError(String msg) {
        this.addErrorMessage(new HTMLMsg(2, msg));
    }

    @Override
    public void showErrors(ConstraintReport[] errors) {
        this.addErrors(errors);
    }

    @Override
    public void showWarning(String msg) {
        this.addWarningMessage(new HTMLMsg(3, msg));
    }

    public void addScriptToPerform(String script, boolean isTransient) {
        int scriptKey = script.hashCode();
        if (isTransient) {
            if (this.scriptToPerformMap == null || !this.scriptToPerformMap.containsKey(scriptKey)) {
                if (this.scriptToPerform == null) {
                    this.scriptToPerform = new StringBuffer("");
                }
                this.scriptToPerform.append(script);
            }
        } else {
            if (this.scriptToPerformMap == null) {
                this.scriptToPerformMap = new HashMap<Integer, String>();
            }
            this.scriptToPerformMap.put(scriptKey, script);
        }
    }

    public void addScriptToPerform(String script) {
        this.addScriptToPerform(script, true);
    }

    protected String buildHTMLMessage(String label, String msg, String htmlId) {
        StringBuffer msgBuffer = new StringBuffer();
        msgBuffer.append("<span>");
        if (htmlId != null) {
            msgBuffer.append("<span style=\"text-decoration: underline;\" onmouseover=\"this.style.cursor='pointer'\" onClick=\"setFocusOnElement('");
            msgBuffer.append(htmlId);
            msgBuffer.append("');return false;\">");
            msgBuffer.append(label);
            msgBuffer.append("</span>");
        } else {
            msgBuffer.append(label);
        }
        msgBuffer.append(": ");
        msgBuffer.append(msg);
        msgBuffer.append("</span>");
        return msgBuffer.toString();
    }

    private void addErrorMessage(HTMLMsg msg) {
        if (this.errorMsgList == null) {
            this.errorMsgList = new ArrayList<HTMLMsg>();
        }
        this.errorMsgList.add(msg);
    }

    private void addErrors(ConstraintReport[] errors) {
        if (errors != null) {
            block8: for (ConstraintReport error : errors) {
                String errorMsg = error.getMessage();
                switch (error.getErrorType()) {
                    case 0: {
                        XFormPresentationXMLObject xform;
                        if (error.isGroupError()) {
                            XOInputComponent comp = this.getPresComponentWithRef(error.getDataId());
                            assert (comp instanceof XOGroupComponent);
                            xform = ((XOGroupComponent)comp).getColumnElementByDataId(error.getColumnDataId()).getPresentationXMLObject();
                        } else {
                            xform = this.getPresComponentWithRef(error.getDataId()).getPresentationXMLObject();
                        }
                        if (xform instanceof XFormUserInputPresentationXMLObject) {
                            errorMsg = (error.isGroupError() ? "[" + error.getIndex() + "] " : "") + XObjectRuntimeMsg.REQUIRED_VALUE.getString(this.getLocale());
                        }
                        this.addErrorMessage(new HTMLMsg(2, this.getHtmlComponentError(error.getDataId(), error.getColumnDataId(), errorMsg, error.getIndex())));
                        continue block8;
                    }
                    case 1: {
                        this.addErrorMessage(new HTMLMsg(2, this.getHtmlMethodError(error.getMethod(), errorMsg)));
                        continue block8;
                    }
                    case 2: {
                        this.addErrorMessage(new HTMLMsg(2, this.getHtmlComponentError(error.getDataId(), error.getColumnDataId(), errorMsg, error.getIndex())));
                        continue block8;
                    }
                    case 3: {
                        this.addErrorMessage(new HTMLMsg(2, this.getHtmlComponentError(error.getDataId(), error.getColumnDataId(), errorMsg, error.getIndex())));
                        continue block8;
                    }
                    case 4: {
                        this.addErrorMessage(new HTMLMsg(2, this.getHtmlComponentError(error.getDataId(), error.getColumnDataId(), errorMsg, error.getIndex())));
                        continue block8;
                    }
                    case 5: {
                        this.addErrorMessage(new HTMLMsg(2, this.getHtmlCheckError(error.getDataId(), errorMsg)));
                        continue block8;
                    }
                }
            }
        }
    }

    private void addOnLoadBodyScript(String script) {
        if (this.onLoadBodyScript_d == null) {
            this.onLoadBodyScript_d = new StringBuffer("");
        }
        this.onLoadBodyScript_d.append(script);
    }

    private void addWarningMessage(HTMLMsg msg) {
        if (this.warningMsgList == null) {
            this.warningMsgList = new ArrayList<HTMLMsg>();
        }
        this.warningMsgList.add(msg);
    }

    private String buildHTMLMsgs(List<HTMLMsg> msgs) {
        StringBuffer msgBuffer = new StringBuffer();
        if (msgs != null) {
            for (int i = 0; i < msgs.size(); ++i) {
                HTMLMsg msg = msgs.get(i);
                TR errorTR = this.getPage().getMsgRow(msg.getType(), "fo.serverErrorIcon." + i, "fo.serverErrorMsg." + i, msg.getHTML());
                try {
                    msgBuffer.append(errorTR.getHtmlText());
                    continue;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
        return msgBuffer.toString();
    }

    private String getHtmlCheckError(String dataId, String message) {
        StringBuffer jsBuffer = new StringBuffer();
        jsBuffer.append("<b>");
        jsBuffer.append(dataId);
        jsBuffer.append(":</b> ");
        jsBuffer.append(message);
        return jsBuffer.toString();
    }

    private String getHtmlComponentError(String dataId, String columnDataId, String message, Integer index) {
        boolean isGroupElement = columnDataId != null && index != null;
        String htmlId = null;
        HTMLElement element = this.getPElementWithRef(dataId);
        if (isGroupElement) {
            assert (element instanceof HTMLGroupElement);
            XOElementComponent columnComponent = ((HTMLGroupElement)element).getColumnElementByDataId(columnDataId);
            htmlId = XOConstants.createGrpStr(element.getId(), columnComponent.getId(), index);
        } else if (element instanceof HTMLInputElement) {
            htmlId = ((HTMLInputElement)element).getElementHtmlId();
        }
        StringBuffer label = new StringBuffer();
        label.append(dataId);
        if (isGroupElement) {
            label.append(" - ");
            label.append(columnDataId);
            label.append("[");
            label.append(index);
            label.append("]");
        }
        String msg = Str.convertToHTMLString(message);
        return this.buildHTMLMessage(label.toString(), msg, htmlId);
    }

    private String getHtmlMethodError(String method, String message) {
        StringBuffer jsBuffer = new StringBuffer();
        jsBuffer.append("<b>");
        jsBuffer.append(LibMsg.METHOD.getString());
        jsBuffer.append(" [");
        jsBuffer.append(method);
        jsBuffer.append("]:</b> ");
        jsBuffer.append(message);
        return jsBuffer.toString();
    }

    private static final class HTMLMsg {
        private String msg;
        private int type;
        public static final int ERROR = 2;
        public static final int WARNING = 3;

        HTMLMsg(int type, String msg) {
            this.type = type;
            this.msg = msg;
        }

        public String getHTML() {
            return this.msg;
        }

        public int getType() {
            return this.type;
        }
    }

    public static class HTMLElemnetChangeImpl
    implements HTMLElementChangeListener {
        private HashSet<String> set = new HashSet();

        @Override
        public void elementChange(String presId) {
            this.set.add(presId);
        }

        @Override
        public String[] getIds() {
            return this.set.toArray(new String[this.set.size()]);
        }

        @Override
        public void reset() {
            this.set.clear();
        }
    }
}

