/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextFieldComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextFieldComponentDelegate;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLTextField
extends HTMLInputElement
implements XOTextFieldComponent,
XODateTimeComponent,
Cloneable {
    private XOTextFieldComponentDelegate componentDelegate_d;
    private XODateTimeComponentDelegate dateComponentDelegate;
    private DecimalFormatSymbols decimalSymb_d = null;
    private Input editableTextfield_d;
    private boolean isDisplayAsLabel_d = false;
    private DIV nonEditableDIV_d;
    private Text nonEditableText_d;
    private String onChangeScript_d = null;
    private boolean restrictLength_d = false;
    private int restrictLengthValue_d = -1;
    private boolean restrictPrecision_d = false;
    private int restrictPrecisionValue_d = -1;
    private boolean restrictType_d = false;
    private int restrictTypeValue_d = -1;
    private String theValue = null;
    private static final double SIZE_X_FACTOR = 1.2;
    static final long serialVersionUID = -8052548159053465591L;
    static final long serialCheck = -1679535185971242411L;

    public HTMLTextField(XScreen xScreen, XFormText t, Locale locale, TimeZone tz) {
        super(xScreen, t);
        this.decimalSymb_d = new DecimalFormatSymbols(locale);
        this.componentDelegate_d = new XOTextFieldComponentDelegate(this);
        this.dateComponentDelegate = new XODateTimeComponentDelegate(this, locale, tz);
        this.initTextField(t);
    }

    public static HTMLTextField newInstance(HTMLTextField originalElement) {
        HTMLTextField newElement = new HTMLTextField(originalElement.getXScreen(), (XFormText)originalElement.getPresentationXMLObject(), originalElement.getLocale(), originalElement.getTimeZone());
        newElement.setValue(originalElement.getDefaultValue());
        if (originalElement.restrictLength_d) {
            newElement.restrictLength(originalElement.restrictLengthValue_d);
        }
        if (originalElement.restrictPrecision_d) {
            newElement.restrictPrecision(originalElement.restrictPrecisionValue_d);
        }
        if (originalElement.restrictType_d) {
            newElement.restrictType(originalElement.restrictTypeValue_d);
        }
        return newElement;
    }

    @Override
    public void _setEditable(boolean editable) {
        super._setEditable(editable);
        if (this.editableTextfield_d != null) {
            this.editableTextfield_d.setReadOnly(!this.isEditable());
            if (!this.isDisplayAsLabel_d) {
                String value = null;
                if (editable) {
                    value = this.theValue;
                    XFormText t = (XFormText)this.getPresentationXMLObject();
                    if (t.getColqty() > 0) {
                        this.editableTextfield_d.setSize(String.valueOf((int)((double)t.getColqty() * 1.2)));
                    }
                } else {
                    value = this.componentDelegate_d.getNonEditableText(this.getLocale(), this.theValue, this.getKind());
                }
                this.editableTextfield_d.setValue(value);
            }
        }
        this.applyStyle();
    }

    @Override
    public Object clone() {
        return HTMLTextField.newInstance(this);
    }

    @Override
    public String convertDataValueToPresentationValue(Time time) {
        return this.dateComponentDelegate.convertDataValueToPresentationValue(time);
    }

    @Override
    public String convertPresentationValueToDataValue(String value) throws ParseException {
        return this.dateComponentDelegate.convertPresentationValueToDataValue(value);
    }

    @Override
    public int getDatePrecision() {
        return this.dateComponentDelegate.getDatePrecision();
    }

    @Override
    public String getElementHtmlId() {
        return this.getPureElement().getAttribute(Input.ID_PROPERTY);
    }

    @Override
    public String getFormatString() {
        return null;
    }

    @Override
    public String getInputPattern() {
        return this.componentDelegate_d.getInputPattern();
    }

    @Override
    public String getInputPatternErrorColor() {
        return this.componentDelegate_d.getInputPatternErrorColor();
    }

    @Override
    public String getInputPatternErrorMsg() {
        return this.componentDelegate_d.getInputPatternErrorMsg();
    }

    @Override
    public Locale getLocale() {
        return this.dateComponentDelegate.getLocale();
    }

    @Override
    public String getMask() {
        return this.componentDelegate_d.getMask();
    }

    @Override
    public String getMaskErrorColor() {
        return this.componentDelegate_d.getMaskErrorColor();
    }

    @Override
    public String getMaskErrorMsg() {
        return this.componentDelegate_d.getMaskErrorMsg();
    }

    @Override
    public String getOutputMask() {
        return this.componentDelegate_d.getOutputMask();
    }

    @Override
    public int getOutputMaskType() {
        return this.componentDelegate_d.getOutputMaskType();
    }

    @Override
    public Element getPureElement() {
        if (!this.isEditable() && this.isDisplayAsLabel_d) {
            return this.nonEditableDIV_d;
        }
        return this.editableTextfield_d;
    }

    @Override
    public String getStyle() {
        XFormText t = (XFormText)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(t.fonttype, t.getFontStyle(), t.fontsize));
            css.append(this.getInlineTextAlignmentCSS(t.alignment));
            String foregroundColor = this.getForegroundColor();
            if (foregroundColor == null && !this.isEditable()) {
                foregroundColor = "#000000";
            }
            css.append(this.getInlineForegroundColorCCS(foregroundColor));
            if (this.isEditable()) {
                css.append(this.getInlineBorderCSS(t.borderstyle, t.bordercolor, t.borderwidth));
            }
        }
        return css.toString();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.dateComponentDelegate.getTimeZone();
    }

    @Override
    public boolean hasInputPattern() {
        return this.componentDelegate_d.hasInputPattern();
    }

    @Override
    public boolean hasMask() {
        return this.componentDelegate_d.hasMask();
    }

    @Override
    public boolean hasOutputMask() {
        return this.componentDelegate_d.hasOutputMask();
    }

    @Override
    public boolean isAbsoluteDate() {
        return this.dateComponentDelegate.isAbsoluteDate();
    }

    @Override
    public boolean isDate() {
        return this.dateComponentDelegate.isDate();
    }

    public boolean isDisplayAsLabel() {
        return this.isDisplayAsLabel_d;
    }

    @Override
    public void restrict(int presicion, boolean isAbsolute) {
        this.dateComponentDelegate.restrict(presicion, isAbsolute);
        ((XScreenHTMLImpl)this.getXScreen()).getPage().initPageWithDateTimeElement(this.getLocale(), this.getTimeZone());
        this.editableTextfield_d.setOnChange(this.getOnChangeScript());
    }

    @Override
    public void restrictLength(int length) {
        this.restrictLength_d = true;
        this.restrictLengthValue_d = length;
        this.editableTextfield_d.setMaxlength(String.valueOf(length));
    }

    @Override
    public void restrictPrecision(int precision) {
        this.restrictPrecision_d = true;
        this.restrictPrecisionValue_d = precision;
        this.applyRestrictions(this.restrictType_d, this.restrictPrecision_d);
    }

    @Override
    public void restrictType(int kind) {
        this.restrictType_d = true;
        this.restrictTypeValue_d = kind;
        this.applyRestrictions(this.restrictType_d, this.restrictPrecision_d);
    }

    @Override
    public void setName(String name) {
        if (this.editableTextfield_d != null) {
            this.editableTextfield_d.setName(name);
            this.editableTextfield_d.setHtmlId(name);
        }
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.editableTextfield_d != null) {
            this.editableTextfield_d.setTabindex(tabIndex);
        }
    }

    @Override
    public void setValue(Object value) {
        try {
            String valueStr = this.componentDelegate_d.convertToString(value);
            if (this.isDate()) {
                if (valueStr != null && !valueStr.trim().equals("")) {
                    Time fullDate = Time.valueOf(valueStr);
                    valueStr = this.convertDataValueToPresentationValue(fullDate);
                }
            } else {
                int kind = this.getKind();
                if (kind == 2 || kind == 5) {
                    Pattern pattern;
                    String warningMsg = null;
                    XORuntimeManager runtimeMgr = this.getXScreen().getRuntimeManager();
                    if (this.hasMask()) {
                        try {
                            valueStr = this.componentDelegate_d.applyMask(this.getMask(), valueStr);
                        }
                        catch (RuntimeException e) {
                            warningMsg = XObjectRuntimeMsg.INVALID_INPUT_BY_MASK2(valueStr, this.getMask()).getString(this.getLocale());
                            valueStr = null;
                        }
                    }
                    if (this.hasInputPattern() && valueStr != null && runtimeMgr.isInitialized() && !(pattern = Pattern.compile(this.getInputPattern())).matcher(valueStr).matches()) {
                        Locale locale = this.getLocale();
                        warningMsg = XObjectRuntimeMsg.INVALID_INPUT_BY_PATTERN2(valueStr, this.getInputPattern()).getString(locale);
                        valueStr = CoreMsg.ERROR.getString(locale);
                    }
                    if (warningMsg != null) {
                        String htmlId = null;
                        if (this.isEditable()) {
                            htmlId = this.getElementHtmlId();
                        }
                        XScreenHTMLImpl xScreen = (XScreenHTMLImpl)this.getXScreen();
                        String msg = xScreen.buildHTMLMessage(this.getReference(), warningMsg, htmlId);
                        xScreen.showWarning(msg);
                    }
                } else if (kind == 3 || kind == 4) {
                    valueStr = valueStr.replace('.', this.decimalSymb_d.getDecimalSeparator());
                }
            }
            if (valueStr != null) {
                String nonEditableText = this.componentDelegate_d.getNonEditableText(this.getLocale(), valueStr, this.getKind());
                this.editableTextfield_d.setValue(!this.isEditable() && !this.isDisplayAsLabel_d ? nonEditableText : valueStr);
                this.nonEditableText_d.setText(nonEditableText);
                this.theValue = valueStr;
                if (!this.isEditable() && !this.isDisplayAsLabel_d) {
                    XFormText xText = (XFormText)this.getPresentationXMLObject();
                    int visibleSize = (int)((double)(valueStr.length() > xText.getColqty() ? valueStr.length() : xText.getColqty()) * 1.2);
                    this.editableTextfield_d.setSize(String.valueOf(visibleSize));
                }
            }
        }
        catch (Exception e) {
            this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
            Log.logDebug(e);
        }
    }

    @Override
    protected void _applyStyle(String style) {
        this.applyEditableStyle(style);
        this.applyNonEditableStyle(style);
    }

    @Override
    void _setOnFocus(String js) {
        this.editableTextfield_d.setOnFocus(js + "lastElementValue = this.value;");
    }

    private void applyEditableStyle(String style) {
        if (this.editableTextfield_d != null) {
            StringBuffer css = new StringBuffer(style);
            if (!this.isEditable()) {
                css.append(this.getInlineBorderCSS("none", "#FFFFFF", 0));
            }
            if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
                String bgColorStyle = "";
                bgColorStyle = this.isEditable() ? this.getInlineBackgroundColorCCS(this.getBackgroundColor()) : this.getInlineBackgroundColorCCS("transparent");
                css.append(bgColorStyle);
            }
            this.editableTextfield_d.setStyle(css.toString());
            if (this.isCssEnabled()) {
                this.editableTextfield_d.setCssClass(this.getCssClassName());
            } else {
                this.editableTextfield_d.setCssClass("");
            }
        }
    }

    private void applyNonEditableStyle(String style) {
        if (this.nonEditableDIV_d != null) {
            StringBuffer css = new StringBuffer(style);
            if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
                String bgColorStyle = this.isEditable() ? this.getInlineBackgroundColorCCS(this.getBackgroundColor()) : this.getInlineBackgroundColorCCS("transparent");
                css.append(bgColorStyle);
            }
            this.nonEditableDIV_d.setStyle(css.toString());
            if (this.isCssEnabled()) {
                this.nonEditableDIV_d.setCssClass(this.getCssClassName());
            } else {
                this.nonEditableDIV_d.setCssClass("");
            }
        }
    }

    private void applyRestrictions(boolean type, boolean precision) {
        if (this.isEditable()) {
            StringBuffer js = new StringBuffer();
            js.append("if(!isEnterKey(event) && (isSpecialKey(event) || ");
            if (type) {
                switch (this.restrictTypeValue_d) {
                    case 2: 
                    case 3: 
                    case 4: {
                        int thePrecision = this.getPrecision() == -1 ? 100 : this.getPrecision();
                        js.append(this.hasMask() ? "true" : "checkNumber(this, " + this.getLength() + ", " + thePrecision + ", '" + this.decimalSymb_d.getDecimalSeparator() + "')");
                        this.editableTextfield_d.setOnKeyUp(this.hasMask() ? "true" : "checkNumber(this, " + this.getLength() + ", " + thePrecision + ", '" + this.decimalSymb_d.getDecimalSeparator() + "')");
                        StringBuffer onBlur = new StringBuffer();
                        onBlur.append("if(navigator.appName == 'Microsoft Internet Explorer' && lastElementValue != this.value){");
                        onBlur.append(this.getOnChangeScript());
                        onBlur.append("}");
                        this.editableTextfield_d.setOnBlur(onBlur.toString());
                        break;
                    }
                    default: {
                        js.append("true");
                    }
                }
            }
            js.append(")){return true;}else{return false;}");
            this.editableTextfield_d.setOnKeyPress(js.toString());
            this.editableTextfield_d.setOnSelect("setSelectedComponent(this.name)");
        }
    }

    private String getOnChangeScript() {
        XFormText xText = (XFormText)this.getPresentationXMLObject();
        StringBuffer onChangeScript = new StringBuffer();
        if (!this.isPreview()) {
            if (this.isDate()) {
                String pattern = ((SimpleDateFormat)this.dateComponentDelegate.getDateFormat(this.getLocale())).toLocalizedPattern();
                this.editableTextfield_d.setTitle(pattern);
                onChangeScript.append("if(performInlineValidation(isDate(this.value, '");
                onChangeScript.append(pattern);
                onChangeScript.append("'), '");
                onChangeScript.append(this.escape(XObjectRuntimeMsg.INVALID_DATE_FORMAT(pattern).getString(), true));
                onChangeScript.append("', this.style.bgcolor, this");
                if (!this.isClientErrorAsPopup()) {
                    onChangeScript.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                }
                onChangeScript.append(")){");
            }
            onChangeScript.append("isMaskOk=true;isPatternOk=true;");
            if (!(xText.passwordfield || xText.getReference() == null || this.getKind() != 5 && this.getKind() != 2)) {
                if (this.hasMask()) {
                    String mask = this.escape(this.getMask(), true);
                    onChangeScript.append("mask='");
                    onChangeScript.append(mask);
                    onChangeScript.append("';");
                    onChangeScript.append("isMaskOk=performInlineValidation(eval('applyMask(mask, this)'),'");
                    onChangeScript.append(this.escape(this.getMaskErrorMsg(), true));
                    onChangeScript.append("', '");
                    onChangeScript.append(this.getMaskErrorColor());
                    onChangeScript.append("', this");
                    if (!this.isClientErrorAsPopup()) {
                        onChangeScript.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                    }
                    onChangeScript.append(");");
                    this.editableTextfield_d.setTitle(mask);
                }
                if (this.hasInputPattern()) {
                    onChangeScript.append("pattern=/");
                    onChangeScript.append(this.escape(this.getInputPattern(), false));
                    onChangeScript.append("/;");
                    onChangeScript.append("if(isMaskOk){isPatternOk=performInlineValidation(eval('isPatternMatch(this.value, pattern)'),'");
                    onChangeScript.append(this.escape(this.getInputPatternErrorMsg(), true));
                    onChangeScript.append("', '");
                    onChangeScript.append(this.getInputPatternErrorColor());
                    onChangeScript.append("', this");
                    if (!this.isClientErrorAsPopup()) {
                        onChangeScript.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                    }
                    onChangeScript.append(");}");
                }
            }
            if (!this.isPreview()) {
                onChangeScript.append("if(isMaskOk && isPatternOk){valueChanged(this.name, ");
                onChangeScript.append(this.onChangeScript_d);
                onChangeScript.append(");}");
            }
            if (this.isDate()) {
                onChangeScript.append("}");
            }
        }
        return onChangeScript.toString();
    }

    private void initEditableTextField(XFormText t) {
        this.editableTextfield_d = new Input(this.getId());
        if (!t.passwordfield) {
            this.editableTextfield_d.setType("TEXT");
        } else {
            this.editableTextfield_d.setType("PASSWORD");
        }
        this.editableTextfield_d.setName(this.getHtmlAttString());
        this.editableTextfield_d.setHtmlId(this.getHtmlAttString());
        this.editableTextfield_d.setTabindex(this.getTabindex());
        if (t.getColqty() > 0) {
            this.editableTextfield_d.setSize(String.valueOf((int)((double)t.getColqty() * 1.2)));
        }
        this.editableTextfield_d.setReadOnly(!this.isEditable());
        this.onChangeScript_d = Boolean.toString(t.getOnChange() != null);
        this.editableTextfield_d.setOnChange(this.getOnChangeScript());
    }

    private void initNonEditableTextField(XFormText t) {
        this.nonEditableText_d = new Text();
        if (t.value != null) {
            this.nonEditableText_d.setText(this.componentDelegate_d.getNonEditableText(this.getLocale(), t.value.value_d, this.getKind()));
        }
        this.nonEditableDIV_d = new DIV(this.getId());
        this.nonEditableDIV_d.addChild(this.nonEditableText_d);
    }

    private void initTextField(XFormText t) {
        this.isDisplayAsLabel_d = t.displayaslabel;
        this.initEditableTextField(t);
        this.initNonEditableTextField(t);
        this.applyStyle();
        this.applyFocusPersistence();
    }
}

