/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormRadio;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLMultivaluatedElement;
import oracle.bpm.xobject.runtime.presentationComponents.MultivaluatedComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XORadioComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XORadioComponentDelegate;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLRadio
extends HTMLMultivaluatedElement
implements XORadioComponent,
MultivaluatedComponent,
XODateTimeComponent,
Cloneable {
    private Table borderTable;
    private final int cols;
    private XORadioComponentDelegate componentDelegate;
    private XODateTimeComponentDelegate dateComponentDelegate;
    private Table innerTable;
    private Input inputHidden;
    private String name;
    private String onChangeScript_d;
    private List<Input> radios = new ArrayList<Input>();
    private final int rows;
    private Text title;
    private String titleStr;
    private List<TR> trs = new ArrayList<TR>();
    static final long serialVersionUID = 7453827284467275393L;
    static final long serialCheck = -8265074365557866731L;

    public HTMLRadio(XScreen xScreen, XFormRadio r, Locale locale, TimeZone tz) {
        super(xScreen, r);
        this.rows = r.rows;
        this.cols = r.cols;
        this.titleStr = r.display;
        this.onChangeScript_d = r.getOnChange() != null ? "true" : "false";
        this.dateComponentDelegate = new XODateTimeComponentDelegate(this, locale, tz);
        this.initRadio();
        this.componentDelegate = new XORadioComponentDelegate(this);
    }

    public static HTMLRadio newInstance(HTMLRadio originalElement) {
        Object[][] vv;
        HTMLRadio newElement = new HTMLRadio(originalElement.getXScreen(), (XFormRadio)originalElement.getPresentationXMLObject(), originalElement.getLocale(), originalElement.getTimeZone());
        if (originalElement.isDate()) {
            newElement.restrict(originalElement.getDatePrecision(), originalElement.isAbsoluteDate());
        }
        if ((vv = originalElement.getValidValues()) != null && vv.length == 2) {
            newElement.setValidValues(vv[0], vv[1]);
        }
        newElement.setValue(originalElement.getValue());
        return newElement;
    }

    @Override
    public boolean isAbsoluteDate() {
        return this.dateComponentDelegate.isAbsoluteDate();
    }

    @Override
    public int getDatePrecision() {
        return this.dateComponentDelegate.getDatePrecision();
    }

    @Override
    public String getElementHtmlId() {
        return this.radios.size() > 0 ? this.radios.get(0).getAttribute(Input.ID_PROPERTY) : this.borderTable.getAttribute(Table.ID_PROPERTY);
    }

    @Override
    public String getFormatString() {
        return null;
    }

    @Override
    public Locale getLocale() {
        return this.dateComponentDelegate.getLocale();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.inputHidden != null) {
            this.inputHidden.setName(name);
        }
        for (int i = 0; i < this.radios.size(); ++i) {
            Input radio = this.radios.get(i);
            radio.setName("radio_" + name);
            radio.setHtmlId(name + "_id_" + i);
        }
    }

    @Override
    public Element getPureElement() {
        return this.borderTable;
    }

    @Override
    public String getStyle() {
        XFormRadio xRadio = (XFormRadio)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineBorderCSS(xRadio.borderstyle, xRadio.bordercolor, xRadio.borderwidth));
            css.append(this.getInlineFontCCS(xRadio.fonttype, xRadio.getFontStyle(), xRadio.fontsize));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
        }
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        for (Input radio : this.radios) {
            radio.setTabindex(tabIndex);
        }
    }

    @Override
    public TimeZone getTimeZone() {
        return this.dateComponentDelegate.getTimeZone();
    }

    @Override
    public Object[][] getValidValues() {
        return this.componentDelegate.getValidValues();
    }

    @Override
    public void setValue(Object value) {
        block2: {
            try {
                String valueStr = this.componentDelegate.convertToString(value);
                this.setSelectedOption(valueStr);
            }
            catch (Exception e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
                if (!Log.isDebugging()) break block2;
                Log.logDebug(e);
            }
        }
    }

    @Override
    public void _setEditable(boolean editable) {
        if (this.borderTable != null) {
            if (this.radios.isEmpty()) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_MULTIVALUATED_EMPTY(this.getId(), "setEditable"));
            }
            for (Input radio : this.radios) {
                radio.setDisabled(!editable);
            }
        }
    }

    @Override
    public void _setValidValues(Object[] values, Object[] presValues) {
        assert (values == presValues || values != null && presValues != null && presValues.length == values.length);
        if (values != null) {
            String[] strValues = ConversionUtilities.convertToString(values);
            String[] labels = ConversionUtilities.convertToString(presValues);
            if (this.isDate()) {
                for (int i = 0; i < values.length; ++i) {
                    long microseconds = this.dateComponentDelegate.convertDataValueToMicroseconds(strValues[i]);
                    strValues[i] = microseconds != -1L ? String.valueOf(microseconds) : "";
                    try {
                        Time t = Time.valueOf(labels[i]);
                        if (t == null) continue;
                        labels[i] = this.convertDataValueToPresentationValue(t);
                        continue;
                    }
                    catch (TimeFormatException e) {
                        // empty catch block
                    }
                }
            }
            this.setOptions(labels, strValues);
        } else {
            this.clearOptions();
        }
    }

    @Override
    public String convertDataValueToPresentationValue(Time time) {
        return this.dateComponentDelegate.convertDataValueToPresentationValue(time);
    }

    @Override
    public String convertPresentationValueToDataValue(String value) throws ParseException {
        return this.dateComponentDelegate.convertPresentationValueToDataValue(value);
    }

    public void initRadio() {
        this.borderTable = new Table(this.getId());
        TR tr = new TR("tr");
        TD td = new TD("td");
        td.setAlign("left");
        tr.addChild(td);
        this.borderTable.addChild(tr);
        Table tableTitle = new Table("tableTitle");
        tableTitle.setBorder("0");
        TR trTitle = new TR("trTitle");
        TD tdTitle = new TD("tdTitle");
        tdTitle.setVAlign("bottom");
        this.title = new Text("title");
        this.setText(this.titleStr);
        tdTitle.addChild(this.title);
        trTitle.addChild(tdTitle);
        tableTitle.addChild(trTitle);
        this.innerTable = new Table("innerTable");
        this.innerTable.setWidth("100%");
        this.innerTable.setHeight("100%");
        this.innerTable.setHtmlId(this.getName());
        this.inputHidden = new Input("inputHidden");
        this.inputHidden.setType("HIDDEN");
        this.inputHidden.setName(this.getName());
        this.inputHidden.setHtmlId(this.getId());
        td.addChild(tableTitle);
        td.addChild(this.inputHidden);
        td.addChild(this.innerTable);
        this.applyStyle();
        this.applyFocusPersistence();
        if (this.isPreview()) {
            this.setOptions(new String[]{"a", "b", "c"}, new String[]{"a", "b", "c"});
        }
    }

    @Override
    public boolean isDate() {
        return this.dateComponentDelegate.isDate();
    }

    @Override
    public Object clone() {
        return HTMLRadio.newInstance(this);
    }

    @Override
    public void restrict(int presicion, boolean isAbsolute) {
        this.dateComponentDelegate.restrict(presicion, isAbsolute);
    }

    @Override
    protected void _applyStyle(String style) {
        this.innerTable.setStyle(style);
        this.borderTable.setStyle(this.getInlineVisibilityCCS(this.isVisible()));
        if (this.isCssEnabled()) {
            this.innerTable.setCssClass(this.getCssClassName());
        } else {
            this.innerTable.setCssClass("");
        }
    }

    @Override
    protected void _setText(String text) {
        if (this.title != null) {
            this.title.setText(text);
        }
    }

    @Override
    void _setOnFocus(String js) {
        for (Input radio : this.radios) {
            radio.setOnFocus(js);
        }
    }

    private String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getHtmlAttString();
    }

    private void setOptions(String[] labels, String[] values) {
        int visibleItemQty;
        this.clearOptions();
        assert (labels.length == values.length);
        String htmlAttString = this.getName();
        String hiddenInputName = "document.xobjectForm." + htmlAttString;
        String radioGroupName = "document.xobjectForm.radio_" + htmlAttString;
        StringBuffer onChangeBuffer = new StringBuffer();
        onChangeBuffer.append(hiddenInputName);
        onChangeBuffer.append(".value = this.value;for(i=0;i<");
        onChangeBuffer.append(values.length);
        onChangeBuffer.append(";i++){");
        onChangeBuffer.append(radioGroupName);
        onChangeBuffer.append("[i].defaultChecked=false};this.defaultChecked=true;valueChanged('");
        onChangeBuffer.append(htmlAttString);
        onChangeBuffer.append("', ");
        onChangeBuffer.append(this.onChangeScript_d);
        onChangeBuffer.append(")");
        StringBuffer nonRequiredScriptBuffer = new StringBuffer();
        nonRequiredScriptBuffer.append("if(this.defaultChecked){this.defaultChecked=false;");
        nonRequiredScriptBuffer.append(radioGroupName);
        nonRequiredScriptBuffer.append("[0].checked=true;");
        nonRequiredScriptBuffer.append(hiddenInputName);
        nonRequiredScriptBuffer.append(".value = '';valueChanged('");
        nonRequiredScriptBuffer.append(htmlAttString);
        nonRequiredScriptBuffer.append("', ");
        nonRequiredScriptBuffer.append(this.onChangeScript_d);
        nonRequiredScriptBuffer.append(");return true;}");
        boolean hasNull = false;
        if (labels.length > 0 && values.length > 0) {
            hasNull = labels[0] == null || "".equals(labels[0]) && values[0] == null || "".equals(values[0]);
        }
        int n = visibleItemQty = hasNull ? labels.length - 1 : labels.length;
        int colQty = this.rows > 0 ? visibleItemQty / this.rows + (visibleItemQty % this.rows > 0 ? 1 : 0) : (this.cols < 2 ? 1 : this.cols);
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] == null) {
                labels[i] = "";
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_MULTIVALUATED_NULL_LABEL(this.getId(), this.getReference()));
            }
            if (values[i] == null) {
                values[i] = "";
            }
            Input radio = new Input(this.getName());
            radio.setType("RADIO");
            radio.setName("radio_" + this.getName());
            radio.setHtmlId(this.getName() + "_id_" + i);
            radio.setTabindex(this.getTabindex());
            radio.setValue(values[i]);
            Text label = new Text(String.valueOf(i), labels[i]);
            if (i == 0 && hasNull) {
                radio.setStyle(this.getInlineDisplayCCS(false));
                if (!this.isPreview()) {
                    radio.setOnClick(onChangeBuffer.toString());
                }
                onChangeBuffer = nonRequiredScriptBuffer.append(onChangeBuffer);
            } else if (!this.isPreview()) {
                radio.setOnClick(onChangeBuffer.toString());
            }
            this.radios.add(radio);
            this.addElement(hasNull ? i - 1 : i, radio, label, colQty);
        }
        this.applyFocusPersistence();
    }

    private void setSelectedOption(String value) {
        if (value == null) {
            value = "";
        } else if (this.isDate()) {
            long microseconds = this.dateComponentDelegate.convertDataValueToMicroseconds(value);
            value = microseconds != -1L ? String.valueOf(microseconds) : "";
        }
        boolean hasChecked = false;
        if (this.radios.isEmpty()) {
            this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_MULTIVALUATED_EMPTY(this.getId(), "setSelectedOption"));
        }
        for (Input radio : this.radios) {
            boolean checked = radio.getAttribute("value").equals(value);
            if (checked && !hasChecked) {
                hasChecked = true;
                this.inputHidden.setValue(value);
                radio.setChecked(true);
                continue;
            }
            radio.setChecked(false);
        }
        if (!hasChecked) {
            this.inputHidden.setValue("");
        }
    }

    private void addElement(int index, Input radio, Text label, int colQty) {
        TR tr;
        radio.setDisabled(!this.isEditable());
        if (index == -1 || index % colQty == 0) {
            tr = new TR(String.valueOf(this.trs.size()));
            if (index == -1) {
                tr.setStyle(this.getInlineDisplayCCS(false));
            }
            this.trs.add(tr);
            this.innerTable.addChild(tr);
        } else {
            tr = this.trs.get(this.trs.size() - 1);
        }
        TD td = new TD(String.valueOf(index));
        td.addChild(radio);
        td.addChild(label);
        tr.addChild(td);
    }

    private void clearOptions() {
        this.innerTable.removeAllChilds();
        this.trs.clear();
        this.radios.clear();
    }
}

