/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLComponentElement;
import oracle.bpm.xobject.runtime.presentationComponents.ComponentIdFactory;
import oracle.bpm.xobject.runtime.presentationComponents.XOLabelComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOLabelComponentDelegate;
import oracle.bpm.xobject.xhb.A;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Text;

public class HTMLLabel
extends HTMLComponentElement
implements XOLabelComponent,
Cloneable {
    private XOLabelComponentDelegate componentDelegate;
    private DIV div;
    private A href;
    private Text label;
    private String methodinvocation;
    static final long serialVersionUID = -6226320701247642884L;
    static final long serialCheck = 8631995326992114305L;

    public HTMLLabel(XScreen xScreen, XFormLabel l) {
        super(xScreen, l);
        this.initLabel(l);
        this.componentDelegate = new XOLabelComponentDelegate(this);
    }

    public static HTMLLabel newInstance(HTMLLabel originalElement) {
        return new HTMLLabel(originalElement.getXScreen(), (XFormLabel)originalElement.getPresentationXMLObject());
    }

    @Override
    public int getMethodArgumentQty() {
        return 0;
    }

    @Override
    public String getMethodInvocation() {
        if (this.methodinvocation != null && !this.methodinvocation.trim().equals("")) {
            return this.methodinvocation;
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.div.setHtmlId(name);
    }

    @Override
    public Element getPureElement() {
        if (!this.areEventsAllowed() || this.getLink() == null) {
            return this.div;
        }
        return this.href;
    }

    @Override
    public String getStyle() {
        XFormLabel xLabel = (XFormLabel)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (this.areEventsAllowed() && this.getMethodInvocation() != null || this.getLink() != null) {
            css.append("text-decoration: underline;");
        }
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xLabel.getFonttype(), xLabel.getFontStyle(), xLabel.getFontsize()));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
        }
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.href != null) {
            this.href.setTabIndex(tabIndex);
        }
    }

    @Override
    public boolean hasClick() {
        return this.getMethodInvocation() != null;
    }

    @Override
    public void _setEditable(boolean editable) {
        if (this.parent_d != null) {
            this.initLabelAction();
            this.applyStyle();
            Element element = this.getElement();
            this.parent_d.getElement().removeChild(element.getId());
            this.parent_d.getElement().addChild(element);
        }
    }

    @Override
    public Object clone() {
        return HTMLLabel.newInstance(this);
    }

    @Override
    protected void _applyStyle(String style) {
        this.div.setStyle(style);
        if (this.isCssEnabled()) {
            this.div.setCssClass(this.getCssClassName());
        } else {
            this.div.setCssClass("");
        }
    }

    @Override
    protected void _setLink(String link) {
        if (this.parent_d != null) {
            Element element = this.getElement();
            this.parent_d.getElement().removeChild(element.getId());
            this.parent_d.getElement().addChild(element);
            this.initLabelAction();
            this.applyStyle();
        }
    }

    @Override
    protected void _setText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    protected void addOnClickEvent(String script) {
        if (this.div != null) {
            if (script != null && !script.trim().equals("")) {
                this.div.setOnClick(script);
            } else {
                this.div.removeAttribute(A.ON_CLICK);
            }
        }
    }

    protected void initLabel(XFormLabel xLabel) {
        this.href = new A();
        this.href.setTabIndex(this.getTabindex());
        this.div = new DIV();
        this.div.setHtmlId(ComponentIdFactory.buildEditableTextComponentId(this.getId()));
        this.label = new Text();
        this.setText(xLabel.value.value_d);
        this.methodinvocation = xLabel.getOnclick();
        this.div.addChild(this.label);
        this.href.addChild(this.div);
        this.initLabelAction();
        this.applyStyle();
    }

    protected void initLabelAction() {
        StringBuffer onClickScriptBuffer = new StringBuffer();
        boolean hasAction = false;
        if (this.getLink() != null) {
            String url = this.getLink();
            if (!url.toLowerCase().startsWith("mailto:")) {
                onClickScriptBuffer.append("window.open('");
                onClickScriptBuffer.append(url);
                onClickScriptBuffer.append("', '_blank'");
                XFormLabel xLabel = (XFormLabel)this.getPresentationXMLObject();
                if (!xLabel.isFullBrowser()) {
                    onClickScriptBuffer.append(", 'resizable,scrollbars'");
                }
                onClickScriptBuffer.append(");return false;");
            } else {
                onClickScriptBuffer.append("return true;");
            }
            hasAction = true;
            this.href.setHref(url);
            this.href.setTitle(url);
        } else if (this.areEventsAllowed() && this.getMethodInvocation() != null) {
            this.div.removeAttribute(DIV.TITLE_PROPERTY);
            onClickScriptBuffer.append("this.style.cursor = 'wait';doXoAction(");
            onClickScriptBuffer.append(14);
            onClickScriptBuffer.append(", this.id);return false;");
            hasAction = true;
        }
        if (!this.isEditor()) {
            if (hasAction) {
                this.addOnClickEvent(onClickScriptBuffer.toString());
                if (!this.isPreview()) {
                    this.div.setOnMouseOver("if(isActionInProgress()){this.style.cursor = 'wait'}else{this.style.cursor = 'pointer'}");
                } else {
                    this.div.setOnMouseOver("this.style.cursor = 'pointer'");
                }
                this.div.setOnMouseOut("this.style.cursor = 'auto'");
            } else {
                this.removeOnClickEvent();
                this.div.removeAttribute(DIV.TITLE_PROPERTY);
                this.div.setOnMouseOver("this.style.cursor = 'auto'");
                this.div.setOnMouseOut("this.style.cursor = 'auto'");
            }
        }
    }

    protected void removeOnClickEvent() {
        if (this.div != null) {
            this.div.removeAttribute(DIV.ON_CLICK);
        }
    }

    @Override
    void _setOnFocus(String js) {
    }
}

