/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormCheck;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.presentationComponents.ComponentIdFactory;
import oracle.bpm.xobject.runtime.presentationComponents.XOCheckBoxComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOCheckBoxComponentDelegate;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLCheckBox
extends HTMLInputElement
implements XOCheckBoxComponent,
Cloneable {
    private Input check;
    private Table checkTable;
    private Text checkText;
    private XOCheckBoxComponentDelegate componentDelegate;
    private String onChangeScript;
    static final long serialVersionUID = -1323857086554552264L;
    static final long serialCheck = 7933324123574224237L;

    public HTMLCheckBox(XScreen xScreen, XFormCheck xCheck) {
        super(xScreen, xCheck);
        this.initCheckBox();
        this.componentDelegate = new XOCheckBoxComponentDelegate(this);
    }

    public static HTMLCheckBox newInstance(HTMLCheckBox originalElement) {
        HTMLCheckBox newElement = new HTMLCheckBox(originalElement.getXScreen(), (XFormCheck)originalElement.getPresentationXMLObject());
        newElement.setValue(originalElement.getDefaultValue());
        return newElement;
    }

    @Override
    public String getElementHtmlId() {
        return this.check.getAttribute(Input.ID_PROPERTY);
    }

    @Override
    public void setName(String name) {
        if (this.check != null) {
            this.check.setName(name);
            this.check.setHtmlId(name);
        }
    }

    @Override
    public Element getPureElement() {
        if (!this.isPreview()) {
            this.check.setOnClick("if(this.value=='false'){this.value='true'}else{this.value='false'};valueChanged(this.name, " + this.onChangeScript + ");");
        }
        return this.checkTable;
    }

    @Override
    public String getStyle() {
        XFormCheck check = (XFormCheck)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(check.fonttype, check.getFontStyle(), check.fontsize));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
            css.append(this.getInlineBorderCSS(check.borderstyle, check.bordercolor, check.borderwidth));
        }
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.check != null) {
            this.check.setTabindex(tabIndex);
        }
    }

    @Override
    public void setValue(Object value) {
        block2: {
            try {
                String valueStr = this.componentDelegate.convertToString(value);
                this.check.setValue(valueStr);
                boolean boolVal = Boolean.valueOf(valueStr);
                this.check.setChecked(boolVal);
            }
            catch (Exception e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
                if (!Log.isDebugging()) break block2;
                Log.logDebug(e);
            }
        }
    }

    @Override
    public void _setEditable(boolean editable) {
        if (this.check != null) {
            this.check.setDisabled(!editable);
        }
    }

    @Override
    public Object clone() {
        return HTMLCheckBox.newInstance(this);
    }

    @Override
    protected void _applyStyle(String style) {
        this.checkTable.setStyle(style);
        if (this.isCssEnabled()) {
            this.checkTable.setCssClass(this.getCssClassName());
        } else {
            this.checkTable.setCssClass("");
        }
    }

    @Override
    protected void _setText(String text) {
        this.checkText.setText(text);
    }

    @Override
    void _setOnFocus(String js) {
        this.check.setOnFocus(js);
    }

    void addValueChangeEvent(String script) {
        if (this.check != null) {
            this.check.setOnChange(script);
        }
    }

    private void initCheckBox() {
        XFormCheck xCheck = (XFormCheck)this.getPresentationXMLObject();
        this.check = new Input();
        this.check.setType("CHECKBOX");
        this.check.setDisabled(!xCheck.editable || this.isDisplay());
        this.check.setName(this.getHtmlAttString());
        this.check.setHtmlId(this.getHtmlAttString());
        this.check.setTabindex(this.getTabindex());
        TD checkInputTD = new TD();
        checkInputTD.setNoWrap(true);
        checkInputTD.addChild(this.check);
        TD checkLabelTD = new TD();
        checkLabelTD.setNoWrap(true);
        checkLabelTD.setHtmlId(ComponentIdFactory.buildEditableTextComponentId(this.getId()));
        this.checkText = new Text();
        if (xCheck.value != null) {
            this.setText(xCheck.value.getValue());
        }
        checkLabelTD.addChild(this.checkText);
        TR checkTR = new TR();
        checkTR.addChild(checkInputTD);
        checkTR.addChild(checkLabelTD);
        this.checkTable = new Table();
        this.checkTable.addChild(checkTR);
        this.onChangeScript = xCheck.getOnChange() != null ? "true" : "false";
        this.applyStyle();
        this.applyFocusPersistence();
    }
}

