/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.servlet.ParameterNotFoundException;
import oracle.bpm.web.execution.Attachment;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.Controller;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.Request;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.XOExecutionController;
import oracle.bpm.xobject.runtime.html.HTMLGroup;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class FObjectFileChooserController
implements Controller {
    static final long serialVersionUID = 401146848584451137L;
    static final long serialCheck = 3510330840359827647L;

    public void service(ComponentContext componentContext, ExternalContext externalContext) throws Exception {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$Action", "xo$DocSessKey", "xo$FileChooserDataId", "xo$ScreenSessKey"});
        int action = 9999;
        String xfdocKey = null;
        String xfscreenKey = null;
        String attrId = null;
        String onChange = null;
        try {
            xfdocKey = this.getStringParameter(request, "xo$DocSessKey");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_DOCKEY_NOT_FOUND(pnfe.getMessage()));
            this.renderErrorPage(externalContext, pnfe);
            return;
        }
        XOExecutionController controller = null;
        try {
            controller = (XOExecutionController)componentContext.getAttribute(xfdocKey);
        }
        catch (Throwable e) {
            this.renderErrorPage(externalContext, e);
            return;
        }
        if (controller == null) {
            Exception e = new Exception(XObjectRuntimeMsg.FOBJECT_00001(xfdocKey).getString());
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_XSCREEN_NOT_FOUND(e.getMessage()));
            this.renderErrorPage(externalContext, e);
            return;
        }
        try {
            xfscreenKey = this.getStringParameter(request, "xo$ScreenSessKey");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_DOCKEY_NOT_FOUND(pnfe.getMessage()));
            this.renderErrorPage(externalContext, pnfe);
            return;
        }
        XScreenHTMLImpl doc = null;
        try {
            doc = (XScreenHTMLImpl)controller.getManager(Integer.parseInt(xfscreenKey)).getXScreen();
        }
        catch (NumberFormatException e) {
            Log.logDebug(e);
            doc = (XScreenHTMLImpl)controller.getCurrentManager().getXScreen();
        }
        if (doc == null) {
            Exception e = new Exception(XObjectRuntimeMsg.FOBJECT_00001(xfdocKey).getString());
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_XSCREEN_NOT_FOUND(e.getMessage()));
            this.renderErrorPage(externalContext, e);
            return;
        }
        try {
            attrId = this.getStringParameter(request, "xo$FileChooserDataId");
        }
        catch (NumberFormatException nfe) {
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_CORRUPTED_ACTION(attrId, nfe.getMessage()));
            this.renderErrorPage(externalContext, nfe);
            return;
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_ACTION_NOT_FOUND(pnfe.getMessage()));
            this.renderErrorPage(externalContext, pnfe);
            return;
        }
        try {
            action = this.getIntParameter(request, "xo$Action");
        }
        catch (NumberFormatException nfe) {
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_CORRUPTED_ACTION(String.valueOf(action), nfe.getMessage()));
            this.renderErrorPage(externalContext, nfe);
            return;
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_ACTION_NOT_FOUND(pnfe.getMessage()));
            this.renderErrorPage(externalContext, pnfe);
            return;
        }
        try {
            onChange = this.getStringParameter(request, "xo$FileChooserOnChange");
        }
        catch (ParameterNotFoundException pnfe) {
            onChange = null;
        }
        try {
            switch (action) {
                case 9999: {
                    this.renderPage(externalContext, componentContext, doc, attrId, onChange);
                    break;
                }
                case 0: {
                    this.updateBynaryValue(externalContext, componentContext, doc, attrId);
                    this.renderOkPage(externalContext, componentContext, doc, attrId, onChange);
                }
            }
        }
        catch (Throwable t) {
            Log.logWarning(XObjectRuntimeMsg.FOBJECT_ACTION_MANAGEMENT_ERROR(t.getMessage()));
            this.renderErrorPage(externalContext, t);
        }
    }

    public int getIntParameter(Request request, String name) throws ParameterNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringParameter(request, name));
    }

    protected void updateBynaryValue(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, String attrId) throws IOException, ComponentExecutionException, InvocationTargetException {
        if (doc.isDisplay()) {
            return;
        }
        List attachments = externalContext.getRequest().getAttachments();
        for (Attachment attachment : attachments) {
            File file = attachment.getFile();
            byte[] fileBytes = StreamUtils.readBytes(new FileInputStream(file));
            if (fileBytes != null && fileBytes.length == 0) {
                fileBytes = null;
            }
            if (attrId.startsWith("att$")) {
                String presAttId = XOConstants.getAttId(attrId);
                String dataId = doc.getDataIdtWithPressId(presAttId);
                doc.getRuntimeManager().getXObject().setAttributeValue(dataId, fileBytes);
                continue;
            }
            if (!attrId.startsWith("grp$")) continue;
            String groupPresId = XOConstants.getGrpId(attrId);
            String groupDataId = doc.getDataIdtWithPressId(groupPresId);
            String groupColumnPresId = XOConstants.getAttId(attrId);
            int index = XOConstants.getGrpIndex(attrId);
            HTMLGroup group = (HTMLGroup)doc.getPElementWithId(groupPresId);
            String groupColumnDataId = group.getDataIdtWithPressId(groupColumnPresId);
            doc.getRuntimeManager().getXObject().setGroupAttributeValue(groupDataId, groupColumnDataId, index, fileBytes);
        }
    }

    private void checkParameters(Request request, String[] strings) {
    }

    private void renderErrorPage(ExternalContext externalContext, Throwable error) {
        Request request = externalContext.getRequest();
        request.setAttribute("xo$FileChooserResult", (Object)String.valueOf(1));
        externalContext.processAction("XObject", "fileChooser");
    }

    private void renderOkPage(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, String dataId, String onChange) {
        Request request = externalContext.getRequest();
        request.setAttribute("xo$FileChooserResult", (Object)String.valueOf(0));
        this.renderPage(externalContext, componentContext, doc, dataId, onChange);
    }

    private void renderPage(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, String dataId, String onChange) {
        Request request = externalContext.getRequest();
        componentContext.setAttribute("xo$DocSessKey", (Object)doc.getRuntimeManager().getExecutionController().getIdentifier());
        componentContext.setAttribute("xo$ScreenSessKey", (Object)doc.getIdentifier());
        request.setAttribute("xo$FileChooserDataId", (Object)dataId);
        request.setAttribute("xo$FileChooserOnChange", (Object)onChange);
        externalContext.processAction("XObject", "fileChooser");
    }

    private String getStringParameter(Request request, String name) throws ParameterNotFoundException {
        String[] values = (String[])request.getParameterMap().get(name);
        if (values == null) {
            throw new ParameterNotFoundException(name + " not found");
        }
        if (values[0].length() == 0) {
            throw new ParameterNotFoundException(name + " was empty");
        }
        return values[0];
    }
}

