/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.components;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import oracle.bpm.collections.maps.WeakValueHashMap;
import oracle.bpm.component.Component;
import oracle.bpm.lang.SuspendableThreadLocal;

@oracle.bpm.component.metadata.Component(module="Fuego.Internal")
public abstract class Executor {
    protected String key = Integer.toHexString(random.nextInt(Integer.MAX_VALUE)) + "-" + Integer.toHexString(this.hashCode());
    private static final ThreadLocal<Executor> currentExecutor = new SuspendableThreadLocal<Executor>();
    protected static final Map<String, Executor> executors = Collections.synchronizedMap(new WeakValueHashMap());
    protected static final Random random = new Random();

    public Executor() {
        executors.put(this.key, this);
    }

    public abstract Object[] invokeMethod(Object var1, String var2, Object[] var3, Object[] var4) throws Exception;

    public static void setCurrent(Executor executor) {
        currentExecutor.set(executor);
    }

    public static Executor getCurrent() {
        if (Component.isRunningOnClientSide() || Component.isRunningOnBrowser()) {
            return currentExecutor.get();
        }
        return null;
    }

    public static Executor findExecutor(String key) {
        return executors.get(key);
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.key != null) {
                executors.remove(this.key);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

