/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import oracle.bpm.component.ExecutionRelayedThrowable;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.InvalidSignatureException;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.ValidationException;
import oracle.bpm.log.Log;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.Conversion;
import oracle.bpm.xobject.MaskUtilities;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.runtime.ConstraintReport;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.runtime.DataProcessing;
import oracle.bpm.xobject.runtime.ErrorListener;
import oracle.bpm.xobject.runtime.ExecutionListener;
import oracle.bpm.xobject.runtime.FinishFOExecution;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.PresentationProcessing;
import oracle.bpm.xobject.runtime.ShowFOExecution;
import oracle.bpm.xobject.runtime.ValueChangeListener;
import oracle.bpm.xobject.runtime.XOExecutionController;
import oracle.bpm.xobject.runtime.XObjectGroupRowInstance;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.XObjectRuntimeInternalException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.components.PresentableDelegate;
import oracle.bpm.xobject.runtime.html.UrlBuilder;
import oracle.bpm.xobject.runtime.presentationComponents.MultivaluatedComponent;
import oracle.bpm.xobject.runtime.presentationComponents.RefreshableComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOElementComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextFieldComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XORuntimeManager
implements ValueChangeListener {
    private transient UrlBuilder builder;
    private XOExecutionController controller;
    private int execStackPosition;
    private final int implType;
    private boolean initialized = false;
    private final Locale locale;
    private Set<String> presentationDataIdList;
    private Map<String, String> presentationDataMap;
    private XFormPresentationModel presentationModel;
    private String presName;
    private Set<String> refreshablePresIdList;
    private XScreen screen;
    private int showOption = 0;
    private final TimeZone tZone;
    private XObjectInstance xoInstance;
    public static final int INPUT = 0;
    public static final int DISPLAY = 1;
    public static final int PREVIEW = 2;
    public static final int SHOW = 3;
    public static final int EDITOR = 4;
    public static final int SWING_IMPL = 10;
    public static final int HTML_IMPL = 11;

    public XORuntimeManager(XObjectInstance xo, String presName, int implType, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        this.locale = locale;
        this.tZone = tZone;
        this.implType = implType;
        this.xoInstance = xo;
        this.presName = presName;
        this.presentationDataMap = new HashMap<String, String>();
        this.presentationDataIdList = new HashSet<String>();
    }

    public XORuntimeManager(XOExecutionController controller, Object xo, String presName, int implType, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        this.controller = controller;
        this.locale = locale;
        this.tZone = tZone;
        this.implType = implType;
        this.xoInstance = new XObjectInstance(xo, !controller.isPreview());
        if (presName != null) {
            this.xoInstance.validatePresentationName(presName);
        }
        this.presName = presName;
        this.presentationDataMap = new HashMap<String, String>();
        this.presentationDataIdList = new HashSet<String>();
    }

    protected XORuntimeManager(XObjectInstance xoInstance) {
        this.locale = Locale.getDefault();
        this.tZone = TimeZone.getDefault();
        this.implType = 11;
        this.xoInstance = xoInstance;
    }

    public XFormPresentationModel getCurrentPModel() throws XObjectRuntimeInternalException {
        XFormPresentationModel model = this.getModel();
        this.presName = model.getPresentationName();
        return model;
    }

    public XOExecutionController getExecutionController() {
        return this.controller;
    }

    public int getExecutionStackPosition() {
        return this.execStackPosition;
    }

    public int getImplementationType() {
        return this.implType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPresentationName() {
        return this.presName;
    }

    public int getShowOption() {
        return this.showOption;
    }

    public TimeZone getTimeZone() {
        return this.tZone;
    }

    public UrlBuilder getUrlBuilder() {
        return this.builder;
    }

    public XObjectInstance getXObject() {
        return this.xoInstance;
    }

    public XScreen getXScreen() {
        return this.screen;
    }

    public void initPresentationComponents() throws XObjectRuntimeInternalException {
        Set<String> dataIds = this.getAllDataIds();
        for (String dataId : dataIds) {
            XObjectRuntimeInternalException xoie;
            XOInputComponent comp = this.getXScreen().getPresComponentWithRef(dataId);
            comp.applyRestrictions();
            if (comp instanceof XOGroupComponent) {
                ((XOGroupComponent)comp).initPresentationGroupComponents();
                if (this.isPreview()) {
                    try {
                        if (this.getXObject().getGroupSize(dataId) == 0) {
                            this.getXObject().addNewRowToGroup(dataId);
                        }
                    }
                    catch (Throwable e) {
                        Log.logWarning(e);
                    }
                }
            }
            if (comp instanceof MultivaluatedComponent) {
                try {
                    Object[][] vv = this.getXObject().getAttributeValidValues(comp.getReference());
                    ((MultivaluatedComponent)comp).setValidValues(vv[0], vv[1]);
                }
                catch (InvalidXOAttributeException e) {
                    xoie = new XObjectRuntimeInternalException(XObjectRuntimeMsg.XOBJ_INV_ATTR_0003(dataId), (Throwable)e);
                    Log.logWarning(xoie);
                    if (!this.isPreview()) {
                        throw xoie;
                    }
                }
                catch (RuntimeException e) {
                    if (this.isPreview()) {
                        Log.logWarning(e);
                    }
                    throw e;
                }
            }
            try {
                comp.refreshPresentationValue(true);
            }
            catch (Throwable t) {
                xoie = new XObjectRuntimeInternalException(t);
                Log.logWarning(xoie);
                if (this.isPreview()) continue;
                throw xoie;
            }
        }
        this.getXObject().resetDirty();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isDisplay() {
        return this.getShowOption() == 1;
    }

    public boolean isHTMLImp() {
        return this.getImplementationType() == 11;
    }

    public boolean isInput() {
        return this.getShowOption() == 0;
    }

    public boolean isPreview() {
        return this.getShowOption() == 2 || this.getShowOption() == 4;
    }

    public boolean isShow() {
        return this.getShowOption() == 3;
    }

    public boolean isEditor() {
        return this.getShowOption() == 4;
    }

    public boolean isSwingImp() {
        return this.getImplementationType() == 10;
    }

    public void loadPresentationValidValues() {
        Set<String> presIds = this.getAllRefreshablePresentationIds();
        for (String presId : presIds) {
            this.setPresentationValidValues(presId);
        }
    }

    public void refreshPresentation(boolean force) {
        Set<String> presIds = this.getAllRefreshablePresentationIds();
        for (String presId : presIds) {
            XOPresentationComponent comp = this.getXScreen().getPresComponentWithId(presId);
            if (comp.isGroupColumnComponent()) continue;
            if (comp instanceof XOInputComponent) {
                force = force || comp.isPresCompDirty();
                comp.resetPresCompDirty();
                ((XOInputComponent)comp).refreshPresentationValue(force);
            }
            if (!(comp instanceof RefreshableComponent)) continue;
            ((RefreshableComponent)((Object)comp)).refresh(this.getXObject());
        }
        this.getXObject().resetDirty();
    }

    public void registerComponent(String presId, String dataId, XOPresentationComponent comp) {
        if (this.presentationDataMap == null) {
            this.presentationDataMap = new HashMap<String, String>();
        }
        if (this.presentationDataIdList == null) {
            this.presentationDataIdList = new HashSet<String>();
        }
        if (this.refreshablePresIdList == null) {
            this.refreshablePresIdList = new HashSet<String>();
        }
        if (dataId == null || !this.getXObject().hasGroupXOAttName(dataId)) {
            this.presentationDataMap.put(presId, dataId);
            if (dataId != null) {
                this.presentationDataIdList.add(dataId);
            }
            if (comp instanceof XOInputComponent || comp instanceof RefreshableComponent) {
                this.refreshablePresIdList.add(presId);
            }
        }
    }

    public void setExecutionStackPosition(int execStackPosition) {
        this.execStackPosition = execStackPosition;
    }

    public boolean setGroupInstanceValue(String groupDataId, String columnDataId, int index, String value) throws ComponentExecutionException {
        XObjectInstance xoInstance = this.getXObject();
        XScreen xScreen = this.getXScreen();
        try {
            Object val;
            XOTextFieldComponent text;
            XOGroupComponent group = (XOGroupComponent)xScreen.getPresComponentWithRef(groupDataId);
            XOElementComponent columnElement = group.getColumnElementByDataId(columnDataId);
            if (columnElement != null && columnElement instanceof XOTextFieldComponent && (((XOTextFieldComponent)columnElement).getKind() == 5 || ((XOTextFieldComponent)columnElement).getKind() == 2) && (text = (XOTextFieldComponent)columnElement).hasMask()) {
                value = MaskUtilities.cleanMask(text.getMask(), value);
            }
            XObjectGroupRowInstance groupRowXObjectInstance = xoInstance.getGroupXObjectInstance(groupDataId, index);
            int kind = columnElement instanceof XOInputComponent ? ((XOInputComponent)columnElement).getKind() : groupRowXObjectInstance.getAttributeKind(columnDataId);
            if (kind == 17) {
                val = Integer.valueOf(value);
            } else {
                if (kind == 2) {
                    int length = groupRowXObjectInstance.getAttributeLength(columnDataId);
                    TypeDescription typeDescription = TypeFactory.getInt(length);
                    String minValue = typeDescription.getMinValue();
                    String maxValue = typeDescription.getMaxValue();
                    try {
                        Class<?> cl = typeDescription.getJavaClass();
                        val = Conversion.convertTo(value, cl);
                    }
                    catch (IllegalConversionException ice) {
                        ConstraintReport notNullError = ConstraintReport.getRuntimeSetterErrorReportInstance(groupDataId, columnDataId, XObjectRuntimeMsg.NUMBER_FORMAT_OUT_OF_RANGE(value, minValue, maxValue).getString(), index);
                        xScreen.showError(notNullError);
                        Object oldValue = groupRowXObjectInstance.getAttributeValue(columnDataId);
                        groupRowXObjectInstance.setAttributeValue(columnDataId, oldValue);
                        return true;
                    }
                }
                try {
                    val = ConversionUtilities.fromString(value, groupRowXObjectInstance.getAttributeKind(columnDataId));
                }
                catch (Throwable t) {
                    ConstraintReport notNullError = ConstraintReport.getRuntimeSetterErrorReportInstance(groupDataId, columnDataId, XObjectRuntimeMsg.FORMAT_ERROR(value).getString(), index);
                    xScreen.showError(notNullError);
                    Object oldValue = groupRowXObjectInstance.getAttributeValue(columnDataId);
                    groupRowXObjectInstance.setAttributeValue(columnDataId, oldValue);
                    return true;
                }
            }
            if (val == null && groupRowXObjectInstance.isAttributeRequired(columnDataId)) {
                ConstraintReport notNullError = ConstraintReport.getRuntimeNotNullErrorReportInstance(groupDataId, columnDataId, XObjectRuntimeMsg.NOT_NULL_FAIL.getString(), index);
                xScreen.showError(notNullError);
                Object oldValue = groupRowXObjectInstance.getAttributeValue(columnDataId);
                groupRowXObjectInstance.setAttributeValue(columnDataId, oldValue);
                return true;
            }
            groupRowXObjectInstance.setAttributeValue(columnDataId, val);
            return true;
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause != null && cause instanceof ValidationException) {
                String validationMsg = cause.getMessage();
                if (validationMsg == null || validationMsg.trim().length() == 0) {
                    validationMsg = XObjectRuntimeMsg.REQUIRED_EXP_FAIL.getString();
                }
                ConstraintReport error = ConstraintReport.getRuntimeSetterErrorReportInstance(groupDataId, columnDataId, validationMsg, index);
                xScreen.showError(error);
            } else {
                if (e instanceof ComponentExecutionException) {
                    throw (ComponentExecutionException)e;
                }
                if (cause instanceof ComponentExecutionException) {
                    throw (ComponentExecutionException)cause;
                }
                if (cause instanceof ExecutionRelayedThrowable) {
                    Log.logWarning(XObjectRuntimeMsg.XO_RUNTIME_MGR_INTERACTIVE_COMP_FROM_RELAY);
                    Log.logWarning(e);
                } else {
                    StringBuffer buff = new StringBuffer();
                    buff.append("set");
                    buff.append(Character.toUpperCase(columnDataId.charAt(0)));
                    buff.append(columnDataId.substring(1));
                    cause.printStackTrace();
                    throw new XObjectRuntimeInternalException(XObjectRuntimeMsg.XOBJ_MTD_ERR_0001(buff.toString(), this.xoInstance.getName()), cause);
                }
            }
            return false;
        }
    }

    public boolean setInstanceValue(String dataId, String value) throws ComponentExecutionException {
        XObjectInstance xoInstance = this.getXObject();
        XScreen xScreen = this.getXScreen();
        try {
            XOTextFieldComponent text;
            XOInputComponent inputComp = xScreen.getPresComponentWithRef(dataId);
            int kind = inputComp.getKind();
            if (inputComp instanceof XOTextFieldComponent && (kind == 5 || inputComp.getKind() == 2) && (text = (XOTextFieldComponent)inputComp).hasMask()) {
                value = MaskUtilities.cleanMask(text.getMask(), value);
            }
            Object val = null;
            if (!Str.isEmpty(value)) {
                if (kind == 17) {
                    val = Integer.valueOf(value);
                } else {
                    if (kind == 2) {
                        int length = xoInstance.getAttributeLength(dataId);
                        TypeDescription typeDescription = TypeFactory.getInt(length);
                        String minValue = typeDescription.getMinValue();
                        String maxValue = typeDescription.getMaxValue();
                        try {
                            Class<?> cl = typeDescription.getJavaClass();
                            val = Conversion.convertTo(value, cl);
                        }
                        catch (IllegalConversionException ice) {
                            ConstraintReport notNullError = ConstraintReport.getRuntimeSetterErrorReportInstance(dataId, XObjectRuntimeMsg.NUMBER_FORMAT_OUT_OF_RANGE(value, minValue, maxValue).getString());
                            xScreen.showError(notNullError);
                            inputComp.refreshPresentationValue(true);
                            return false;
                        }
                    }
                    try {
                        val = ConversionUtilities.fromString(value, kind);
                    }
                    catch (Throwable t) {
                        ConstraintReport notNullError = ConstraintReport.getRuntimeSetterErrorReportInstance(dataId, XObjectRuntimeMsg.FORMAT_ERROR(value).getString());
                        xScreen.showError(notNullError);
                        inputComp.refreshPresentationValue(true);
                        return false;
                    }
                }
            }
            if (val == null && xoInstance.isAttributeRequired(dataId)) {
                ConstraintReport notNullError = ConstraintReport.getRuntimeNotNullErrorReportInstance(dataId, XObjectRuntimeMsg.NOT_NULL_FAIL.getString());
                xScreen.showError(notNullError);
                inputComp.refreshPresentationValue(true);
                return false;
            }
            xoInstance.setAttributeValue(dataId, val);
            return true;
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof ValidationException) {
                String validationMsg = cause.getMessage();
                if (validationMsg == null || validationMsg.trim().length() == 0) {
                    validationMsg = XObjectRuntimeMsg.REQUIRED_EXP_FAIL.getString();
                }
                ConstraintReport setterError = ConstraintReport.getRuntimeSetterErrorReportInstance(dataId, validationMsg);
                xScreen.showError(setterError);
            } else {
                if (e instanceof ComponentExecutionException) {
                    throw (ComponentExecutionException)e;
                }
                if (cause instanceof ComponentExecutionException) {
                    throw (ComponentExecutionException)cause;
                }
                if (cause instanceof ExecutionRelayedThrowable) {
                    Log.logWarning(XObjectRuntimeMsg.XO_RUNTIME_MGR_INTERACTIVE_COMP_FROM_RELAY);
                    Log.logWarning(e);
                } else {
                    StringBuffer buff = new StringBuffer();
                    buff.append("set");
                    buff.append(Character.toUpperCase(dataId.charAt(0)));
                    buff.append(dataId.substring(1));
                    throw new XObjectRuntimeInternalException(XObjectRuntimeMsg.XOBJ_MTD_ERR_0001(buff.toString(), this.xoInstance.getName()), cause);
                }
            }
            return false;
        }
    }

    public void setPresentationValidValues(String compId) {
        XOPresentationComponent comp = this.getXScreen().getPresComponentWithId(compId);
        if (comp != null) {
            if (comp instanceof MultivaluatedComponent) {
                try {
                    Object[][] vv = this.getXObject().getAttributeValidValues(comp.getReference());
                    ((MultivaluatedComponent)comp).setValidValues(vv[0], vv[1]);
                }
                catch (InvalidXOAttributeException e) {
                    Log.logWarning(XObjectRuntimeMsg.XO_RUNTIME_MGR_INVALID_VV_REFERENCE(comp.getReference(), e.getCause().getMessage()));
                    Log.logWarning(e);
                }
            } else if (comp instanceof XOGroupComponent) {
                ((XOGroupComponent)comp).refreshPresentationValue(true);
            } else if (this.isEmbedded()) {
                Log.logWarning(XObjectRuntimeMsg.XO_RUNTIME_MGR_NON_MULTIVALUATED_COMP(compId, this.getPresentationName(), this.getFOName()));
            } else {
                Log.logInfo(XObjectRuntimeMsg.XO_RUNTIME_MGR_NON_MULTIVALUATED_COMP(compId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Log.logWarning(XObjectRuntimeMsg.XO_RUNTIME_MGR_COMPONENT_NOT_FOUND(compId));
        }
    }

    public void setShowOption(int option) {
        this.showOption = option;
    }

    public void restoreListeners() {
        List groupComponentIds;
        XScreen xScreen = this.getXScreen();
        if (xScreen != null && (groupComponentIds = xScreen.getGroupComponentIds()) != null && !groupComponentIds.isEmpty()) {
            for (Object groupComponentId : groupComponentIds) {
                String groupId = (String)groupComponentId;
                XOGroupComponent groupComponent = (XOGroupComponent)xScreen.getPresComponentWithId(groupId);
                groupComponent.registerListener();
            }
        }
    }

    public void setUrlBuilder(UrlBuilder builder) {
        this.builder = builder;
    }

    public void setXScreen(XScreen xScreen) {
        this.screen = xScreen;
    }

    public boolean isEmbedded() {
        return Boolean.getBoolean("fuego.environment.embedded");
    }

    @Override
    public void valueChanged(String dataId, String value) {
        try {
            boolean isValueSet = this.setInstanceValue(dataId, value);
            if (isValueSet) {
                String onChange;
                this.refreshPresentation(false);
                XFormPresentationXMLObject xElement = this.getXScreen().getPresComponentWithRef(dataId).getPresentationXMLObject();
                if (xElement instanceof XFormUserInputPresentationXMLObject && (onChange = ((XFormUserInputPresentationXMLObject)xElement).getOnChange()) != null && !onChange.trim().equals("")) {
                    try {
                        this.getXScreen().processAction(onChange, null);
                    }
                    catch (ComponentExecutionException e) {
                        this.getXScreen().showError(e.getMessage());
                        Log.logWarning(e);
                    }
                }
            }
        }
        catch (ComponentExecutionException e) {
            this.getXScreen().showError(e.getLocalizedMessage());
            Log.logWarning(e);
        }
    }

    @Override
    public void valueChanged(String groupDataId, String columnDataId, int index, String value) {
        try {
            boolean isValueSet = this.setGroupInstanceValue(groupDataId, columnDataId, index, value);
            if (isValueSet) {
                String onChange;
                this.refreshPresentation(false);
                XOGroupComponent group = (XOGroupComponent)this.getXScreen().getPresComponentWithRef(groupDataId);
                XFormPresentationXMLObject xColumnElement = group.getColumnElementByDataId(columnDataId).getPresentationXMLObject();
                if (xColumnElement instanceof XFormUserInputPresentationXMLObject && (onChange = ((XFormUserInputPresentationXMLObject)xColumnElement).getOnChange()) != null && !onChange.trim().equals("")) {
                    try {
                        this.getXScreen().processAction(onChange, index);
                    }
                    catch (ComponentExecutionException e) {
                        this.getXScreen().showError(e.getLocalizedMessage());
                        Log.logWarning(e);
                    }
                }
            }
        }
        catch (ComponentExecutionException e) {
            this.getXScreen().showError(e.getLocalizedMessage());
            Log.logWarning(e);
        }
    }

    protected void initPresentableDelegate() throws ComponentExecutionException {
        PresentableDelegate pd = new PresentableDelegate(this);
        String sig = "Mset__presentableDelegate_delegate(Lfuego.xobject.runtime.components.PresentableDelegate;)V";
        try {
            this.getXObject().invokeMethod("Mset__presentableDelegate_delegate(Lfuego.xobject.runtime.components.PresentableDelegate;)V", new Object[]{pd});
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Log.logWarning(e);
            if (!this.isPreview() && !(cause instanceof ExecutionRelayedThrowable)) {
                throw new XObjectRuntimeInternalException(XObjectRuntimeMsg.XOBJ_MTD_ERR_0001(JavaClass.getMethodNameFromSignature("Mset__presentableDelegate_delegate(Lfuego.xobject.runtime.components.PresentableDelegate;)V"), this.xoInstance.getName()), cause);
            }
        }
        catch (ComponentExecutionException e) {
            if (!this.isPreview()) {
                throw e;
            }
            Log.logWarning(e);
        }
    }

    Set<String> getAllDataIds() {
        return this.presentationDataIdList;
    }

    Set<String> getAllPresentationIds() {
        return this.presentationDataMap.keySet();
    }

    Set<String> getAllRefreshablePresentationIds() {
        return this.refreshablePresIdList;
    }

    String getDataId(String presId) {
        return this.presentationDataMap.get(presId);
    }

    Object getTarget() {
        return this.xoInstance.getTarget();
    }

    void invokeActionMethod(String methodSignature, Integer index, Object[] args) throws ComponentExecutionException {
        try {
            this.getXObject().invokeMethod(methodSignature, index, args);
        }
        catch (FinishFOExecution e) {
            throw e;
        }
        catch (ShowFOExecution e) {
            throw e;
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof ValidationException) {
                String errorMsg = cause.getMessage() != null ? cause.getMessage() : XObjectRuntimeMsg.REQUIRED_EXP_FAIL.getString();
                ConstraintReport[] error = new ConstraintReport[]{index != null ? ConstraintReport.getRuntimeMethodErrorReportInstance(methodSignature, errorMsg, index) : ConstraintReport.getRuntimeMethodErrorReportInstance(methodSignature, errorMsg)};
                this.getXScreen().showErrors(error);
            }
            if (cause instanceof FinishFOExecution) {
                throw (FinishFOExecution)cause;
            }
            if (cause instanceof ShowFOExecution) {
                throw (ShowFOExecution)cause;
            }
            if (e instanceof ComponentExecutionException) {
                throw (ComponentExecutionException)e;
            }
            if (cause instanceof ComponentExecutionException) {
                throw (ComponentExecutionException)cause;
            }
            if (cause instanceof ExecutionRelayedThrowable) {
                Log.logWarning(XObjectRuntimeMsg.XO_RUNTIME_MGR_INTERACTIVE_COMP_FROM_RELAY);
                Log.logWarning(e);
            }
            String methodName = methodSignature;
            try {
                methodName = JavaClass.getMethodNameFromSignature(methodName);
            }
            catch (InvalidSignatureException ise) {
                // empty catch block
            }
            throw new XObjectRuntimeInternalException(XObjectRuntimeMsg.XOBJ_MTD_ERR_0001(methodName, this.xoInstance.getName()), cause);
        }
    }

    void makeXScreen(ExecutionListener dl, ErrorListener el) throws ComponentExecutionException {
        this.initPresentableDelegate();
        PresentationProcessing pp = PresentationProcessing.get(this, dl, el);
        this.screen = pp.process();
        DataProcessing dp = new DataProcessing(this);
        this.screen = dp.process();
        this.screen.initialize();
    }

    private String getFOName() {
        String FOname = this.getXObject().getName();
        int i = FOname.indexOf(46);
        FOname = FOname.substring(i + 1);
        return FOname;
    }

    private XFormPresentationModel getModel() throws XObjectRuntimeInternalException {
        String defPres;
        if (this.presName == null && (defPres = this.xoInstance.getXODefaultPresentation()) != null) {
            this.presName = defPres;
        }
        if (this.presentationModel == null) {
            this.presentationModel = this.xoInstance.getXOPresentationModel(this.presName);
        }
        return this.presentationModel;
    }
}

