/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

public class XOConstants {
    public static final String ACTION_PARAM_NAME = "xo$Action";
    public static final int FILE_CHOOSER_ACTION_NONE = 9999;
    public static String ATT_EXEC_INST = "xoExecType";
    public static final String ATT_WEBROOT_PATH = "webRootPath";
    public static final String ATT_EXEC_RESULT = "xoExecResult";
    public static final String ATT_EXEC_IN_PROGRESS = "xoExecInProgress";
    public static final String XFDOC_SESS_ATT_NAME = "_xDocAttName_";
    public static final String XFSCREEN_SESS_ATT_NAME = "_xScreenAttName_";
    public static final String ATT_NAME_PARAM_NAME = "xo$AttName";
    public static final String CHANGED_ATT_LIST = "xo$ChangedAtts";
    public static final String XCONTROLLER_ID_PARAM_NAME = "xo$DocSessKey";
    public static final String XSCREEN_ID_PARAM_NAME = "xo$ScreenSessKey";
    public static final String LAST_FOCUS_ELEMENT_ID = "xo$lastFocusElement";
    public static final String GROUP_INDEX_PARAM_NAME = "xo$GroupIndexes";
    public static final String TIMER_VALUES_PARAM_NAME = "xo$TimerValues";
    public static final String GRAPHIC_CLICK_CATEGORY_PARAM_NAME = "fo$graphiclick$category";
    public static final String GRAPHIC_CLICK_SERIES_PARAM_NAME = "fo$graphiclick$series";
    public static final String CONTEXT_ID_PARAM_NAME = "ctxId";
    public static final String HTML_IMAGE_ID_PARAM_NAME = "htmlImageId";
    public static final String QSTR_PARAM_NAME = "getQueryString";
    public static final String FILE_CHOOSER_DATAID_PARAM_NAME = "xo$FileChooserDataId";
    public static final String FILE_CHOOSER_RESULT_PARAM_NAME = "xo$FileChooserResult";
    public static final String FILE_CHOOSER_ONCHANGE_PARAM_NAME = "xo$FileChooserOnChange";
    public static final String EXECUTION_TYPE_PARAM_NAME = "xo$executionType";
    public static final int ACTION_NONE = 9999;
    public static final int ACTION_GET_INSTANCE = 0;
    public static final int ACTION_DONE = 1;
    public static final int ACTION_EXECUTOR = 3;
    public static final int ACTION_ARRAY_ADD_ROW = 4;
    public static final int ACTION_ARRAY_REMOVE_LAST_ROW = 5;
    public static final int ACTION_GET_IMG = 6;
    public static final int ACTION_SUBMIT = 7;
    public static final int ACTION_CANCEL = 8;
    public static final int ACTION_REFRESH = 9;
    public static final int ACTION_RESET = 10;
    public static final int ACTION_ACTION = 11;
    public static final int ACTION_GET_BG_IMG = 12;
    public static final int ACTION_ONCHANGE = 13;
    public static final int ACTION_ONCLICK = 14;
    public static final int ACTION_ARRAY_REMOVE_ROW = 15;
    public static final int ACTION_ARRAY_INSERT_UP_ROW = 16;
    public static final int ACTION_ARRAY_INSERT_DOWN_ROW = 17;
    public static final int ACTION_ARRAY_NEXT_PAGE = 18;
    public static final int ACTION_ARRAY_PREV_PAGE = 19;
    public static final int ACTION_SAVE = 20;
    public static final int ACTION_PRINT = 21;
    public static final int ACTION_GET_GRAPHIC_IMG = 22;
    public static final int ACTION_REFRESH_GRAPHIC_IMG = 23;
    public static final int ACTION_CHANGE_TYPE_GRAPHIC_IMG = 24;
    public static final int ACTION_ON_CTRL_CLICK = 25;
    public static final int ACTION_ON_GRAPHIC_CTRL_CLICK = 26;
    public static final int ACTION_ON_GRAPHIC_CLICK = 27;
    public static final int ACTION_REPAINT = 28;
    public static final int ACTION_START_CHILD = 29;
    public static final int ACTION_CLOSE_CHILD = 30;
    public static final int ACTION_ARRAY_SORT = 31;
    public static final int ACTION_FINISH_EXECUTION = 32;
    public static final int ACTION_GET_GRAPHIC_DATA = 33;
    public static final int FILE_CHOOSER_ACTION_APPLY = 0;
    public static final int FILE_CHOOSER_RESULT_OK = 0;
    public static final int FILE_CHOOSER_RESULT_ERROR = 1;
    public static final String CONST_SEPARATOR = "$";
    public static final String CONST_GRP_PREFIX = "grp";
    public static final String CONST_ATT_PREFIX = "att";
    public static final String CONST_ATT = "att$";
    public static final String CONST_GRP = "grp$";
    public static final String GRAPHIC_TYPE_ATT = "graphicType$";
    public static final int REQUETER_EXEC_TYPE = 0;
    public static final int REMOTE_SCRIPT_EXEC_TYPE = 1;

    public static String getAttId(String str) {
        if (!str.startsWith(CONST_ATT) && !str.startsWith(CONST_GRP)) {
            throw new IllegalArgumentException("Illegal argument '" + str + "', name should start with 'att$' or 'grp$'.");
        }
        String attId = null;
        if (str.startsWith(CONST_ATT)) {
            int begin = CONST_ATT.length();
            int end = str.length();
            attId = str.substring(begin, end);
        } else if (str.startsWith(CONST_GRP)) {
            int begin = str.indexOf(CONST_SEPARATOR, CONST_ATT.length()) + 1;
            int end = str.indexOf(CONST_SEPARATOR, begin);
            attId = str.substring(begin, end);
        }
        return attId;
    }

    public static String getGrpId(String str) {
        if (!str.startsWith(CONST_GRP)) {
            throw new IllegalArgumentException();
        }
        int begin = CONST_GRP.length();
        int end = str.indexOf(CONST_SEPARATOR, begin);
        return str.substring(begin, end);
    }

    public static int getGrpIndex(String str) throws NumberFormatException {
        int index = -1;
        if (!str.startsWith(CONST_GRP)) {
            return index;
        }
        int begin = str.indexOf(CONST_SEPARATOR, CONST_GRP.length());
        int end = str.indexOf(CONST_SEPARATOR, begin);
        begin = str.indexOf(CONST_SEPARATOR, end + 1) + 1;
        end = str.length();
        String grpIndex = str.substring(begin, end);
        end = grpIndex.length();
        grpIndex = grpIndex.substring(0, end);
        index = Integer.parseInt(grpIndex);
        return index;
    }

    public static String createAttGraphicChangeStr(String id) {
        StringBuffer str = new StringBuffer();
        str.append(GRAPHIC_TYPE_ATT);
        str.append(CONST_ATT);
        str.append(id);
        return str.toString();
    }

    public static String createAttStr(String id) {
        StringBuffer str = new StringBuffer();
        str.append(CONST_ATT);
        str.append(id);
        return str.toString();
    }

    public static String createGrpStr(String groupId, String attId, int index) {
        StringBuffer str = new StringBuffer();
        str.append(CONST_GRP);
        str.append(groupId);
        str.append(CONST_SEPARATOR);
        str.append(attId);
        str.append(CONST_SEPARATOR);
        str.append(index);
        return str.toString();
    }

    public static String createGrpRegExp() {
        StringBuffer str = new StringBuffer();
        str.append(CONST_GRP_PREFIX);
        str.append("\\");
        str.append(CONST_SEPARATOR);
        str.append("\\.+\\");
        str.append(CONST_SEPARATOR);
        str.append("\\d+");
        return str.toString();
    }

    public static String createGrpIndexRegExp() {
        StringBuffer str = new StringBuffer();
        str.append("\\");
        str.append(CONST_SEPARATOR);
        str.append("\\d+");
        return str.toString();
    }

    public static void main(String[] args) {
        String fn = XOConstants.createAttStr("FechaNacimiento");
        String edad = XOConstants.createAttStr("edad");
        String gQty = XOConstants.createGrpStr("factura", "qty", 3);
        String gTms = XOConstants.createGrpStr("factura", "fecha", 2);
        System.out.println("fn = " + fn);
        System.out.println("\tattId = " + XOConstants.getAttId(fn));
        System.out.println();
        System.out.println("edad = " + edad);
        System.out.println("\tattId = " + XOConstants.getAttId(edad));
        System.out.println();
        System.out.println("gQty = " + gQty);
        System.out.println("\tgrpId = " + XOConstants.getGrpId(gQty));
        System.out.println("\tattId = " + XOConstants.getAttId(gQty));
        System.out.println("\tindex = " + XOConstants.getGrpIndex(gQty));
        System.out.println();
        System.out.println("gTms = " + gTms);
        System.out.println("\tgrpId = " + XOConstants.getGrpId(gTms));
        System.out.println("\tattId = " + XOConstants.getAttId(gTms));
        System.out.println("\tindex = " + XOConstants.getGrpIndex(gTms));
        System.out.println();
    }
}

