/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

import java.util.Locale;
import oracle.bpm.util.Base64;
import oracle.bpm.util.Conversion;

public class ConversionUtilities {
    public static String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        return Conversion.tojava_lang_String(value);
    }

    public static String[] convertToString(Object[] values) {
        assert (values != null);
        String[] strArray = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            strArray[i] = ConversionUtilities.convertToString(value);
        }
        return strArray;
    }

    public static Object fromString(String value, int kind) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        switch (kind) {
            case 1: {
                return Conversion.tojava_lang_Boolean(value);
            }
            case 2: {
                return Conversion.tojava_lang_Integer(value);
            }
            case 3: {
                return Conversion.tojava_math_BigDecimal(value);
            }
            case 4: {
                return Conversion.tojava_lang_Double(value);
            }
            case 5: {
                return value;
            }
            case 6: {
                return Conversion.tooracle_bpm_lang_Time(value);
            }
            case 7: {
                return Conversion.tooracle_bpm_lang_Interval(value);
            }
            case 8: {
                return Base64.decode(value);
            }
        }
        return null;
    }

    public static Object fromString(String value, int kind, Locale locale) {
        switch (kind) {
            case 3: {
                return Conversion.tojava_math_BigDecimal(value, locale);
            }
            case 4: {
                return Conversion.tojava_lang_Double(value, locale);
            }
        }
        return ConversionUtilities.fromString(value, kind);
    }
}

