/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib.chart;

import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.runtime.html.HTMLGauge;
import oracle.bpm.xobject.runtime.html.HTMLXY;
import oracle.bpm.xobject.runtime.html.HTMLXYZ;

public class SwfFactory {
    private String relativePath;

    public SwfFactory(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getSwf(HTMLGauge gauge) {
        return this.getSwf((XFormGauge)gauge.getPresentationXMLObject(), gauge.getGraphicType());
    }

    public String getSwf(XFormGauge gauge) {
        return this.getSwf(gauge, GraphicType.valueOf(gauge.getEnumType()));
    }

    public String getSwf(XFormGauge gauge, GraphicType type) {
        String widget = type == GraphicType.GAUGE_SPEEDOMETER ? "AngularGauge.swf" : "Thermometer.swf";
        return new StringBuffer(this.relativePath).append("charts/").append(widget).toString();
    }

    public String getSwf(HTMLXY pie) {
        return this.getSwf((XFormPie)pie.getPresentationXMLObject(), pie.getGraphicType());
    }

    public String getSwf(XFormPie pie) {
        return this.getSwf(pie, GraphicType.valueOf(pie.getEnumType()));
    }

    public String getSwf(XFormPie pie, GraphicType type) {
        StringBuffer swfString = new StringBuffer(this.relativePath).append("charts/");
        switch (type) {
            case PIE: {
                swfString.append("Pie2D.swf");
                break;
            }
            case PIE3D: {
                swfString.append("Pie3D.swf");
                break;
            }
            case BAR_CHART: {
                if (pie.getOrder() == 1) {
                    swfString.append("Column2D.swf");
                    break;
                }
                swfString.append("Bar2D.swf");
                break;
            }
            case BAR_CHART_3D: {
                if (pie.getOrder() == 1) {
                    swfString.append("Column3D.swf");
                    break;
                }
                swfString.append("Bar2D.swf");
                break;
            }
            case STACKED_BAR_CHART: {
                if (pie.getOrder() == 1) {
                    swfString.append("StackedColumn2D.swf");
                    break;
                }
                swfString.append("StackedBar2D.swf");
                break;
            }
            case STACKED_BAR_CHART_3D: {
                if (pie.getOrder() == 1) {
                    swfString.append("StackedColumn3D.swf");
                    break;
                }
                swfString.append("StackedBar3D.swf");
                break;
            }
            case AREA_CHART: {
                swfString.append("Area2D.swf");
                break;
            }
            case STACKED_AREA_CHART: {
                swfString.append("StackedArea2D.swf");
                break;
            }
            case LINE_CHART: {
                swfString.append("Line.swf");
                break;
            }
            default: {
                swfString.append("Pie2D.swf");
            }
        }
        return swfString.toString();
    }

    public String getSwf(HTMLXYZ chart) {
        return this.getSwf((XFormChart)chart.getPresentationXMLObject(), chart.getGraphicType());
    }

    public String getSwf(XFormChart chart) {
        return this.getSwf(chart, GraphicType.valueOf(chart.getEnumType()));
    }

    public String getSwf(XFormChart chart, GraphicType type) {
        StringBuffer swfString = new StringBuffer(this.relativePath).append("charts/");
        switch (type) {
            case BAR_CHART: {
                if (chart.getOrder() == 1) {
                    swfString.append("MSColumn2D.swf");
                    break;
                }
                swfString.append("MSBar2D.swf");
                break;
            }
            case BAR_CHART_3D: {
                if (chart.getOrder() == 1) {
                    swfString.append("MSColumn3D.swf");
                    break;
                }
                swfString.append("MSBar3D.swf");
                break;
            }
            case STACKED_BAR_CHART: {
                if (chart.getOrder() == 1) {
                    swfString.append("StackedColumn2D.swf");
                    break;
                }
                swfString.append("StackedBar2D.swf");
                break;
            }
            case STACKED_BAR_CHART_3D: {
                if (chart.getOrder() == 1) {
                    swfString.append("StackedColumn3D.swf");
                    break;
                }
                swfString.append("StackedBar3D.swf");
                break;
            }
            case AREA_CHART: {
                swfString.append("MSArea.swf");
                break;
            }
            case STACKED_AREA_CHART: {
                swfString.append("StackedArea2D.swf");
                break;
            }
            case LINE_CHART: {
                swfString.append("MSLine.swf");
                break;
            }
            default: {
                swfString.append("MSColumn2D.swf");
            }
        }
        return swfString.toString();
    }
}

