/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib.chart;

import java.io.IOException;
import java.math.BigDecimal;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.xml.XmlWriter;

@Component(module="Fuego.Chart")
public class Range {
    private double max;
    private double min;

    public Range(double min, double max) {
        this.setMin(min);
        this.setMax(max);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    @Exclude
    public BusinessVariableData.Range createBVDRange() {
        BigDecimal start = new BigDecimal(this.getMin());
        BigDecimal finish = new BigDecimal(this.getMax());
        return BusinessVariableData.Range.create(null, start, finish);
    }

    @Exclude
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range r = (Range)o;
        return this.min == r.min && this.max == r.max;
    }

    @Exclude
    public int hashCode() {
        int result = 17;
        long f = this.max != 0.0 ? Double.doubleToLongBits(this.max) : 0L;
        result = 37 * result + (int)(f ^ f >>> 32);
        f = this.min != 0.0 ? Double.doubleToLongBits(this.min) : 0L;
        result = 37 * result + (int)(f ^ f >>> 32);
        return result;
    }

    @Exclude
    public void serializeToXml(XmlWriter writer, String id) throws IOException {
        writer.startElement("Range");
        writer.printAttribute("id", id);
        writer.printAttribute("max", this.max);
        writer.printAttribute("min", this.min);
        writer.endElement();
    }

    private void setMax(double max) {
        this.max = max;
    }

    private void setMin(double min) {
        this.min = min;
    }
}

