/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib.chart;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

@Component(module="Fuego.Chart")
public enum GraphicType implements I18nProvider
{
    GAUGE_SPEEDOMETER(oracle.bpm.xobject.GraphicType.GAUGE_SPEEDOMETER),
    GAUGE_THERMOMETER(oracle.bpm.xobject.GraphicType.GAUGE_THERMOMETER),
    PIE(oracle.bpm.xobject.GraphicType.PIE),
    PIE3D(oracle.bpm.xobject.GraphicType.PIE3D),
    MULTIPLE_PIE(oracle.bpm.xobject.GraphicType.MULTIPLE_PIE),
    MULTIPLE_PIE3D(oracle.bpm.xobject.GraphicType.MULTIPLE_PIE3D),
    BAR_CHART(oracle.bpm.xobject.GraphicType.BAR_CHART),
    BAR_CHART_3D(oracle.bpm.xobject.GraphicType.BAR_CHART_3D),
    STACKED_BAR_CHART(oracle.bpm.xobject.GraphicType.STACKED_BAR_CHART),
    STACKED_BAR_CHART_3D(oracle.bpm.xobject.GraphicType.STACKED_BAR_CHART_3D),
    AREA_CHART(oracle.bpm.xobject.GraphicType.AREA_CHART),
    STACKED_AREA_CHART(oracle.bpm.xobject.GraphicType.STACKED_AREA_CHART),
    LINE_CHART(oracle.bpm.xobject.GraphicType.LINE_CHART),
    WATERFALL_CHART(oracle.bpm.xobject.GraphicType.WATERFALL_CHART);

    private static final int GAUGE_TYPE_QTY = 2;
    private static final int XY_TYPE_QTY = 2;
    private transient oracle.bpm.xobject.GraphicType type;
    public static final String GAUGE_TYPE = "GAUGE";
    public static final String XY_TYPE = "XY";
    public static final String XYZ_TYPE = "XYZ";

    private GraphicType(oracle.bpm.xobject.GraphicType type) {
        this.type = type;
    }

    public static GraphicType valueOf(int ordinal) {
        GraphicType[] types = GraphicType.values();
        return ordinal < 0 || ordinal >= types.length ? null : types[ordinal];
    }

    public static GraphicType valueOf(String graphicType, int typeCode) {
        Object result = null;
        if (graphicType.toUpperCase().indexOf(XYZ_TYPE) != -1) {
            typeCode = typeCode + 2 + 2;
        } else if (graphicType.toUpperCase().indexOf(XY_TYPE) != -1) {
            typeCode += 2;
        }
        return GraphicType.valueOf(typeCode);
    }

    public static GraphicType valueOf(oracle.bpm.xobject.GraphicType type) {
        for (GraphicType gType : GraphicType.values()) {
            if (gType.type != type) continue;
            return gType;
        }
        return null;
    }

    public int getGraphicCode() {
        return this.type.getGraphicCode();
    }

    public String getGraphicType() {
        return this.type.getGraphicType();
    }

    @Exclude
    public static List<GraphicType> getSubtypes(String type) {
        ArrayList<GraphicType> list = new ArrayList<GraphicType>();
        GraphicType[] types = GraphicType.values();
        for (int i = 0; i < types.length; ++i) {
            GraphicType subtype = types[i];
            if (!subtype.getGraphicType().equals(type)) continue;
            list.add(subtype);
        }
        list.remove(MULTIPLE_PIE);
        list.remove(MULTIPLE_PIE3D);
        return list;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    @Exclude
    public Msg getMsg() {
        return this.type.getMsg();
    }
}

