/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib.chart;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.SystemInfo;
import oracle.bpm.xobject.lib.XYDataSource;
import oracle.bpm.xobject.lib.XYZDataSource;
import oracle.bpm.xobject.lib.chart.FusionChartXmlFactory;
import oracle.bpm.xobject.lib.chart.SwfFactory;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.html.HTMLGauge;
import oracle.bpm.xobject.runtime.html.HTMLGraphic;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class FusionChartsCreator {
    private static SwfFactory EDITOR_SWF_FACTORY;
    private static final SwfFactory PREVIEW_SWF_FACTORY;
    private static final SwfFactory swfFactory;

    public static String addCacheToDataURL(String strDataURL) {
        String cachedURL = strDataURL;
        Calendar nowCal = Calendar.getInstance();
        Date now = nowCal.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH_mm_ss a");
        String strNow = sdf.format(now);
        try {
            cachedURL = strDataURL.indexOf("?") > 0 ? strDataURL + "&FCCurrTime=" + URLEncoder.encode(strNow, "UTF-8") : strDataURL + "?FCCurrTime=" + URLEncoder.encode(strNow, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            cachedURL = strDataURL + "?FCCurrTime=" + strNow;
        }
        return cachedURL;
    }

    public static String createChart(HTMLGraphic htmlGraphic, String url) {
        StringBuffer result = new StringBuffer();
        String xml = htmlGraphic.isPreview() ? htmlGraphic.getDummyDataSourceXml() : "";
        String swfUrl = FusionChartsCreator.getSWFUrl(htmlGraphic);
        if (!htmlGraphic.isEditor()) {
            boolean debugMode = false;
            boolean resgisterWithJS = true;
            result.append(FusionChartsCreator.createChart(swfUrl, url, xml, htmlGraphic, debugMode, resgisterWithJS));
        } else {
            XFormGraphic xChart = (XFormGraphic)htmlGraphic.getPresentationXMLObject();
            String widgetHtml = null;
            if (FusionChartsCreator.showSwf()) {
                widgetHtml = FusionChartsCreator.createChartHTML(swfUrl, url, xml, xChart.getId(), xChart.getWidth(), xChart.getHeight(), false, null);
            } else {
                Msg msg = null;
                if (xChart instanceof XFormPie) {
                    msg = XObjectRuntimeMsg.PIE;
                } else if (xChart instanceof XFormChart) {
                    msg = XObjectRuntimeMsg.BAR_CHART;
                } else if (xChart instanceof XFormGauge) {
                    msg = XObjectRuntimeMsg.SPEEDOMETER;
                }
                if (msg != null) {
                    String svg = HTMLElement.getPreviewImage(msg);
                    widgetHtml = "<embed src=\"" + svg + "\" width=\"" + xChart.getWidth() + "\" height=\"" + xChart.getHeight() + "\" pluginspage=\"http://www.adobe.com/svg/viewer/install/\" />";
                }
            }
            result.append(widgetHtml);
        }
        return result.toString();
    }

    public static String createChart(XYZDataSource data, XFormChart chart, String relativePath, boolean drillDown) {
        String swfFile = new SwfFactory(relativePath).getSwf(chart);
        String widgetHtml = FusionChartsCreator.createChartHTML(swfFile, "", FusionChartXmlFactory.getFusionChartData(data, chart, null, drillDown), chart.getId(), chart.getWidth(), chart.getHeight(), false, null);
        return FusionChartsCreator.getHtmlPage(widgetHtml, relativePath);
    }

    public static String createChart(XYDataSource data, XFormPie pie, String relativePath, boolean drillDown) {
        String swfFile = new SwfFactory(relativePath).getSwf(pie);
        String widgetHtml = FusionChartsCreator.createChartHTML(swfFile, "", FusionChartXmlFactory.getFusionChartData(data, pie, null, drillDown), pie.getId(), pie.getWidth(), pie.getHeight(), false, null);
        return FusionChartsCreator.getHtmlPage(widgetHtml, relativePath);
    }

    public static String createChart(Number data, XFormGauge gauge, String relativePath, boolean drillDown) {
        String swfFile = new SwfFactory(relativePath).getSwf(gauge);
        String title = FusionChartsCreator.getTitle(gauge);
        String widgetHtml = FusionChartsCreator.createChartHTML(swfFile, "", FusionChartXmlFactory.getFusionChartData(data, gauge, gauge.getId(), drillDown), gauge.getId(), gauge.getWidth(), gauge.getHeight(), false, title);
        return FusionChartsCreator.getHtmlPage(widgetHtml, relativePath);
    }

    public static String createChartHTML(String chartSWF, String strURL, String strXML, String chartId, int chartWidth, int chartHeight, boolean debugMode, String title) {
        String strFlashVars = "";
        Boolean debugModeBool = debugMode;
        strFlashVars = strXML.equals("") ? "chartWidth=" + chartWidth + "&chartHeight=" + chartHeight + "&debugMode=" + FusionChartsCreator.boolToNum(debugModeBool) + "&dataURL=" + strURL + "" : "chartWidth=" + chartWidth + "&chartHeight=" + chartHeight + "&debugMode=" + FusionChartsCreator.boolToNum(debugModeBool) + "&dataXML=" + strXML + "";
        StringBuffer strBuf = new StringBuffer();
        if (title != null) {
            strBuf.append(title);
        }
        strBuf.append("\t\t<!--START Code Block for Chart-->\n");
        strBuf.append("\t\t<object classid='clsid:d27cdb6e-ae6d-11cf-96b8-444553540000' codebase='http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0' width='").append(chartWidth).append("' height='").append(chartHeight).append("' id='").append(chartId).append("'>\n");
        strBuf.append("\t\t\t\t<param name='allowScriptAccess' value='always' />\n");
        strBuf.append("\t\t\t\t<param name='movie' value='").append(chartSWF).append("'/>\n");
        strBuf.append("\t\t\t\t<param name='FlashVars' value=\"").append(strFlashVars).append("\" />\n");
        strBuf.append("\t\t\t\t<param name='quality' value='high' />\n");
        strBuf.append("\t\t\t\t<embed src='").append(chartSWF).append("' FlashVars=\"").append(strFlashVars).append("\" quality='high' width='").append(chartWidth).append("' height='").append(chartHeight).append("' name='").append(chartId).append("' allowScriptAccess='always' type='application/x-shockwave-flash' pluginspage='http://www.macromedia.com/go/getflashplayer' wmode='transparent'/>\n");
        strBuf.append("\t\t</object>\n");
        strBuf.append("\t\t<!--END Code Block for Chart-->\n");
        return strBuf.substring(0);
    }

    public static int boolToNum(Boolean bool) {
        int num = 0;
        if (bool.booleanValue()) {
            num = 1;
        }
        return num;
    }

    public static String updateChart(HTMLGraphic graphic) {
        StringBuffer result = new StringBuffer();
        result.append("getChartFromId('").append(FusionChartsCreator.getFusionChartObjectId(graphic)).append("').setDataURL('").append(Str.escapeForScripts(graphic.getDataURL())).append("');");
        return result.toString();
    }

    public static String updateChartType(HTMLGraphic graphic) {
        StringBuffer result = new StringBuffer();
        result.append("changeChartType_").append(graphic.getId()).append("('").append(FusionChartsCreator.getSWFUrl(graphic)).append("');");
        return result.toString();
    }

    public static void registerEditorFactory(String workspaceDir) {
        EDITOR_SWF_FACTORY = new SwfFactory(workspaceDir);
    }

    private static String getSWFUrl(HTMLGraphic htmlGraphic) {
        Locale locale = htmlGraphic.getXScreen().getLocale();
        StringBuffer swfFile = new StringBuffer(htmlGraphic.getSWF(FusionChartsCreator.getSwfFactory(htmlGraphic)).trim());
        swfFile.append("?InvalidXMLText=");
        swfFile.append(Str.encodeURL(XObjectRuntimeMsg.GRAPHIC_LOAD_ERROR.getString(locale)));
        swfFile.append("&ChartNoDataText=").append(Str.encodeURL(XObjectRuntimeMsg.NO_DATA_TO_DISPLAY.getString(locale)));
        return swfFile.toString();
    }

    private static boolean showSwf() {
        return !SystemInfo.isAnyMac();
    }

    private static SwfFactory getSwfFactory(XOGraphicComponent graphic) {
        return !graphic.isPreview() ? swfFactory : (graphic.isEditor() ? EDITOR_SWF_FACTORY : PREVIEW_SWF_FACTORY);
    }

    private static String getTitle(XFormGraphic xform) {
        return FusionChartsCreator.getTitle(xform.getTitle(), xform);
    }

    private static String getTitle(String title, XFormGraphic xform) {
        StringBuffer stringBuffer = new StringBuffer();
        if (title != null) {
            stringBuffer.append("<div style=\"height=100%; width=94%; color:").append(xform.titleforeground).append("; ");
            stringBuffer.append("font-size: ").append(xform.fontsize).append("; ");
            if (xform.getFontStyle().isItalic()) {
                stringBuffer.append("font-style:italic;");
            }
            if (xform.getFontStyle().isBold()) {
                stringBuffer.append("font-weight: bold; ");
            }
            stringBuffer.append("font-family: ").append(xform.fonttype).append("; ");
            String background = xform.titlebackground;
            if (background == null) {
                background = xform.bgcolor;
            }
            stringBuffer.append("background:").append(background).append("; ");
            stringBuffer.append("text-align:center\">");
            stringBuffer.append("</br>");
            stringBuffer.append(title);
            stringBuffer.append("</br>");
            stringBuffer.append("</div>");
        }
        return stringBuffer.toString();
    }

    private static String getHtmlPage(String widgetHtml, String relativePath) {
        StringBuffer htmlPage = new StringBuffer("<html>\n");
        if (FusionChartsCreator.showSwf()) {
            htmlPage.append("<head>\n");
            htmlPage.append("<script language=\"JavaScript\" src=\"");
            htmlPage.append(relativePath);
            htmlPage.append("js/FusionCharts.js\"></script>\n");
            htmlPage.append("    </head>\n");
        }
        htmlPage.append("<body bgcolor=\"#ffffff\">");
        htmlPage.append(widgetHtml);
        htmlPage.append("</body></html>");
        return htmlPage.toString();
    }

    private static String createChart(String chartSWF, String strURL, String strXML, HTMLGraphic graphic, boolean debugMode, boolean registerWithJS) {
        return FusionChartsCreator.createChart(chartSWF, strURL, strXML, debugMode, registerWithJS, graphic);
    }

    private static String createChart(String chartSWF, String strURL, String strXML, boolean debugMode, boolean registerWithJS, HTMLGraphic graphic) {
        String chartId = graphic.getId();
        String anchorId = chartId + "Anchor";
        String divId = chartId + "Div";
        String fusionChartId = FusionChartsCreator.getFusionChartObjectId(graphic);
        String chartVarName = "chart_" + chartId;
        int chartWidth = graphic.getSize().getWidth();
        int chartHeight = graphic.getSize().getHeight();
        boolean isGauge = graphic instanceof HTMLGauge;
        String title = isGauge ? FusionChartsCreator.getTitle(graphic.getText(), (XFormGraphic)graphic.getPresentationXMLObject()) : null;
        StringBuffer strBuf = new StringBuffer();
        if (title != null) {
            strBuf.append(title);
        }
        strBuf.append("\t\t<!-- START Script Block for Chart-->\n");
        strBuf.append("\t\t<div id='" + divId + "' align='center'>\n");
        strBuf.append("\t\t\t\tChart.\n");
        strBuf.append("\t\t</div>\n");
        strBuf.append("\t\t<a name=\"").append(anchorId).append("\" id=\"").append(anchorId).append("\" href=\"").append(strURL).append("\" style=\"display: none;\">\n");
        if (isGauge) {
            String drillDownJS = "drillDown_" + chartId + "()";
            String clickeableScript = HTMLGraphic.getClickeableScript(null, null, graphic.getId());
            strBuf.append("\t\t<script type='text/javascript'>\n");
            strBuf.append("\t\t\tfunction " + drillDownJS + " {");
            strBuf.append("\t\t\t\t" + clickeableScript + "\n");
            strBuf.append("\t\t\t}");
            strBuf.append("\t\t</script>\n");
        }
        strBuf.append("\t\t<script type='text/javascript'>\n");
        Boolean registerWithJSBool = registerWithJS;
        Boolean debugModeBool = debugMode;
        int regWithJSInt = FusionChartsCreator.boolToNum(registerWithJSBool);
        int debugModeInt = FusionChartsCreator.boolToNum(debugModeBool);
        String refreshJS = "showChart_" + chartId + "()";
        strBuf.append("\t\t\tvar ").append(chartVarName).append(";\n");
        strBuf.append("\t\t\tfunction changeChartType_").append(chartId).append("(swf){");
        strBuf.append("\t\t\t\t").append(chartVarName).append(".setAttribute('swf', swf);");
        strBuf.append("\t\t\t\t").append(chartVarName).append(".render(\"").append(divId).append("\");\n");
        strBuf.append("\t\t\twindow.").append(fusionChartId).append("= document.forms[0].").append(fusionChartId).append(";");
        strBuf.append("\t\t\t}\n");
        strBuf.append("\t\t\tfunction ").append(refreshJS).append(" {");
        strBuf.append("\t\t\t\t").append(chartVarName).append(" = new FusionCharts('").append(chartSWF).append("', '").append(fusionChartId).append("', '").append(chartWidth).append("', '").append(chartHeight).append("', '").append(debugModeInt).append("', '").append(regWithJSInt).append("');\n");
        if (strXML.equals("")) {
            strBuf.append("\t\t\t\t// Set the dataURL of the chart\n");
            strBuf.append("\t\t\t\tvar chartDataUrl = document.getElementById('").append(anchorId).append("').href;\n");
            strBuf.append("\t\t\t\tvar chartDataUrlEncoded = encodeURIComponent(chartDataUrl);\n");
            strBuf.append("\t\t\t\t").append(chartVarName).append(".setDataURL(chartDataUrlEncoded);\n");
        } else {
            strBuf.append("\t\t\t\t// Provide entire XML data using dataXML method\n");
            strBuf.append("\t\t\t\t").append(chartVarName).append(".setDataXML(\"").append(strXML).append("\");\n");
        }
        strBuf.append("\t\t\t\t// Finally, render the chart.\n");
        strBuf.append("\t\t\t\t").append(chartVarName).append(".render(\"").append(divId).append("\");\n");
        strBuf.append("\t\t\twindow.").append(fusionChartId).append("= document.forms[0].").append(fusionChartId).append(";");
        strBuf.append("\t\t\t}\n");
        strBuf.append("\t\t\t").append(refreshJS).append(";");
        graphic.addScriptToPerform(refreshJS + ";");
        strBuf.append("\t\t</script>\n");
        strBuf.append("\t\t<!--END Script Block for Chart-->\n");
        return strBuf.substring(0);
    }

    private static String getFusionChartObjectId(HTMLGraphic graphic) {
        return graphic.getId().concat("FSChart");
    }

    static {
        PREVIEW_SWF_FACTORY = new SwfFactory("./");
        swfFactory = new SwfFactory("../");
    }
}

