/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib;

import java.util.Vector;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XObjectCheckerMessage {
    Vector<Object[]> cilErrors;
    Vector<Object[]> cilWarnings;
    StringBuffer message = null;
    XObjectTypeDescription otd;
    Vector<Object[]> presentationErrors;
    Vector<Object[]> presentationWarnings;

    public XObjectCheckerMessage(XObjectTypeDescription otd, Vector<Object[]> presentationErrors, Vector<Object[]> presentationWarnings) {
        this(otd, null, null, presentationErrors, presentationWarnings);
    }

    public XObjectCheckerMessage(XObjectTypeDescription otd, Vector<Object[]> cilErrors, Vector<Object[]> cilWarnings, Vector<Object[]> presentationErrors, Vector<Object[]> presentationWarnings) {
        this.otd = otd;
        this.cilErrors = cilErrors != null ? cilErrors : new Vector(0);
        this.cilWarnings = cilWarnings != null ? cilWarnings : new Vector(0);
        this.presentationErrors = presentationErrors != null ? presentationErrors : new Vector(0);
        this.presentationWarnings = presentationWarnings != null ? presentationWarnings : new Vector(0);
    }

    public String getErrorAndWarningMessages() {
        return this.getMessages(true, true);
    }

    public String getOnlyErrorMessages() {
        return this.getMessages(true, false);
    }

    public String getOnlyWarningMessages() {
        return this.getMessages(false, true);
    }

    private String getMessages(boolean withErrors, boolean withWarnings) {
        this.buildMessage(withErrors, withWarnings);
        return this.message.toString();
    }

    private void addCilMessages(String msgHeader, Vector<Object[]> cilMsgs, Vector<String> methodContainer, StringBuffer attributeBuffer, StringBuffer methodBuffer) {
        for (Object[] next : cilMsgs) {
            assert (next.length == 5);
            String methodName = (String)next[0];
            String line = next[1].toString();
            String col = next[2].toString();
            String msg = next[3].toString();
            String xoName = next[4].toString();
            if (xoName.trim().length() > 0) {
                xoName = " (" + xoName + ")";
            }
            if (methodContainer.contains(methodName)) continue;
            String strLineColumn = line.equals("0") ? " : " : "[" + line + ":" + col + "] : ";
            int index = methodName.indexOf("validate$");
            if (index >= 0) {
                attributeBuffer.append("\n\t- ");
                attributeBuffer.append(msgHeader);
                attributeBuffer.append(xoName);
                attributeBuffer.append(" ");
                attributeBuffer.append(methodName.substring(index + "validate$".length()));
                attributeBuffer.append("(");
                attributeBuffer.append(XObjectRuntimeMsg.VALIDATION_EXPRESSION.getString());
                attributeBuffer.append(") ");
                attributeBuffer.append(strLineColumn);
                attributeBuffer.append(msg);
            } else {
                index = methodName.indexOf("calculate$");
                if (index >= 0) {
                    attributeBuffer.append("\n\t- ");
                    attributeBuffer.append(msgHeader.length());
                    attributeBuffer.append(xoName);
                    attributeBuffer.append(" ");
                    attributeBuffer.append(methodName.substring(index + "calculate$".length()));
                    attributeBuffer.append("(");
                    attributeBuffer.append(XObjectRuntimeMsg.CALCULATION_EXPRESSION.getString());
                    attributeBuffer.append(") ");
                    attributeBuffer.append(strLineColumn);
                    attributeBuffer.append(msg);
                } else {
                    methodBuffer.append("\n\t- ");
                    methodBuffer.append(msgHeader);
                    methodBuffer.append(xoName);
                    methodBuffer.append(" ");
                    methodBuffer.append(methodName);
                    methodBuffer.append(strLineColumn);
                    methodBuffer.append(msg);
                }
            }
            methodContainer.add(methodName);
        }
    }

    private void addPresentationMessages(String msgHeader, Vector<Object[]> presentationMsgs, Vector<String> presContainer, StringBuffer attributeBuffer, StringBuffer methodBuffer, StringBuffer presentationBuffer) {
        for (Object[] next : presentationMsgs) {
            assert (next.length == 4);
            String xoName = next[3].toString();
            if (next[2] instanceof String) {
                if (((String)next[2]).indexOf("%attr%") == 0) {
                    attributeBuffer.append("\n\t- ");
                    attributeBuffer.append(msgHeader);
                    attributeBuffer.append(" (").append(xoName).append(") ");
                    attributeBuffer.append(((String)next[2]).substring("%attr%".length()));
                    if (next[1] == null) continue;
                    attributeBuffer.append(":").append((String)next[1]);
                    continue;
                }
                methodBuffer.append("\n\t- ");
                methodBuffer.append(msgHeader);
                methodBuffer.append(" (").append(xoName).append(") ");
                methodBuffer.append(next[2]);
                if (next[1] == null) continue;
                methodBuffer.append(":").append((String)next[1]);
                continue;
            }
            if (presContainer.contains(next[0])) continue;
            String presentationName = (String)next[0];
            String errorMsg = (String)next[1];
            XFormPresentationXMLObject xFormObj = (XFormPresentationXMLObject)next[2];
            presentationBuffer.append("\n\t- ");
            presentationBuffer.append(msgHeader);
            presentationBuffer.append(" (").append(xoName).append(") ");
            presentationBuffer.append(presentationName);
            presentationBuffer.append(": ");
            presentationBuffer.append(errorMsg);
            presentationBuffer.append(" ");
            presentationBuffer.append(xFormObj instanceof XFormPresentation ? "" : xFormObj.getId());
            presContainer.add(presentationName);
        }
    }

    private void buildMessage(boolean withErrors, boolean withWarnings) {
        boolean hasPresentationMsgs;
        boolean hasCilWarnings;
        this.message = new StringBuffer();
        StringBuffer presentationString = new StringBuffer();
        StringBuffer methodString = new StringBuffer();
        StringBuffer attributeString = new StringBuffer();
        Vector<String> addedPresentations = new Vector<String>();
        Vector<String> addedMethods = new Vector<String>();
        boolean hasPresentationErrors = this.presentationErrors.size() > 0;
        boolean hasPresentationWarnings = this.presentationWarnings.size() > 0;
        boolean hasCilErrors = this.cilErrors.size() > 0;
        boolean bl = hasCilWarnings = this.cilWarnings.size() > 0;
        if (withErrors) {
            if (hasPresentationErrors) {
                this.addPresentationMessages("[" + CoreMsg.ERROR + "]", this.presentationErrors, addedPresentations, attributeString, methodString, presentationString);
            }
            if (hasCilErrors) {
                this.addCilMessages("[" + CoreMsg.ERROR + "]", this.cilErrors, addedMethods, attributeString, methodString);
            }
        }
        if (withWarnings) {
            if (hasPresentationWarnings) {
                this.addPresentationMessages("[" + CoreMsg.WARNING + "]", this.presentationWarnings, addedPresentations, attributeString, methodString, presentationString);
            }
            if (hasCilWarnings) {
                this.addCilMessages("[" + CoreMsg.WARNING + "]", this.cilWarnings, addedMethods, attributeString, methodString);
            }
        }
        boolean hasAttrMsgs = attributeString.length() > 0;
        boolean hasMethodMsgs = methodString.length() > 0;
        boolean bl2 = hasPresentationMsgs = presentationString.length() > 0;
        if (hasPresentationMsgs || hasAttrMsgs || hasMethodMsgs) {
            if (this.otd != null) {
                this.message.append("FuegoObject ");
                if (this.otd.getModule() != null) {
                    this.message.append(this.otd.getModule().getName());
                    this.message.append(".");
                }
                this.message.append(this.otd.getName());
                this.message.append(" ");
                if (hasCilErrors || hasPresentationErrors) {
                    this.message.append(XObjectRuntimeMsg.IS_NOT_VALID.getString());
                } else {
                    this.message.append(XObjectRuntimeMsg.HAS_WARNINGS.getString());
                }
                this.message.append("\n");
            }
            if (hasMethodMsgs) {
                this.message.append(XObjectRuntimeMsg.PLEASE_CHECK_THE_FOLLOWING_METHODS.getString());
                this.message.append(methodString);
                this.message.append("\n");
            }
            if (hasAttrMsgs) {
                this.message.append(XObjectRuntimeMsg.PLEASE_CHECK_THE_FOLLOWING_ATTRIBUTES.getString());
                this.message.append(attributeString);
                this.message.append("\n");
            }
            if (hasPresentationMsgs) {
                this.message.append(XObjectRuntimeMsg.PLEASE_CHECK_THE_FOLLOWING_PRESENTATIONS.getString());
                this.message.append(presentationString);
                this.message.append("\n");
            }
        }
    }
}

