/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.data.html.LinkType;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xobject.lib.CheckerListener;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.lib.XYDataSource;
import oracle.bpm.xobject.lib.XYZDataSource;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormArrayComponent;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModelHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.util.XObjectValueResolver;
import oracle.bpm.xobject.xml.XFormXMLObject;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Checker {
    private XFormPresentationXMLObject currentPresentation = null;
    private boolean hasCancel_d;
    private boolean hasSubmit_d;
    private boolean hasUxoConstraints;
    private Set<String> innerXO;
    private List<CheckerListener> listenerList;
    private Locale locale;
    private ObjectTypeDescription model = null;
    private Map<String, XFormPresentationXMLObject> presentationmodelTable_d;
    private StringList presentations_d;
    private Map<String, XFormPresentationXMLObject> referenceTable_d;
    private boolean withError = false;
    private ObjectTypeDescription xotd;
    @NonNls
    public static final String ATTR = "%attr%";

    public Checker(ObjectTypeDescription xotd) {
        this.xotd = xotd;
        this.locale = Locale.getDefault();
        this.clear();
    }

    private Checker(ObjectTypeDescription xotd, CheckerListener checkerListener) {
        this(xotd);
        this.setListener(checkerListener);
    }

    public static void check(XObjectTypeDescription xo, CheckerListener listener) {
        Checker checker = new Checker(xo, listener);
        checker.checkDataModel(xo);
        for (XFormPresentationModel pmodel : xo.getPModels()) {
            checker.checkPresentationModel(pmodel, xo);
        }
        if (!xo.isSynthesized()) {
            for (TypeRef ref : xo.getInnerTypeRefs()) {
                ObjectTypeDescription description = ref.get().asObject();
                Checker.check((XObjectTypeDescription)description, listener);
            }
        }
    }

    public void setListener(CheckerListener listener) {
        this.clearListenerList();
        this.addListener(listener);
    }

    public StringList getPresentations() {
        return this.presentations_d;
    }

    public void addListener(CheckerListener cl) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<CheckerListener>();
        }
        this.listenerList.add(cl);
    }

    public void checkDataModel(ObjectTypeDescription model) {
        this.model = model;
        if (!this.innerXO.contains(model.getText())) {
            this.innerXO.add(model.getText());
            this.checkAttributes(model);
        }
    }

    public void checkPresentationModel(XFormPresentationModel pModel, ObjectTypeDescription otd) {
        this.withError = false;
        if (this.model == null) {
            this.checkDataModel(otd);
        }
        this.hasSubmit_d = false;
        this.hasCancel_d = false;
        this.hasUxoConstraints = false;
        this.presentations_d.add(pModel.getModelName());
        this.referenceTable_d = new HashMap<String, XFormPresentationXMLObject>();
        this.presentationmodelTable_d = new HashMap<String, XFormPresentationXMLObject>();
        this.currentPresentation = pModel.getPresentation();
        this.checkComponent(this.currentPresentation, false, false, null);
        if (!this.hasSubmit_d && !this.hasCancel_d) {
            this.warning(XObjectRuntimeMsg.NO_SUBMIT, (XFormXMLObject)pModel.getPresentation());
        }
        pModel.setChecked(!this.withError);
    }

    public boolean hasUxoConstraints() {
        return this.hasUxoConstraints;
    }

    public void removeListener(CheckerListener cl) {
        if (this.listenerList != null) {
            this.listenerList.remove(cl);
        }
    }

    public void reset() {
        this.model = null;
        this.clear();
        if (this.listenerList != null) {
            for (CheckerListener listener : this.listenerList) {
                listener.resetErrAndWarn();
            }
        }
    }

    private static String getArrayId(XFormRepeatable array) {
        return array != null ? array.getId() : "";
    }

    private void checkAttributes(ObjectTypeDescription model) {
        List<MethodTypeDescription> attributes = model.getAttributes();
        if (attributes != null) {
            for (MethodTypeDescription attribute : attributes) {
                this.checkAttribute(attribute.asAttribute(), model);
            }
        }
    }

    private void checkInnerDataModel(ObjectTypeDescription innerTd) {
        String name = innerTd.getText();
        if (!this.innerXO.contains(name)) {
            this.innerXO.add(name);
            this.checkAttributes(innerTd);
        }
    }

    private void checkAttribute(AttributeTypeDescription att, ObjectTypeDescription model) {
        block10: {
            String defaultValue;
            String attributeName;
            TypeDescription attributeType;
            block12: {
                MethodTypeDescription member;
                String validValuesMethod;
                block13: {
                    block11: {
                        block9: {
                            if (att.isSynthesized()) {
                                return;
                            }
                            attributeType = att.getResultType();
                            if (!attributeType.isBpmObject()) break block9;
                            this.checkInnerDataModel(attributeType.asObject());
                            break block10;
                        }
                        if (!attributeType.isArray() || !attributeType.getElementType().isBpmObject()) break block11;
                        this.checkInnerDataModel(attributeType.getElementType().asObject());
                        break block10;
                    }
                    attributeName = att.getName();
                    defaultValue = att.getDefaultValue();
                    if (attributeType.getKind() != 5 && att.isRequired() && Str.isEmpty(defaultValue) && !att.isVirtual()) {
                        this.error(XObjectRuntimeMsg.DEFAULT_VALUE_REQUIRED(attributeName), ATTR + attributeName, model);
                    }
                    if ((validValuesMethod = att.getValidValuesMethod()) == null) break block12;
                    member = model.findMember(validValuesMethod);
                    if (member != null) break block13;
                    if ("".equals(validValuesMethod)) {
                        this.error(XObjectRuntimeMsg.METHOD_SHOULD_NOT_BE_EMPTY(attributeName), ATTR + attributeName, model);
                    } else {
                        this.error(XObjectRuntimeMsg.INVALID_ARG_TYPE, ATTR + attributeName, model);
                    }
                    break block10;
                }
                if (member.isAttribute() || model.getMember(validValuesMethod, 14) != null) break block10;
                this.error(XObjectRuntimeMsg.INVALID_ARG_TYPE, ATTR + attributeName, model);
                break block10;
            }
            StringList validValues = att.getValidValues();
            if (validValues != null) {
                XObjectValueResolver.ValueResolver valueResolver = XObjectValueResolver.getValueResolver(attributeType.getKind());
                if (validValues.isEmpty()) {
                    this.error(XObjectRuntimeMsg.VALID_VALUES_LIST_NOT_EMPTY, ATTR + attributeName, model);
                }
                if (!Str.isEmpty(defaultValue) && !this.smartValidValuesContains(valueResolver, att, defaultValue)) {
                    this.error(XObjectRuntimeMsg.DEFAULT_VALUE_ONE_VALID_VALUE, ATTR + attributeName, model);
                }
                String lastValue = null;
                for (String current : validValues.clone().sort()) {
                    if (!Str.isEmpty(lastValue) && valueResolver.typedEquals(lastValue, current)) {
                        this.error(XObjectRuntimeMsg.DUPLICATE_VALID_VALUE_AT(current, attributeName), ATTR + attributeName, model);
                    }
                    lastValue = current;
                }
            }
        }
    }

    private boolean smartValidValuesContains(XObjectValueResolver.ValueResolver<?> valueResolver, AttributeTypeDescription att, String defaultValue) {
        boolean result;
        block1: {
            String stringVV;
            StringList validValues = att.getValidValues();
            result = validValues.contains(defaultValue);
            if (result) break block1;
            Iterator i$ = validValues.iterator();
            while (i$.hasNext() && !(result = valueResolver.typedEquals(defaultValue, stringVV = (String)i$.next()))) {
            }
        }
        return result;
    }

    private boolean checkMethod(String signature, int argQtyAllowed) {
        return this.checkMethod(signature, this.model, argQtyAllowed);
    }

    private boolean checkMethod(String signature, ObjectTypeDescription model, int argQtyAllowed) {
        MethodTypeDescription mtd = XFormPresentationModelHelper.getMethod(model, signature);
        if (mtd == null) {
            return false;
        }
        int count = mtd.getArgumentCount();
        return count == argQtyAllowed;
    }

    private void clear() {
        this.presentations_d = StringList.create();
        this.innerXO = new HashSet<String>();
    }

    private void clearListenerList() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
    }

    private void error(Msg err, XFormXMLObject where) {
        this.error(err.getString(this.locale), where);
    }

    private void error(String err, XFormXMLObject where) {
        this.withError = true;
        if (this.listenerList != null) {
            for (CheckerListener listener : this.listenerList) {
                listener.error(this.xotd, err, where, this.currentPresentation);
            }
        }
    }

    private void error(Msg err, Object where, ObjectTypeDescription model) {
        this.withError = true;
        if (this.listenerList != null) {
            String whereString = where == null ? "" : where.toString();
            for (CheckerListener listener : this.listenerList) {
                listener.error(model, err.getString(this.locale), whereString);
            }
        }
    }

    private void nonFatalError(Msg err, XFormXMLObject where) {
        this.withError = true;
        if (this.listenerList != null) {
            for (CheckerListener listener : this.listenerList) {
                listener.nonFatalError(this.xotd, err.getString(this.locale), where, this.currentPresentation);
            }
        }
    }

    private void checkComponent(XFormPresentationXMLObject presentationXMLObject, boolean inGroup, boolean inRepeatableTable, XFormRepeatable parentArray) {
        this.checkComponentType(presentationXMLObject);
        XFormComponentType componentType = presentationXMLObject.getComponentType();
        if (inRepeatableTable && componentType != XFormComponentType.CELL && componentType != XFormComponentType.ROW && !(presentationXMLObject instanceof XFormArrayComponent)) {
            this.error(XObjectRuntimeMsg.INVALID_COMPO_FOR_ARRAY(presentationXMLObject.getId(), Checker.getArrayId(parentArray)), (XFormXMLObject)presentationXMLObject);
        }
        this.checkId(presentationXMLObject);
        if (presentationXMLObject.isReferenceable()) {
            this.checkReference(presentationXMLObject, inGroup, inRepeatableTable, parentArray);
        }
        boolean isArray = false;
        boolean currentIsInTable = false;
        if (presentationXMLObject instanceof XFormRepeatable) {
            isArray = true;
            parentArray = (XFormRepeatable)presentationXMLObject;
            if (presentationXMLObject instanceof XFormArray) {
                currentIsInTable = true;
            }
        }
        int childs = presentationXMLObject.getChildCount();
        for (int i = 0; i < childs; ++i) {
            XFormXMLObject eachChild = presentationXMLObject.getChildAt(i);
            if (!(eachChild instanceof XFormPresentationXMLObject)) continue;
            this.checkComponent((XFormPresentationXMLObject)eachChild, isArray || inGroup, inRepeatableTable || currentIsInTable, parentArray);
        }
        if (childs <= 0 && inRepeatableTable && presentationXMLObject instanceof XFormCell) {
            this.error(XObjectRuntimeMsg.EMPTY_EDITOR(presentationXMLObject.getId(), Checker.getArrayId(parentArray)), (XFormXMLObject)parentArray);
        }
    }

    private void checkReference(XFormPresentationXMLObject xmlObject, boolean inGroup, boolean inRepeatableTable, XFormRepeatable parentArray) {
        String reference = xmlObject.getReference();
        if (Str.isEmpty(reference)) {
            if (xmlObject instanceof XFormImage) {
                String gifencoded = ((XFormImage)xmlObject).gifencoded;
                if (Str.isEmpty(gifencoded)) {
                    this.warning(XObjectRuntimeMsg.EMPTY_REFERENCE_OR_VALUE_IMAGE(xmlObject.getId()), (XFormXMLObject)xmlObject);
                }
            } else {
                this.nonFatalError(XObjectRuntimeMsg.MISSING_REFERENCE(xmlObject.getId()), xmlObject);
            }
        } else {
            if (xmlObject instanceof XFormPresentation) {
                if (!reference.equals(this.model.getName())) {
                    this.error(XObjectRuntimeMsg.INVALID_REFERNCE(xmlObject.getId()), (XFormXMLObject)xmlObject);
                }
            } else {
                MethodTypeDescription member = XObjectTypeDescriptionHelper.getMemberFor(reference, this.model);
                if (member == null) {
                    this.error(XObjectRuntimeMsg.INVALID_REFERNCE(xmlObject.getId()), (XFormXMLObject)xmlObject);
                } else {
                    AttributeTypeDescription attribute = member.asAttribute();
                    if (!attribute.hasSetter() && xmlObject instanceof XFormUserInputPresentationXMLObject && ((XFormUserInputPresentationXMLObject)xmlObject).isEditable()) {
                        this.error(XObjectRuntimeMsg.CALC_FIELD_IS_EDITABLE(xmlObject.getId()), (XFormXMLObject)xmlObject);
                    }
                    this.checkValidValues(xmlObject, attribute);
                    TypeDescription resultType = member.getResultType();
                    this.checkUXOConstraints(inRepeatableTable, attribute, resultType);
                    this.checkReferenceType(xmlObject, resultType);
                    if (inGroup) {
                        String prefix = parentArray.getReference();
                        if (prefix != null && reference != null && !reference.startsWith(prefix)) {
                            this.error(XObjectRuntimeMsg.INVALID_REFERNCE_TYPE(xmlObject.getId()), (XFormXMLObject)xmlObject);
                        }
                    } else if (reference.indexOf("[].") >= 0) {
                        this.error(XObjectRuntimeMsg.INVALID_REFERNCE_TYPE(xmlObject.getId()), (XFormXMLObject)xmlObject);
                    }
                }
            }
            if (!(xmlObject instanceof XFormRepeatable)) {
                if (this.referenceTable_d.get(reference) != null) {
                    this.error(XObjectRuntimeMsg.DUPLICATE_REFERENCE(reference), (XFormXMLObject)xmlObject);
                } else {
                    this.referenceTable_d.put(reference, xmlObject);
                }
            }
        }
    }

    private void checkComponentType(XFormPresentationXMLObject xmlObject) {
        XFormUserInputPresentationXMLObject inputPresentationObject;
        String methodSignatureString;
        XFormComponentType componentType = xmlObject.getComponentType();
        switch (componentType) {
            case PIE: 
            case GAUGE: 
            case CHART: {
                this.checkGraphic((XFormGraphic)xmlObject);
                break;
            }
            case PRESENTATION: {
                String methodSignatureString2 = ((XFormPresentation)xmlObject).getInitializationMethod();
                if (methodSignatureString2 == null) break;
                this.verifyMethod(methodSignatureString2, xmlObject);
                break;
            }
            case LABEL: {
                this.checkLabel((XFormLabel)xmlObject);
                break;
            }
            case LINK: {
                this.checkLabel((XFormLabel)xmlObject);
                this.checkLink((XFormLink)xmlObject);
                break;
            }
            case IMAGE: {
                this.checkImage((XFormImage)xmlObject);
                break;
            }
            case ACTION_BUTTON: 
            case CANCEL_BUTTON: 
            case PRINT_BUTTON: 
            case REFRESH_BUTTON: 
            case RESET_BUTTON: 
            case SAVE_BUTTON: 
            case SUBMIT_BUTTON: {
                this.checkButton((XFormButton)xmlObject);
                break;
            }
            case PASSWORD: 
            case TEXT: {
                this.checkPassword((XFormText)xmlObject);
                break;
            }
            case TABLE: {
                this.checkTable((XFormTable)xmlObject);
            }
        }
        if (xmlObject instanceof XFormUserInputPresentationXMLObject && (methodSignatureString = (inputPresentationObject = (XFormUserInputPresentationXMLObject)xmlObject).getOnChange()) != null) {
            if (methodSignatureString.trim().equals("")) {
                inputPresentationObject.setOnChange(null);
            } else {
                this.verifyMethod(methodSignatureString, inputPresentationObject);
            }
        }
    }

    private void checkReferenceType(XFormPresentationXMLObject presentationXMLObject, TypeDescription resultType) {
        if (!ArrayUtils.contains(presentationXMLObject.getPossibleReffering(), (Object)resultType.getKind())) {
            this.error(XObjectRuntimeMsg.INVALID_REFERNCE_TYPE(presentationXMLObject.getId()), (XFormXMLObject)presentationXMLObject);
        }
    }

    private void checkUXOConstraints(boolean inRepeatableTable, AttributeTypeDescription attribute, TypeDescription resultType) {
        if (!this.hasUxoConstraints) {
            this.hasUxoConstraints = inRepeatableTable ? !resultType.isPredefined() : !resultType.isPredefined() && !resultType.isArray() && !resultType.asObject().getComponentType().equals(ComponentType.XOBJECT.getText());
            String validValuesMethod = attribute.getValidValuesMethod();
            if (validValuesMethod != null) {
                MethodTypeDescription mtd = this.model.getMember(validValuesMethod, 14);
                this.hasUxoConstraints = mtd != null && Modifier.isServer(mtd.getModifiers());
            }
        }
    }

    private void checkValidValues(XFormPresentationXMLObject xmlObject, AttributeTypeDescription attribute) {
        boolean needsValidValues;
        boolean bl = needsValidValues = xmlObject.getComponentID() == 0 || xmlObject.getComponentID() == 9;
        if (attribute.hasValidValues() || attribute.getType().isEnum()) {
            if (!needsValidValues) {
                this.warning(XObjectRuntimeMsg.REF_HAS_VALID_VALUES(xmlObject.getId()), (XFormXMLObject)xmlObject);
            }
        } else if (needsValidValues) {
            this.error(XObjectRuntimeMsg.INVALID_REF_NO_VALID_VALUES(xmlObject.getId()), (XFormXMLObject)xmlObject);
        }
    }

    private void checkId(XFormPresentationXMLObject xmlObject) {
        String val = xmlObject.getId();
        if (Str.isEmpty(val)) {
            this.error(XObjectRuntimeMsg.MISSING_ID.getString(this.locale) + "(field=" + xmlObject.getName() + ")", (XFormXMLObject)xmlObject);
        } else if (this.isNullString(val)) {
            this.error(XObjectRuntimeMsg.ID_NOT_NULL, (XFormXMLObject)xmlObject);
        } else if (this.presentationmodelTable_d.get(val) != null) {
            this.error(XObjectRuntimeMsg.DUPLICATE_ID(val), (XFormXMLObject)xmlObject);
        } else {
            this.presentationmodelTable_d.put(val, xmlObject);
        }
    }

    private void checkTable(XFormTable xFormTable) {
        try {
            this.isTableCorrect(xFormTable);
        }
        catch (ValidationException v) {
            this.warning(v.getKey(), (XFormXMLObject)xFormTable);
        }
    }

    private void isTableCorrect(XFormTable xFormTable) throws ValidationException {
        XFormRow[] rows = xFormTable.row;
        if (rows != null && rows.length > 0) {
            int columnCount = rows[0].calculateColumns();
            int[] rowSpans = new int[columnCount];
            for (XFormRow row : rows) {
                this.checkRow(xFormTable.getId(), rowSpans, row);
            }
            int lastRowSpan = rowSpans[0];
            for (int rowSpan : rowSpans) {
                if (rowSpan != lastRowSpan) {
                    throw new ValidationException(XObjectRuntimeMsg.TABLE_HAS_DIFFERENT_HEIGHTS(xFormTable.id));
                }
                lastRowSpan = rowSpan;
            }
        }
    }

    private void checkRow(String tableId, int[] rowSpans, XFormRow row) throws ValidationException {
        int currentCellIndex = 0;
        if (row.cell == null) {
            throw new ValidationException(XObjectRuntimeMsg.TABLE_HAS_DIFFERENT_WIDTHS(tableId));
        }
        for (int currentCol = 0; currentCol < rowSpans.length; ++currentCol) {
            int currentValue = rowSpans[currentCol];
            if (currentValue != 0) continue;
            if (currentCellIndex >= row.cell.length) {
                throw new ValidationException(XObjectRuntimeMsg.TABLE_HAS_DIFFERENT_WIDTHS(tableId));
            }
            XFormCell cell = row.cell[currentCellIndex];
            int cellColSpan = cell.getHexpand();
            for (int eachColumn = 0; eachColumn < cellColSpan; ++eachColumn) {
                if (eachColumn > 0) {
                    ++currentCol;
                }
                if (currentCol >= rowSpans.length) {
                    throw new ValidationException(XObjectRuntimeMsg.TABLE_HAS_DIFFERENT_WIDTHS(tableId));
                }
                if (rowSpans[currentCol] != 0) {
                    throw new ValidationException(XObjectRuntimeMsg.TABLE_HAS_CELL_SUPERPOSITION(tableId));
                }
                rowSpans[currentCol] = cell.getVexpand();
            }
            ++currentCellIndex;
        }
        if (currentCellIndex != row.cell.length) {
            throw new ValidationException(XObjectRuntimeMsg.TABLE_HAS_DIFFERENT_WIDTHS(tableId));
        }
        int column = 0;
        while (column < rowSpans.length) {
            int n = column++;
            rowSpans[n] = rowSpans[n] - 1;
        }
    }

    private void checkLink(XFormLink link) {
        String reference;
        if (link.getEnumLinkType() == LinkType.REFERENCE && (Str.isEmpty(reference = link.getLinkValue()) || this.isNullString(reference) || XObjectTypeDescriptionHelper.getMemberFor(reference, this.model) == null)) {
            this.error(XObjectRuntimeMsg.INVALID_REFERNCE(link.getId()), (XFormXMLObject)link);
        }
    }

    private void checkPassword(XFormText text) {
        if (!text.editable && text.passwordfield) {
            this.error(XObjectRuntimeMsg.CANT_BE_NO_EDIT_PASS(text.getId()), (XFormXMLObject)text);
        }
    }

    private void checkButton(XFormButton button) {
        if (button.isAction()) {
            String methodSignatureString = button.methodinvocation;
            if (!Str.isEmpty(methodSignatureString)) {
                this.verifyMethod(methodSignatureString, button);
            } else {
                this.error(XObjectRuntimeMsg.NULL_METHOD_CALL(button.getId()), (XFormXMLObject)button);
            }
        }
        if (Str.isEmpty(button.display)) {
            button.display = button.getAction();
            this.warning(XObjectRuntimeMsg.MISSING_DISPLAY_USED_ACTION(button.getId()), (XFormXMLObject)button);
        }
        if (button.getAction().equals(XFormButton.possibleAction_d[0])) {
            this.hasSubmit_d = true;
        } else if (button.getAction().equals(XFormButton.possibleAction_d[1])) {
            if (this.hasCancel_d) {
                this.error(XObjectRuntimeMsg.MORE_THAN_ONE_CANCEL, (XFormXMLObject)button);
            }
            this.hasCancel_d = true;
        }
    }

    private void checkImage(XFormImage image) {
        String methodSignatureString = image.getOnclick();
        if (methodSignatureString != null) {
            this.verifyMethod(methodSignatureString, image);
        }
    }

    private void checkLabel(XFormLabel label) {
        if (label.value == null) {
            this.error(XObjectRuntimeMsg.MISSING_REFERENCE_OR_VALUE(label.getId()), (XFormXMLObject)label);
        } else if (Str.isEmpty(label.getText())) {
            this.warning(XObjectRuntimeMsg.EMPTY_REFERENCE_OR_VALUE(label.getId()), (XFormXMLObject)label);
        }
        String methodSignatureString = label.getOnclick();
        if (methodSignatureString != null) {
            this.verifyMethod(methodSignatureString, label);
        }
    }

    private void checkGraphic(XFormGraphic xFormGraphic) {
        String backMethod;
        String methodSignature = xFormGraphic.getMethodinvocation();
        if (Str.isEmpty(methodSignature)) {
            this.error(XObjectRuntimeMsg.GRAPHIC_MISSING_METHOD(xFormGraphic.getId()), (XFormXMLObject)xFormGraphic);
        } else if (this.isNullString(methodSignature)) {
            this.error(XObjectRuntimeMsg.GRAPHIC_NULL_METHOD(xFormGraphic.getId()), (XFormXMLObject)xFormGraphic);
        } else {
            this.verifyLoadMethod(methodSignature, xFormGraphic);
        }
        String onClick = xFormGraphic.getOnclick();
        if (!Str.isEmpty(onClick)) {
            int onClickArgQtyAllowed = xFormGraphic.getOnClickArgumentQty();
            this.verifyMethod(onClick, xFormGraphic, onClickArgQtyAllowed);
        }
        if (!Str.isEmpty(backMethod = xFormGraphic.backmethod)) {
            int backArgQtyAllowed = xFormGraphic.getBackMethodArgumentQty();
            this.verifyMethod(backMethod, xFormGraphic, backArgQtyAllowed);
        }
    }

    private boolean isNullString(@NotNull String str) {
        return str.trim().equalsIgnoreCase("null");
    }

    private void verifyLoadMethod(String methodSignatureString, XFormGraphic graphic) {
        if (this.verifyMethod(methodSignatureString, graphic)) {
            boolean ok;
            MethodTypeDescription method = XFormPresentationModelHelper.getMethod(this.model, methodSignatureString);
            TypeDescription resultType = method.getResultType();
            XFormComponentType componentType = graphic.getComponentType();
            if (componentType == XFormComponentType.GAUGE) {
                ok = resultType.isNumber();
            } else {
                Class correctClass = componentType == XFormComponentType.PIE ? XYDataSource.class : XYZDataSource.class;
                boolean bl = ok = resultType.getJavaClass() != null && correctClass.isAssignableFrom(resultType.getJavaClass());
            }
            if (!ok) {
                this.error(XObjectRuntimeMsg.GRAPHIC_INVALID_METHOD_RETURN(graphic.getId()), (XFormXMLObject)graphic);
            }
        }
    }

    private boolean verifyMethod(String methodSignatureString, XFormPresentationXMLObject o) {
        return this.verifyMethod(methodSignatureString, o, 0);
    }

    private boolean verifyMethod(String methodSignatureString, XFormPresentationXMLObject presentationXMLObject, int argQtyAllowed) {
        boolean result = true;
        MethodTypeDescription method = XFormPresentationModelHelper.getMethod(this.model, methodSignatureString);
        if (method == null) {
            this.error(XObjectRuntimeMsg.INVALID_METHOD_CALL(presentationXMLObject.getId()), (XFormXMLObject)presentationXMLObject);
            result = false;
        } else {
            if (!this.checkMethod(methodSignatureString, argQtyAllowed)) {
                this.error(XObjectRuntimeMsg.INVALID_METHOD_CALL(presentationXMLObject.getId()), (XFormXMLObject)presentationXMLObject);
                result = false;
            }
            if (!this.hasUxoConstraints) {
                this.hasUxoConstraints = Modifier.isServer(method.getModifiers());
            }
        }
        return result;
    }

    private void warning(Msg err, XFormXMLObject where) {
        this.warning(err.getString(this.locale), where);
    }

    private void warning(String err, XFormXMLObject where) {
        if (this.listenerList != null) {
            for (CheckerListener listener : this.listenerList) {
                listener.warning(this.xotd, err, where, this.currentPresentation);
            }
        }
    }

    private class ValidationException
    extends DefaultException {
        private static final long serialVersionUID = 1593478814203465011L;

        public ValidationException(Msg msg) {
            super(msg);
        }
    }
}

