/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import oracle.bpm.component.Replaceable;
import oracle.bpm.io.ReferenceManager;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.TypeDescription;

public class FOClonner {
    public static void applyReplaceableGraph(Map<Long, Object> target, Map<Long, Object> source) {
        IdentityHashMap<Object, Object> copied = new IdentityHashMap<Object, Object>();
        for (Map.Entry<Long, Object> entry : target.entrySet()) {
            long key = entry.getKey();
            Object src = source.get(-key);
            FOClonner.shallowCopy(entry.getValue(), src, copied);
        }
        IdentitySet visited = new IdentitySet();
        FOClonner.traverseFields(copied, new MyFieldTraversalVisitor(target), visited);
    }

    public static Object clone(Object obj, Map<Long, Object> collected) {
        if (obj == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(obj);
            oos.close();
            final ClassLoader classLoader = FOClonner.getObjectClassLoader(obj);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            CollectorInputStream ois = new CollectorInputStream(in, collected){

                protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    String name = desc.getName();
                    return JavaClass.loadByJavaType(name, classLoader);
                }
            };
            obj = ois.readObject();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    public static Object overrideClone(Object obj, Map<Long, Object> collected) {
        ClassLoader classLoader = FOClonner.getObjectClassLoader(obj);
        return FOClonner.overrideClone(obj, collected, classLoader);
    }

    public static Object overrideClone(Object obj, Map<Long, Object> collected, final ClassLoader classLoader) {
        if (obj == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            CollectorOutputStream oos = new CollectorOutputStream(out, collected);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            OverrideReferenceInputStream ois = new OverrideReferenceInputStream(in){

                protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    String name = desc.getName();
                    return JavaClass.loadByJavaType(name, classLoader);
                }
            };
            obj = ois.readObject();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    public static void shallowCopy(Object target, Object src, IdentityHashMap<Object, Object> copied) {
        block5: {
            Class<?> targetClass = target.getClass();
            Class<?> srcClass = src.getClass();
            if (srcClass != targetClass) {
                throw new IllegalArgumentException("objects should be of the same class: source " + srcClass + ", target " + targetClass);
            }
            if (srcClass.isArray()) {
                throw new IllegalArgumentException("cannot copy arrays");
            }
            Field[] fields = JavaClass.getAllFields(srcClass);
            try {
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    int modifiers = field.getModifiers();
                    if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
                    field.setAccessible(true);
                    Object value = field.get(src);
                    copied.put(value, value);
                    field.set(target, value);
                }
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"unexpected exception");
            }
        }
    }

    public static void traverseFields(Object target, FieldTraversalVisitor visitor, IdentitySet visited) {
        block3: {
            Class<?> componentType;
            Class<?> klass;
            block4: {
                klass = target.getClass();
                if (FOClonner.mustStkip(target, klass)) {
                    return;
                }
                if (visited.contains(target)) break block3;
                visited.add(target);
                componentType = klass.getComponentType();
                if (klass.isArray()) break block4;
                while (klass != null) {
                    FOClonner.traverseFields(klass, target, visitor, visited);
                    klass = klass.getSuperclass();
                }
                break block3;
            }
            if (klass.getComponentType().isPrimitive()) break block3;
            int len = Array.getLength(target);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(target, i);
                visitor.visit(target, i, value);
                if (value == null || componentType.isPrimitive()) continue;
                FOClonner.traverseFields(value, visitor, visited);
            }
        }
    }

    private static ClassLoader getObjectClassLoader(Object obj) {
        return obj instanceof Invokeable ? Thread.currentThread().getContextClassLoader() : obj.getClass().getClassLoader();
    }

    private static void collect(Object obj, Map<Long, Object> collected) {
        if (obj instanceof Replaceable) {
            long refId = ReferenceManager.getReferenceId((Replaceable)obj);
            collected.put(refId, obj);
        }
    }

    private static boolean mustStkip(Object target, Class klass) {
        String name = klass.getName();
        return name.startsWith("java.lang.reflect") || name.startsWith("org.") || name.startsWith("com.") || name.startsWith("java.util.regex") || name.startsWith("oracle.bpm.io.ReferenceManager") || TypeDescription.class.isAssignableFrom(klass) || klass == String.class || target instanceof Class || target instanceof Number || target instanceof ClassLoader || target instanceof Thread || target instanceof ThreadGroup;
    }

    private static void traverseFields(Class klass, Object target, FieldTraversalVisitor visitor, IdentitySet visited) {
        block3: {
            Field[] fields = klass.getDeclaredFields();
            try {
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    int modifiers = field.getModifiers();
                    if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
                    field.setAccessible(true);
                    Object value = field.get(target);
                    visitor.visit(target, field, value);
                    if (value == null || field.getType().isPrimitive()) continue;
                    FOClonner.traverseFields(value, visitor, visited);
                }
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"unexpected exception");
            }
        }
    }

    private static class MyFieldTraversalVisitor
    implements FieldTraversalVisitor {
        private final Map<Long, Object> target;

        public MyFieldTraversalVisitor(Map<Long, Object> target) {
            this.target = target;
        }

        @Override
        public void visit(Object obj, Field field, Object value) {
            block3: {
                long id;
                if (value instanceof Replaceable && (id = ReferenceManager.getReferenceId((Replaceable)value)) < 0L) {
                    try {
                        field.set(obj, this.target.get(-id));
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)"field should be accessible");
                    }
                }
            }
        }

        @Override
        public void visit(Object array, int index, Object value) {
            long id;
            if (value instanceof Replaceable && (id = ReferenceManager.getReferenceId((Replaceable)value)) < 0L) {
                Array.set(array, index, this.target.get(-id));
            }
        }
    }

    static class IdentitySet {
        IdentityHashMap<Object, Object> map = new IdentityHashMap(1000);

        IdentitySet() {
        }

        public boolean contains(Object target) {
            return this.map.containsKey(target);
        }

        public void add(Object target) {
            this.map.put(target, target);
        }
    }

    public static class OverrideReferenceInputStream
    extends ObjectInputStream {
        public OverrideReferenceInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            ReferenceManager.override(obj);
            return obj;
        }
    }

    public static class CollectorOutputStream
    extends ObjectOutputStream {
        private Map<Long, Object> collected;

        public CollectorOutputStream(OutputStream out, Map<Long, Object> collected) throws IOException {
            super(out);
            if (collected == null) {
                throw new NullPointerException("collected cannot be null");
            }
            this.collected = collected;
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            FOClonner.collect(obj, this.collected);
            return obj;
        }
    }

    public static class CollectorInputStream
    extends ObjectInputStream {
        private Map<Long, Object> collected;

        public CollectorInputStream(InputStream out, Map<Long, Object> collected) throws IOException {
            super(out);
            if (collected == null) {
                throw new NullPointerException("collected cannot be null");
            }
            this.collected = collected;
            this.enableResolveObject(true);
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            FOClonner.collect(obj, this.collected);
            return obj;
        }
    }

    public static interface FieldTraversalVisitor {
        public void visit(Object var1, Field var2, Object var3);

        public void visit(Object var1, int var2, Object var3);
    }
}

