/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.internal;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.EncryptionService;
import oracle.bpel.services.workflow.permission.WorkflowAccessPermission;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.verification.impl.WorkflowContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.Severity;
import oracle.security.jps.util.JpsAuth;
import oracle.soa.common.util.Base64Encoder;
import oracle.tip.pc.services.common.ServiceFactory;

public class InternalBPMContext
extends WorkflowContext {
    private static String DEFAULT_REALM = InternalBPMContext.getDefaultRealmName();
    private static BPMException s_bootstrupException = null;
    private static String INTERNAL_CONTEXT_TOKEN;
    private static Object sContextCreationMonitor;
    public static final String NAME = "workflowsystem";

    protected InternalBPMContext(String sessionKey, String token) {
        super(NAME, DEFAULT_REALM, sessionKey, token, (String)null, true, true, true, Locale.getDefault(), TimeZone.getDefault());
    }

    protected InternalBPMContext(String sessionKey, String token, Locale locale, TimeZone tz) {
        super(NAME, DEFAULT_REALM, sessionKey, token, null, true, true, true, locale, tz);
    }

    public static IBPMContext getInternalBPMContext() throws BPMException {
        return InternalBPMContext.getInternalBPMContext(Locale.getDefault(), TimeZone.getDefault());
    }

    public static IBPMContext getInternalBPMContext(Locale locale, TimeZone tz) throws BPMException {
        if (s_bootstrupException != null) {
            throw s_bootstrupException;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JpsAuth.checkPermission((Permission)WorkflowAccessPermission.CREATE_INTERNAL_CONTEXT_PERMISSION);
                    return null;
                }
            });
        }
        catch (AccessControlException ace) {
            Object[] errorObjs = new Object[]{"createInternalBPMContext"};
            throw new BPMException(71056, errorObjs, (Throwable)ace);
        }
        catch (PrivilegedActionException pae) {
            Object[] errorObjs = new Object[]{"createInternalBPMContext"};
            throw new BPMException(71056, errorObjs, (Throwable)pae);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        InternalBPMContext internalBPMContext = new InternalBPMContext(InternalBPMContext.getInternalContextToken(), InternalBPMContext.getInternalContextToken(), locale, tz);
        return internalBPMContext;
    }

    public String getUser() {
        return NAME;
    }

    private static String getInternalContextToken() {
        return InternalBPMContext.getInternalContextToken(Severity.ERRORS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInternalContextToken(Severity serverity) {
        try {
            if (INTERNAL_CONTEXT_TOKEN != null) {
                return INTERNAL_CONTEXT_TOKEN;
            }
            Object object = sContextCreationMonitor;
            synchronized (object) {
                HashMap<String, String> fieldMap = new HashMap<String, String>();
                fieldMap.put("1", NAME);
                fieldMap.put("4", "");
                fieldMap.put("5", new Boolean(true).toString());
                fieldMap.put("6", new Boolean(true).toString());
                fieldMap.put("7", new Boolean(true).toString());
                INTERNAL_CONTEXT_TOKEN = InternalBPMContext.createTokenFromMap(fieldMap);
                return INTERNAL_CONTEXT_TOKEN;
            }
        }
        catch (Exception e) {
            Object[] errorObjs = new Object[]{"bootstrup"};
            s_bootstrupException = new BPMException(serverity, 71055, errorObjs, (Throwable)e);
            return null;
        }
    }

    private static String createTokenFromMap(Map map) throws Exception {
        String sessionKey = null;
        StringBuffer sb = new StringBuffer();
        for (String fieldId : map.keySet()) {
            String fieldValue = (String)map.get(fieldId);
            sb = sb.append(fieldId).append("__").append(fieldValue).append(";;");
            if (!"4".equals(fieldId)) continue;
            sessionKey = fieldValue;
        }
        String fieldString = sb.toString();
        String token = InternalBPMContext.encryptString(fieldString);
        if (sessionKey == null) {
            sessionKey = Util.getGuid();
        }
        token = sessionKey + ";;" + token;
        return token;
    }

    private static String encryptString(String string) throws Exception {
        byte[] key = EncryptionService.encrypt((String)string);
        return Base64Encoder.encode((byte[])key);
    }

    private static String getDefaultRealmName() {
        try {
            String realmName = ServiceFactory.getIdentityConfigServiceInstance().getDefaultRealmName();
            return realmName;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        sContextCreationMonitor = new Object();
    }
}

