/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.spi.ConfigurationEditorFactory;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ConfigEditorMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;

public class ConfigEditorRegistry {
    private static Map<ConfigType, ConfigurationEditorFactory> editors;

    public static ConfigurationEditorFactory getFactoryFor(ConfigType configType) {
        ConfigurationEditorFactory factory = ConfigEditorRegistry.getEditors().get(configType);
        if (factory == null && configType.getParent() != null) {
            factory = ConfigEditorRegistry.getFactoryFor(configType.getParent());
        }
        return factory;
    }

    public static final ConfigurationEditorBean createBeanFor(BaseConfiguration configuration) {
        ConfigType configType = configuration.getConfigType();
        ConfigurationEditorFactory factory = ConfigEditorRegistry.getFactoryFor(configType);
        if (factory == null) {
            throw new IllegalStateException("Configuration Editor subtype is not registered!!. Editor Subtype: " + configType + ". Registered editors: " + editors.keySet());
        }
        return factory.createEditorBeanFor((Configuration)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<ConfigType, ConfigurationEditorFactory> getEditors() {
        if (editors != null) return editors;
        Class<ConfigEditorRegistry> clazz = ConfigEditorRegistry.class;
        synchronized (ConfigEditorRegistry.class) {
            if (editors != null) return editors;
            HashMap<ConfigType, ConfigurationEditorFactory> editors = new HashMap<ConfigType, ConfigurationEditorFactory>();
            ExtensionService service = Platform.getExtensionService();
            List<Extension<ConfigEditorMetadata>> extensions = service.getExtensionsByPoint(ConfigEditorMetadata.class);
            for (Extension<ConfigEditorMetadata> extension : extensions) {
                try {
                    ConfigurationEditorFactory factory = extension.instantiateAs(ConfigurationEditorFactory.class);
                    editors.put(factory.getConfigType(), factory);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    Log.logSevere(e);
                }
            }
            ConfigEditorRegistry.editors = editors;
            // ** MonitorExit[var0] (shouldn't be in output)
            return editors;
        }
    }
}

