/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.engine.EnginePreferences;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.base.StoreEvents;
import fuego.prefs.engine.standalone.StandaloneEnginePreferences;
import fuego.prefs.engine.standalone.enterprise.EnterpriseEnginePreferences;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import oracle.bpm.data.EngineAccessInfo;
import oracle.bpm.data.EngineProperties;
import oracle.bpm.data.ServerLocation;
import oracle.bpm.log.Log;
import oracle.bpm.xml.DeserializationException;

public class EnginePreferencesMigration {
    public static void main(String[] arg) throws IOException, BackingStoreException {
        for (int i = 0; i < arg.length; ++i) {
            EnginePreferencesNode root = new EnginePreferencesNode("default");
            String fileName = arg[i];
            File file = new File(fileName);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bi = new BufferedInputStream(fileInputStream){

                @Override
                public void close() {
                }
            };
            bi.mark(Integer.MAX_VALUE);
            StandaloneEnginePreferences enginePreferences = EnginePreferencesMigration.migrate(null, bi, root, EngineType.ENTERPRISE);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            EnginePreferences.doExport(enginePreferences, fileOutputStream);
        }
    }

    public static StandaloneEnginePreferences migrate(String engineId, InputStream is, EnginePreferencesNode root, EngineType type) {
        assert (is.markSupported()) : "InputStream.mark is not supported";
        try {
            is.reset();
            EngineProperties engineProperties = EngineProperties.doImport(is);
            return EnginePreferencesMigration.migrate(engineId, engineProperties, root, type);
        }
        catch (DeserializationException e) {
            Log.logWarning(DirectoryMsg.CANNOT_MIGRATE_PROPERTIES(e.toString()));
            return new EnterpriseEnginePreferences(engineId, "default", root);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.logWarning(DirectoryMsg.CANNOT_MIGRATE_PROPERTIES(e.toString()));
            return new EnterpriseEnginePreferences(engineId, "default", root);
        }
    }

    public static StandaloneEnginePreferences migrate(String engineId, DirectorySession session, EnginePreferencesNode root, EngineType type) {
        try {
            EngineProperties engineProperties = EngineProperties.load(engineId, session);
            return EnginePreferencesMigration.migrate(engineId, engineProperties, root, type);
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static StandaloneEnginePreferences migrate(String engineId, EngineProperties engineProperties, EnginePreferencesNode root, EngineType type) {
        assert (type.isStandalone()) : "EngineType must be standalone";
        StandaloneEnginePreferences enginePreferences = (StandaloneEnginePreferences)type.createPreferences(engineId, engineProperties.getConfiguration(), root);
        Iterator locations = engineProperties.getServerLocations();
        while (locations != null && locations.hasNext()) {
            ServerLocation serverLocation = (ServerLocation)locations.next();
            enginePreferences.addEngineLocation(serverLocation.getHost(), serverLocation.getWebconsoleURL(), serverLocation.getLogDir(), serverLocation.getHomeDir());
        }
        Iterator accessInfos = engineProperties.getEngineAccessInfo();
        while (accessInfos != null && accessInfos.hasNext()) {
            EngineAccessInfo accessInfo = (EngineAccessInfo)accessInfos.next();
            enginePreferences.getLocation(accessInfo.getAddress()).addAccessInfo(accessInfo.getPort(), accessInfo.getProtocol());
        }
        enginePreferences.getConfiguration().setValue(engineProperties.getConfiguration());
        enginePreferences.getCreationConfiguration().setValue(engineProperties.getCreationConfiguration());
        enginePreferences.getRuntimeConfiguration().setValue(engineProperties.getRuntimeConfiguration());
        enginePreferences.getDirectoryPollingInterval().setValue(engineProperties.getDirectoryPollingInterval());
        StoreEvents events = StoreEvents.values()[engineProperties.getWriteEventsValue()];
        enginePreferences.getStoreEvents().setValue(events.name());
        enginePreferences.getLog().getDetailLevel().setValue(engineProperties.getLogDefaultDetailLevel());
        enginePreferences.getLog().getEngineLogSeverity().setValue(engineProperties.getLogDefaultSeverities());
        enginePreferences.getLog().getMailLogSeverity().setValue(engineProperties.getLogMailSeverities());
        enginePreferences.getLog().getMaxLogFiles().setValue(engineProperties.getLogBackupFiles());
        enginePreferences.getLog().getMaxLogSize().setValue(engineProperties.getLogMaxSize());
        enginePreferences.getExecution().getAutomaticExecutionThreadsPoolSize().setValue(engineProperties.getToDoThreadCount());
        enginePreferences.getExecution().getAutomaticExecutionThreadsPriority().setValue(engineProperties.getToDoThreadPriority());
        enginePreferences.getExecution().getAutomaticItemsQueueSize().setValue(engineProperties.getToDoQueueSize());
        enginePreferences.getExecution().getHttpThreadCount().setValue(engineProperties.getHttpThreadCount());
        enginePreferences.getExecution().getInteractiveExecutionThreadsPoolSize().setValue(engineProperties.getExecutionThreadPoolSize());
        enginePreferences.getExecution().getRequestQueueSize().setValue(engineProperties.getRequestQueueSize());
        enginePreferences.getExecution().getRequestQueueTimeout().setValue(engineProperties.getRequestQueueTimeout());
        enginePreferences.getExecution().getRogueThreadsLimit().setValue(engineProperties.getRogueThreadsLimit());
        enginePreferences.getTimeouts().getItemExecutionTimeout().setValue(engineProperties.getItemExecutionTimeout());
        enginePreferences.getTimeouts().getMaxMethodTimeout().setValue(engineProperties.getMaxCILTimeout() * 60);
        enginePreferences.getDisposer().getArchivingConfiguration().setValue(engineProperties.getArchivingConfiguration());
        enginePreferences.getDisposer().getArchivingEnabled().setValue(engineProperties.isArchivingEnable());
        enginePreferences.getDisposer().getDisposerLatency().setValue(engineProperties.getDisposeLatency());
        enginePreferences.getDisposer().getDisposerStartingTime().setValue(engineProperties.getDisposerStartingTime());
        enginePreferences.getDisposer().getInstanceCaducity().setValue(engineProperties.getDisposeInstanceCaducity());
        enginePreferences.getBAM().getBamSnapshotDisposing().setFrequencyValue(engineProperties.getBamSnapshotDisposing());
        enginePreferences.getBAM().getBamSnapshotResolution().setFrequencyValue(engineProperties.getBamSnapshotResolution());
        enginePreferences.getIPC().getMaxIncomingConnections().setValue(engineProperties.getMaxIPCIncomingConnections());
        enginePreferences.getIPC().getServiceEnabled().setValue(engineProperties.isIpcServiceEnabled());
        enginePreferences.getIPC().getServicePort().setValue(engineProperties.getIpcServicePort());
        enginePreferences.getSNMP().getAgentPort().setValue(engineProperties.getSnmpAgentPort());
        enginePreferences.getSNMP().getManagerHost().setValue(engineProperties.getInternalSnmpManagerHost());
        enginePreferences.getSNMP().getManagerPort().setValue(engineProperties.getSnmpManagerPort());
        enginePreferences.getSNMP().getServiceEnabled().setValue(engineProperties.isSnmpServiceEnabled());
        enginePreferences.getNetworking().getMailServerName().setValue(engineProperties.getMailServerName());
        enginePreferences.getNetworking().getAdministratorMail().setValue(engineProperties.getAdministratorMail());
        enginePreferences.getNetworking().getPortalUrl().setValue(engineProperties.getInternalWebBUIServer());
        enginePreferences.getNetworking().getWebServicesUrl().setValue(engineProperties.getInternalWebServicesURL());
        enginePreferences.getStartup().getArguments().setValue(engineProperties.getStartArguments());
        enginePreferences.getStartup().getAutoStartable().setValue(engineProperties.isAutoStartable());
        enginePreferences.getStartup().getJavaArguments().setValue(engineProperties.getStartJavaArguments());
        enginePreferences.getMemory().getInstancesCacheSize().setValue(engineProperties.getCacheSize());
        enginePreferences.getMemory().getMaxInstanceSize().setValue(engineProperties.getInstanceMaxSize());
        enginePreferences.getMemory().getMaxJvmHeapSize().setValue(engineProperties.getJvmHeapMax());
        enginePreferences.getPapi().getInstanceRetrievalSize().setValue(engineProperties.getInstanceRetrievalSize());
        enginePreferences.getPapi().getLatencyBetweenNotifications().setValue(engineProperties.getNotifyThreadLatency());
        enginePreferences.getPapi().getNotifyThreadPriority().setValue(engineProperties.getNotifyThreadPriority());
        return enginePreferences;
    }
}

