/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.standalone.studio;

import fuego.prefs.LocalhostUserPreference;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.base.BaseExecutionPreferences;
import fuego.prefs.engine.base.BaseNetworkingPreferences;
import fuego.prefs.engine.base.BaseRoundTripPreferences;
import fuego.prefs.engine.base.BaseSNMPPreferences;
import fuego.prefs.engine.standalone.StandaloneEngineLocationPreferences;
import fuego.prefs.engine.standalone.StandaloneEnginePreferences;
import fuego.prefs.engine.standalone.studio.StudioExecutionPreferences;
import fuego.prefs.engine.standalone.studio.StudioNetworkingPreferences;
import fuego.prefs.engine.standalone.studio.StudioRoundTripPreferences;
import fuego.prefs.engine.standalone.studio.StudioSNMPPreferences;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import fuego.prefs.engine.storage.FileSystemStore;

public class StudioEnginePreferences
extends StandaloneEnginePreferences {
    public StudioEnginePreferences(String serverId, String configuration, EnginePreferencesNode root) {
        super(EngineType.STUDIO, serverId, configuration, root);
        StandaloneEngineLocationPreferences location = this.getLocation(this.getLocalhost());
        assert (location != null) : "The location for 'localhost' can not be null";
        this.restoreDefaultLocalInfo(location.getHomeDir().getValue(), location.getLogDir().getValue());
        FileSystemStore portalUrlStorage = new FileSystemStore((LocalhostUserPreference)this.getNetworking().getPortalUrl(), location.getLogDir());
        this.getRoot().registerBackingStoreListener(portalUrlStorage);
        FileSystemStore webServiceUrlStorage = new FileSystemStore((LocalhostUserPreference)this.getNetworking().getWebServicesUrl(), location.getLogDir());
        this.getRoot().registerBackingStoreListener(webServiceUrlStorage);
        this.getRoot().notifyLoadToListeners();
    }

    @Override
    protected BaseExecutionPreferences createExecutionPreferences() {
        return new StudioExecutionPreferences(this);
    }

    @Override
    protected BaseNetworkingPreferences createNetworkingPreferences() {
        return new StudioNetworkingPreferences(this);
    }

    @Override
    protected BaseSNMPPreferences createSnmpPreferences() {
        return new StudioSNMPPreferences(this);
    }

    @Override
    protected BaseRoundTripPreferences createRoundTripPreferences() {
        return new StudioRoundTripPreferences(this);
    }
}

