/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.PasswordPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.ErrorMsg;
import java.util.Collection;
import java.util.Iterator;
import oracle.bpm.data.Frequency;
import oracle.bpm.resources.Msg;

public abstract class BaseWSPreferences
extends CategoryPreference {
    protected IntegerPreference wsListenerPort;
    protected IntegerPreference wsMaxIncomingConnections = new IntegerPreference("wsMaxIncomingConnections", this, DirectoryMsg.WEB_SERVICES_MAX_INCOMING, null, null, 20, 1, Integer.MAX_VALUE, 1);
    private StringPreference keystoreFile;
    private PasswordPreference password;
    private StringPreference protocol;
    private IntegerPreference wsConnectionTimeout;
    private BooleanPreference wsUseSsl;
    private static final String DEFAULT_PROTOCOL = "TLS";
    public static final int WS_MAX_INCOMING_CONNECTIONS_DEF = 20;
    public static final int WS_LISTENER_PORT_DEF = 9000;
    public static final int WS_DEFAULT_TIMEOUT = 60;

    public BaseWSPreferences(CategoryPreference parent) {
        this("ws", parent, null, null, null);
    }

    public BaseWSPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.wsListenerPort = new IntegerPreference("wsListenerPort", this, DirectoryMsg.WEB_SERVICES_SERVER_PORT, null, null, 9000, 1024, 65535, 1);
        this.wsUseSsl = new BooleanPreference("wsUseSsl", this, DirectoryMsg.WEB_SERVICES_USE_SSL, null, null, false);
        this.protocol = new StringPreference("protocol", this, DirectoryMsg.WEB_SERVICES_SSL_PROTOCOL, null, null, DEFAULT_PROTOCOL);
        this.password = new PasswordPreference("keystorePassword", this, DirectoryMsg.WEB_SERVICES_KS_PASSWORD, null, null, null);
        this.keystoreFile = new StringPreference("keystoreFile", this, DirectoryMsg.WEB_SERVICES_KS_FILE, null, null, null);
        this.wsConnectionTimeout = new IntegerPreference("wsConnectionTimeout", this, DirectoryMsg.WEB_SERVICES_SERVER_TIMEOUT, null, null, 60, 0, 600, 1);
        this.wsMaxIncomingConnections.setModifiableInRuntime(true);
        this.wsListenerPort.setModifiableInRuntime(false);
        this.wsUseSsl.setModifiableInRuntime(false);
        this.protocol.setModifiableInRuntime(false);
        this.password.setModifiableInRuntime(false);
        this.keystoreFile.setModifiableInRuntime(false);
        this.wsConnectionTimeout.setModifiableInRuntime(false);
    }

    public IntegerPreference getWsListenerPort() {
        return this.wsListenerPort;
    }

    public IntegerPreference getWsConnectionTimeout() {
        return this.wsConnectionTimeout;
    }

    public void setWsConnectionTimeout(IntegerPreference wsConnectionTimeout) {
        this.wsConnectionTimeout = wsConnectionTimeout;
    }

    public IntegerPreference getWsMaxIncomingConnections() {
        return this.wsMaxIncomingConnections;
    }

    public BooleanPreference getWsUseSsl() {
        return this.wsUseSsl;
    }

    public StringPreference getProtocol() {
        return this.protocol;
    }

    public PasswordPreference getPassword() {
        return this.password;
    }

    public StringPreference getKeystoreFile() {
        return this.keystoreFile;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.wsListenerPort.validate();
        if (msg == null && (msg = this.wsMaxIncomingConnections.validate()) == null && (msg = this.wsUseSsl.validate()) == null && (msg = this.protocol.validate()) == null && (msg = this.password.validate()) == null) {
            msg = this.keystoreFile.validate();
        }
        return msg;
    }

    private static String[] getArray(Collection defaultValue) {
        String[] values = new String[defaultValue.size()];
        Iterator it = defaultValue.iterator();
        int i = 0;
        while (it.hasNext()) {
            Frequency value = (Frequency)it.next();
            values[i] = value.toString();
            ++i;
        }
        return values;
    }
}

