/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.validator.ErrorMsg;
import oracle.bpm.resources.Msg;

public abstract class BaseTimeoutsPreferences
extends CategoryPreference {
    protected IntegerPreference itemExecutionTimeout;
    protected IntegerPreference maxMethodTimeout;
    protected IntegerPreference maxWebServiceSessionTimeout = new IntegerPreference("maxWebServiceSessionTimeout", this, DirectoryMsg.MAX_WEB_SERVICE_SESSION_TIMEOUT, null, DirectoryMsg.SECONDS, 300, 1, Integer.MAX_VALUE, 20);
    public static final int MAX_METHOD_TIMEOUT_DEF = 1800;
    public static final int MAX_WEB_SERVICE_SESSION_TIMEOUT_DEF = 300;
    public static final int ITEM_EXECUTION_TIMEOUT_DEF = 720;

    public BaseTimeoutsPreferences(CategoryPreference parent) {
        this("timeouts", parent, null, null, null);
    }

    public BaseTimeoutsPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.maxMethodTimeout = new IntegerPreference("maxMethodTimeout", this, DirectoryMsg.MAX_CIL_TIMEOUT, null, DirectoryMsg.SECONDS, 1800, 1, Integer.MAX_VALUE, 30);
        this.itemExecutionTimeout = new IntegerPreference("itemExecutionTimeout", this, DirectoryMsg.ITEM_EXECUTION_TIMEOUT, null, DirectoryMsg.MINUTES, 720, 1, Integer.MAX_VALUE, 30);
    }

    public IntegerPreference getItemExecutionTimeout() {
        return this.itemExecutionTimeout;
    }

    public IntegerPreference getMaxMethodTimeout() {
        return this.maxMethodTimeout;
    }

    public IntegerPreference getMaxWebServiceSessionTimeout() {
        return this.maxWebServiceSessionTimeout;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.itemExecutionTimeout.validate();
        if (msg != null) {
            return msg;
        }
        return this.maxMethodTimeout.validate();
    }
}

