/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.engine.base.LogMailSeverity;
import fuego.prefs.engine.base.LogSeverity;
import fuego.prefs.validator.ErrorMsg;
import fuego.prefs.validator.LogValidator;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.resources.Msg;

public abstract class BaseLogPreferences
extends CategoryPreference {
    protected IntegerPreference detailLevel;
    protected StringPreference engineLogSeverity = new StringPreference("engineLogSeverity", (CategoryPreference)this, DirectoryMsg.LOG_DEFAULT_SEVERITIES, null, null, new LogValidator(), ENGINE_LOG_SEVERITY_DEF);
    protected StringPreference mailLogSeverity;
    protected IntegerPreference maxLogFiles;
    protected IntegerPreference maxLogSize;
    protected StringPreference methodLogSeverity = new StringPreference("methodLogSeverity", (CategoryPreference)this, DirectoryMsg.LOG_DEFAULT_CLIENT_SEVERITIES, null, null, new LogValidator(), METHOD_LOG_SEVERITY_DEF);
    private static final String NONE = "None";
    private static final String WARNING = "Warning";
    private static final String SEVERE = "Severe";
    private static final String FATAL = "Fatal";
    private static final String INFO = "Info";
    private static final String DEBUG = "Debug";
    public static final String ENGINE_LOG_SEVERITY_DEF = LogSeverity.WARNING.getLogSeverityId();
    public static final String METHOD_LOG_SEVERITY_DEF = LogSeverity.INFO.getLogSeverityId();
    public static final String MAIL_LOG_SEVERITY_DEF = LogMailSeverity.NONE.getLogMailSeverityId();
    public static final int MAX_LOG_SIZE_DEF = 2000;
    public static final int MAX_LOG_FILES_DEF = 5;
    public static final int DETAIL_LEVEL_DEF = 1;

    public BaseLogPreferences(CategoryPreference parent) {
        this("log", parent, null, null, null);
    }

    public BaseLogPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.mailLogSeverity = new StringPreference("mailLogSeverity", (CategoryPreference)this, DirectoryMsg.LOG_MAIL_SEVERITIES, null, null, new LogValidator(), MAIL_LOG_SEVERITY_DEF);
        this.maxLogSize = new IntegerPreference("maxLogSize", this, DirectoryMsg.LOG_MAX_SIZE, null, DirectoryMsg.LOGSIZE_HINT, 2000, 1000, 1000000000, 100);
        this.maxLogFiles = new IntegerPreference("maxLogFiles", this, DirectoryMsg.LOG_BACKUP_FILES, null, null, 5, 1, 100, 1);
        this.detailLevel = new IntegerPreference("detailLevel", this, DirectoryMsg.LOG_DEFAULT_DETAIL_LEVEL, null, DirectoryMsg.PRIORITY_HINT, 1, 1, 10, 1);
    }

    public static String getFullLogMailSeverities(String severities) {
        if (severities.equals(WARNING)) {
            return "Fatal,Severe,Warning";
        }
        if (severities.equals(SEVERE)) {
            return "Fatal,Severe";
        }
        return NONE;
    }

    public static String getFullLogSeverities(String severities) {
        if (severities.equals(DEBUG)) {
            return "Trace,Fatal,Severe,Warning,Info,Debug";
        }
        if (severities.equals(INFO)) {
            return "Trace,Fatal,Severe,Warning,Info";
        }
        if (severities.equals(WARNING)) {
            return "Trace,Fatal,Severe,Warning";
        }
        if (severities.equals(SEVERE)) {
            return "Trace,Fatal,Severe";
        }
        return "Trace,Fatal";
    }

    public IntegerPreference getDetailLevel() {
        return this.detailLevel;
    }

    public StringPreference getEngineLogSeverity() {
        return this.engineLogSeverity;
    }

    public StringPreference getMailLogSeverity() {
        return this.mailLogSeverity;
    }

    public IntegerPreference getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public IntegerPreference getMaxLogSize() {
        return this.maxLogSize;
    }

    public StringPreference getMethodLogSeverity() {
        return this.methodLogSeverity;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.detailLevel.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.maxLogFiles.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.maxLogSize.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.engineLogSeverity.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.mailLogSeverity.validate();
        if (msg != null) {
            return msg;
        }
        return this.methodLogSeverity.validate();
    }

    public List<LogMailSeverity> valuesLogMailSeverities() {
        return Arrays.asList(LogMailSeverity.values());
    }

    public List<LogSeverity> valuesLogSeverities() {
        return Arrays.asList(LogSeverity.values());
    }
}

