/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs;

import fuego.prefs.CategoryPreference;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import fuego.prefs.validator.ErrorMsg;
import java.util.prefs.Preferences;
import oracle.bpm.resources.Msg;

public abstract class Preference {
    private Msg help;
    private Msg hint;
    private Msg label;
    private String name;
    private CategoryPreference parent;

    protected Preference(String name, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        this.name = name;
        this.parent = parent;
        this.label = label;
        this.help = help;
        this.hint = hint;
    }

    public abstract ErrorMsg validate();

    public abstract ErrorMsg validate(String var1);

    public String getKey() {
        return this.parent != null ? this.parent.getKey() + '/' + this.name : this.name;
    }

    public Msg getHelp() {
        return this.help;
    }

    public Msg getHint() {
        return this.hint;
    }

    public Msg getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    protected Preferences getParent() {
        assert (this.parent != null);
        return this.parent.getParent().node(this.getName());
    }

    protected EnginePreferencesNode getRoot() {
        assert (this.parent != null);
        return this.parent.getRoot();
    }
}

