/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs;

import fuego.prefs.CategoryPreference;
import fuego.prefs.CustomStoragePreference;
import fuego.prefs.LocalhostPreference;
import fuego.prefs.validator.StringPrefValidator;
import oracle.bpm.resources.Msg;

public class LocalhostUserPreference
extends LocalhostPreference
implements CustomStoragePreference {
    private String value;

    public LocalhostUserPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, StringPrefValidator validator, String defaultValue) {
        super(id, parent, label, help, hint, validator, defaultValue);
        this.value = defaultValue;
    }

    @Override
    public void setStoredValue(String value) {
        this.value = value;
    }

    @Override
    public void setStringValue(String value) {
        String localHostName = LocalhostUserPreference.getLocalhost();
        if (value.indexOf(localHostName) != -1) {
            value = value.replaceAll(localHostName, "\\$LOCALHOST\\$");
        }
        this.value = value;
        this.setStringValueInternal(this.value);
    }

    @Override
    public String getStringValue() {
        String value = this.updateContext(this.value, super.getStringValue());
        if (value.indexOf("$LOCALHOST$") != -1) {
            String localHostName = LocalhostUserPreference.getLocalhost();
            value = value.replaceAll("\\$LOCALHOST\\$", localHostName);
        }
        return value;
    }

    @Override
    public String getValueToStore() {
        return this.value;
    }

    protected String updateContext(String value, String storedValue) {
        if (!storedValue.equals(this.getDefaultValue())) {
            value = value.substring(0, value.lastIndexOf("/")) + storedValue.substring(storedValue.lastIndexOf("/"), storedValue.length());
        }
        return value;
    }
}

