/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs;

import fuego.prefs.CategoryPreference;
import fuego.prefs.StringPreference;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.resources.Msg;

public class CSVPreference
extends StringPreference {
    private StringList values;
    private static final String SEPARATOR = ",";

    public CSVPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, String defaultValue) {
        super(id, parent, label, help, hint, defaultValue);
    }

    public void setCSValue(String value) {
        StringList values = this.getCSValues();
        if (!values.contains(value)) {
            values.add(value);
            this.setCSValues(values);
        }
    }

    public StringList getCSValues() {
        if (this.values == null) {
            this.values = StringList.createTokenizing(this.getValue(), SEPARATOR);
        }
        return this.values;
    }

    public void removeCSValue(String value) {
        StringList values = this.getCSValues();
        if (values.remove(value)) {
            this.setCSValues(values);
        }
    }

    private void setCSValues(List values) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            buffer.append(value);
            if (!it.hasNext()) continue;
            buffer.append(SEPARATOR);
        }
        this.setValue(buffer.toString());
    }
}

