/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.util;

import fuego.directory.DirBusinessParameter;
import fuego.directory.DirCalendarRule;
import fuego.directory.DirHolidayRule;
import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirOrganizationalGroup;
import fuego.directory.DirOrganizationalRole;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.DirPresentation;
import fuego.directory.DirProcessVariable;
import fuego.directory.DirReferral;
import fuego.directory.DirView;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.DirObjectAlreadyExistsException;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import fuego.directory.util.CouldNotImportObjectsException;
import fuego.directory.util.DirectoryImportException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FDIImport
extends DefaultHandler {
    private String data_d;
    private DirBusinessParameterContainer dirBusinessParameterContainer_d;
    private DirCalendarRuleContainer dirCalendarRuleContainer_d;
    private DirectoryContainer directoryContainer_d;
    private DirHolidayRuleContainer dirHolidayRuleContainer_d;
    private DirHumanParticipantContainer dirHumanParticipantContainer_d;
    private String dirObject_d;
    private final List<DirObjectContainer> dirObjectContainer_d;
    private DirOrganizationalGroupContainer dirOrganizationalGroupContainer_d;
    private DirOrganizationalRoleContainer dirOrganizationalRoleContainer_d;
    private DirOrganizationalUnitContainer dirOrganizationalUnitContainer_d;
    private DirPresentationContainer dirPresentationContainer_d;
    private DirProcessVariableContainer dirProcessVariableContainer_d;
    private DirReferralContainer dirReferralContainer_d;
    private final DirectorySession<? extends Object> dirSession_d;
    private DirViewContainer dirViewContainer_d;
    private boolean fdiObjectAppeared = false;
    private boolean generatePassFile_d;
    private String inFileName_d;
    private InputStream is;
    private Locator locator;
    private final Map<String, DirOrganizationalUnitContainer> ouMap_d;
    private String outputData_d;
    private final TreeSet<String> ouTree_d;
    private String passFileOutputDir;
    private final Random random;
    private static final String OUTPUTFILENAME = "output.txt";
    private static final String FUEGOTECH_PACKAGE = "fuegotech";
    private static final String FUEGO_PACKAGE = "fuego";

    public FDIImport(DirectorySession<? extends Object> dirSession, String inFileName) {
        this(dirSession, inFileName, true);
    }

    public FDIImport(DirectorySession<? extends Object> dirSession, String inFileName, boolean generatePassFile) {
        this.dirSession_d = dirSession;
        this.inFileName_d = inFileName;
        this.dirObjectContainer_d = new ArrayList<DirObjectContainer>();
        this.outputData_d = "";
        this.ouTree_d = new TreeSet();
        this.ouMap_d = new HashMap<String, DirOrganizationalUnitContainer>();
        this.dirObject_d = "";
        this.generatePassFile_d = generatePassFile;
        this.random = new SecureRandom();
    }

    public FDIImport(DirectorySession<Object> dirSession, String inFileName, InputStream is) {
        this(dirSession, inFileName, is, true);
    }

    public FDIImport(DirectorySession<Object> dirSession, String inFileName, InputStream is, boolean generatePassFile) {
        this(dirSession, inFileName, generatePassFile);
        this.is = is;
    }

    public static String migrateCalendarProperties(String properties) {
        return properties.replaceAll("daySchedules_d", "daySchedules").replaceAll("start1_d", "start1").replaceAll("start2_d", "start2").replaceAll("finish1_d", "finish1").replaceAll("finish2_d", "finish2");
    }

    public void setPassFileOutputDir(String passFileOutputDir) {
        this.passFileOutputDir = passFileOutputDir;
    }

    public final List<DirObjectContainer> getDirObjectsFromFile() throws DirectoryImportException {
        return this.getDirObjectsFromFile(true);
    }

    public final List<DirObjectContainer> getDirObjectsFromFile(boolean ignoreFileCorruption) throws DirectoryImportException {
        this.dirObjectContainer_d.clear();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(this.getInputStream());
            saxParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (IOException e) {
            throw DirectoryImportException.xmlParseException(this.getFileName(), e);
        }
        catch (ParserConfigurationException e) {
            throw DirectoryImportException.xmlParseException(this.getFileName(), e);
        }
        catch (SAXParseException e) {
            if (ignoreFileCorruption) {
                Log.logWarning(DirectoryMsg.CANNOT_PARSE_OBJECT(this.getFileName()));
            }
            throw DirectoryImportException.xmlParseException(this.getFileName(), e);
        }
        catch (SAXException e) {
            Exception source = e.getException();
            if (source == null) {
                source = e;
            } else if (source instanceof DirectoryImportException) {
                throw (DirectoryImportException)source;
            }
            throw DirectoryImportException.xmlParseException(this.getFileName(), source);
        }
        return this.dirObjectContainer_d;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public final void characters(char[] buf, int offset, int len) {
        this.data_d = this.data_d + new String(buf, offset, len);
    }

    @Override
    public final void endDocument() {
    }

    @Override
    public final void endElement(String namespaceURI, String sName, String qName) {
        if (this.dirObject_d.equals("DirOrganizationalRole")) {
            if (qName.equals("name")) {
                this.dirOrganizationalRoleContainer_d.id = this.data_d;
            } else if (qName.equals("description")) {
                if (this.data_d != null && !this.data_d.trim().equals("")) {
                    this.dirOrganizationalRoleContainer_d.description = this.data_d;
                }
            } else if (qName.equals("value")) {
                if (this.data_d != null && !this.data_d.trim().equals("")) {
                    this.dirOrganizationalRoleContainer_d.getParametricValues().add(this.data_d);
                }
            } else if (qName.equals("isParametric")) {
                this.dirOrganizationalRoleContainer_d.isParametric = Boolean.valueOf(this.data_d);
            } else if (qName.equals("nameCalendar")) {
                this.dirOrganizationalRoleContainer_d.calendarRuleNameCalendar = this.data_d;
            } else if (qName.equals("ou")) {
                this.dirOrganizationalRoleContainer_d.calendarRuleOu = this.data_d;
            } else if (qName.equals("calendarRule")) {
                this.dirOrganizationalRoleContainer_d.getCalendarRules().add(new DirOrganizationalRole.CalendarRuleAssignment(this.dirOrganizationalRoleContainer_d.calendarRuleOu, this.dirOrganizationalRoleContainer_d.calendarRuleNameCalendar));
            } else if (qName.equals("prop_category")) {
                this.dirOrganizationalRoleContainer_d.category = this.data_d;
            } else if (qName.equals("prop_key")) {
                this.dirOrganizationalRoleContainer_d.key = this.data_d;
            } else if (qName.equals("prop_value")) {
                this.dirOrganizationalRoleContainer_d.value = this.data_d;
            } else if (qName.equals("roleProperty")) {
                this.dirOrganizationalRoleContainer_d.properties.add(new Property(this.dirOrganizationalRoleContainer_d.category, this.dirOrganizationalRoleContainer_d.key, this.dirOrganizationalRoleContainer_d.value));
            } else if (qName.equals("locale")) {
                this.dirOrganizationalRoleContainer_d.locale = this.data_d;
            }
            if (qName.equals("message")) {
                this.dirOrganizationalRoleContainer_d.message = this.data_d;
            } else if (qName.equals("localizedDisplayName")) {
                this.dirOrganizationalRoleContainer_d.localizedMessages.add(new DirProcessVariable.LocalizedMessage(this.dirOrganizationalRoleContainer_d.locale, this.dirOrganizationalRoleContainer_d.message));
            } else if (qName.equals("DirOrganizationalRole")) {
                this.dirObjectContainer_d.add(this.dirOrganizationalRoleContainer_d);
            }
        } else if (this.dirObject_d.equals("DirOrganizationalUnit")) {
            if (qName.equals("name")) {
                this.dirOrganizationalUnitContainer_d.name = this.data_d;
            } else if (qName.equals("description")) {
                if (this.data_d != null && !this.data_d.equals("")) {
                    this.dirOrganizationalUnitContainer_d.description = this.data_d;
                }
            } else if (qName.equals("parentId")) {
                this.dirOrganizationalUnitContainer_d.parentId = this.data_d;
            } else if (qName.equals("DirOrganizationalUnit")) {
                this.dirOrganizationalUnitContainer_d.id = this.dirOrganizationalUnitContainer_d.getId();
                this.ouMap_d.put(this.dirOrganizationalUnitContainer_d.id, this.dirOrganizationalUnitContainer_d);
                this.ouTree_d.add(this.dirOrganizationalUnitContainer_d.id);
                this.dirObjectContainer_d.add(this.dirOrganizationalUnitContainer_d);
            }
        } else if (this.dirObject_d.equals("DirHolidayRule")) {
            if (qName.equals("name")) {
                this.dirHolidayRuleContainer_d.id = this.data_d;
            } else if (qName.equals("properties")) {
                this.dirHolidayRuleContainer_d.properties = FDIImport.modifyPackageName(this.data_d);
            } else if (qName.equals("DirHolidayRule")) {
                this.dirObjectContainer_d.add(this.dirHolidayRuleContainer_d);
            }
        } else if (this.dirObject_d.equals("DirCalendarRule")) {
            if (qName.equals("name")) {
                this.dirCalendarRuleContainer_d.id = this.data_d;
            } else if (qName.equals("properties")) {
                this.dirCalendarRuleContainer_d.properties = FDIImport.modifyPackageName(this.data_d);
                this.dirCalendarRuleContainer_d.properties = FDIImport.migrateCalendarProperties(this.dirCalendarRuleContainer_d.properties);
            } else if (qName.equals("value")) {
                if (this.data_d.equals("/")) {
                    this.data_d = DirOrganizationalUnit.getRootId();
                }
                this.dirCalendarRuleContainer_d.getOus().add(this.data_d);
            } else if (qName.equals("DirCalendarRule")) {
                this.dirObjectContainer_d.add(this.dirCalendarRuleContainer_d);
            }
        } else if (this.dirObject_d.equals("DirHumanParticipant")) {
            if (qName.equals("id")) {
                this.dirHumanParticipantContainer_d.id = this.data_d;
            } else if (qName.equals("firstName")) {
                this.dirHumanParticipantContainer_d.firstName = this.data_d;
            } else if (qName.equals("lastName")) {
                this.dirHumanParticipantContainer_d.lastName = this.data_d;
            } else if (qName.equals("displayName")) {
                this.dirHumanParticipantContainer_d.displayName = this.data_d;
            } else if (qName.equals("mail")) {
                this.dirHumanParticipantContainer_d.mail = this.data_d;
            } else if (qName.equals("receivesMail")) {
                this.dirHumanParticipantContainer_d.receivesMail = this.data_d;
            } else if (qName.equals("ou")) {
                this.dirHumanParticipantContainer_d.ouId = this.data_d;
            } else if (qName.equals("status")) {
                this.dirHumanParticipantContainer_d.status = this.data_d;
            } else if (qName.equals("telephone")) {
                this.dirHumanParticipantContainer_d.telephone = this.data_d;
            } else if (qName.equals("fax")) {
                this.dirHumanParticipantContainer_d.fax = this.data_d;
            } else if (!qName.equals("employeeId") && !qName.equals("manager")) {
                if (qName.equals("perm")) {
                    this.dirHumanParticipantContainer_d.participantPermissions = Integer.parseInt(this.data_d);
                } else if (qName.equals("roleId")) {
                    this.dirHumanParticipantContainer_d.roleId = this.data_d;
                } else if (qName.equals("password")) {
                    this.dirHumanParticipantContainer_d.password = this.data_d;
                } else if (qName.equals("parametricValue")) {
                    if (this.data_d != null && !this.data_d.trim().equals("")) {
                        this.dirHumanParticipantContainer_d.parametricValue = this.data_d;
                    }
                } else if (qName.equals("permissions")) {
                    if (this.data_d != null && !this.data_d.trim().equals("")) {
                        this.dirHumanParticipantContainer_d.rolePermissions = Integer.parseInt(this.data_d);
                    }
                } else if (qName.equals("category")) {
                    if (this.data_d != null && !this.data_d.trim().equals("")) {
                        this.dirHumanParticipantContainer_d.assignmentRoleCategory = Integer.parseInt(this.data_d);
                    }
                } else if (qName.equals("roleAssignment")) {
                    this.dirHumanParticipantContainer_d.getRolesAssignment().add(new DirHumanParticipant.RoleAssignment(this.dirHumanParticipantContainer_d.roleId, this.dirHumanParticipantContainer_d.parametricValue, this.dirHumanParticipantContainer_d.rolePermissions, -1, this.dirHumanParticipantContainer_d.assignmentRoleCategory));
                    this.dirHumanParticipantContainer_d.roleId = null;
                    this.dirHumanParticipantContainer_d.parametricValue = null;
                } else if (qName.equals("administeredOU")) {
                    this.dirHumanParticipantContainer_d.getAdministratedOus().add(this.dirHumanParticipantContainer_d.getAdministratedOuName());
                    this.dirHumanParticipantContainer_d.setAdministratedOuName(null);
                } else if (qName.equals("administeredOUName")) {
                    this.dirHumanParticipantContainer_d.setAdministratedOuName(this.data_d);
                } else if (qName.equals("to")) {
                    this.dirHumanParticipantContainer_d.to = Time.valueOf(this.data_d);
                } else if (qName.equals("from")) {
                    this.dirHumanParticipantContainer_d.from = Time.valueOf(this.data_d);
                } else if (qName.equals("replacement")) {
                    this.dirHumanParticipantContainer_d.getReplacements().add(this.data_d);
                } else if (qName.equals("absence")) {
                    DirHumanParticipant.Absence o = new DirHumanParticipant.Absence(this.dirHumanParticipantContainer_d.from, this.dirHumanParticipantContainer_d.to, this.dirHumanParticipantContainer_d.getReplacements().toArray(new String[this.dirHumanParticipantContainer_d.getReplacements().size()]));
                    this.dirHumanParticipantContainer_d.getAbsences().add(o);
                } else if (qName.equals("prop_category")) {
                    this.dirHumanParticipantContainer_d.category = this.data_d;
                } else if (qName.equals("prop_key")) {
                    this.dirHumanParticipantContainer_d.key = this.data_d;
                } else if (qName.equals("prop_value")) {
                    this.dirHumanParticipantContainer_d.value = this.data_d;
                } else if (qName.equals("participantProperty")) {
                    this.dirHumanParticipantContainer_d.properties.add(new Property(this.dirHumanParticipantContainer_d.category, this.dirHumanParticipantContainer_d.key, this.dirHumanParticipantContainer_d.value));
                } else if (qName.equals("DirHumanParticipant")) {
                    this.dirObjectContainer_d.add(this.dirHumanParticipantContainer_d);
                }
            }
        } else if (this.dirObject_d.equals("DirOrganizationalGroup")) {
            if (qName.equals("displayName")) {
                this.dirOrganizationalGroupContainer_d.displayName = this.data_d;
            } else if (qName.equals("name")) {
                this.dirOrganizationalGroupContainer_d.id = this.data_d;
            } else if (qName.equals("description")) {
                this.dirOrganizationalGroupContainer_d.description = this.data_d;
            } else if (qName.equals("roleId")) {
                this.dirOrganizationalGroupContainer_d.roleId = this.data_d;
            } else if (qName.equals("parametricValue")) {
                this.dirOrganizationalGroupContainer_d.parametricValue = this.data_d;
            } else if (qName.equals("permissions")) {
                this.dirOrganizationalGroupContainer_d.permissions = Integer.parseInt(this.data_d);
            } else if (qName.equals("category")) {
                if (this.data_d != null && !this.data_d.trim().equals("")) {
                    this.dirOrganizationalGroupContainer_d.assignmentRoleCategory = Integer.parseInt(this.data_d);
                }
            } else if (qName.equals("roleAssignment")) {
                this.dirOrganizationalGroupContainer_d.getRolesAssignment().add(new DirHumanParticipant.RoleAssignment(this.dirOrganizationalGroupContainer_d.roleId, this.dirOrganizationalGroupContainer_d.parametricValue, this.dirOrganizationalGroupContainer_d.permissions, -1, this.dirOrganizationalGroupContainer_d.assignmentRoleCategory));
                this.dirOrganizationalGroupContainer_d.roleId = null;
                this.dirOrganizationalGroupContainer_d.parametricValue = null;
            } else if (qName.equals("groupId")) {
                this.dirOrganizationalGroupContainer_d.getAssignedGroups().add(this.data_d);
            } else if (qName.equals("participantId")) {
                this.dirOrganizationalGroupContainer_d.getAssignedParticipants().add(this.data_d);
            } else if (qName.equals("allowRolesAssigned")) {
                this.dirOrganizationalGroupContainer_d.allowRolesAssigned = Boolean.valueOf(this.data_d);
            } else if (qName.equals("status")) {
                this.dirOrganizationalGroupContainer_d.status = this.data_d;
            } else if (qName.equals("ou")) {
                this.dirOrganizationalGroupContainer_d.ou = this.data_d;
            } else if (qName.equals("prop_category")) {
                this.dirOrganizationalGroupContainer_d.category = this.data_d;
            } else if (qName.equals("prop_key")) {
                this.dirOrganizationalGroupContainer_d.key = this.data_d;
            } else if (qName.equals("prop_value")) {
                this.dirOrganizationalGroupContainer_d.value = this.data_d;
            } else if (qName.equals("groupProperty")) {
                this.dirOrganizationalGroupContainer_d.properties.add(new Property(this.dirOrganizationalGroupContainer_d.category, this.dirOrganizationalGroupContainer_d.key, this.dirOrganizationalGroupContainer_d.value));
            } else if (qName.equals("DirOrganizationalGroup")) {
                this.dirObjectContainer_d.add(this.dirOrganizationalGroupContainer_d);
            }
        } else if (this.dirObject_d.equals("DirProcessVariable")) {
            if (qName.equals("id")) {
                this.dirProcessVariableContainer_d.id = this.data_d;
            }
            if (qName.equals("type")) {
                this.dirProcessVariableContainer_d.type = this.data_d;
            }
            if (qName.equals("mask")) {
                this.dirProcessVariableContainer_d.mask = this.data_d;
            }
            if (qName.equals("size")) {
                this.dirProcessVariableContainer_d.size = this.data_d;
            }
            if (qName.equals("locale")) {
                this.dirProcessVariableContainer_d.locale = this.data_d;
            }
            if (qName.equals("message")) {
                this.dirProcessVariableContainer_d.message = this.data_d;
            } else if (qName.equals("localizedDisplayName")) {
                this.dirProcessVariableContainer_d.localizedMessages.add(new DirProcessVariable.LocalizedMessage(this.dirProcessVariableContainer_d.locale, this.dirProcessVariableContainer_d.message));
            } else if (qName.equals("prop_category")) {
                this.dirProcessVariableContainer_d.category = this.data_d;
            } else if (qName.equals("prop_key")) {
                this.dirProcessVariableContainer_d.key = this.data_d;
            } else if (qName.equals("prop_value")) {
                this.dirProcessVariableContainer_d.value = this.data_d;
            } else if (qName.equals("processVariableProperty")) {
                this.dirProcessVariableContainer_d.properties.add(new Property(this.dirProcessVariableContainer_d.category, this.dirProcessVariableContainer_d.key, this.dirProcessVariableContainer_d.value));
            } else if (qName.equals("DirProcessVariable")) {
                this.dirObjectContainer_d.add(this.dirProcessVariableContainer_d);
            }
        } else if (this.dirObject_d.equals("DirBusinessParameter")) {
            if (qName.equals("id")) {
                this.dirBusinessParameterContainer_d.id = this.data_d;
            }
            if (qName.equals("type")) {
                this.dirBusinessParameterContainer_d.type = this.data_d;
            }
            if (qName.equals("size")) {
                this.dirBusinessParameterContainer_d.size = this.data_d;
            }
            if (qName.equals("defaultValue")) {
                this.dirBusinessParameterContainer_d.defaultValue = this.data_d;
            }
            if (qName.equals("key")) {
                this.dirBusinessParameterContainer_d.key = this.data_d;
            }
            if (qName.equals("value")) {
                this.dirBusinessParameterContainer_d.value = this.data_d;
            }
            if (qName.equals("entry")) {
                this.dirBusinessParameterContainer_d.addValue(this.dirBusinessParameterContainer_d.key, this.dirBusinessParameterContainer_d.value);
            }
            if (qName.equals("DirBusinessParameter")) {
                this.dirObjectContainer_d.add(this.dirBusinessParameterContainer_d);
            }
        } else if (this.dirObject_d.equals("DirReferral")) {
            if (qName.equals("organization")) {
                this.dirReferralContainer_d.organization = this.data_d;
            } else if (qName.equals("properties")) {
                this.dirReferralContainer_d.properties = this.data_d;
            } else if (qName.equals("DirReferral")) {
                this.dirObjectContainer_d.add(this.dirReferralContainer_d);
            }
        } else if (this.dirObject_d.equals("DirView")) {
            if (qName.equals("id")) {
                this.dirViewContainer_d.id = this.data_d;
            } else if (qName.equals("process")) {
                this.dirViewContainer_d.processes.add(this.data_d);
            } else if (qName.equals("role")) {
                this.dirViewContainer_d.roles.add(this.data_d);
            } else if (qName.equals("properties")) {
                this.dirViewContainer_d.properties = this.data_d;
            } else if (qName.equals("type")) {
                this.dirViewContainer_d.type = Integer.parseInt(this.data_d);
            } else if (qName.equals("prop_category")) {
                this.dirViewContainer_d.category = this.data_d;
            } else if (qName.equals("prop_key")) {
                this.dirViewContainer_d.key = this.data_d;
            } else if (qName.equals("prop_value")) {
                this.dirViewContainer_d.value = this.data_d;
            } else if (qName.equals("viewProperty")) {
                this.dirViewContainer_d.viewProperties.add(new Property(this.dirViewContainer_d.category, this.dirViewContainer_d.key, this.dirViewContainer_d.value));
            } else if (qName.equals("DirView")) {
                this.dirObjectContainer_d.add(this.dirViewContainer_d);
            }
        } else if (this.dirObject_d.equals("DirPresentation")) {
            if (qName.equals("id")) {
                this.dirPresentationContainer_d.id = this.data_d;
            } else if (qName.equals("properties")) {
                this.dirPresentationContainer_d.properties = this.data_d;
            } else if (qName.equals("type")) {
                this.dirPresentationContainer_d.type = Integer.parseInt(this.data_d);
            } else if (qName.equals("DirPresentation")) {
                this.dirObjectContainer_d.add(this.dirPresentationContainer_d);
            }
        } else if (this.dirObject_d.equals("Directory")) {
            if (qName.equals("prop_category")) {
                this.directoryContainer_d.category = this.data_d;
            } else if (qName.equals("prop_key")) {
                this.directoryContainer_d.key = this.data_d;
            } else if (qName.equals("prop_value")) {
                this.directoryContainer_d.value = this.data_d;
            } else if (qName.equals("directoryProperty")) {
                this.directoryContainer_d.properties.add(new Property(this.directoryContainer_d.category, this.directoryContainer_d.key, this.directoryContainer_d.value));
            } else if (qName.equals("Directory")) {
                this.dirObjectContainer_d.add(this.directoryContainer_d);
            }
        }
    }

    public void putDirObjects(List<DirObjectContainer> dirObjects) throws DirectoryImportException {
        if (dirObjects.size() == 0) {
            return;
        }
        ArrayList<DirObjectContainer> dirHumanParticipantContainer = new ArrayList<DirObjectContainer>();
        ArrayList<DirObjectContainer> dirOrganizationalGroupContainer = new ArrayList<DirObjectContainer>();
        ArrayList<DirObjectContainer> dirObjectContainer = new ArrayList<DirObjectContainer>();
        for (DirObjectContainer actual : dirObjects) {
            if (actual instanceof DirHumanParticipantContainer) {
                dirHumanParticipantContainer.add(actual);
                continue;
            }
            if (actual instanceof DirOrganizationalGroupContainer) {
                dirOrganizationalGroupContainer.add(actual);
                continue;
            }
            dirObjectContainer.add(actual);
        }
        this.createDirObjects(dirObjects.size(), dirObjectContainer, dirHumanParticipantContainer, dirOrganizationalGroupContainer);
    }

    public void putProperties(List<DirObjectContainer> dirObjects) throws DirectoryImportException {
        HashMap<DirObjectContainer, Exception> exceptions = new HashMap<DirObjectContainer, Exception>(dirObjects.size());
        for (DirObjectContainer actual : dirObjects) {
            try {
                actual.insertProperties();
            }
            catch (DirectoryException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
            catch (DirectoryRuntimeException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
        }
        if (exceptions.size() > 0) {
            throw CouldNotImportObjectsException.groupImportExceptions(this.getDirectorySession().getDirectoryId(), this.getFileName(), exceptions);
        }
    }

    @Override
    public final void startDocument() {
    }

    @Override
    public final void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.data_d = "";
        if (qName.equals("FDIObject")) {
            this.fdiObjectAppeared = true;
            return;
        }
        if (!this.fdiObjectAppeared) {
            throw new SAXException(DirectoryImportException.notAnFDIExportFile(this.getFileName()));
        }
        if (qName.equals("DirOrganizationalRole")) {
            this.dirObject_d = qName;
            this.dirOrganizationalRoleContainer_d = new DirOrganizationalRoleContainer();
        } else if (qName.equals("DirOrganizationalUnit")) {
            this.dirObject_d = qName;
            this.dirOrganizationalUnitContainer_d = new DirOrganizationalUnitContainer();
        } else if (qName.equals("DirHolidayRule")) {
            this.dirObject_d = qName;
            this.dirHolidayRuleContainer_d = new DirHolidayRuleContainer();
        } else if (qName.equals("DirCalendarRule")) {
            this.dirObject_d = qName;
            this.dirCalendarRuleContainer_d = new DirCalendarRuleContainer();
        } else if (qName.equals("DirHumanParticipant")) {
            this.dirObject_d = qName;
            this.dirHumanParticipantContainer_d = new DirHumanParticipantContainer();
        } else if (qName.equals("DirOrganizationalGroup")) {
            this.dirObject_d = qName;
            this.dirOrganizationalGroupContainer_d = new DirOrganizationalGroupContainer();
        } else if (qName.equals("DirProcessVariable")) {
            this.dirObject_d = qName;
            this.dirProcessVariableContainer_d = new DirProcessVariableContainer();
        } else if (qName.equals("DirBusinessParameter")) {
            this.dirObject_d = qName;
            this.dirBusinessParameterContainer_d = new DirBusinessParameterContainer();
        } else if (qName.equals("DirReferral")) {
            this.dirObject_d = qName;
            this.dirReferralContainer_d = new DirReferralContainer();
        } else if (qName.equals("DirView")) {
            this.dirObject_d = qName;
            this.dirViewContainer_d = new DirViewContainer();
        } else if (qName.equals("DirPresentation")) {
            this.dirObject_d = qName;
            this.dirPresentationContainer_d = new DirPresentationContainer();
        } else if (qName.equals("Directory")) {
            this.dirObject_d = qName;
            this.directoryContainer_d = new DirectoryContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createDirObjects(int size, ArrayList<DirObjectContainer> dirObjectContainer, ArrayList<DirObjectContainer> dirHumanParticipantContainer, ArrayList<DirObjectContainer> dirOrganizationalGroupContainer) throws DirectoryImportException {
        HashMap<DirObjectContainer, Exception> exceptions = new HashMap<DirObjectContainer, Exception>(size);
        while (!this.ouTree_d.isEmpty()) {
            String first = this.ouTree_d.first();
            DirObjectContainer ou = this.ouMap_d.get(first);
            try {
                ou.create();
            }
            catch (DirectoryException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(ou, ex);
            }
            catch (DirectoryRuntimeException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(ou, ex);
            }
            finally {
                this.ouTree_d.remove(first);
            }
        }
        for (DirObjectContainer actual : dirObjectContainer) {
            try {
                actual.create();
            }
            catch (DirObjectAlreadyExistsException ignore) {
            }
            catch (DirectoryException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
            catch (DirectoryRuntimeException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
        }
        for (DirObjectContainer actual : dirHumanParticipantContainer) {
            try {
                actual.create();
            }
            catch (DirectoryException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
            catch (DirectoryRuntimeException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
        }
        for (DirObjectContainer actual : dirOrganizationalGroupContainer) {
            try {
                actual.create();
            }
            catch (DirectoryException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
            catch (DirectoryRuntimeException ex) {
                if (Log.isDebugging()) {
                    Log.logDebug(ex);
                }
                exceptions.put(actual, ex);
            }
        }
        if (exceptions.size() > 0) {
            throw CouldNotImportObjectsException.groupImportExceptions(this.getDirectorySession().getDirectoryId(), this.getFileName(), exceptions);
        }
        File file = null;
        try {
            if (this.generatePassFile_d) {
                file = this.passFileOutputDir != null ? new File(this.passFileOutputDir, OUTPUTFILENAME) : new File(OUTPUTFILENAME);
                File parent = file.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                FileWriter writer = new FileWriter(file);
                writer.write(this.outputData_d);
                writer.flush();
                writer.close();
            }
        }
        catch (IOException e) {
            throw DirectoryImportException.ioExceptionOnGeneratePasswords(this.getDirectorySession().getDirectoryId(), file.getPath(), e);
        }
    }

    protected DirectorySession<? extends Object> getDirectorySession() {
        return this.dirSession_d;
    }

    protected String getFileName() {
        return this.inFileName_d;
    }

    private static String modifyPackageName(String properties) {
        if (properties.indexOf(FUEGOTECH_PACKAGE) > -1) {
            properties = Str.replaceString(properties, FUEGOTECH_PACKAGE, FUEGO_PACKAGE);
        }
        return properties;
    }

    private InputStream getInputStream() throws FileNotFoundException {
        if (this.is == null) {
            this.is = new FileInputStream(new File(this.getFileName()));
        }
        return this.is;
    }

    private void storePropertyInternal(DirObject o, String category, String key, String value) throws DirectoryException {
        o.storeProperty("NO_CATEGORY".equals(category) ? null : category, key, (Serializable)((Object)value));
    }

    public final class DirViewContainer
    extends DirObjectContainer {
        public String category;
        public String key;
        public ArrayList<String> processes;
        public String properties;
        public ArrayList<String> roles;
        public int type;
        public String value;
        public List<Property> viewProperties;

        public DirViewContainer() {
            super("DirView", FDIImport.this.locator.getLineNumber());
            this.roles = new ArrayList();
            this.processes = new ArrayList();
            this.viewProperties = new ArrayList<Property>();
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirView fetch = null;
            if (!this.id.equals("")) {
                fetch = DirView.fetch(FDIImport.this.getDirectorySession(), this.id);
                if (fetch == null) {
                    fetch = DirView.create(FDIImport.this.getDirectorySession(), this.id, this.type, this.processes.toArray(new String[this.processes.size()]), this.roles.toArray(new String[this.roles.size()]), this.properties);
                } else {
                    fetch.setProcesses(this.processes.toArray(new String[this.processes.size()]));
                    fetch.setRoles(this.roles.toArray(new String[this.roles.size()]));
                    fetch.setProperties(this.properties);
                    fetch.update();
                }
            }
            return fetch;
        }

        @Override
        public void insertProperties() throws DirectoryException {
            DirView fetch = DirView.fetch(FDIImport.this.getDirectorySession(), this.id);
            if (fetch != null) {
                Property[] propertiesToStore;
                for (Property property : propertiesToStore = this.viewProperties.toArray(new Property[this.viewProperties.size()])) {
                    FDIImport.this.storePropertyInternal(fetch, property.category, property.key, property.value);
                }
            }
        }
    }

    public final class DirReferralContainer
    extends DirObjectContainer {
        public String organization;
        public String properties;

        public DirReferralContainer() {
            super("DirReferral", FDIImport.this.locator.getLineNumber());
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirReferral fetch = null;
            if (!this.organization.equals("")) {
                fetch = DirReferral.fetch(FDIImport.this.getDirectorySession(), this.organization);
                if (fetch == null) {
                    fetch = DirReferral.create(FDIImport.this.getDirectorySession(), this.organization, this.properties);
                } else {
                    fetch.setProperties(this.properties);
                    fetch.update();
                }
            }
            return fetch;
        }
    }

    public final class DirProcessVariableContainer
    extends DirObjectContainer {
        public String category;
        public String key;
        public String locale;
        public ArrayList<DirProcessVariable.LocalizedMessage> localizedMessages;
        public String mask;
        public String message;
        public List<Property> properties;
        public String size;
        public String type;
        public String value;

        public DirProcessVariableContainer() {
            super("DirProcessVariable", FDIImport.this.locator.getLineNumber());
            this.localizedMessages = new ArrayList();
            this.properties = new ArrayList<Property>();
        }

        @Override
        public DirObject create() throws DirectoryException {
            Property[] propertiesToStore;
            DirProcessVariable fetch = null;
            if (!this.id.equals("")) {
                fetch = DirProcessVariable.fetch(FDIImport.this.getDirectorySession(), this.id);
                if (fetch == null) {
                    fetch = DirProcessVariable.create(FDIImport.this.getDirectorySession(), this.id, this.type, this.size, this.mask, this.localizedMessages.toArray(new DirProcessVariable.LocalizedMessage[this.localizedMessages.size()]));
                } else {
                    fetch.setLocalizedDisplayNames(this.localizedMessages.toArray(new DirProcessVariable.LocalizedMessage[this.localizedMessages.size()]));
                    fetch.setMask(this.mask);
                    fetch.setSize(this.size);
                    fetch.setType(this.type);
                    fetch.update();
                }
            }
            for (Property property : propertiesToStore = this.properties.toArray(new Property[this.properties.size()])) {
                if (!property.category.equals("BUSINESS_VARIABLE")) continue;
                FDIImport.this.storePropertyInternal(fetch, property.category, property.key, property.value);
            }
            return fetch;
        }

        @Override
        public void insertProperties() throws DirectoryException {
            DirProcessVariable fetch = DirProcessVariable.fetch(FDIImport.this.dirSession_d, this.id);
            if (fetch != null) {
                Property[] propertiesToStore;
                for (Property property : propertiesToStore = this.properties.toArray(new Property[this.properties.size()])) {
                    if (property.category.equals("BUSINESS_VARIABLE")) continue;
                    FDIImport.this.storePropertyInternal(fetch, property.category, property.key, property.value);
                }
            }
        }
    }

    public final class DirPresentationContainer
    extends DirObjectContainer {
        public String properties;
        public int type;

        public DirPresentationContainer() {
            super("DirPresentation", FDIImport.this.locator.getLineNumber());
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirPresentation fetch = null;
            if (!this.id.equals("")) {
                fetch = DirPresentation.fetch(FDIImport.this.getDirectorySession(), this.id);
                if (fetch == null) {
                    fetch = DirPresentation.create(FDIImport.this.getDirectorySession(), this.id, this.type, this.properties);
                } else {
                    fetch.setProperties(this.properties);
                    fetch.update();
                }
            }
            return fetch;
        }
    }

    public final class DirOrganizationalUnitContainer
    extends DirObjectContainer {
        public String description;
        public String name;
        public String parentId;

        public DirOrganizationalUnitContainer() {
            super("DirOrganizationalUnit", FDIImport.this.locator.getLineNumber());
            this.description = null;
            this.name = null;
            this.parentId = null;
        }

        public String getId() {
            return (this.parentId == null || this.parentId.equals("") ? "" : this.parentId + "/") + this.name;
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirOrganizationalUnit fetch = null;
            if (!this.name.equals("")) {
                fetch = DirOrganizationalUnit.fetch(FDIImport.this.getDirectorySession(), this.getId());
                if (fetch == null) {
                    DirOrganizationalUnit parentOU = this.parentId == null || this.parentId.equals("") ? DirOrganizationalUnit.fetchRoot(FDIImport.this.getDirectorySession()) : DirOrganizationalUnit.fetch(FDIImport.this.getDirectorySession(), this.parentId);
                    if (parentOU != null) {
                        fetch = parentOU.create(this.name, this.description);
                    } else {
                        Log.logWarning(DirectoryMsg.DII_00002(this.id, this.parentId));
                    }
                } else {
                    fetch.setDescription(this.description);
                    fetch.update();
                }
            }
            return fetch;
        }
    }

    public final class DirOrganizationalRoleContainer
    extends DirObjectContainer {
        public String calendarRuleNameCalendar;
        public String calendarRuleOu;
        public List<DirOrganizationalRole.CalendarRuleAssignment> calendarRules;
        public String category;
        public String description;
        public boolean isParametric;
        public String key;
        public String locale;
        public ArrayList<DirProcessVariable.LocalizedMessage> localizedMessages;
        public String message;
        public StringList parametricValues;
        public List<Property> properties;
        public String value;

        public DirOrganizationalRoleContainer() {
            super("DirOrganizationalRole", FDIImport.this.locator.getLineNumber());
            this.calendarRules = new ArrayList<DirOrganizationalRole.CalendarRuleAssignment>();
            this.properties = new ArrayList<Property>();
            this.parametricValues = StringList.create();
            this.localizedMessages = new ArrayList();
        }

        public List<DirOrganizationalRole.CalendarRuleAssignment> getCalendarRules() {
            return this.calendarRules;
        }

        public StringList getParametricValues() {
            return this.parametricValues;
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirOrganizationalRole fetch = null;
            if (!this.id.equals("")) {
                fetch = DirOrganizationalRole.fetch(FDIImport.this.getDirectorySession(), this.id);
                if (fetch == null) {
                    fetch = DirOrganizationalRole.create(FDIImport.this.getDirectorySession(), this.id, this.isParametric, this.description, this.parametricValues.toArray(new String[this.parametricValues.size()]), this.calendarRules.toArray(new DirOrganizationalRole.CalendarRuleAssignment[this.calendarRules.size()]));
                    if (FDIImport.this.getDirectorySession().supports().rolesLocalizedMessages()) {
                        fetch.setLocalizedDisplayNames(this.localizedMessages.toArray(new DirProcessVariable.LocalizedMessage[this.localizedMessages.size()]));
                        fetch.update();
                    }
                } else {
                    if (fetch.isParametric() != this.isParametric) {
                        throw DirectoryImportException.roleExistsAndParametricDiffers(this.id, fetch.isParametric());
                    }
                    fetch.setCalendarRulesAssignment(this.calendarRules.toArray(new DirOrganizationalRole.CalendarRuleAssignment[this.calendarRules.size()]));
                    fetch.setDescription(this.description);
                    if (fetch.isParametric()) {
                        fetch.setParametricValues(this.parametricValues.toArray(new String[this.parametricValues.size()]));
                    }
                    if (FDIImport.this.getDirectorySession().supports().rolesLocalizedMessages()) {
                        fetch.setLocalizedDisplayNames(this.localizedMessages.toArray(new DirProcessVariable.LocalizedMessage[this.localizedMessages.size()]));
                    }
                    fetch.update();
                }
            }
            return fetch;
        }

        @Override
        public void insertProperties() throws DirectoryException {
            DirOrganizationalRole fetch = DirOrganizationalRole.fetch(FDIImport.this.getDirectorySession(), this.id);
            if (fetch != null) {
                Property[] propertiesToStore;
                for (Property property : propertiesToStore = this.properties.toArray(new Property[this.properties.size()])) {
                    FDIImport.this.storePropertyInternal(fetch, property.category, property.key, property.value);
                }
            }
        }
    }

    public final class DirOrganizationalGroupContainer
    extends DirObjectContainer {
        public boolean allowRolesAssigned;
        public ArrayList<String> assignedGroups;
        public ArrayList<String> assignedParticipants;
        public int assignmentRoleCategory;
        public String category;
        public String description;
        public String displayName;
        public String key;
        public String ou;
        public String parametricValue;
        public int permissions;
        public List<Property> properties;
        public String roleId;
        public ArrayList<DirHumanParticipant.RoleAssignment> rolesAssignment;
        public String status;
        public String value;

        public DirOrganizationalGroupContainer() {
            super("DirOrganizationalGroup", FDIImport.this.locator.getLineNumber());
            this.rolesAssignment = new ArrayList();
            this.assignedGroups = new ArrayList();
            this.assignedParticipants = new ArrayList();
            this.properties = new ArrayList<Property>();
        }

        public List<String> getAssignedGroups() {
            return this.assignedGroups;
        }

        public List<String> getAssignedParticipants() {
            return this.assignedParticipants;
        }

        public List<DirHumanParticipant.RoleAssignment> getRolesAssignment() {
            return this.rolesAssignment;
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirOrganizationalGroup group = null;
            if (!this.id.equals("")) {
                group = DirOrganizationalGroup.fetch(FDIImport.this.getDirectorySession(), this.id);
                String orgUnit = this.ou != null ? this.ou : DirOrganizationalUnit.getRootId();
                String string = this.displayName = this.displayName == null ? this.id : this.displayName;
                if (group == null) {
                    group = DirOrganizationalGroup.create(FDIImport.this.getDirectorySession(), this.id, this.displayName, this.description, this.assignedParticipants.toArray(new String[this.assignedParticipants.size()]), this.assignedGroups.toArray(new String[this.assignedGroups.size()]), this.allowRolesAssigned, true, orgUnit);
                } else {
                    group.setDisplayName(this.displayName);
                    group.setDescription(this.description);
                    group.setAssignedParticipants(this.assignedParticipants.toArray(new String[this.assignedParticipants.size()]));
                    group.setAssignedGroups(this.assignedGroups.toArray(new String[this.assignedGroups.size()]));
                    group.setAllowRolesAssigned(this.allowRolesAssigned);
                    group.setEnabled(!"D".equalsIgnoreCase(this.status));
                    group.setOU(orgUnit);
                }
                ArrayList<DirHumanParticipant.RoleAssignment> newRolesAssignment = new ArrayList<DirHumanParticipant.RoleAssignment>();
                for (DirHumanParticipant.RoleAssignment roleAssignment : this.rolesAssignment) {
                    DirOrganizationalRole role = DirOrganizationalRole.fetch(FDIImport.this.getDirectorySession(), roleAssignment.role);
                    if (role == null) continue;
                    int roleIn = role.isParametric() ? role.getParametricIn(roleAssignment.parametricValue) : role.getIn();
                    newRolesAssignment.add(new DirHumanParticipant.RoleAssignment(roleAssignment.role, roleAssignment.parametricValue, roleAssignment.permissions, roleIn, roleAssignment.category));
                }
                if (group.isAllowRolesAssigned()) {
                    group.setRolesAssignment(newRolesAssignment.toArray(new DirHumanParticipant.RoleAssignment[newRolesAssignment.size()]));
                }
                group.update();
            }
            return group;
        }

        @Override
        public void insertProperties() throws DirectoryException {
            Property[] propertiesToStore;
            DirOrganizationalGroup group = DirOrganizationalGroup.fetch(FDIImport.this.dirSession_d, this.id);
            for (Property property : propertiesToStore = this.properties.toArray(new Property[this.properties.size()])) {
                FDIImport.this.storePropertyInternal(group, property.category, property.key, property.value);
            }
        }
    }

    public final class DirHumanParticipantContainer
    extends DirObjectContainer {
        public ArrayList<DirHumanParticipant.Absence> absences;
        public String administratedOuName;
        public ArrayList<String> administratedOus;
        public int assignmentRoleCategory;
        public String category;
        public String displayName;
        public String fax;
        public String firstName;
        public Time from;
        public String key;
        public String lastName;
        public String mail;
        public DirOrganizationalUnit ou;
        public String ouId;
        public String parametricValue;
        public int participantPermissions;
        public String password;
        public List<Property> properties;
        public String receivesMail;
        public List<String> replacement;
        public String roleId;
        public int rolePermissions;
        public ArrayList<DirHumanParticipant.RoleAssignment> rolesAssignment;
        public String status;
        public String telephone;
        public Time to;
        public String value;

        public DirHumanParticipantContainer() {
            super("DirHumanParticipant", FDIImport.this.locator.getLineNumber());
            this.rolesAssignment = new ArrayList();
            this.absences = new ArrayList();
            this.properties = new ArrayList<Property>();
            this.replacement = new ArrayList<String>();
            this.administratedOus = new ArrayList();
        }

        public List<DirHumanParticipant.Absence> getAbsences() {
            return this.absences;
        }

        public List<String> getReplacements() {
            return this.replacement;
        }

        public List<DirHumanParticipant.RoleAssignment> getRolesAssignment() {
            return this.rolesAssignment;
        }

        public ArrayList<String> getAdministratedOus() {
            return this.administratedOus;
        }

        public String getAdministratedOuName() {
            return this.administratedOuName;
        }

        public void setAdministratedOuName(String administratedOuName) {
            this.administratedOuName = administratedOuName;
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirHumanParticipant dirHumanParticipant = null;
            if (!this.id.equals("")) {
                if (this.status == null) {
                    this.status = "A";
                }
                if (!this.status.equals("R")) {
                    DirHumanParticipant.RoleAssignment[] oldRoles;
                    ArrayList<DirHumanParticipant.RoleAssignment> newRoles = new ArrayList<DirHumanParticipant.RoleAssignment>();
                    ArrayList<String> newRolesId = new ArrayList<String>();
                    for (DirHumanParticipant.RoleAssignment oldRole : oldRoles = this.rolesAssignment.toArray(new DirHumanParticipant.RoleAssignment[this.rolesAssignment.size()])) {
                        DirOrganizationalRole role = DirOrganizationalRole.fetch(FDIImport.this.getDirectorySession(), oldRole.role);
                        if (role == null) {
                            throw DirectoryImportException.roleDoesNotExistInAssignment(oldRole.role);
                        }
                        int roleIn = role.isParametric() ? role.getParametricIn(oldRole.parametricValue) : role.getIn();
                        newRoles.add(new DirHumanParticipant.RoleAssignment(oldRole.role, oldRole.parametricValue, oldRole.permissions, roleIn, oldRole.category));
                        newRolesId.add(oldRole.role);
                    }
                    if (this.ouId == null) {
                        this.ou = DirOrganizationalUnit.fetchRoot(FDIImport.this.getDirectorySession());
                    } else {
                        this.ou = DirOrganizationalUnit.fetch(FDIImport.this.getDirectorySession(), this.ouId);
                        if (this.ou == null) {
                            Log.logWarning(DirectoryMsg.DII_00004(this.ouId, this.id));
                            this.ou = DirOrganizationalUnit.fetchRoot(FDIImport.this.getDirectorySession());
                        }
                    }
                    if (this.password == null || this.password.length() == 0) {
                        this.password = String.valueOf(Math.abs(FDIImport.this.random.nextInt()));
                        FDIImport.this.outputData_d = FDIImport.this.outputData_d + this.id + ":" + this.password + ":" + this.mail + "\n";
                    } else {
                        FDIImport.this.outputData_d = FDIImport.this.outputData_d + this.id + ":........:" + this.mail + "\n";
                    }
                    dirHumanParticipant = DirHumanParticipant.fetch(FDIImport.this.getDirectorySession(), this.id);
                    if (dirHumanParticipant == null) {
                        try {
                            dirHumanParticipant = DirHumanParticipant.create(FDIImport.this.getDirectorySession(), this.id, this.firstName, this.lastName, this.displayName, this.mail, this.telephone, this.fax, this.password, this.ou, newRoles.toArray(new DirHumanParticipant.RoleAssignment[newRoles.size()]), this.participantPermissions, !"D".equalsIgnoreCase(this.status));
                            dirHumanParticipant.setAdministrator("S".equals(this.status));
                            dirHumanParticipant.update();
                        }
                        catch (OperationNotSupportedException onse) {
                            DirHumanParticipant[] dirHumanParticipants = DirHumanParticipant.fetchMatchingName(FDIImport.this.getDirectorySession(), this.displayName, 1);
                            if (dirHumanParticipants != null && dirHumanParticipants.length == 1) {
                                dirHumanParticipant = dirHumanParticipants[0];
                            }
                            throw onse;
                        }
                    } else {
                        DirHumanParticipant.RoleAssignment[] rolesAssignment;
                        dirHumanParticipant.setLastName(this.lastName);
                        dirHumanParticipant.setFirstName(this.firstName);
                        dirHumanParticipant.setDisplayName(this.displayName);
                        dirHumanParticipant.setMail(this.mail);
                        dirHumanParticipant.setFax(this.fax);
                        dirHumanParticipant.setTelephone(this.telephone);
                        if (FDIImport.this.getDirectorySession().supports().changeParticipantOU()) {
                            dirHumanParticipant.setOU(this.ou);
                        }
                        dirHumanParticipant.setPermissions(this.participantPermissions);
                        for (DirHumanParticipant.RoleAssignment roleAssignment : rolesAssignment = dirHumanParticipant.getRolesAssignment()) {
                            if (newRolesId.contains(roleAssignment.role)) continue;
                            newRoles.add(roleAssignment);
                        }
                        dirHumanParticipant.setRolesAssignment(newRoles.toArray(new DirHumanParticipant.RoleAssignment[newRoles.size()]));
                        dirHumanParticipant.setEnabled(!"D".equalsIgnoreCase(this.status));
                        dirHumanParticipant.setAdministrator("S".equals(this.status));
                        dirHumanParticipant.update();
                    }
                    if (this.getAbsences().size() > 0) {
                        dirHumanParticipant.setAbsencePeriods(this.getAbsences().toArray(new DirHumanParticipant.Absence[this.getAbsences().size()]));
                        dirHumanParticipant.update();
                    }
                    if (!this.getAdministratedOus().isEmpty()) {
                        String[] administeredOUs = this.getAdministratedOus().toArray(new String[this.getAdministratedOus().size()]);
                        dirHumanParticipant.changeAdministeredOUs(administeredOUs);
                    }
                    dirHumanParticipant.storeProperty("prefs", "mail", (Serializable)((Object)Boolean.valueOf(this.receivesMail).toString()));
                }
            }
            return dirHumanParticipant;
        }

        @Override
        public void insertProperties() throws DirectoryException {
            DirHumanParticipant fetch = DirHumanParticipant.fetch(FDIImport.this.dirSession_d, this.id);
            if (fetch != null) {
                Property[] propertiesToStore;
                for (Property property : propertiesToStore = this.properties.toArray(new Property[this.properties.size()])) {
                    FDIImport.this.storePropertyInternal(fetch, property.category, property.key, property.value);
                }
            }
        }
    }

    public final class DirHolidayRuleContainer
    extends DirObjectContainer {
        public String properties;

        public DirHolidayRuleContainer() {
            super("DirHolidayRule", FDIImport.this.locator.getLineNumber());
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirHolidayRule fetch = null;
            if (!this.id.equals("")) {
                fetch = DirHolidayRule.fetch(FDIImport.this.getDirectorySession(), this.id);
                if (fetch == null) {
                    fetch = DirHolidayRule.create(FDIImport.this.getDirectorySession(), this.id, this.properties);
                } else {
                    fetch.setProperties(this.properties);
                    fetch.update();
                }
            }
            return fetch;
        }
    }

    public final class DirectoryContainer
    extends DirObjectContainer {
        public String category;
        public String key;
        public List<Property> properties;
        public String value;

        public DirectoryContainer() {
            super("Directory", FDIImport.this.locator.getLineNumber());
            this.properties = new ArrayList<Property>();
        }

        @Override
        public void insertProperties() throws DirectoryException {
            Property[] propertiesToStore;
            for (Property property : propertiesToStore = this.properties.toArray(new Property[this.properties.size()])) {
                Directory.storeProperty(FDIImport.this.getDirectorySession(), "NO_CATEGORY".equals(property.category) ? null : property.category, property.key, property.value);
            }
        }
    }

    public final class DirCalendarRuleContainer
    extends DirObjectContainer {
        public ArrayList<String> ous;
        public String properties;

        public DirCalendarRuleContainer() {
            super("DirCalendarRule", FDIImport.this.locator.getLineNumber());
            this.ous = new ArrayList();
        }

        public List<String> getOus() {
            return this.ous;
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirCalendarRule fetch = null;
            if (!this.id.equals("")) {
                fetch = DirCalendarRule.fetch(FDIImport.this.getDirectorySession(), this.id);
                if (fetch == null) {
                    fetch = DirCalendarRule.create(FDIImport.this.getDirectorySession(), this.id, this.properties);
                } else {
                    fetch.setProperties(this.properties);
                }
                fetch.setOUs(this.ous.toArray(new String[this.ous.size()]));
                fetch.update();
            }
            return fetch;
        }
    }

    public final class DirBusinessParameterContainer
    extends DirObjectContainer {
        public String defaultValue;
        public String key;
        public String size;
        public String type;
        public String value;
        private Map<String, String> values;

        public DirBusinessParameterContainer() {
            super("DirBusinessParameter", FDIImport.this.locator.getLineNumber());
            this.values = new HashMap<String, String>();
        }

        @Override
        public DirObject create() throws DirectoryException {
            DirBusinessParameter fetch = null;
            if (!this.id.equals("")) {
                fetch = DirBusinessParameter.fetch(FDIImport.this.getDirectorySession(), this.id);
                if (fetch == null) {
                    fetch = DirBusinessParameter.create(FDIImport.this.getDirectorySession(), this.id, this.type, this.size, this.defaultValue, this.values);
                } else {
                    fetch.setValues(this.values);
                    fetch.setDefaultValue(this.defaultValue);
                    fetch.setSize(this.size);
                    fetch.setType(this.type);
                    fetch.update();
                }
            }
            return fetch;
        }

        public void addValue(String key, String value) {
            this.values.put(key, value);
        }
    }

    public static final class Property {
        public final String category;
        public final String key;
        public final String value;

        public Property(String category, String key, String value) {
            this.category = category;
            this.key = key;
            this.value = value;
        }
    }

    public static abstract class DirObjectContainer {
        public String id;
        int lineNumber;
        String objectClass;

        public DirObjectContainer(String objectClass, int lineNumber) {
            this.objectClass = objectClass;
            this.lineNumber = lineNumber;
        }

        public DirObject create() throws DirectoryException {
            return null;
        }

        public void insertProperties() throws DirectoryException {
        }

        public String toString() {
            return this.objectClass + " in line: " + this.lineNumber;
        }
    }
}

