/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.util;

import fuego.directory.DirBusinessParameter;
import fuego.directory.DirCalendarRule;
import fuego.directory.DirHolidayRule;
import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirObjectList;
import fuego.directory.DirOrganizationalGroup;
import fuego.directory.DirOrganizationalRole;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.DirPresentation;
import fuego.directory.DirProcessVariable;
import fuego.directory.DirReferral;
import fuego.directory.DirView;
import fuego.directory.DirectoryProperty;
import fuego.directory.DirectorySession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.TreeMap;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Literals;
import oracle.bpm.xml.XmlWriter;

public class FDIExport {
    private String charsetName = Literals.DEFAULT_ENCODING;
    private final DirObjectList directoryObjects = DirObjectList.create();
    private final StringList directoryPropertiesCategories;
    private int exportedObjects;
    private String fileName_d = null;
    private final StringList groupPropertiesCategories;
    private final String organizationName;
    private final StringList participantPropertiesCategories;
    private final StringList processVariableCategories;
    private final StringList rolePropertiesCategories;
    private final String schemaId;
    private final String schemaVersion;
    private DirectorySession session;
    private final StringList viewPropertiesCategories;
    public static final String ELEM_FDI_OBJECT = "FDIObject";

    public FDIExport(DirectorySession session) {
        this(session, null, null, null, null, null, null);
    }

    public FDIExport(String fileName, DirectorySession session) {
        this(fileName, session, null, null, null, null, null, null);
    }

    public FDIExport(DirectorySession session, StringList participantPropertiesCategories, StringList rolePropertiesCategories, StringList groupPropertiesCategories, StringList directoryPropertiesCategories, StringList processVariableCategories, StringList viewPropertiesCategories) {
        this.schemaVersion = session.getSchemaVersion();
        this.schemaId = session.getSchemaId();
        this.organizationName = session.getOrganizationName();
        this.participantPropertiesCategories = participantPropertiesCategories;
        this.rolePropertiesCategories = rolePropertiesCategories;
        this.viewPropertiesCategories = viewPropertiesCategories;
        this.groupPropertiesCategories = groupPropertiesCategories;
        this.directoryPropertiesCategories = directoryPropertiesCategories;
        this.processVariableCategories = processVariableCategories;
        this.session = session;
    }

    public FDIExport(String fileName, DirectorySession session, StringList participantPropertiesCategories, StringList rolePropertiesCategories, StringList groupPropertiesCategories, StringList directoryPropertiesCategories, StringList processVariableCategories, StringList viewPropertiesCategories) {
        this(session, participantPropertiesCategories, rolePropertiesCategories, groupPropertiesCategories, directoryPropertiesCategories, processVariableCategories, viewPropertiesCategories);
        this.fileName_d = fileName;
    }

    public void setCharset(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getCharset() {
        return this.charsetName;
    }

    public String getXML() throws IOException {
        if (this.fileName_d != null) {
            throw new UnsupportedOperationException();
        }
        return this.getXMLString();
    }

    public void add(DirObject o) {
        this.getDirObjects().add(o);
    }

    public void add(Collection<DirObject> objects) {
        this.getDirObjects().addAll(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int printXML() throws IOException {
        File file = new File(this.fileName_d);
        File parent = file.getParentFile();
        FileOutputStream fileOutputStream = null;
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, this.charsetName);
            this.exportedObjects = 0;
            String xml = this.getXMLString();
            writer.write(xml);
            writer.flush();
            writer.close();
            int n = this.exportedObjects;
            return n;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public int size() {
        return this.getDirObjects().size();
    }

    public void addAll(DirObject[] objects) {
        for (DirObject object : objects) {
            this.getDirObjects().add(object);
        }
    }

    protected DirectorySession getSession() {
        return this.session;
    }

    private DirObjectList getDirObjects() {
        return this.directoryObjects;
    }

    private String getXMLString() throws IOException {
        TreeMap<String, DirHolidayRule> holidays = new TreeMap<String, DirHolidayRule>();
        TreeMap<String, DirCalendarRule> calendars = new TreeMap<String, DirCalendarRule>();
        TreeMap<String, DirOrganizationalUnit> ous = new TreeMap<String, DirOrganizationalUnit>();
        TreeMap<Integer, DirOrganizationalRole> roles = new TreeMap<Integer, DirOrganizationalRole>();
        TreeMap<Integer, DirHumanParticipant> participants = new TreeMap<Integer, DirHumanParticipant>();
        TreeMap<Integer, DirOrganizationalGroup> groups = new TreeMap<Integer, DirOrganizationalGroup>();
        TreeMap<Integer, DirProcessVariable> variables = new TreeMap<Integer, DirProcessVariable>();
        TreeMap<String, DirBusinessParameter> busParams = new TreeMap<String, DirBusinessParameter>();
        TreeMap<Integer, DirReferral> referrals = new TreeMap<Integer, DirReferral>();
        TreeMap<String, DirView> views = new TreeMap<String, DirView>();
        TreeMap<String, DirPresentation> presentations = new TreeMap<String, DirPresentation>();
        DirectoryProperty dirProperty = null;
        for (DirObject object : this.getDirObjects()) {
            if (object instanceof DirHolidayRule) {
                this.printPrevious(holidays.put(object.getId(), (DirHolidayRule)object));
                continue;
            }
            if (object instanceof DirCalendarRule) {
                this.printPrevious(calendars.put(object.getId(), (DirCalendarRule)object));
                continue;
            }
            if (object instanceof DirOrganizationalUnit) {
                this.printPrevious(ous.put(object.getId(), (DirOrganizationalUnit)object));
                continue;
            }
            if (object instanceof DirOrganizationalRole) {
                this.printPrevious(roles.put(object.getIn(), (DirOrganizationalRole)object));
                continue;
            }
            if (object instanceof DirHumanParticipant) {
                this.printPrevious(participants.put(object.getIn(), (DirHumanParticipant)object));
                continue;
            }
            if (object instanceof DirOrganizationalGroup) {
                this.printPrevious(groups.put(object.getIn(), (DirOrganizationalGroup)object));
                continue;
            }
            if (object instanceof DirProcessVariable) {
                this.printPrevious(variables.put(object.getIn(), (DirProcessVariable)object));
                continue;
            }
            if (object instanceof DirBusinessParameter) {
                this.printPrevious(busParams.put(object.getId(), (DirBusinessParameter)object));
                continue;
            }
            if (object instanceof DirReferral) {
                this.printPrevious(referrals.put(object.getIn(), (DirReferral)object));
                continue;
            }
            if (object instanceof DirView) {
                this.printPrevious(views.put(object.getId(), (DirView)object));
                continue;
            }
            if (object instanceof DirPresentation) {
                this.printPrevious(presentations.put(object.getId(), (DirPresentation)object));
                continue;
            }
            if (!(object instanceof DirectoryProperty)) continue;
            dirProperty = (DirectoryProperty)object;
        }
        StringWriter writer = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(writer, this.charsetName);
        xmlWriter.startDocument();
        xmlWriter.startElement(ELEM_FDI_OBJECT);
        xmlWriter.printAttribute("SchemaVersion", this.schemaVersion);
        xmlWriter.printAttribute("SchemaId", this.schemaId);
        xmlWriter.printAttribute("Organization", this.organizationName);
        for (String id : holidays.keySet()) {
            ((DirHolidayRule)holidays.get(id)).writeXML(xmlWriter);
            ++this.exportedObjects;
        }
        for (String id : calendars.keySet()) {
            ((DirCalendarRule)calendars.get(id)).writeXML(xmlWriter);
            ++this.exportedObjects;
        }
        for (String id : ous.keySet()) {
            ((DirOrganizationalUnit)ous.get(id)).writeXML(xmlWriter);
            ++this.exportedObjects;
        }
        for (Integer in : roles.keySet()) {
            ((DirOrganizationalRole)roles.get(in)).writeXML(xmlWriter, this.rolePropertiesCategories);
            ++this.exportedObjects;
        }
        for (Integer in : participants.keySet()) {
            ((DirHumanParticipant)participants.get(in)).writeXML(xmlWriter, this.participantPropertiesCategories);
            ++this.exportedObjects;
        }
        for (Integer in : groups.keySet()) {
            ((DirOrganizationalGroup)groups.get(in)).writeXML(xmlWriter, this.groupPropertiesCategories);
            ++this.exportedObjects;
        }
        for (Integer in : variables.keySet()) {
            ((DirProcessVariable)variables.get(in)).writeXML(xmlWriter, this.processVariableCategories);
            ++this.exportedObjects;
        }
        for (String id : busParams.keySet()) {
            ((DirBusinessParameter)busParams.get(id)).writeXML(xmlWriter);
            ++this.exportedObjects;
        }
        for (Integer in : referrals.keySet()) {
            ((DirReferral)referrals.get(in)).writeXML(xmlWriter);
            ++this.exportedObjects;
        }
        for (String id : views.keySet()) {
            ((DirView)views.get(id)).writeXML(xmlWriter, this.viewPropertiesCategories);
            ++this.exportedObjects;
        }
        for (String id : presentations.keySet()) {
            ((DirPresentation)presentations.get(id)).writeXML(xmlWriter);
            ++this.exportedObjects;
        }
        if (dirProperty != null) {
            dirProperty.writeXML(xmlWriter, this.directoryPropertiesCategories);
            ++this.exportedObjects;
        }
        xmlWriter.endElement();
        xmlWriter.close();
        return writer.toString();
    }

    private void printPrevious(Object previous) {
        if (previous != null) {
            System.out.println("previous = " + previous);
        }
    }
}

