/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.provider.notifiers.DirectoryNotifier;

abstract class NotifierMode {
    boolean active;
    final DirectoryNotifier notifier;

    protected NotifierMode(DirectoryNotifier notifier) {
        this.notifier = notifier;
    }

    public abstract void switchToChangesMode();

    public abstract void switchToRecoveryMode();

    public static Changes createChangesMode(DirectoryNotifier notifier, boolean active) {
        if (active) {
            return new ActiveChanges(notifier);
        }
        return new PasiveChanges(notifier);
    }

    public static Recovery createRecoveryMode(DirectoryNotifier notifier, boolean active) {
        if (active) {
            return new ActiveRecovery(notifier);
        }
        return new PasiveRecovery(notifier);
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void startMode() {
        this.active = true;
    }

    protected void stopMode() {
        this.active = false;
    }

    static class PasiveRecovery
    extends Recovery {
        PasiveRecovery(DirectoryNotifier notifier) {
            super(notifier);
        }

        @Override
        protected void startMode() {
            this.notifier.initializeForListening();
            super.startMode();
        }

        @Override
        protected void stopMode() {
            this.notifier.stopListening();
            super.stopMode();
        }
    }

    static class PasiveChanges
    extends Changes {
        PasiveChanges(DirectoryNotifier notifier) {
            super(notifier);
        }

        @Override
        protected void startMode() {
            this.notifier.initializeForListening();
            super.startMode();
        }

        @Override
        protected void stopMode() {
            this.notifier.stopListening();
            super.stopMode();
        }
    }

    static class ActiveRecovery
    extends Recovery {
        private ActiveRecovery(DirectoryNotifier notifier) {
            super(notifier);
        }

        @Override
        protected void startMode() {
            this.notifier.startPolling();
            this.notifier.initializeForListening();
            super.startMode();
        }

        @Override
        protected void stopMode() {
            this.notifier.stopListening();
            super.stopMode();
        }
    }

    static class ActiveChanges
    extends Changes {
        private ActiveChanges(DirectoryNotifier notifier) {
            super(notifier);
        }

        @Override
        protected void startMode() {
            this.notifier.startPolling();
            this.notifier.initializeForListening();
            super.startMode();
        }

        @Override
        protected void stopMode() {
            this.notifier.stopListening();
            super.stopMode();
        }
    }

    public static abstract class Recovery
    extends NotifierMode {
        Recovery(DirectoryNotifier notifier) {
            super(notifier);
        }

        @Override
        public void switchToChangesMode() {
            this.switchMode();
        }

        @Override
        public void switchToRecoveryMode() {
        }

        private void switchMode() {
            this.stopMode();
            this.notifier.getChangesMode().startMode();
        }
    }

    public static abstract class Changes
    extends NotifierMode {
        Changes(DirectoryNotifier notifier) {
            super(notifier);
        }

        @Override
        public void switchToChangesMode() {
        }

        @Override
        public void switchToRecoveryMode() {
            this.switchMode();
        }

        private void switchMode() {
            this.stopMode();
            this.notifier.getRecoveryMode().startMode();
        }
    }
}

