/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.msg.DirectoryMsg;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.notifiers.Constants;
import fuego.directory.provider.notifiers.DirObjectType;
import fuego.directory.provider.notifiers.DirectoryEventGenerator;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;

public abstract class DirectoryEventGeneratorImpl
implements DirectoryEventGenerator,
Constants {
    private boolean listening;
    private final DirObjectType objectType;
    private final DirectorySessionImpl session;
    private Time timestamp;
    private Time timeStampBuffer;
    public static final long TIMESTAMP_DELTA = 300000L;

    protected DirectoryEventGeneratorImpl(DirObjectType objectType, DirectorySessionImpl session) {
        this.objectType = objectType;
        this.session = session;
    }

    @Override
    public final DirObjectType getObjectType() {
        return this.objectType;
    }

    public DirectorySessionImpl getSession() {
        return this.session;
    }

    public void notifyServiceNotAvailable() {
        this.session.getDirectoryNotifierImpl().notifyServiceNotAvailable();
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public void setListening(boolean listening) {
        this.listening = listening;
    }

    protected Time getTimestamp() {
        return this.timestamp;
    }

    protected void initTimeStamps(Time time) {
        this.timestamp = time;
        this.timeStampBuffer = time;
    }

    protected void updateTimeStamp() {
        this.timestamp = this.timeStampBuffer;
    }

    protected void updateTimeStampBuffer(Time modifyTimeStamp, String objectInfo) {
        if (this.timeStampBuffer.compareTo(modifyTimeStamp) < 0) {
            this.timeStampBuffer = modifyTimeStamp;
            Time now = Time.now();
            if (this.timeStampBuffer.getMilliSeconds() - now.getMilliSeconds() > 300000L) {
                Log.logSevere(DirectoryMsg.JDBC_30000(objectInfo, this.timeStampBuffer, now));
            }
        }
    }
}

