/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Preferences {
    private Map<String, String> preferences = new HashMap<String, String>();

    public boolean contains(String key) {
        return this.isSingleValue(key) || this.isMultiValue(key);
    }

    public boolean isSingleValue(String key) {
        return this.preferences.containsKey(key);
    }

    public boolean isMultiValue(String key) {
        return this.preferences.containsKey(key + "." + 0);
    }

    public String getPreference(String key, String defaultValue) {
        String returnValue = this.getSingleValue(key);
        return returnValue == null ? defaultValue : returnValue;
    }

    public String getSingleValue(String key) {
        return this.preferences.get(key);
    }

    public List<String> getMultiValue(String key) {
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (this.contains(key + "." + i)) {
            results.add(this.getSingleValue(key + "." + i));
            ++i;
        }
        return results;
    }

    public List<String> getValue(String key) {
        List<String> result = null;
        if (this.isSingleValue(key)) {
            result = new ArrayList<String>();
            result.add(this.getSingleValue(key));
        } else if (this.isMultiValue(key)) {
            result = this.getMultiValue(key);
        }
        return result;
    }

    public void addValue(String key, String value) {
        this.preferences.put(key, value);
    }

    public Map<String, String> getPreferencesMap() {
        return Collections.unmodifiableMap(this.preferences);
    }
}

