/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider;

import fuego.directory.AuthenticationException;
import fuego.directory.CommunicationException;
import fuego.directory.DirectoryPassport;
import fuego.directory.DirectoryPropertiesProvider;
import fuego.directory.auth.AuthenticatorFactory;
import fuego.directory.exception.CouldNotCreateSchemaException;
import fuego.directory.exception.CouldNotDropSchemaException;
import fuego.directory.exception.ProtocolNotSupportedException;
import fuego.directory.provider.AttributeValidator;
import fuego.directory.provider.AuthenticationAccessor;
import fuego.directory.provider.DirectoryPersistenceManager;
import fuego.directory.provider.DirectoryPreferencesAccessor;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.DirectoryStatus;
import fuego.directory.provider.EngineAccessor;
import fuego.directory.provider.Factory;
import fuego.directory.provider.GroupAccessor;
import fuego.directory.provider.ObjectClassInstanceAccessor;
import fuego.directory.provider.ObjectPropertiesAccessor;
import fuego.directory.provider.OrganizationAccessor;
import fuego.directory.provider.ParticipantAccessor;
import fuego.directory.provider.ProcessAccessor;
import fuego.directory.provider.ProcessManagerAccessor;
import fuego.directory.provider.ProjectAccessor;
import fuego.directory.provider.SchemaCreationBean;
import fuego.directory.provider.TransactionSupport;
import fuego.directory.provider.ValidationAccessor;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.util.Properties;

public abstract class DelegatorFactory<T>
extends Factory<T> {
    private Map<String, Factory<T>> delegators = new HashMap<String, Factory<T>>();

    protected DelegatorFactory() {
    }

    @Override
    public void createSchema(Properties properties) throws CouldNotCreateSchemaException {
        this.getDelegator(this.getDirectoryId(properties)).createSchema(properties);
    }

    @Override
    public String getCreateSentences(String directoryId) {
        return this.getDelegator(directoryId).getCreateSentences(directoryId);
    }

    @Override
    public void dropSchema(Properties properties) throws CouldNotDropSchemaException {
        this.getDelegator(this.getDirectoryId(properties)).dropSchema(properties);
    }

    @Override
    public DirectoryStatus getDirectoryStatusFor(DirectoryPassport passport) throws AuthenticationException, CommunicationException {
        return this.getDelegator(passport.getId()).getDirectoryStatusFor(passport);
    }

    @Override
    public SchemaCreationBean createSchemaCreationBean(DirectoryPropertiesProvider directoryPropertiesProvider) {
        return this.getDelegator(directoryPropertiesProvider.getId()).createSchemaCreationBean(directoryPropertiesProvider);
    }

    @Override
    public String getPanelClassName() {
        return null;
    }

    @Override
    public void buildCreationSentences(String directoryId, Properties properties) {
        this.getDelegator(directoryId).buildCreationSentences(directoryId, properties);
    }

    @Override
    public void fillPassport(DirectoryPassport passport) throws AuthenticationException, CommunicationException {
        this.getDelegator(passport.getId()).fillPassport(passport);
    }

    @Override
    public Map<String, AuthenticatorFactory> getAuthMethods(String directoryId) {
        return this.getDelegator(directoryId).getAuthMethods(directoryId);
    }

    protected abstract Factory<T> loadDelegatorFactory(String var1) throws ProtocolNotSupportedException;

    protected Factory<T> getDelegator(String directoryId) {
        Factory<T> delegator = this.delegators.get(directoryId);
        if (delegator == null) {
            try {
                delegator = this.loadDelegatorFactory(directoryId);
                this.delegators.put(directoryId, delegator);
            }
            catch (ProtocolNotSupportedException e) {
                throw CommunicationException.wrapException(e);
            }
        }
        return delegator;
    }

    @Override
    protected AuthenticationAccessor createAuthenticationAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createAuthenticationAccessor(session);
    }

    @Override
    protected void createAuthFactories(String directoryId) {
        this.getDelegator(directoryId).createAuthFactories(directoryId);
    }

    @Override
    protected EngineAccessor createEngineAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createEngineAccessor(session);
    }

    @Override
    protected GroupAccessor createGroupAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createGroupAccessor(session);
    }

    @Override
    protected ObjectPropertiesAccessor createObjectPropertiesAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createObjectPropertiesAccessor(session);
    }

    @Override
    protected OrganizationAccessor createOrganizationAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createOrganizationAccessor(session);
    }

    @Override
    protected ProcessManagerAccessor createProcessManagerAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createProcessManagerAccessor(session);
    }

    @Override
    protected ObjectClassInstanceAccessor createObjectClassInstanceAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createObjectClassInstanceAccessor(session);
    }

    @Override
    protected ParticipantAccessor createParticipantAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createParticipantAccessor(session);
    }

    @Override
    protected DirectoryPersistenceManager createPersistenceManager(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createPersistenceManager(session);
    }

    @Override
    protected ProcessAccessor createProcessAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createProcessAccessor(session);
    }

    @Override
    protected ProjectAccessor createProjectAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createProjectAccessor(session);
    }

    @Override
    protected AttributeValidator createAttributeValidator(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createAttributeValidator(session);
    }

    @Override
    protected TransactionSupport createTransactionSupport(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createTransactionSupport(session);
    }

    @Override
    protected ValidationAccessor createValidationAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createValidationAccessor(session);
    }

    @Override
    protected void initializeSession(DirectorySessionImpl<T> session, DirectoryPassport passport) {
        this.getDelegator(session.getDirectoryId()).initializeSession(session, passport);
    }

    @Override
    protected DirectoryPreferencesAccessor createDirectoryPreferencesAccessor(DirectorySessionImpl<T> session) {
        return this.getDelegator(session.getDirectoryId()).createDirectoryPreferencesAccessor(session);
    }
}

