/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.exception;

import fuego.directory.DirHumanParticipant;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.msg.DirectoryMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public class InvalidAttributeValueException
extends DirectoryRuntimeException {
    static final long serialVersionUID = 907258894724366021L;
    static final long serialCheck = 6778150239738815607L;

    InvalidAttributeValueException(Msg msg) {
        super(msg);
    }

    public static InvalidAttributeValueException atLeastOneParametricValueRequired() {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00143);
    }

    public static InvalidAttributeValueException cannotAllowTheSameValueWithDifferentCases(String originalValue, String otherValue) {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00144(originalValue, otherValue));
    }

    public static InvalidAttributeValueException duplicateRoleAssignment(String object, DirHumanParticipant.RoleAssignment original, DirHumanParticipant.RoleAssignment duplicate) {
        String roleString = original.role + (original.parametricValue == null ? "" : "(" + original.parametricValue + ")");
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00142(object, roleString, DirHumanParticipant.castPermissionToString(original.permissions), DirHumanParticipant.castPermissionToString(duplicate.permissions)));
    }

    public static InvalidAttributeValueException groupRequiresParticipants() {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00703);
    }

    public static InvalidAttributeValueException invalidIdValue(String attributeName, String invalidValue, char invalidChar) {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00057(attributeName, invalidValue, invalidChar));
    }

    public static InvalidAttributeValueException invalidValue(@NonNls String attributeName, String invalidValue) {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00017(attributeName, invalidValue));
    }

    public static InvalidAttributeValueException invalidValue(String attributeName, String invalidValue, String reason) {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00017(attributeName, invalidValue));
    }

    public static InvalidAttributeValueException invalidValue(String attributeName, String invalidValue, char invalidChar) {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00057(attributeName, invalidValue, invalidChar));
    }

    public static InvalidAttributeValueException lengthNotAllowed(String attributeName, String invalidValue, int maxLength) {
        String showValue = invalidValue;
        if (invalidValue.length() > 20) {
            showValue = invalidValue.substring(0, 9) + "..." + invalidValue.substring(invalidValue.length() - 10);
        }
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00060(attributeName, showValue, invalidValue.length(), maxLength));
    }

    public static InvalidAttributeValueException valueEmpty(String attributeName) {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00058(attributeName));
    }

    public static InvalidAttributeValueException whitespaceNotAllowed(String attributeName, String invalidValue) {
        return new InvalidAttributeValueException(DirectoryMsg.DIR_00059(attributeName, invalidValue));
    }
}

