/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.auth;

import fuego.directory.auth.SecurityEnvironment;
import fuego.directory.auth.SecurityProvider;
import fuego.directory.auth.TokenValidator;

public enum AuthenticationType {
    TOKEN{

        @Override
        public int getSecurityLevel() {
            return 7;
        }

        @Override
        public TokenValidator createSecurityProvider(SecurityEnvironment environment) throws Exception {
            String className = environment.getTokenValidationClassName();
            Class<?> clazz = Class.forName(className);
            return (TokenValidator)clazz.newInstance();
        }
    }
    ,
    SIMPLE{

        @Override
        public SecurityProvider createSecurityProvider(SecurityEnvironment environment) throws Exception {
            return null;
        }

        @Override
        public int getSecurityLevel() {
            return 8;
        }
    }
    ,
    STUDIO{

        @Override
        public SecurityProvider createSecurityProvider(SecurityEnvironment environment) throws Exception {
            return null;
        }

        @Override
        public int getSecurityLevel() {
            return 8;
        }
    }
    ,
    TRUSTED{

        @Override
        public SecurityProvider createSecurityProvider(SecurityEnvironment environment) throws Exception {
            return null;
        }

        @Override
        public int getSecurityLevel() {
            return 9;
        }
    };


    public abstract int getSecurityLevel();

    public boolean hasHigherOrEqualSecurityLevel(int securityLevel) {
        return this.getSecurityLevel() <= securityLevel;
    }

    public abstract SecurityProvider createSecurityProvider(SecurityEnvironment var1) throws Exception;
}

