/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.Time;

class TimeMeter {
    private static Map<Integer, List<Long>> operations_sd = new HashMap<Integer, List<Long>>();
    private static ThreadLocal<Time> elapsed_sd = new ThreadLocal();
    private static ThreadLocal<Integer> key_sd = new ThreadLocal();
    public static final Integer START_SESSION = 0;
    public static final Integer START_ANONYMOUS_SESSION = 1;
    public static final Integer AUTHENTICATE = 2;
    public static final String FDI_PERFORMANCE_LOGGING = "FDI_PERFORMANCE_LOGGING";

    TimeMeter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOperationsNumber(Integer key) {
        Map<Integer, List<Long>> map = operations_sd;
        synchronized (map) {
            List<Long> operations = operations_sd.get(key);
            return operations != null ? operations.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getOperationsTime(Integer key) {
        Map<Integer, List<Long>> map = operations_sd;
        synchronized (map) {
            return operations_sd.get(key);
        }
    }

    public void begin(Integer key) {
        if (this.isLogging()) {
            elapsed_sd.set(Time.now());
            key_sd.set(key);
        }
    }

    public void end() {
        if (this.isLogging()) {
            Time now = Time.now();
            TimeMeter.addOperationTime(key_sd.get(), now.sub(elapsed_sd.get()).getMilliSeconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addOperationTime(Integer key, long value) {
        Map<Integer, List<Long>> map = operations_sd;
        synchronized (map) {
            if (key != null) {
                List<Long> operations = operations_sd.get(key);
                if (operations == null) {
                    operations = new ArrayList<Long>();
                    operations_sd.put(key, operations);
                }
                operations.add(value);
            }
        }
    }

    private boolean isLogging() {
        return Boolean.valueOf(System.getProperty(FDI_PERFORMANCE_LOGGING));
    }
}

