/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.AuthenticationException;
import fuego.directory.CommunicationException;
import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirectoryConfigurationManagerInterface;
import fuego.directory.DirectoryConfigurationManagerLocatorInterface;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryPassport;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.DirectorySession;
import fuego.directory.TimeMeter;
import fuego.directory.exception.CouldNotCheckAvailabilityException;
import fuego.directory.exception.CouldNotCleanSchemaException;
import fuego.directory.exception.CouldNotCreateSchemaException;
import fuego.directory.exception.CouldNotDropSchemaException;
import fuego.directory.exception.InvalidDirectorySessionException;
import fuego.directory.exception.InvalidSchemaException;
import fuego.directory.exception.ProtocolNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import fuego.directory.provider.Factory;
import java.util.Map;
import oracle.bpm.util.Properties;
import org.jetbrains.annotations.NonNls;

public class Directory {
    @NonNls
    private static final String DIRECTORY_CONFIGURATION_MANAGER_LOCATOR = "fuego.directory.DirectoryConfigurationManagerLocator";
    static TimeMeter timeMeter_sd = new TimeMeter();
    private static DirectoryConfigurationManagerLocatorInterface directoryConfigurationManagerLocatorInterface;

    private Directory() {
    }

    public static DirHumanParticipant authenticate(DirectoryPassport passport) throws ProtocolNotSupportedException, AuthenticationException, CommunicationException {
        timeMeter_sd.begin(TimeMeter.AUTHENTICATE);
        String participant = passport.getParticipant();
        if (participant == null || participant.trim().length() == 0) {
            throw AuthenticationException.participantIdIsWrong(passport.getId(), passport.getParticipant());
        }
        Factory sessionFactory = Factory.getDirectoryFactory(passport.getId());
        DirHumanParticipant result = sessionFactory.authenticate(passport);
        if (result == null) {
            throw AuthenticationException.error(passport.getId(), passport.getParticipant(), DirectoryMsg.DIR_00004_REASON_PARTICIPANT_NOT_FOUND);
        }
        timeMeter_sd.end();
        return result;
    }

    public static void cleanSchema(String protocol, Properties schemaProperties) throws CouldNotCleanSchemaException {
        try {
            Factory.getFactoryFor(protocol).cleanSchema(schemaProperties);
        }
        catch (ProtocolNotSupportedException e) {
            throw CouldNotCleanSchemaException.cleanException(e);
        }
    }

    public static void createSchema(String protocol, Properties schemaProperties) throws ProtocolNotSupportedException, CouldNotCreateSchemaException {
        String orgName = schemaProperties.getProperty("ORGNAME");
        DirectorySession.validateValue("Organization", orgName, DirObject.INVALID_EXTENDED_ID_CHARS);
        Factory.getFactoryFor(protocol).createSchema(schemaProperties);
    }

    public static void dropSchema(String protocol, Properties schemaProperties) throws ProtocolNotSupportedException, CouldNotDropSchemaException {
        Factory.getFactoryFor(protocol).dropSchema(schemaProperties);
    }

    public static void fillPassport(DirectoryPassport passport) throws ProtocolNotSupportedException, AuthenticationException, CommunicationException {
        Factory sessionFactory = Factory.getDirectoryFactory(passport.getId());
        sessionFactory.fillPassport(passport);
    }

    public static boolean isAvailable(String id) throws ProtocolNotSupportedException, DirectoryRuntimeException {
        try {
            DirectoryPassport passport = DirectoryPassport.createWithID(id);
            Directory.fillPassport(passport);
            return Directory.isAvailable(passport);
        }
        catch (InvalidSchemaException ise) {
            return false;
        }
        catch (AuthenticationException ae) {
            return false;
        }
        catch (ProtocolNotSupportedException pnse) {
            throw pnse;
        }
        catch (DirectoryException ex) {
            throw new CouldNotCheckAvailabilityException(id, (Throwable)ex);
        }
    }

    public static boolean isAvailable(DirectoryPassport passport) throws ProtocolNotSupportedException {
        Factory sessionFactory = Factory.getDirectoryFactory(passport.getId());
        return sessionFactory.isAvailable(passport);
    }

    public static DirectorySession startAdminSession(DirectoryPassport passport) throws ProtocolNotSupportedException, AuthenticationException {
        DirectorySession session = Directory.startSession(passport);
        if (!session.isAdministrator()) {
            throw AuthenticationException.notAdministrator(session);
        }
        return session;
    }

    public static DirectorySession startAnonymousSession(DirectoryPassport passport) throws ProtocolNotSupportedException, AuthenticationException, CommunicationException {
        timeMeter_sd.begin(TimeMeter.START_ANONYMOUS_SESSION);
        passport.setParticipant(null);
        Factory sessionFactory = Factory.getDirectoryFactory(passport.getId());
        DirectorySession session = sessionFactory.startSession(passport);
        timeMeter_sd.end();
        return session;
    }

    public static DirectorySession startSession(DirectoryPassport passport) throws ProtocolNotSupportedException, AuthenticationException, CommunicationException {
        timeMeter_sd.begin(TimeMeter.START_SESSION);
        String participant = passport.getParticipant();
        if (participant == null || participant.trim().length() == 0) {
            throw AuthenticationException.participantIdIsWrong(passport.getId(), passport.getParticipant());
        }
        Factory sessionFactory = Factory.getDirectoryFactory(passport.getId());
        DirectorySession session = sessionFactory.startSession(passport);
        timeMeter_sd.end();
        assert (session != null) : "Start session cannot return null!";
        return session;
    }

    public static DirectoryConfigurationManagerInterface getPropertyManager(String directoryId) {
        DirectoryConfigurationManagerLocatorInterface locator = directoryConfigurationManagerLocatorInterface;
        if (locator == null) {
            try {
                Class.forName(DIRECTORY_CONFIGURATION_MANAGER_LOCATOR);
            }
            catch (ClassNotFoundException e) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class.forName(DIRECTORY_CONFIGURATION_MANAGER_LOCATOR, true, loader);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException(e1);
                }
            }
            locator = directoryConfigurationManagerLocatorInterface;
            assert (locator != null) : "directoryConfigurationManagerLocatorInterface is null";
        }
        return locator.getDirectoryConfigurationManager(directoryId);
    }

    public static void setPropertyManager(DirectoryConfigurationManagerLocatorInterface directoryConfigurationManagerLocator) {
        directoryConfigurationManagerLocatorInterface = directoryConfigurationManagerLocator;
    }

    public static Map<String, Object> retrieveAllProperties(DirectorySession session, String category) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectPropertiesAccessor().fetchAllDirectoryProperties(category);
    }

    public static Object retrieveProperty(DirectorySession session, String category, String key) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectPropertiesAccessor().fetchDirectoryProperty(category, key);
    }

    public static Object retrieveEncryptedProperty(DirectorySession session, String category, String key, String encryptionKey) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectPropertiesAccessor().fetchEncryptedDirectoryProperty(category, key, encryptionKey);
    }

    public static void storeProperty(DirectorySession session, String category, String key, Object value) throws DirectoryException {
        Directory.checkSession(session);
        session.getObjectPropertiesAccessor().storeDirectoryProperty(category, key, value);
    }

    public static void storeEncryptedProperty(DirectorySession session, String category, String key, String value, String encryptionKey) throws DirectoryException {
        Directory.checkSession(session);
        session.getObjectPropertiesAccessor().storeEncryptedDirectoryProperty(category, key, value, encryptionKey);
    }

    public void store(DirectorySession session, String category, String key, Object value) throws DirectoryException {
        Directory.storeProperty(session, category, key, value);
    }

    static void checkAdministratorSession(DirectorySession session) {
        Directory.checkSession(session);
        if (!session.isAdministrator()) {
            throw InvalidDirectorySessionException.notAdministratorSession();
        }
    }

    static void checkAdministratorSession(DirectorySession session, DirHumanParticipant participant, int permission, String ou) {
        Directory.checkSession(session);
        if (!session.isAdministrator()) {
            if (!participant.hasPermission(permission)) {
                throw InvalidDirectorySessionException.notAdministratorSession();
            }
            if (!participant.isOUAdministeredBy(ou)) {
                throw InvalidDirectorySessionException.notAdministratorForOU();
            }
        }
    }

    static void checkSession(DirectorySession session) {
        if (session == null) {
            throw InvalidDirectorySessionException.nullSession();
        }
        if (!session.isConnected()) {
            throw InvalidDirectorySessionException.sessionNotConnected();
        }
    }
}

