/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.xml.XmlWriter;

public class DirProcessVariable
extends DirObject
implements Cloneable {
    protected LocalizedMessage[] displayNames_d;
    protected String id_d;
    protected String mask_d;
    protected String size_d;
    protected String type_d;
    public static final String CATEGORY_BUSINESS = "BUSINESS_VARIABLE";
    public static final String KEY_BUSINESS_TYPE = "TYPE";
    public static final String KEY_BUSINESS_DATA = "DATA";
    public static final String ELEM_VAR = "DirProcessVariable";
    static final long serialVersionUID = -8512357113594975038L;
    static final long serialCheck = -5745732897480770980L;

    public DirProcessVariable(DirectorySession session, int in, String id, String type, String size, String mask, LocalizedMessage[] displayNames, String internalID) {
        super(session, in, internalID);
        this.id_d = id;
        this.type_d = type;
        if (size != null && (size = size.trim()).equals("")) {
            size = null;
        }
        this.size_d = size;
        this.mask_d = mask != null && mask.trim().equals("") ? null : mask;
        this.displayNames_d = displayNames;
    }

    public static DirProcessVariable create(DirectorySession session, String id, String type, String size, String mask, LocalizedMessage[] displayNames) throws DirectoryException {
        Directory.checkSession(session);
        session.getAttributeValidator().validateProcessVariableId(id);
        DirectorySession.checkAttributeValue("type", type);
        return session.getProcessAccessor().createVariable(id, type, size, mask, displayNames);
    }

    public static DirProcessVariable fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchVariable(id);
    }

    public static DirProcessVariable[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllVariables();
    }

    @Override
    public String getDisplayName() {
        return this.id_d;
    }

    @Override
    public String getId() {
        return this.id_d;
    }

    public void setLocalizedDisplayNames(LocalizedMessage[] displayNames) {
        this.displayNames_d = displayNames;
    }

    public LocalizedMessage[] getLocalizedDisplayNames() {
        return this.displayNames_d;
    }

    public void setMask(String mask) {
        this.mask_d = mask;
    }

    public String getMask() {
        return this.mask_d;
    }

    public void setSize(String size) {
        if (size != null && (size = size.trim()).equals("")) {
            size = null;
        }
        this.size_d = size;
    }

    public String getSize() {
        return this.size_d;
    }

    public void setType(String type) {
        DirectorySession.checkAttributeValue("type", type);
        this.type_d = type;
    }

    public String getType() {
        return this.type_d;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getProcessAccessor().deleteVariable(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getProcessAccessor().refreshVariable(this);
    }

    @Override
    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveAllPropertiesImpl(category);
    }

    @Override
    public String retrieveEncryptedProperty(String category, String key, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveEncryptedPropertyImpl(category, key, encryptionKey);
    }

    @Override
    public Object retrieveProperty(String category, String key) throws DirectoryException, OperationNotSupportedException {
        return this.retrievePropertyImpl(category, key);
    }

    @Override
    public void storeEncryptedProperty(String category, String key, String value, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        this.storeEncryptedPropertyImpl(category, key, value, encryptionKey);
    }

    @Override
    public void storeProperty(String category, String key, Serializable value) throws DirectoryException, OperationNotSupportedException {
        this.storePropertyImpl(category, key, value);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getProcessAccessor().updateVariable(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter, StringList categories) throws IOException {
        xmlWriter.startElement(ELEM_VAR);
        xmlWriter.printValuedElement("id", this.getId());
        xmlWriter.printValuedElement("type", this.getType());
        xmlWriter.printValuedElement("size", this.getSize());
        xmlWriter.printValuedElement("mask", this.getMask());
        LocalizedMessage[] localizedMessages = this.getLocalizedDisplayNames();
        if (localizedMessages != null && localizedMessages.length > 0) {
            xmlWriter.startElement("localizedDisplayNames");
            for (LocalizedMessage localizedMessage : localizedMessages) {
                xmlWriter.startElement("localizedDisplayName");
                xmlWriter.printValuedElement("locale", localizedMessage.locale);
                xmlWriter.printValuedElement("message", localizedMessage.message);
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        if (categories == null) {
            categories = StringList.create();
        }
        if (!categories.contains(CATEGORY_BUSINESS)) {
            categories.add(CATEGORY_BUSINESS);
        }
        xmlWriter.startElement("processVariableProperties");
        for (String category : categories) {
            try {
                Map<String, Object> properties = this.retrieveAllProperties(category);
                properties.putAll(this.retrieveAllProperties(null));
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    this.printProperty(xmlWriter, "processVariableProperty", category, entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                }
            }
            catch (DirectoryException e) {
                e.printStackTrace();
            }
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    public static class LocalizedMessage {
        public final String locale;
        public final String message;

        public LocalizedMessage(String locale, String message) {
            DirObject.check(locale != null, DirectoryMsg.DIR_00136);
            DirObject.check(message != null, DirectoryMsg.DIR_00137);
            this.locale = locale;
            this.message = message;
        }

        public String asStoreString() {
            return this.locale + "/" + this.message;
        }
    }
}

