/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.BusinessParameterMapping;
import fuego.directory.DirDeployedProcess;
import fuego.directory.DirObject;
import fuego.directory.DirProjectRevision;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.RoleMapping;
import fuego.directory.VarMapping;
import fuego.directory.exception.OperationNotSupportedException;

public class DirProcessDefinition
extends DirObject {
    protected String author_d;
    protected String description_d;
    protected String name_d;
    protected int projectRevisionCreatorIn = -1;
    protected String projectRevisionRemarks;
    protected long serialUID_d;
    private BusinessParameterMapping[] businessParameterMapping;
    private int catalogIn = -1;
    private boolean engineUsage = false;
    private int major = -1;
    private int minor = -1;
    private String namespace;
    private int revision = -1;
    private RoleMapping[] rolesMapping;
    private String schemaType;
    private VarMapping[] varMapping;
    static final long serialVersionUID = 1598474646824934559L;
    static final long serialCheck = 2462733601062386148L;

    public DirProcessDefinition(DirectorySession session, int in, String name, String description, String author, long serialUID, String namespace, String schemaType, String internalId) {
        super(session, in, internalId);
        this.name_d = name;
        this.description_d = description;
        this.author_d = author;
        this.serialUID_d = serialUID;
        this.projectRevisionCreatorIn = -1;
        this.projectRevisionRemarks = null;
        this.namespace = namespace;
        this.schemaType = schemaType;
    }

    public DirProcessDefinition(DirectorySession session, int in, String name, String description, String author, long serialUID, int projectRevisionCreatorIn, String projectRevisionRemarks, String namespace, String schemaType, String internalId) {
        super(session, in, internalId);
        this.name_d = name;
        this.description_d = description;
        this.author_d = author;
        this.serialUID_d = serialUID;
        this.projectRevisionCreatorIn = projectRevisionCreatorIn;
        this.projectRevisionRemarks = projectRevisionRemarks;
        this.namespace = namespace;
        this.schemaType = schemaType;
    }

    public static DirProcessDefinition create(DirectorySession session, String name, String description, String author, long serialUID, String processSource, byte[] processJar, String processDocumentation, String processImage, String namespace, String schemaType) throws DirectoryException {
        Directory.checkSession(session);
        session.getAttributeValidator().validateProcessDefinitionId(name);
        description = session.getAttributeValidator().validateDescription(description);
        return session.getProcessAccessor().createProcessDefinition(name, description, author, serialUID, processSource, processJar, processDocumentation, processImage, namespace, schemaType);
    }

    public static DirProcessDefinition[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllProcessDefinitions();
    }

    public static DirProcessDefinition[] fetchAll(DirectorySession session, String name) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllProcessDefinitions(name);
    }

    public static String getDeployedVersion(int major, int minor) {
        return major + "." + minor;
    }

    public static String buildId(String name, int major, int minor, int revision) {
        return name + "/" + major + "/" + minor + "/" + revision;
    }

    public String getAuthor() {
        return this.author_d;
    }

    public void setBusinessParameterMapping(BusinessParameterMapping[] businessParameterMapping) {
        if (!this.engineUsage) {
            throw new UnsupportedOperationException();
        }
        this.businessParameterMapping = businessParameterMapping;
    }

    public BusinessParameterMapping[] getBusinessParameterMapping() {
        if (this.engineUsage) {
            return this.businessParameterMapping;
        }
        throw new UnsupportedOperationException();
    }

    public void setCatalogIn(int catalogIn) {
        if (!this.engineUsage) {
            throw new UnsupportedOperationException();
        }
        this.catalogIn = catalogIn;
    }

    public int getCatalogIn() {
        if (this.engineUsage) {
            return this.catalogIn;
        }
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        return this.description_d;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this.name_d + "/";
    }

    public void setMajor(int major) {
        if (!this.engineUsage) {
            throw new UnsupportedOperationException();
        }
        this.major = major;
    }

    public int getMajor() {
        if (this.engineUsage) {
            return this.major;
        }
        throw new UnsupportedOperationException();
    }

    public void setMinor(int minor) {
        if (!this.engineUsage) {
            throw new UnsupportedOperationException();
        }
        this.minor = minor;
    }

    public int getMinor() {
        if (this.engineUsage) {
            return this.minor;
        }
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name_d;
    }

    public int getProjectRevisionCreatorIn() {
        return this.projectRevisionCreatorIn;
    }

    public String getProjectRevisionRemarks() {
        return this.projectRevisionRemarks;
    }

    public void setRevision(int revision) {
        if (!this.engineUsage) {
            throw new UnsupportedOperationException();
        }
        this.revision = revision;
    }

    public int getRevision() {
        if (this.engineUsage) {
            return this.revision;
        }
        throw new UnsupportedOperationException();
    }

    public void setRolesMapping(RoleMapping[] rolesMapping) {
        if (!this.engineUsage) {
            throw new UnsupportedOperationException();
        }
        this.rolesMapping = rolesMapping;
    }

    public RoleMapping[] getRolesMapping() {
        if (this.engineUsage) {
            return this.rolesMapping;
        }
        throw new UnsupportedOperationException();
    }

    public long getSerialUID() {
        return this.serialUID_d;
    }

    public void setUsedByEngine() {
        this.engineUsage = true;
    }

    public void setVarMapping(VarMapping[] varMapping) {
        if (!this.engineUsage) {
            throw new UnsupportedOperationException();
        }
        this.varMapping = varMapping;
    }

    public VarMapping[] getVarMapping() {
        if (this.engineUsage) {
            return this.varMapping;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() throws DirectoryException {
        throw new UnsupportedOperationException("delete");
    }

    public DirDeployedProcess[] fetchDeployedProcesses() throws DirectoryException {
        return this.getDirectoryAdministratorSession().getProcessAccessor().fetchDeployedProcesses(this);
    }

    public String fetchProcessDocumentation() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchProcessDocumentation(this);
    }

    public String fetchProcessImage() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchProcessImage(this);
    }

    public byte[] fetchProcessJar() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchProcessJar(this);
    }

    public String fetchProcessSource() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchProcessSource(this);
    }

    public DirProjectRevision fetchProjectRevision() throws DirectoryException {
        if (this.engineUsage) {
            return this.getDirectoryAdministratorSession().getProjectAccessor().fetchProjectRevisionByIn(this.getCatalogIn());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() throws DirectoryException {
        throw new OperationNotSupportedException("refresh", this.toString());
    }

    @Override
    public String toString() {
        return "Published process '" + this.getId() + "'.\nDescription: " + super.toString();
    }

    @Override
    public void update() throws DirectoryException {
        throw new OperationNotSupportedException("update", this.toString());
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

