/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirProcessVariable;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.InvalidAttributeValueException;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.exception.RoleIsNotParametricException;
import fuego.directory.msg.DirectoryMsg;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xml.XmlWriter;

public class DirOrganizationalRole
extends DirObject
implements DynamicObject.Dynamizable {
    protected CalendarRuleAssignment[] calendarRules_d;
    protected String description_d;
    protected DirProcessVariable.LocalizedMessage[] displayNames_d;
    protected boolean isParametric_d;
    protected String name_d;
    protected Map<String, Integer> parametricMap_d;
    protected String[] parametricValues_d;
    public static final String ELEM_ROLE = "DirOrganizationalRole";
    public static final char[] INVALID_ID_CHARS = new char[]{'\u0000', ':'};
    public static final String PARAMETER_ROLE_SEPARATOR = ":";
    static final long serialVersionUID = 4668135551593133724L;
    static final long serialCheck = 6246860621315038806L;
    private static final DirProcessVariable.LocalizedMessage[] EMPTY_LOCALIZED_MESSAGE = new DirProcessVariable.LocalizedMessage[0];

    public DirOrganizationalRole(DirectorySession session, int in, String name, boolean isParametric, String description, CalendarRuleAssignment[] calendarRules, Map<String, Integer> parametricMap, String internalId) {
        this(session, in, name, isParametric, description, calendarRules, parametricMap, EMPTY_LOCALIZED_MESSAGE, internalId);
    }

    public DirOrganizationalRole(DirectorySession session, int in, String name, boolean isParametric, String description, CalendarRuleAssignment[] calendarRules, Map<String, Integer> parametricMap, DirProcessVariable.LocalizedMessage[] displayNames, String internalId) {
        super(session, in, internalId);
        this.name_d = name;
        this.setDescription(description);
        this.calendarRules_d = calendarRules;
        this.isParametric_d = isParametric;
        this.setParametricMap(parametricMap);
        this.displayNames_d = displayNames;
    }

    public static String getParameticValueFromRoleId(String roleId) {
        int indexOf = roleId.indexOf(PARAMETER_ROLE_SEPARATOR);
        return indexOf == -1 ? null : roleId.substring(indexOf + 1);
    }

    public static String getRoleNameFromRoleId(String roleId) {
        int indexOf = roleId.indexOf(PARAMETER_ROLE_SEPARATOR);
        return indexOf == -1 ? roleId : roleId.substring(0, indexOf);
    }

    public static DirOrganizationalRole create(DirectorySession session, String name, boolean isParametric, String description) throws DirectoryException {
        String[] parametricValues = new String[]{};
        CalendarRuleAssignment[] calendarRules = new CalendarRuleAssignment[]{};
        return DirOrganizationalRole.create(session, name, isParametric, description, parametricValues, calendarRules);
    }

    public static DirOrganizationalRole create(DirectorySession session, String name, boolean isParametric, String description, String[] parametricValues, CalendarRuleAssignment[] calendarRules) throws DirectoryException {
        return DirOrganizationalRole.create(session, name, isParametric, description, parametricValues, calendarRules, EMPTY_LOCALIZED_MESSAGE);
    }

    public static DirOrganizationalRole create(DirectorySession session, String name, boolean isParametric, String description, String[] parametricValues, CalendarRuleAssignment[] calendarRules, DirProcessVariable.LocalizedMessage[] displayNames) throws DirectoryException {
        if (calendarRules == null) {
            calendarRules = new CalendarRuleAssignment[]{};
        }
        Directory.checkSession(session);
        session.getAttributeValidator().validateNewRoleName(name);
        parametricValues = isParametric ? DirOrganizationalRole.checkParametricValues(session, parametricValues) : null;
        description = session.getAttributeValidator().validateDescription(description);
        return session.getOrganizationAccessor().createRole(name, isParametric, description, (String[])parametricValues, calendarRules, displayNames);
    }

    public static DirOrganizationalRole fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        if (!session.getAttributeValidator().isValidRoleName(id)) {
            return null;
        }
        return session.getOrganizationAccessor().fetchRole(id);
    }

    public static DirOrganizationalRole fetch(DirectorySession session, int in) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchRole(in);
    }

    public static DirOrganizationalRole[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchAllRoles();
    }

    public static String makeRoleId(String roleName, String parametricValue) {
        String roleId = roleName;
        if (parametricValue != null) {
            roleId = roleId + PARAMETER_ROLE_SEPARATOR + parametricValue;
        }
        return roleId;
    }

    public static Map fetchAllPropertyValues(DirectorySession session, String category, String key) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectPropertiesAccessor().fetchAllPropertyValuesForRoles(category, key);
    }

    public void setCalendarRulesAssignment(CalendarRuleAssignment[] calendarRules) {
        DirOrganizationalRole.check(calendarRules != null, DirectoryMsg.DIR_00107);
        this.calendarRules_d = ArrayUtils.trim(calendarRules);
    }

    public CalendarRuleAssignment[] getCalendarRulesAssignment() {
        return this.calendarRules_d;
    }

    public DirProcessVariable.LocalizedMessage[] getLocalizedDisplayNames() {
        return this.displayNames_d;
    }

    public void setLocalizedDisplayNames(DirProcessVariable.LocalizedMessage[] displayNames) {
        this.displayNames_d = displayNames;
    }

    public void setDescription(String description) {
        this.description_d = this.getDirectorySession().getAttributeValidator().validateDescription(description);
    }

    public String getDescription() {
        return this.description_d;
    }

    public String getName() {
        return this.name_d;
    }

    public boolean isParametric() {
        return this.isParametric_d;
    }

    public int getParametricIn(String parametricValue) throws RoleIsNotParametricException {
        if (!this.isParametric()) {
            throw new RoleIsNotParametricException(this);
        }
        Integer in = this.parametricMap_d.get(parametricValue);
        return in == null ? -1 : in;
    }

    @Exclude
    public void setParametricMap(Map<String, Integer> parametricMap) {
        if (parametricMap != null) {
            this.parametricValues_d = parametricMap.keySet().toArray(new String[parametricMap.size()]);
            this.parametricMap_d = parametricMap;
        } else {
            this.parametricValues_d = new String[0];
            this.parametricMap_d = new HashMap<String, Integer>();
        }
    }

    @Exclude
    public Map<String, Integer> getParametricMap() {
        return this.parametricMap_d;
    }

    public void setParametricValues(String[] parametricValues) throws RoleIsNotParametricException {
        if (!this.isParametric()) {
            throw new RoleIsNotParametricException(this);
        }
        this.parametricValues_d = DirOrganizationalRole.checkParametricValues(this.getDirectorySession(), parametricValues);
    }

    public String[] getParametricValues() throws RoleIsNotParametricException {
        if (!this.isParametric()) {
            throw new RoleIsNotParametricException(this);
        }
        return this.parametricValues_d;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Deprecated
    public String getGlobalDN() {
        return "cn=" + this.getId() + ",o=" + this.getOrganization();
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().deleteRole(this, true);
    }

    @Override
    public boolean equals(Object o) {
        int length;
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirOrganizationalRole)) {
            return false;
        }
        DirOrganizationalRole other = (DirOrganizationalRole)o;
        if (this.isParametric_d != other.isParametric_d) {
            return false;
        }
        if (this.calendarRules_d != other.calendarRules_d) {
            int i;
            if (this.calendarRules_d == null || other.calendarRules_d == null) {
                return false;
            }
            length = this.calendarRules_d.length;
            if (length != other.calendarRules_d.length) {
                return false;
            }
            Object[] thisCalendarStrings = new String[length];
            Object[] otherCalendarStrings = new String[length];
            for (i = 0; i < this.calendarRules_d.length; ++i) {
                thisCalendarStrings[i] = this.calendarRules_d[i].asStoreString();
            }
            for (i = 0; i < other.calendarRules_d.length; ++i) {
                otherCalendarStrings[i] = other.calendarRules_d[i].asStoreString();
            }
            Arrays.sort(thisCalendarStrings, String.CASE_INSENSITIVE_ORDER);
            Arrays.sort(otherCalendarStrings, String.CASE_INSENSITIVE_ORDER);
            if (!Arrays.equals(thisCalendarStrings, otherCalendarStrings)) {
                return false;
            }
        }
        if (this.description_d != null ? !this.description_d.equals(other.description_d) : other.description_d != null) {
            return false;
        }
        if (this.name_d != null ? !this.name_d.equals(other.name_d) : other.name_d != null) {
            return false;
        }
        if (this.isParametric_d) {
            length = this.parametricValues_d.length;
            if (length != other.parametricValues_d.length) {
                return false;
            }
            Object[] thisParametricValues = new String[length];
            Object[] otherRoleParametricValues = new String[length];
            System.arraycopy(this.parametricValues_d, 0, thisParametricValues, 0, length);
            System.arraycopy(other.parametricValues_d, 0, otherRoleParametricValues, 0, length);
            Arrays.sort(thisParametricValues, String.CASE_INSENSITIVE_ORDER);
            Arrays.sort(otherRoleParametricValues, String.CASE_INSENSITIVE_ORDER);
            if (!Arrays.equals(thisParametricValues, otherRoleParametricValues)) {
                return false;
            }
        }
        return true;
    }

    public DirHumanParticipant[] fetchAssignedParticipants() throws DirectoryException {
        return this.getDirectorySession().getParticipantAccessor().fetchParticipantsForRole(this);
    }

    public DirHumanParticipant[] fetchAssignedParticipants(String parametricValue) throws DirectoryException {
        if (!this.isParametric()) {
            throw new RoleIsNotParametricException(this);
        }
        return this.getDirectorySession().getParticipantAccessor().fetchParticipantsForRole(this, parametricValue);
    }

    @Override
    public int hashCode() {
        int i;
        int result = 17;
        result = 37 * result + (this.description_d == null ? 0 : this.description_d.hashCode());
        result = 37 * result + (this.name_d == null ? 0 : this.name_d.hashCode());
        if (this.calendarRules_d != null) {
            for (i = 0; i < this.calendarRules_d.length; ++i) {
                CalendarRuleAssignment calendarRuleAssignment = this.calendarRules_d[i];
                result = 37 * result + (calendarRuleAssignment == null ? 0 : calendarRuleAssignment.hashCode());
            }
        }
        if (this.parametricValues_d != null) {
            for (i = 0; i < this.parametricValues_d.length; ++i) {
                String parametricValue = this.parametricValues_d[i];
                result = 37 * result + (parametricValue == null ? 0 : parametricValue.hashCode());
            }
        }
        result = 37 * result + (this.isParametric_d ? 0 : 1);
        return result;
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().refreshRole(this);
    }

    @Override
    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveAllPropertiesImpl(category);
    }

    @Override
    public String retrieveEncryptedProperty(String category, String key, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveEncryptedPropertyImpl(category, key, encryptionKey);
    }

    @Override
    public Object retrieveProperty(String category, String key) throws DirectoryException, OperationNotSupportedException {
        return this.retrievePropertyImpl(category, key);
    }

    @Override
    public void storeEncryptedProperty(String category, String key, String value, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        this.storeEncryptedPropertyImpl(category, key, value, encryptionKey);
    }

    @Override
    public void storeProperty(String category, String key, Serializable value) throws DirectoryException, OperationNotSupportedException {
        this.storePropertyImpl(category, key, value);
    }

    @Override
    public String toString() {
        return "name:" + this.name_d + "|description:" + this.description_d + "|parametric:" + this.isParametric() + (this.isParametric() ? PARAMETER_ROLE_SEPARATOR + ArrayUtils.toString(this.parametricValues_d) : "") + "|" + ArrayUtils.toString(this.displayNames_d) + "|" + super.toString();
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().updateRole(this);
    }

    public DynamicObject writeDynamicObject() {
        DynamicObject answer = DynamicObject.create();
        answer.setField("name", this.getName());
        answer.setField("description", this.getDescription());
        answer.setField("isParametric", this.isParametric());
        if (this.isParametric()) {
            try {
                answer.setField("parametricValues", this.getParametricValues());
            }
            catch (RoleIsNotParametricException roleIsNotParametricException) {
                // empty catch block
            }
        }
        answer.setField("calendarRulesAssignment", this.getCalendarRulesAssignment());
        answer.setJavaClassName(this.getClass().getName());
        return answer;
    }

    @Override
    public void writeXML(XmlWriter xmlWriter, StringList categories) throws IOException {
        DirProcessVariable.LocalizedMessage[] localizedMessages;
        int i;
        xmlWriter.startElement(ELEM_ROLE);
        xmlWriter.printValuedElement("name", this.getName());
        xmlWriter.printValuedElement("description", this.getDescription());
        xmlWriter.printValuedElement("isParametric", String.valueOf(this.isParametric()));
        if (this.parametricValues_d != null && this.parametricValues_d.length > 0) {
            xmlWriter.startElement("parametricValues");
            for (i = 0; i < this.parametricValues_d.length; ++i) {
                xmlWriter.printValuedElement("value", this.parametricValues_d[i]);
            }
            xmlWriter.endElement();
        }
        if (this.calendarRules_d != null && this.calendarRules_d.length > 0) {
            xmlWriter.startElement("calendarRules");
            for (i = 0; i < this.calendarRules_d.length; ++i) {
                xmlWriter.startElement("calendarRule");
                xmlWriter.printValuedElement("nameCalendar", this.calendarRules_d[i].calendarRule);
                xmlWriter.printValuedElement("ou", this.calendarRules_d[i].ou);
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        if ((localizedMessages = this.getLocalizedDisplayNames()) != null && localizedMessages.length > 0) {
            xmlWriter.startElement("localizedDisplayNames");
            for (int i2 = 0; i2 < localizedMessages.length; ++i2) {
                xmlWriter.startElement("localizedDisplayName");
                xmlWriter.printValuedElement("locale", localizedMessages[i2].locale);
                xmlWriter.printValuedElement("message", localizedMessages[i2].message);
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        if (categories != null && categories.size() > 0) {
            xmlWriter.startElement("roleProperties");
            for (String category : categories) {
                try {
                    Map<String, Object> properties = this.retrieveAllProperties(category);
                    properties.putAll(this.retrieveAllProperties(null));
                    for (Map.Entry<String, Object> entry : properties.entrySet()) {
                        this.printProperty(xmlWriter, "roleProperty", category, entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                    }
                }
                catch (DirectoryException e) {
                    e.printStackTrace();
                }
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private static String[] checkParametricValues(DirectorySession session, String[] parametricValues) {
        if (parametricValues == null || parametricValues.length == 0) {
            throw InvalidAttributeValueException.atLeastOneParametricValueRequired();
        }
        for (int i = 0; i < parametricValues.length; ++i) {
            String parametricValue = parametricValues[i];
            if (parametricValue == null) continue;
            session.getAttributeValidator().validateParametricValue(parametricValue);
            for (int j = i + 1; j < parametricValues.length; ++j) {
                if (parametricValue.equals(parametricValues[j])) {
                    parametricValues[j] = null;
                }
                if (!parametricValue.equalsIgnoreCase(parametricValues[j])) continue;
                throw InvalidAttributeValueException.cannotAllowTheSameValueWithDifferentCases(parametricValue, parametricValues[j]);
            }
        }
        return ArrayUtils.trim(parametricValues);
    }

    public static class CalendarRuleAssignment
    implements Serializable {
        public final String calendarRule;
        public final String ou;
        static final long serialVersionUID = 4668135551593133724L;
        static final long serialCheck = 6246860621315038806L;

        public CalendarRuleAssignment(String ou, String calendarRule) {
            this.ou = ou;
            this.calendarRule = calendarRule;
        }

        public String asStoreString() {
            return this.ou + DirOrganizationalRole.PARAMETER_ROLE_SEPARATOR + this.calendarRule;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CalendarRuleAssignment)) {
                return false;
            }
            CalendarRuleAssignment calendarRuleAssignment = (CalendarRuleAssignment)obj;
            return calendarRuleAssignment.ou.equals(this.ou) && calendarRuleAssignment.calendarRule.equals(this.calendarRule);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.calendarRule == null ? 0 : this.calendarRule.hashCode());
            result = 37 * result + (this.ou == null ? 0 : this.ou.hashCode());
            return result;
        }
    }
}

