/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirHumanParticipant;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.InvalidDirectorySessionException;
import fuego.directory.exception.NoPermissionException;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Time;
import oracle.bpm.resources.Msg;
import oracle.bpm.xml.XmlWriter;

public abstract class DirObject
implements Serializable {
    protected Time createTimestamp_d;
    protected String creator_d;
    protected int in_d = -1;
    protected String internalProviderId_d;
    protected String modifier_d;
    protected Time modifyTimestamp_d;
    final String schemaId;
    transient DirectorySession session;
    public static final String NS = "/";
    public static final char NameSeparatorChar = '/';
    public static final String NO_CATEGORY = "NO_CATEGORY";
    public static final char[] INVALID_EXTENDED_ID_CHARS = new char[]{'\u0000', '/', '@'};
    public static final char[] INVALID_BASE_ID_CHARS = new char[]{'\u0000', '/'};
    static final long serialCheck = -7412527037480813178L;
    static final long serialVersionUID = -1762154149984881983L;

    protected DirObject(DirectorySession session, int in, String internalId) {
        if (session == null) {
            throw new NullPointerException();
        }
        this.session = session;
        this.schemaId = session.getSchemaId();
        this.internalProviderId_d = internalId;
        this.in_d = in;
    }

    public abstract String getDisplayName();

    public abstract String getId();

    public abstract void delete() throws DirectoryException;

    public abstract void refresh() throws DirectoryException;

    public abstract void update() throws DirectoryException;

    public static final String addSuffixPart(String base, String suffix) {
        if (base == null || base.length() == 0) {
            return suffix;
        }
        return base + NS + suffix;
    }

    public static void checkAttributeValues(String name, String[] value) {
        DirectorySession.checkAttributeValues(name, value);
    }

    public static void checkKeyAttributeValue(String name, String value) {
        DirectorySession.checkKeyAttributeValue(name, value);
    }

    public static final String insertId(String fullId, String id) {
        return fullId == null || fullId.equals("") ? id : fullId + NS + id;
    }

    public static final String removeLastPart(String id) {
        if (id == null) {
            return null;
        }
        int i = id.lastIndexOf(NS);
        return i == -1 ? "" : id.substring(0, i);
    }

    public Time getCreateTimestamp() {
        this.checkAuditInfo();
        return this.createTimestamp_d;
    }

    public String getCreator() {
        this.checkAuditInfo();
        return this.creator_d;
    }

    public void setAuditInfo(Time createTime, Time modifyTime, String creator, String modifier) {
        this.modifier_d = modifier;
        this.modifyTimestamp_d = modifyTime;
        this.creator_d = creator;
        this.createTimestamp_d = createTime;
    }

    public String getGlobalId() {
        return this.getId() + "@" + this.getOrganization();
    }

    public int getIn() {
        return this.in_d;
    }

    public String getInternalId() {
        return this.internalProviderId_d;
    }

    public String getModifier() {
        this.checkAuditInfo();
        return this.modifier_d;
    }

    public Time getModifyTimestamp() {
        this.checkAuditInfo();
        return this.modifyTimestamp_d;
    }

    public String getOrganization() {
        return this.session.getOrganizationName();
    }

    public void checkAttributeValue(String name, String value) {
        DirectorySession.checkAttributeValue(name, value);
    }

    public void checkDescriptionAttributeValue(String name, String value) {
        this.getDirectorySession().checkDescriptionAttributeValue(name, value);
    }

    public void checkFullIDAttributeValue(String name, String value) {
        this.getDirectorySession().checkFullIDAttributeValue(name, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof DirObject && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.in_d;
        result = 37 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 37 * result + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        result = 37 * result + (this.getInternalId() == null ? 0 : this.getInternalId().hashCode());
        return result;
    }

    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException {
        throw new OperationNotSupportedException("retrieveProperty", this.getDisplayName());
    }

    public String retrieveEncryptedProperty(String category, String key, String encryptionKey) throws DirectoryException {
        throw new OperationNotSupportedException("retrieve Encrypted Property", this.getDisplayName());
    }

    public Object retrieveProperty(String category, String key) throws DirectoryException {
        throw new OperationNotSupportedException("retrieveProperty", this.getDisplayName());
    }

    public String retrieveStringProperty(String category, String key) throws DirectoryException {
        throw new OperationNotSupportedException("retrieveStringProperty", this.getDisplayName());
    }

    public void storeEncryptedProperty(String category, String key, String value, String encryptionKey) throws DirectoryException {
        throw new OperationNotSupportedException("storeProperty", this.getDisplayName());
    }

    public void storeProperty(String category, String key, Serializable value) throws DirectoryException {
        throw new OperationNotSupportedException("storeProperty", this.getDisplayName());
    }

    public String toString() {
        return "IN:" + this.getIn() + "|ID:" + this.getId() + "|displayName:" + this.getDisplayName() + "|internalId:" + this.getInternalId();
    }

    public void checkIDAttributeValue(String name, String value) {
        this.getDirectorySession().checkIDAttributeValue(name, value);
    }

    public void writeXML(XmlWriter xmlWriter) throws IOException {
        this.writeXML(xmlWriter, null);
    }

    public void writeXML(XmlWriter xmlWriter, StringList categories) throws IOException {
    }

    protected DirectorySession getDirectoryAdministratorSession() throws InvalidDirectorySessionException, NoPermissionException {
        if (this.session == null) {
            throw InvalidDirectorySessionException.nullSession();
        }
        if (!this.session.isConnected()) {
            throw InvalidDirectorySessionException.sessionNotConnected();
        }
        if (!this.session.isAdministrator()) {
            throw NoPermissionException.notAdministratorSession();
        }
        return this.session;
    }

    protected DirectorySession getDirectoryAdministratorSession(DirHumanParticipant participant, int permission, String ou) throws InvalidDirectorySessionException, NoPermissionException {
        if (this.session == null) {
            throw InvalidDirectorySessionException.nullSession();
        }
        if (!this.session.isConnected()) {
            throw InvalidDirectorySessionException.sessionNotConnected();
        }
        if (!(this.session.isAdministrator() || participant.hasPermission(permission) && participant.isOUAdministeredBy(ou))) {
            throw NoPermissionException.notAdministratorSession();
        }
        return this.session;
    }

    protected DirectorySession getDirectorySession() throws InvalidDirectorySessionException {
        if (this.session == null) {
            throw InvalidDirectorySessionException.nullSession();
        }
        if (!this.session.isConnected()) {
            throw InvalidDirectorySessionException.sessionNotConnected();
        }
        return this.session;
    }

    protected DirectorySession getDirectoryUserSession() throws InvalidDirectorySessionException, NoPermissionException {
        if (this.session == null) {
            throw InvalidDirectorySessionException.nullSession();
        }
        if (!this.session.isConnected()) {
            throw InvalidDirectorySessionException.sessionNotConnected();
        }
        if (this.session.isAnonymous()) {
            throw NoPermissionException.anonymousSession();
        }
        return this.session;
    }

    protected void printProperty(XmlWriter xmlWriter, String propertyTagName, String category, String key, String value) throws IOException {
        if (value == null || value.equals("")) {
            return;
        }
        xmlWriter.startElement(propertyTagName);
        xmlWriter.printValuedElement("prop_category", NO_CATEGORY.equals(category) ? NO_CATEGORY : category);
        xmlWriter.printValuedElement("prop_key", key);
        xmlWriter.printValuedElement("prop_value", value);
        xmlWriter.endElement();
    }

    static void check(boolean condition, Msg msg) {
        if (!condition) {
            throw new DirectoryRuntimeException(msg);
        }
    }

    static void checkSupports(boolean condition, Msg msg) throws OperationNotSupportedException {
        if (!condition) {
            throw new OperationNotSupportedException(msg);
        }
    }

    Map<String, Object> retrieveAllPropertiesImpl(String category) throws DirectoryException {
        DirObject.check(category == null || category.length() > 0, DirectoryMsg.DIR_00132);
        return this.session.getObjectPropertiesAccessor().fetchAll(this, category);
    }

    String retrieveEncryptedPropertyImpl(String category, String key, String encryptionKey) throws DirectoryException {
        DirObject.check(category == null || category.length() > 0, DirectoryMsg.DIR_00132);
        DirObject.check(key != null && key.length() > 0, DirectoryMsg.DIR_00133);
        return this.session.getObjectPropertiesAccessor().fetchEncrypted(this, category, key, encryptionKey);
    }

    Object retrievePropertyImpl(String category, String key) throws DirectoryException {
        DirObject.check(category == null || category.length() > 0, DirectoryMsg.DIR_00132);
        DirObject.check(key != null && key.length() > 0, DirectoryMsg.DIR_00133);
        return this.session.getObjectPropertiesAccessor().fetch(this, category, key);
    }

    String retrieveStringPropertyImpl(String category, String key) throws DirectoryException {
        DirObject.check(category == null || category.length() > 0, DirectoryMsg.DIR_00132);
        DirObject.check(key != null && key.length() > 0, DirectoryMsg.DIR_00133);
        return this.session.getObjectPropertiesAccessor().fetchStringProperty(this, category, key);
    }

    void storeEncryptedPropertyImpl(String category, String key, String value, String encryptionKey) throws DirectoryException {
        this.checkAttributeValue("category", category);
        DirObject.checkKeyAttributeValue("key", key);
        this.session.getObjectPropertiesAccessor().createEncrypted(this, category, key, value, encryptionKey);
    }

    void storePropertyImpl(String category, String key, Object value) throws DirectoryException {
        DirObject.check(category == null || category.length() > 0, DirectoryMsg.DIR_00132);
        DirObject.check(key != null && key.length() > 0, DirectoryMsg.DIR_00133);
        DirectorySession session = this instanceof DirHumanParticipant ? this.getDirectoryUserSession() : this.getDirectoryAdministratorSession();
        this.checkAttributeValue("category", category);
        session.checkPropertyKeyAttributeValue("property key", key);
        session.getObjectPropertiesAccessor().create(this, category, key, value);
    }

    private void checkAuditInfo() {
        if (this.modifyTimestamp_d == null) {
            try {
                this.session.fillAuditInfo(this);
            }
            catch (DirectoryException ex) {
                throw DirectoryRuntimeException.wrapException(ex);
            }
        }
    }
}

